/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.JMXListener;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MediumTests.class})
public class TestJMXListener {
    private static final Log LOG = LogFactory.getLog(TestJMXListener.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static int connectorPort = 61120;
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.regionserver.classes", JMXListener.class.getName());
        conf.setInt("regionserver.rmi.registry.port", connectorPort);
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testStart() throws Exception {
        JMXConnector connector = JMXConnectorFactory.connect(JMXListener.buildJMXServiceURL((int)connectorPort, (int)connectorPort));
        MBeanServerConnection mb = connector.getMBeanServerConnection();
        String domain = mb.getDefaultDomain();
        Assert.assertTrue((String)"default domain is not correct", (!domain.isEmpty() ? 1 : 0) != 0);
        connector.close();
    }

    @Test
    public void testStop() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        LOG.info((Object)"shutdown hbase cluster...");
        cluster.shutdown();
        LOG.info((Object)"wait for the hbase cluster shutdown...");
        cluster.waitUntilShutDown();
        JMXConnector connector = JMXConnectorFactory.newJMXConnector(JMXListener.buildJMXServiceURL((int)connectorPort, (int)connectorPort), null);
        this.expectedEx.expect(IOException.class);
        connector.connect();
    }

    @Test
    public void testGetRegionServerCoprocessors() throws Exception {
        for (JVMClusterUtil.RegionServerThread rs : UTIL.getHBaseCluster().getRegionServerThreads()) {
            boolean find = false;
            for (String s : rs.getRegionServer().getRegionServerCoprocessors()) {
                if (!s.equals(JMXListener.class.getSimpleName())) continue;
                find = true;
                break;
            }
            if (find) continue;
            Assert.fail((String)"where is the JMXListener?");
        }
    }
}

