/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.TestHFileBlock;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RedundantKVGenerator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHFileEncryption {
    private static final Log LOG = LogFactory.getLog(TestHFileEncryption.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final SecureRandom RNG = new SecureRandom();
    private static FileSystem fs;
    private static Encryption.Context cryptoContext;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setFloat("hfile.block.cache.size", 0.0f);
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        conf.setInt("hfile.format.version", 3);
        fs = FileSystem.get((Configuration)conf);
        cryptoContext = Encryption.newContext((Configuration)conf);
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        Cipher aes = Encryption.getCipher((Configuration)conf, (String)algorithm);
        Assert.assertNotNull((Object)aes);
        cryptoContext.setCipher(aes);
        byte[] key = new byte[aes.getKeyLength()];
        RNG.nextBytes(key);
        cryptoContext.setKey(key);
    }

    private int writeBlock(FSDataOutputStream os, HFileContext fileContext, int size) throws IOException {
        HFileBlock.Writer hbw = new HFileBlock.Writer(null, fileContext);
        DataOutputStream dos = hbw.startWriting(BlockType.DATA);
        for (int j = 0; j < size; ++j) {
            dos.writeInt(j);
        }
        hbw.writeHeaderAndData(os);
        LOG.info((Object)("Wrote a block at " + os.getPos() + " with" + " onDiskSizeWithHeader=" + hbw.getOnDiskSizeWithHeader() + " uncompressedSizeWithoutHeader=" + hbw.getOnDiskSizeWithoutHeader() + " uncompressedSizeWithoutHeader=" + hbw.getUncompressedSizeWithoutHeader()));
        return hbw.getOnDiskSizeWithHeader();
    }

    private long readAndVerifyBlock(long pos, HFileContext ctx, HFileBlock.FSReaderImpl hbr, int size) throws IOException {
        HFileBlock b = hbr.readBlockData(pos, -1L, false, false);
        Assert.assertEquals((long)0L, (long)HFile.getAndResetChecksumFailuresCount());
        b.sanityCheck();
        Assert.assertFalse((boolean)b.isUnpacked());
        b = b.unpack(ctx, (HFileBlock.FSReader)hbr);
        LOG.info((Object)("Read a block at " + pos + " with" + " onDiskSizeWithHeader=" + b.getOnDiskSizeWithHeader() + " uncompressedSizeWithoutHeader=" + b.getOnDiskSizeWithoutHeader() + " uncompressedSizeWithoutHeader=" + b.getUncompressedSizeWithoutHeader()));
        DataInputStream dis = b.getByteStream();
        for (int i = 0; i < size; ++i) {
            int read = dis.readInt();
            if (read == i) continue;
            Assert.fail((String)("Block data corrupt at element " + i));
        }
        return b.getOnDiskSizeWithHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testDataBlockEncryption() throws IOException {
        int blocks = 10;
        int[] blockSizes = new int[10];
        for (int i = 0; i < 10; ++i) {
            blockSizes[i] = (1024 + RNG.nextInt(64512)) / 4;
        }
        for (Compression.Algorithm compression : TestHFileBlock.COMPRESSION_ALGORITHMS) {
            Path path = new Path(TEST_UTIL.getDataTestDir(), "block_v3_" + compression + "_AES");
            LOG.info((Object)("testDataBlockEncryption: encryption=AES compression=" + compression));
            long totalSize = 0L;
            HFileContext fileContext = new HFileContextBuilder().withCompression(compression).withEncryptionContext(cryptoContext).build();
            try (FSDataOutputStream os = fs.create(path);){
                for (int i = 0; i < 10; ++i) {
                    totalSize += (long)this.writeBlock(os, fileContext, blockSizes[i]);
                }
            }
            try (FSDataInputStream is = fs.open(path);){
                HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(is, totalSize, fileContext);
                long pos = 0L;
                for (int i = 0; i < 10; ++i) {
                    pos += this.readAndVerifyBlock(pos, fileContext, hbr, blockSizes[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testHFileEncryptionMetadata() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        CacheConfig cacheConf = new CacheConfig(conf);
        HFileContext fileContext = new HFileContextBuilder().withEncryptionContext(cryptoContext).build();
        Path path = new Path(TEST_UTIL.getDataTestDir(), "cryptometa.hfile");
        FSDataOutputStream out = fs.create(path);
        HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withOutputStream(out).withFileContext(fileContext).create();
        try {
            KeyValue kv = new KeyValue("foo".getBytes(), "f1".getBytes(), null, "value".getBytes());
            writer.append((Cell)kv);
        }
        finally {
            writer.close();
            out.close();
        }
        try (HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)path, (CacheConfig)cacheConf, (Configuration)conf);){
            reader.loadFileInfo();
            FixedFileTrailer trailer = reader.getTrailer();
            Assert.assertNotNull((Object)trailer.getEncryptionKey());
            Encryption.Context readerContext = reader.getFileContext().getEncryptionContext();
            Assert.assertEquals((Object)readerContext.getCipher().getName(), (Object)cryptoContext.getCipher().getName());
            Assert.assertTrue((boolean)Bytes.equals((byte[])readerContext.getKeyBytes(), (byte[])cryptoContext.getKeyBytes()));
        }
    }

    @Test(timeout=6000000L)
    public void testHFileEncryption() throws Exception {
        RedundantKVGenerator generator = new RedundantKVGenerator();
        List testKvs = generator.generateTestKeyValues(1000);
        Configuration conf = TEST_UTIL.getConfiguration();
        CacheConfig cacheConf = new CacheConfig(conf);
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            for (Compression.Algorithm compression : TestHFileBlock.COMPRESSION_ALGORITHMS) {
                Cell kv;
                HFileContext fileContext = new HFileContextBuilder().withBlockSize(4096).withEncryptionContext(cryptoContext).withCompression(compression).withDataBlockEncoding(encoding).build();
                LOG.info((Object)("Writing with " + fileContext));
                Path path = new Path(TEST_UTIL.getDataTestDir(), UUID.randomUUID().toString() + ".hfile");
                FSDataOutputStream out = fs.create(path);
                HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withOutputStream(out).withFileContext(fileContext).create();
                for (KeyValue kv2 : testKvs) {
                    writer.append((Cell)kv2);
                }
                writer.close();
                out.close();
                LOG.info((Object)("Reading with " + fileContext));
                HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)path, (CacheConfig)cacheConf, (Configuration)conf);
                reader.loadFileInfo();
                FixedFileTrailer trailer = reader.getTrailer();
                Assert.assertNotNull((Object)trailer.getEncryptionKey());
                HFileScanner scanner = reader.getScanner(false, false);
                Assert.assertTrue((String)"Initial seekTo failed", (boolean)scanner.seekTo());
                int i = 0;
                do {
                    kv = scanner.getKeyValue();
                    Assert.assertTrue((String)"Read back an unexpected or invalid KV", (boolean)testKvs.contains(KeyValueUtil.ensureKeyValue((Cell)kv)));
                    ++i;
                } while (scanner.next());
                reader.close();
                Assert.assertEquals((String)"Did not read back as many KVs as written", (long)i, (long)testKvs.size());
                LOG.info((Object)("Random seeking with " + fileContext));
                reader = HFile.createReader((FileSystem)fs, (Path)path, (CacheConfig)cacheConf, (Configuration)conf);
                scanner = reader.getScanner(false, true);
                Assert.assertTrue((String)"Initial seekTo failed", (boolean)scanner.seekTo());
                for (i = 0; i < 100; ++i) {
                    kv = (KeyValue)testKvs.get(RNG.nextInt(testKvs.size()));
                    Assert.assertEquals((String)("Unable to find KV as expected: " + kv), (long)scanner.seekTo(kv), (long)0L);
                }
                reader.close();
            }
        }
    }
}

