/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.hfile.bucket.FileIOEngine;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFileIOEngine {
    private static final long TOTAL_CAPACITY = 0x600000L;
    private static final String[] FILE_PATHS;
    private static final long SIZE_PER_FILE;
    private static final List<Long> boundaryStartPositions;
    private static final List<Long> boundaryStopPositions;
    private FileIOEngine fileIOEngine;

    @Before
    public void setUp() throws IOException {
        this.fileIOEngine = new FileIOEngine(0x600000L, FILE_PATHS);
    }

    @After
    public void cleanUp() throws IOException {
        this.fileIOEngine.shutdown();
        for (String filePath : FILE_PATHS) {
            File file = new File(filePath);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    @Test
    public void testFileIOEngine() throws IOException {
        for (int i = 0; i < 500; ++i) {
            int len = (int)Math.floor(Math.random() * 100.0) + 1;
            long offset = (long)Math.floor(Math.random() * 6291456.0 % (double)(0x600000L - (long)len));
            if (i < boundaryStartPositions.size()) {
                offset = boundaryStartPositions.get(i);
            } else if (i - boundaryStartPositions.size() < boundaryStopPositions.size()) {
                offset = boundaryStopPositions.get(i - boundaryStartPositions.size()) - (long)len + 1L;
            } else if (i % 2 == 0) {
                offset = (long)Math.max(1, i % FILE_PATHS.length) * SIZE_PER_FILE - (long)(len / 2);
            }
            byte[] data1 = new byte[len];
            for (int j = 0; j < data1.length; ++j) {
                data1[j] = (byte)(Math.random() * 255.0);
            }
            byte[] data2 = new byte[len];
            this.fileIOEngine.write(ByteBuffer.wrap(data1), offset);
            this.fileIOEngine.read(ByteBuffer.wrap(data2), offset);
            Assert.assertArrayEquals((byte[])data1, (byte[])data2);
        }
    }

    @Test
    public void testFileIOEngineHandlesZeroLengthInput() throws IOException {
        byte[] data1 = new byte[]{};
        byte[] data2 = new byte[]{};
        this.fileIOEngine.write(ByteBuffer.wrap(data1), 0L);
        this.fileIOEngine.read(ByteBuffer.wrap(data2), 0L);
        Assert.assertArrayEquals((byte[])data1, (byte[])data2);
    }

    @Test
    public void testClosedChannelException() throws IOException {
        this.fileIOEngine.closeFileChannels();
        int len = 5;
        long offset = 0L;
        byte[] data1 = new byte[len];
        for (int j = 0; j < data1.length; ++j) {
            data1[j] = (byte)(Math.random() * 255.0);
        }
        byte[] data2 = new byte[len];
        this.fileIOEngine.write(ByteBuffer.wrap(data1), offset);
        this.fileIOEngine.read(ByteBuffer.wrap(data2), offset);
        Assert.assertArrayEquals((byte[])data1, (byte[])data2);
    }

    static {
        int i;
        FILE_PATHS = new String[]{"testFileIOEngine1", "testFileIOEngine2", "testFileIOEngine3"};
        SIZE_PER_FILE = 0x600000L / (long)FILE_PATHS.length;
        boundaryStartPositions = new ArrayList<Long>();
        boundaryStopPositions = new ArrayList<Long>();
        boundaryStartPositions.add(0L);
        for (i = 1; i < FILE_PATHS.length; ++i) {
            boundaryStartPositions.add(SIZE_PER_FILE * (long)i - 1L);
            boundaryStartPositions.add(SIZE_PER_FILE * (long)i);
            boundaryStartPositions.add(SIZE_PER_FILE * (long)i + 1L);
        }
        for (i = 1; i < FILE_PATHS.length; ++i) {
            boundaryStopPositions.add(SIZE_PER_FILE * (long)i - 1L);
            boundaryStopPositions.add(SIZE_PER_FILE * (long)i);
            boundaryStopPositions.add(SIZE_PER_FILE * (long)i + 1L);
        }
        boundaryStopPositions.add(SIZE_PER_FILE * (long)FILE_PATHS.length - 1L);
    }
}

