/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.AddColumnFamilyProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestAddColumnFamilyProcedure {
    private static final Log LOG = LogFactory.getLog(TestAddColumnFamilyProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestAddColumnFamilyProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (HTableDescriptor htd : UTIL.getHBaseAdmin().listTables()) {
            LOG.info((Object)("Tear down, remove table=" + htd.getTableName()));
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test(timeout=60000L)
    public void testAddColumnFamily() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAddColumnFamily");
        String cf1 = "cf1";
        String cf2 = "cf2";
        HColumnDescriptor columnDescriptor1 = new HColumnDescriptor("cf1");
        HColumnDescriptor columnDescriptor2 = new HColumnDescriptor("cf2");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f3");
        long procId1 = procExec.submitProcedure((Procedure)new AddColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor1));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId1);
        MasterProcedureTestingUtility.validateColumnFamilyAddition(UTIL.getHBaseCluster().getMaster(), tableName, "cf1");
        UTIL.getHBaseAdmin().disableTable(tableName);
        long procId2 = procExec.submitProcedure((Procedure)new AddColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor2));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId2);
        MasterProcedureTestingUtility.validateColumnFamilyAddition(UTIL.getHBaseCluster().getMaster(), tableName, "cf2");
    }

    @Test(timeout=60000L)
    public void testAddSameColumnFamilyTwice() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAddColumnFamilyTwice");
        String cf2 = "cf2";
        HColumnDescriptor columnDescriptor = new HColumnDescriptor("cf2");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1");
        long procId1 = procExec.submitProcedure((Procedure)new AddColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId1);
        MasterProcedureTestingUtility.validateColumnFamilyAddition(UTIL.getHBaseCluster().getMaster(), tableName, "cf2");
        long procId2 = procExec.submitProcedure((Procedure)new AddColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        ProcedureInfo result = procExec.getResult(procId2);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Add failed with exception: " + result.getExceptionFullMessage()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((ProcedureInfo)result) instanceof InvalidFamilyOperationException));
        UTIL.getHBaseAdmin().disableTable(tableName);
        long procId3 = procExec.submitProcedure((Procedure)new AddColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId3);
        result = procExec.getResult(procId3);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Add failed with exception: " + result.getExceptionFullMessage()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((ProcedureInfo)result) instanceof InvalidFamilyOperationException));
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionOffline() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRecoveryAndDoubleExecutionOffline");
        String cf4 = "cf4";
        HColumnDescriptor columnDescriptor = new HColumnDescriptor("cf4");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2", "f3");
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new AddColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor));
        int numberOfSteps = MasterProcedureProtos.AddColumnFamilyState.values().length;
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.AddColumnFamilyState.values());
        MasterProcedureTestingUtility.validateColumnFamilyAddition(UTIL.getHBaseCluster().getMaster(), tableName, "cf4");
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionOnline() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRecoveryAndDoubleExecutionOnline");
        String cf5 = "cf5";
        HColumnDescriptor columnDescriptor = new HColumnDescriptor("cf5");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2", "f3");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new AddColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor));
        int numberOfSteps = MasterProcedureProtos.AddColumnFamilyState.values().length;
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.AddColumnFamilyState.values());
        MasterProcedureTestingUtility.validateColumnFamilyAddition(UTIL.getHBaseCluster().getMaster(), tableName, "cf5");
    }

    @Test(timeout=60000L)
    public void testRollbackAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRollbackAndDoubleExecution");
        String cf6 = "cf6";
        HColumnDescriptor columnDescriptor = new HColumnDescriptor("cf6");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new AddColumnFamilyProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, columnDescriptor));
        int numberOfSteps = MasterProcedureProtos.AddColumnFamilyState.values().length - 2;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.AddColumnFamilyState.values());
        MasterProcedureTestingUtility.validateColumnFamilyDeletion(UTIL.getHBaseCluster().getMaster(), tableName, "cf6");
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }
}

