/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.TruncateTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestTruncateTableProcedure {
    private static final Log LOG = LogFactory.getLog(TestTruncateTableProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestTruncateTableProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        Assert.assertTrue((String)"expected executor to be running", (boolean)procExec.isRunning());
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (HTableDescriptor htd : UTIL.getHBaseAdmin().listTables()) {
            LOG.info((Object)("Tear down, remove table=" + htd.getTableName()));
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test(timeout=60000L)
    public void testTruncateNotExistentTable() throws Exception {
        TableName tableName = TableName.valueOf((String)"testTruncateNotExistentTable");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, true));
        ProcedureInfo result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Truncate failed with exception: " + result.getExceptionFullMessage()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((ProcedureInfo)result) instanceof TableNotFoundException));
    }

    @Test(timeout=60000L)
    public void testTruncateNotDisabledTable() throws Exception {
        TableName tableName = TableName.valueOf((String)"testTruncateNotDisabledTable");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        ProcedureInfo result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Truncate failed with exception: " + result.getExceptionFullMessage()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((ProcedureInfo)result) instanceof TableNotDisabledException));
    }

    @Test(timeout=60000L)
    public void testSimpleTruncatePreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)"testSimpleTruncatePreserveSplits");
        this.testSimpleTruncate(tableName, true);
    }

    @Test(timeout=60000L)
    public void testSimpleTruncateNoPreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)"testSimpleTruncateNoPreserveSplits");
        this.testSimpleTruncate(tableName, false);
    }

    private void testSimpleTruncate(TableName tableName, boolean preserveSplits) throws Exception {
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, splitKeys, families);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(tableName));
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, preserveSplits));
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        UTIL.waitUntilAllRegionsAssigned(tableName);
        regions = UTIL.getHBaseAdmin().getTableRegions(tableName).toArray(new HRegionInfo[0]);
        if (preserveSplits) {
            Assert.assertEquals((long)(1 + splitKeys.length), (long)regions.length);
        } else {
            Assert.assertEquals((long)1L, (long)regions.length);
        }
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, families);
        Assert.assertEquals((long)0L, (long)UTIL.countRows(tableName));
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 50, splitKeys, families);
        Assert.assertEquals((long)50L, (long)UTIL.countRows(tableName));
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionPreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRecoveryAndDoubleExecutionPreserveSplits");
        this.testRecoveryAndDoubleExecution(tableName, true);
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionNoPreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRecoveryAndDoubleExecutionNoPreserveSplits");
        this.testRecoveryAndDoubleExecution(tableName, false);
    }

    private void testRecoveryAndDoubleExecution(TableName tableName, boolean preserveSplits) throws Exception {
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, splitKeys, families);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(tableName));
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, preserveSplits));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, 7, MasterProcedureProtos.TruncateTableState.values());
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        UTIL.waitUntilAllRegionsAssigned(tableName);
        regions = UTIL.getHBaseAdmin().getTableRegions(tableName).toArray(new HRegionInfo[0]);
        if (preserveSplits) {
            Assert.assertEquals((long)(1 + splitKeys.length), (long)regions.length);
        } else {
            Assert.assertEquals((long)1L, (long)regions.length);
        }
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, families);
        Assert.assertEquals((long)0L, (long)UTIL.countRows(tableName));
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 50, splitKeys, families);
        Assert.assertEquals((long)50L, (long)UTIL.countRows(tableName));
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    @Test(timeout=60000L)
    public void testTruncateWithPreserveAfterSplit() throws Exception {
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        TableName tableName = TableName.valueOf((String)"testTruncateWithPreserveAfterSplit");
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 5000, splitKeys, families);
        Assert.assertEquals((long)5000L, (long)UTIL.countRows(tableName));
        UTIL.getHBaseAdmin().split(tableName);
        UTIL.waitUntilAllRegionsAssigned(tableName);
        while (UTIL.getHBaseAdmin().getTableRegions(tableName).size() <= regions.length) {
            Thread.sleep(50L);
        }
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, true));
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        UTIL.waitUntilAllRegionsAssigned(tableName);
    }
}

