/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.TestVisibilityLabels;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityControllerNotReadyException;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestVisibilityLabelsWithDefaultVisLabelService
extends TestVisibilityLabels {
    private static final Log LOG = LogFactory.getLog(TestVisibilityLabelsWithDefaultVisLabelService.class);

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.master.distributed.log.replay", false);
        conf.setBoolean("hbase.online.schema.update.enable", true);
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.set("hbase.superuser", "admin");
        TEST_UTIL.startMiniCluster(2);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestVisibilityLabelsWithDefaultVisLabelService.addLabels();
    }

    @Test
    public void testAddLabels() throws Throwable {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{"L1", "secret", "L2", "invalid~", "L3"};
                VisibilityLabelsProtos.VisibilityLabelsResponse response = null;
                try (Connection conn = ConnectionFactory.createConnection((Configuration)TestVisibilityLabels.conf);){
                    response = VisibilityClient.addLabels((Connection)conn, (String[])labels);
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have thrown exception");
                }
                List resultList = response.getResultList();
                Assert.assertEquals((long)5L, (long)resultList.size());
                Assert.assertTrue((boolean)((ClientProtos.RegionActionResult)resultList.get(0)).getException().getValue().isEmpty());
                Assert.assertEquals((Object)"org.apache.hadoop.hbase.DoNotRetryIOException", (Object)((ClientProtos.RegionActionResult)resultList.get(1)).getException().getName());
                Assert.assertTrue((boolean)Bytes.toString((byte[])((ClientProtos.RegionActionResult)resultList.get(1)).getException().getValue().toByteArray()).contains("org.apache.hadoop.hbase.security.visibility.LabelAlreadyExistsException: Label 'secret' already exists"));
                Assert.assertTrue((boolean)((ClientProtos.RegionActionResult)resultList.get(2)).getException().getValue().isEmpty());
                Assert.assertTrue((boolean)((ClientProtos.RegionActionResult)resultList.get(3)).getException().getValue().isEmpty());
                Assert.assertTrue((boolean)((ClientProtos.RegionActionResult)resultList.get(4)).getException().getValue().isEmpty());
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    @Test(timeout=60000L)
    public void testAddVisibilityLabelsOnRSRestart() throws Exception {
        List<JVMClusterUtil.RegionServerThread> regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
        for (JVMClusterUtil.RegionServerThread rsThread : regionServerThreads) {
            rsThread.getRegionServer().abort("Aborting ");
        }
        JVMClusterUtil.RegionServerThread rs = TEST_UTIL.getHBaseCluster().startRegionServer();
        this.waitForLabelsRegionAvailability(rs.getRegionServer());
        final AtomicBoolean vcInitialized = new AtomicBoolean(true);
        do {
            PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

                @Override
                public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                    String[] labels = new String[]{"secret", "confidential", "private", "ABC", "XYZ"};
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)TestVisibilityLabels.conf);){
                        VisibilityLabelsProtos.VisibilityLabelsResponse resp = VisibilityClient.addLabels((Connection)conn, (String[])labels);
                        List results = resp.getResultList();
                        if (((ClientProtos.RegionActionResult)results.get(0)).hasException()) {
                            HBaseProtos.NameBytesPair pair = ((ClientProtos.RegionActionResult)results.get(0)).getException();
                            Throwable t = ProtobufUtil.toException((HBaseProtos.NameBytesPair)pair);
                            LOG.debug((Object)"Got exception writing labels", t);
                            if (t instanceof VisibilityControllerNotReadyException) {
                                vcInitialized.set(false);
                                LOG.warn((Object)"VisibilityController was not yet initialized");
                                Threads.sleep((long)10L);
                            } else {
                                vcInitialized.set(true);
                            }
                        } else {
                            LOG.debug((Object)("new labels added: " + resp));
                        }
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)action);
        } while (!vcInitialized.get());
        Scan s = new Scan();
        s.setAuthorizations(new Authorizations(new String[]{"system"}));
        int i = 0;
        try (Table ht = TEST_UTIL.getConnection().getTable(VisibilityConstants.LABELS_TABLE_NAME);
             ResultScanner scanner = ht.getScanner(s);){
            Result next;
            while ((next = scanner.next()) != null) {
                ++i;
            }
        }
        Assert.assertEquals((String)"The count should be 13", (long)13L, (long)i);
    }

    @Test
    public void testListLabels() throws Throwable {
        PrivilegedExceptionAction<VisibilityLabelsProtos.ListLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.ListLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.ListLabelsResponse run() throws Exception {
                VisibilityLabelsProtos.ListLabelsResponse response = null;
                try (Connection conn = ConnectionFactory.createConnection((Configuration)TestVisibilityLabels.conf);){
                    response = VisibilityClient.listLabels((Connection)conn, null);
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have thrown exception");
                }
                List labels = response.getLabelList();
                Assert.assertEquals((long)12L, (long)labels.size());
                Assert.assertTrue((boolean)labels.contains(ByteString.copyFrom((byte[])"secret".getBytes())));
                Assert.assertTrue((boolean)labels.contains(ByteString.copyFrom((byte[])"topsecret".getBytes())));
                Assert.assertTrue((boolean)labels.contains(ByteString.copyFrom((byte[])"confidential".getBytes())));
                Assert.assertTrue((boolean)labels.contains(ByteString.copyFrom((byte[])"ABC".getBytes())));
                Assert.assertTrue((boolean)labels.contains(ByteString.copyFrom((byte[])"XYZ".getBytes())));
                Assert.assertFalse((boolean)labels.contains(ByteString.copyFrom((byte[])"system".getBytes())));
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    @Test
    public void testListLabelsWithRegEx() throws Throwable {
        PrivilegedExceptionAction<VisibilityLabelsProtos.ListLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.ListLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.ListLabelsResponse run() throws Exception {
                VisibilityLabelsProtos.ListLabelsResponse response = null;
                try (Connection conn = ConnectionFactory.createConnection((Configuration)TestVisibilityLabels.conf);){
                    response = VisibilityClient.listLabels((Connection)conn, (String)".*secret");
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have thrown exception");
                }
                List labels = response.getLabelList();
                Assert.assertEquals((long)2L, (long)labels.size());
                Assert.assertTrue((boolean)labels.contains(ByteString.copyFrom((byte[])"secret".getBytes())));
                Assert.assertTrue((boolean)labels.contains(ByteString.copyFrom((byte[])"topsecret".getBytes())));
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    @Test(timeout=60000L)
    public void testVisibilityLabelsOnWALReplay() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = TestVisibilityLabelsWithDefaultVisLabelService.createTableAndWriteDataWithLabels(tableName, "(secret|confidential)", "private");){
            List<JVMClusterUtil.RegionServerThread> regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
            for (JVMClusterUtil.RegionServerThread rsThread : regionServerThreads) {
                rsThread.getRegionServer().abort("Aborting ");
            }
            JVMClusterUtil.RegionServerThread rs = TEST_UTIL.getHBaseCluster().startRegionServer();
            this.waitForLabelsRegionAvailability(rs.getRegionServer());
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{"secret"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
        }
    }
}

