/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.Message;
import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class SplitLogTask {
    private final ServerName originServer;
    private final ZooKeeperProtos.SplitLogTask.State state;
    private final ZooKeeperProtos.SplitLogTask.RecoveryMode mode;

    SplitLogTask(ZooKeeperProtos.SplitLogTask slt) {
        this.originServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)slt.getServerName());
        this.state = slt.getState();
        this.mode = slt.hasMode() ? slt.getMode() : ZooKeeperProtos.SplitLogTask.RecoveryMode.UNKNOWN;
    }

    SplitLogTask(ServerName originServer, ZooKeeperProtos.SplitLogTask.State state, ZooKeeperProtos.SplitLogTask.RecoveryMode mode) {
        this.originServer = originServer;
        this.state = state;
        this.mode = mode;
    }

    public ServerName getServerName() {
        return this.originServer;
    }

    public ZooKeeperProtos.SplitLogTask.RecoveryMode getMode() {
        return this.mode;
    }

    public boolean isUnassigned(ServerName sn) {
        return this.originServer.equals((Object)sn) && this.isUnassigned();
    }

    public boolean isUnassigned() {
        return this.state == ZooKeeperProtos.SplitLogTask.State.UNASSIGNED;
    }

    public boolean isOwned(ServerName sn) {
        return this.originServer.equals((Object)sn) && this.isOwned();
    }

    public boolean isOwned() {
        return this.state == ZooKeeperProtos.SplitLogTask.State.OWNED;
    }

    public boolean isResigned(ServerName sn) {
        return this.originServer.equals((Object)sn) && this.isResigned();
    }

    public boolean isResigned() {
        return this.state == ZooKeeperProtos.SplitLogTask.State.RESIGNED;
    }

    public boolean isDone(ServerName sn) {
        return this.originServer.equals((Object)sn) && this.isDone();
    }

    public boolean isDone() {
        return this.state == ZooKeeperProtos.SplitLogTask.State.DONE;
    }

    public boolean isErr(ServerName sn) {
        return this.originServer.equals((Object)sn) && this.isErr();
    }

    public boolean isErr() {
        return this.state == ZooKeeperProtos.SplitLogTask.State.ERR;
    }

    public String toString() {
        return this.state.toString() + " " + this.originServer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SplitLogTask)) {
            return false;
        }
        SplitLogTask other = (SplitLogTask)obj;
        return other.state.equals((Object)this.state) && other.originServer.equals((Object)this.originServer);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.state.hashCode();
        return 31 * hash + this.originServer.hashCode();
    }

    public static SplitLogTask parseFrom(byte[] data) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix((byte[])data);
        try {
            int prefixLen = ProtobufUtil.lengthOfPBMagic();
            ZooKeeperProtos.SplitLogTask.Builder builder = ZooKeeperProtos.SplitLogTask.newBuilder();
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)prefixLen, (int)(data.length - prefixLen));
            return new SplitLogTask(builder.build());
        }
        catch (IOException e) {
            throw new DeserializationException(Bytes.toStringBinary((byte[])data, (int)0, (int)64), (Throwable)e);
        }
    }

    public byte[] toByteArray() {
        HBaseProtos.ServerName snpb = ProtobufUtil.toServerName((ServerName)this.originServer);
        ZooKeeperProtos.SplitLogTask slts = ZooKeeperProtos.SplitLogTask.newBuilder().setServerName(snpb).setState(this.state).setMode(this.mode).build();
        return ProtobufUtil.prependPBMagic((byte[])slts.toByteArray());
    }

    public static class Err
    extends SplitLogTask {
        public Err(ServerName originServer, ZooKeeperProtos.SplitLogTask.RecoveryMode mode) {
            super(originServer, ZooKeeperProtos.SplitLogTask.State.ERR, mode);
        }
    }

    public static class Done
    extends SplitLogTask {
        public Done(ServerName originServer, ZooKeeperProtos.SplitLogTask.RecoveryMode mode) {
            super(originServer, ZooKeeperProtos.SplitLogTask.State.DONE, mode);
        }
    }

    public static class Resigned
    extends SplitLogTask {
        public Resigned(ServerName originServer, ZooKeeperProtos.SplitLogTask.RecoveryMode mode) {
            super(originServer, ZooKeeperProtos.SplitLogTask.State.RESIGNED, mode);
        }
    }

    public static class Owned
    extends SplitLogTask {
        public Owned(ServerName originServer, ZooKeeperProtos.SplitLogTask.RecoveryMode mode) {
            super(originServer, ZooKeeperProtos.SplitLogTask.State.OWNED, mode);
        }
    }

    public static class Unassigned
    extends SplitLogTask {
        public Unassigned(ServerName originServer, ZooKeeperProtos.SplitLogTask.RecoveryMode mode) {
            super(originServer, ZooKeeperProtos.SplitLogTask.State.UNASSIGNED, mode);
        }
    }
}

