/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hbase.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RegionLocationFinder {
    private static final Logger LOG = LoggerFactory.getLogger(RegionLocationFinder.class);
    private static final long CACHE_TIME = 14400000L;
    private static final HDFSBlocksDistribution EMPTY_BLOCK_DISTRIBUTION = new HDFSBlocksDistribution();
    private Configuration conf;
    private volatile ClusterMetrics status;
    private MasterServices services;
    private final ListeningExecutorService executor;
    private long lastFullRefresh = EnvironmentEdgeManager.currentTime();
    private CacheLoader<RegionInfo, HDFSBlocksDistribution> loader = new CacheLoader<RegionInfo, HDFSBlocksDistribution>(){

        public ListenableFuture<HDFSBlocksDistribution> reload(final RegionInfo hri, HDFSBlocksDistribution oldValue) throws Exception {
            return RegionLocationFinder.this.executor.submit((Callable)new Callable<HDFSBlocksDistribution>(){

                @Override
                public HDFSBlocksDistribution call() throws Exception {
                    return RegionLocationFinder.this.internalGetTopBlockLocation(hri);
                }
            });
        }

        public HDFSBlocksDistribution load(RegionInfo key) throws Exception {
            return RegionLocationFinder.this.internalGetTopBlockLocation(key);
        }
    };
    private LoadingCache<RegionInfo, HDFSBlocksDistribution> cache = this.createCache();

    RegionLocationFinder() {
        this.executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("region-location-%d").build()));
    }

    private LoadingCache<RegionInfo, HDFSBlocksDistribution> createCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(14400000L, TimeUnit.MILLISECONDS).build(this.loader);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public void setServices(MasterServices services) {
        this.services = services;
    }

    public void setClusterMetrics(ClusterMetrics status) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        this.status = status;
        if (currentTime > this.lastFullRefresh + 0x6DDD00L) {
            this.lastFullRefresh = this.scheduleFullRefresh() ? currentTime : this.lastFullRefresh;
        }
    }

    private boolean scheduleFullRefresh() {
        if (this.services == null) {
            return false;
        }
        AssignmentManager am = this.services.getAssignmentManager();
        if (am == null) {
            return false;
        }
        boolean includesUserTables = false;
        for (RegionInfo hri : am.getAssignedRegions()) {
            this.cache.refresh((Object)hri);
            includesUserTables = includesUserTables || !hri.getTable().isSystemTable();
        }
        return includesUserTables;
    }

    protected List<ServerName> getTopBlockLocations(RegionInfo region) {
        List<String> topHosts = this.getBlockDistribution(region).getTopHosts();
        return this.mapHostNameToServerName(topHosts);
    }

    protected List<ServerName> getTopBlockLocations(RegionInfo region, String currentHost) {
        HDFSBlocksDistribution blocksDistribution = this.getBlockDistribution(region);
        ArrayList<String> topHosts = new ArrayList<String>();
        for (String host : blocksDistribution.getTopHosts()) {
            if (host.equals(currentHost)) break;
            topHosts.add(host);
        }
        return this.mapHostNameToServerName(topHosts);
    }

    protected HDFSBlocksDistribution internalGetTopBlockLocation(RegionInfo region) {
        try {
            TableDescriptor tableDescriptor = this.getTableDescriptor(region.getTable());
            if (tableDescriptor != null) {
                HDFSBlocksDistribution blocksDistribution = HRegion.computeHDFSBlocksDistribution(this.getConf(), tableDescriptor, region);
                return blocksDistribution;
            }
        }
        catch (IOException ioe) {
            LOG.warn("IOException during HDFSBlocksDistribution computation. for region = " + region.getEncodedName(), (Throwable)ioe);
        }
        return EMPTY_BLOCK_DISTRIBUTION;
    }

    protected TableDescriptor getTableDescriptor(TableName tableName) throws IOException {
        TableDescriptor tableDescriptor = null;
        try {
            if (this.services != null && this.services.getTableDescriptors() != null) {
                tableDescriptor = this.services.getTableDescriptors().get(tableName);
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.debug("tableName={}", (Object)tableName, (Object)fnfe);
        }
        return tableDescriptor;
    }

    protected List<ServerName> mapHostNameToServerName(List<String> hosts) {
        if (hosts == null || this.status == null) {
            if (hosts == null) {
                LOG.warn("RegionLocationFinder top hosts is null");
            }
            return Lists.newArrayList();
        }
        ArrayList<ServerName> topServerNames = new ArrayList<ServerName>();
        Set regionServers = this.status.getLiveServerMetrics().keySet();
        HashMap hostToServerName = new HashMap();
        for (ServerName sn : regionServers) {
            String host = sn.getHostname();
            if (!hostToServerName.containsKey(host)) {
                hostToServerName.put(host, new ArrayList());
            }
            ((List)hostToServerName.get(host)).add(sn);
        }
        for (String host : hosts) {
            if (!hostToServerName.containsKey(host)) continue;
            for (ServerName sn : (List)hostToServerName.get(host)) {
                if (sn == null) continue;
                topServerNames.add(sn);
            }
        }
        return topServerNames;
    }

    public HDFSBlocksDistribution getBlockDistribution(RegionInfo hri) {
        HDFSBlocksDistribution blockDistbn = null;
        try {
            if (this.cache.asMap().containsKey(hri)) {
                blockDistbn = (HDFSBlocksDistribution)this.cache.get((Object)hri);
                return blockDistbn;
            }
            LOG.trace("HDFSBlocksDistribution not found in cache for {}", (Object)hri.getRegionNameAsString());
            blockDistbn = this.internalGetTopBlockLocation(hri);
            this.cache.put((Object)hri, (Object)blockDistbn);
            return blockDistbn;
        }
        catch (ExecutionException e) {
            LOG.warn("Error while fetching cache entry ", (Throwable)e);
            blockDistbn = this.internalGetTopBlockLocation(hri);
            this.cache.put((Object)hri, (Object)blockDistbn);
            return blockDistbn;
        }
    }

    private ListenableFuture<HDFSBlocksDistribution> asyncGetBlockDistribution(RegionInfo hri) {
        try {
            return this.loader.reload((Object)hri, (Object)EMPTY_BLOCK_DISTRIBUTION);
        }
        catch (Exception e) {
            return Futures.immediateFuture((Object)EMPTY_BLOCK_DISTRIBUTION);
        }
    }

    public void refreshAndWait(Collection<RegionInfo> hris) {
        ArrayList<ListenableFuture<HDFSBlocksDistribution>> regionLocationFutures = new ArrayList<ListenableFuture<HDFSBlocksDistribution>>(hris.size());
        for (RegionInfo hregionInfo : hris) {
            regionLocationFutures.add(this.asyncGetBlockDistribution(hregionInfo));
        }
        int index = 0;
        LOG.info("Refreshing block distribution cache for {} regions (Can take a while on big cluster)", (Object)hris.size());
        for (RegionInfo hregionInfo : hris) {
            ListenableFuture future = (ListenableFuture)regionLocationFutures.get(index);
            try {
                this.cache.put((Object)hregionInfo, future.get());
            }
            catch (InterruptedException ite) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ee) {
                LOG.debug("ExecutionException during HDFSBlocksDistribution computation. for region = " + hregionInfo.getEncodedName(), (Throwable)ee);
            }
            ++index;
        }
        LOG.info("Finished refreshing block distribution cache for {} regions", (Object)hris.size());
    }

    LoadingCache<RegionInfo, HDFSBlocksDistribution> getCache() {
        return this.cache;
    }
}

