/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hive.hcatalog.api.HCatPartition;
import org.apache.hive.hcatalog.api.HCatTable;
import org.apache.hive.hcatalog.common.HCatException;

@InterfaceAudience.LimitedPrivate(value={"Hive"})
@InterfaceStability.Evolving
public class HCatPartitionSpec {
    protected HCatTable hcatTable;
    protected PartitionSpecProxy partitionSpecProxy;

    protected HCatPartitionSpec(HCatTable hcatTable, PartitionSpecProxy partitionSpecProxy) throws HCatException {
        this.hcatTable = hcatTable;
        this.partitionSpecProxy = partitionSpecProxy;
        this.assert_invariant();
    }

    public String getDbName() {
        return this.partitionSpecProxy.getDbName();
    }

    public String getTableName() {
        return this.partitionSpecProxy.getTableName();
    }

    void hcatTable(HCatTable hcatTable) throws HCatException {
        assert (this.hcatTable == null) : "Expected hcatTable to be null at this point.";
        this.hcatTable = hcatTable;
        this.assert_invariant();
    }

    PartitionSpecProxy toPartitionSpecProxy() {
        return this.partitionSpecProxy;
    }

    public int size() throws HCatException {
        return this.partitionSpecProxy.size();
    }

    public void setRootLocation(String location) throws HCatException {
        try {
            this.partitionSpecProxy.setRootLocation(location);
        }
        catch (MetaException metaException) {
            throw new HCatException("Unable to set root-path!", (Throwable)metaException);
        }
    }

    public HCatPartitionIterator getPartitionIterator() {
        return new HCatPartitionIterator(this.hcatTable, this.partitionSpecProxy.getPartitionIterator());
    }

    private void assert_invariant() throws HCatException {
        if (this.hcatTable != null) {
            if (!this.hcatTable.getDbName().equalsIgnoreCase(this.partitionSpecProxy.getDbName())) {
                String errorMessage = "Invalid HCatPartitionSpec instance: Table's DBName (" + this.hcatTable.getDbName() + ") doesn't match PartitionSpec (" + this.partitionSpecProxy.getDbName() + ")";
                assert (false) : errorMessage;
                throw new HCatException(errorMessage);
            }
            if (!this.hcatTable.getTableName().equalsIgnoreCase(this.partitionSpecProxy.getTableName())) {
                String errorMessage = "Invalid HCatPartitionSpec instance: Table's TableName (" + this.hcatTable.getTableName() + ") doesn't match PartitionSpec (" + this.partitionSpecProxy.getTableName() + ")";
                assert (false) : errorMessage;
                throw new HCatException(errorMessage);
            }
        }
    }

    public static class HCatPartitionIterator {
        private HCatTable hcatTable;
        private PartitionSpecProxy.PartitionIterator iterator;

        HCatPartitionIterator(HCatTable hcatTable, PartitionSpecProxy.PartitionIterator iterator) {
            this.hcatTable = hcatTable;
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public HCatPartition next() throws HCatException {
            return new HCatPartition(this.hcatTable, (Partition)this.iterator.next());
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

