/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.tez.MapRecordSource;
import org.apache.hadoop.hive.ql.exec.tez.RecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.hive.ql.exec.tez.tools.KeyValueInputMerger;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapOperator;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.input.MultiMRInput;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class MapRecordProcessor
extends RecordProcessor {
    private MapOperator mapOp;
    private final List<MapOperator> mergeMapOpList = new ArrayList<MapOperator>();
    public static final Log l4j = LogFactory.getLog(MapRecordProcessor.class);
    private MapRecordSource[] sources;
    private final Map<String, MultiMRInput> multiMRInputMap = new HashMap<String, MultiMRInput>();
    private int position = 0;
    MRInputLegacy legacyMRInput = null;
    MultiMRInput mainWorkMultiMRInput = null;
    private ExecMapperContext execContext = null;
    private boolean abort = false;
    protected static final String MAP_PLAN_KEY = "__MAP_PLAN__";
    private MapWork mapWork;
    List<BaseWork> mergeWorkList = null;
    List<String> cacheKeys;
    ObjectCache cache;
    private static Map<Integer, DummyStoreOperator> connectOps = new TreeMap<Integer, DummyStoreOperator>();

    public MapRecordProcessor(final JobConf jconf, ProcessorContext context) throws Exception {
        super(jconf, context);
        ObjectCache cache = ObjectCacheFactory.getCache((Configuration)jconf);
        this.execContext = new ExecMapperContext(jconf);
        this.execContext.setJc(jconf);
        this.cacheKeys = new ArrayList<String>();
        String queryId = HiveConf.getVar((Configuration)jconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYID);
        String key = queryId + MAP_PLAN_KEY;
        this.cacheKeys.add(key);
        this.mapWork = (MapWork)cache.retrieve(key, new Callable<Object>(){

            @Override
            public Object call() {
                return Utilities.getMapWork((Configuration)jconf);
            }
        });
        Utilities.setMapWork((Configuration)jconf, this.mapWork);
        this.mergeWorkList = this.getMergeWorkList(jconf, key, queryId, cache, this.cacheKeys);
    }

    @Override
    void init(MRTaskReporter mrReporter, Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        Configuration updatedConf;
        this.perfLogger.PerfLogBegin(this.CLASS_NAME, "TezInitializeOperators");
        super.init(mrReporter, inputs, outputs);
        MapredContext.init(true, new JobConf((Configuration)this.jconf));
        ((TezContext)MapredContext.get()).setInputs(inputs);
        ((TezContext)MapredContext.get()).setTezProcessorContext(this.processorContext);
        this.legacyMRInput = this.getMRInput(inputs);
        if (this.legacyMRInput != null && (updatedConf = this.legacyMRInput.getConfigUpdates()) != null) {
            for (Map.Entry entry : updatedConf) {
                this.jconf.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.createOutputMap();
        for (Map.Entry<String, LogicalOutput> outputEntry : outputs.entrySet()) {
            l4j.debug((Object)("Starting Output: " + outputEntry.getKey()));
            outputEntry.getValue().start();
            ((TezProcessor.TezKVOutputCollector)this.outMap.get(outputEntry.getKey())).initialize();
        }
        try {
            this.mapOp = this.mapWork.getVectorMode() ? new VectorMapOperator() : new MapOperator();
            this.mapOp.setExecContext(this.execContext);
            connectOps.clear();
            if (this.mergeWorkList != null) {
                MapOperator mergeMapOp = null;
                for (BaseWork baseWork : this.mergeWorkList) {
                    MapWork mergeMapWork = (MapWork)baseWork;
                    mergeMapOp = mergeMapWork.getVectorMode() ? new VectorMapOperator() : new MapOperator();
                    this.mergeMapOpList.add(mergeMapOp);
                    if (mergeMapOp == null) continue;
                    mergeMapOp.setConf(mergeMapWork);
                    l4j.info((Object)("Input name is " + mergeMapWork.getName()));
                    this.jconf.set("iocontext.input.name", mergeMapWork.getName());
                    mergeMapOp.initialize((Configuration)this.jconf, null);
                    mergeMapOp.setChildren((Configuration)this.jconf);
                    DummyStoreOperator dummyOp = this.getJoinParentOp(mergeMapOp);
                    connectOps.put(mergeMapWork.getTag(), dummyOp);
                    mergeMapOp.passExecContext(new ExecMapperContext(this.jconf));
                    mergeMapOp.initializeLocalWork((Configuration)this.jconf);
                }
            }
            ((TezContext)MapredContext.get()).setDummyOpsMap(connectOps);
            this.mapOp.setConf(this.mapWork);
            l4j.info((Object)("Main input name is " + this.mapWork.getName()));
            this.jconf.set("iocontext.input.name", this.mapWork.getName());
            this.mapOp.initialize((Configuration)this.jconf, null);
            this.mapOp.setChildren((Configuration)this.jconf);
            this.mapOp.passExecContext(this.execContext);
            l4j.info((Object)this.mapOp.dump(0));
            this.mapOp.initializeLocalWork((Configuration)this.jconf);
            this.initializeMapRecordSources();
            this.mapOp.initializeMapOperator((Configuration)this.jconf);
            if (this.mergeMapOpList != null && !this.mergeMapOpList.isEmpty()) {
                for (MapOperator mergeMapOp : this.mergeMapOpList) {
                    this.jconf.set("iocontext.input.name", ((MapWork)mergeMapOp.getConf()).getName());
                    mergeMapOp.initializeMapOperator((Configuration)this.jconf);
                }
            }
            List<HashTableDummyOperator> dummyOps = this.mapWork.getDummyOps();
            this.jconf.set("iocontext.input.name", this.mapWork.getName());
            if (dummyOps != null) {
                for (Operator operator : dummyOps) {
                    operator.setExecContext(this.execContext);
                    operator.initialize((Configuration)this.jconf, null);
                }
            }
            OperatorUtils.setChildrenCollector(this.mapOp.getChildOperators(), this.outMap);
            this.mapOp.setReporter((Reporter)this.reporter);
            MapredContext.get().setReporter((Reporter)this.reporter);
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Map operator initialization failed", e);
        }
        this.perfLogger.PerfLogEnd(this.CLASS_NAME, "TezInitializeOperators");
    }

    private void initializeMapRecordSources() throws Exception {
        int size = this.mergeMapOpList.size() + 1;
        this.sources = new MapRecordSource[size];
        this.position = ((MapWork)this.mapOp.getConf()).getTag();
        this.sources[this.position] = new MapRecordSource();
        KeyValueReader reader = null;
        reader = this.mainWorkMultiMRInput != null ? this.getKeyValueReader(this.mainWorkMultiMRInput.getKeyValueReaders(), this.mapOp) : this.legacyMRInput.getReader();
        this.sources[this.position].init(this.jconf, this.mapOp, reader);
        for (MapOperator mapOp : this.mergeMapOpList) {
            int tag = ((MapWork)mapOp.getConf()).getTag();
            this.sources[tag] = new MapRecordSource();
            String inputName = ((MapWork)mapOp.getConf()).getName();
            MultiMRInput multiMRInput = this.multiMRInputMap.get(inputName);
            Collection kvReaders = multiMRInput.getKeyValueReaders();
            l4j.debug((Object)("There are " + kvReaders.size() + " key-value readers for input " + inputName));
            reader = this.getKeyValueReader(kvReaders, mapOp);
            this.sources[tag].init(this.jconf, mapOp, reader);
        }
        ((TezContext)MapredContext.get()).setRecordSources(this.sources);
    }

    private KeyValueReader getKeyValueReader(Collection<KeyValueReader> keyValueReaders, MapOperator mapOp) throws Exception {
        ArrayList<KeyValueReader> kvReaderList = new ArrayList<KeyValueReader>(keyValueReaders);
        mapOp.initializeContexts();
        Deserializer deserializer = mapOp.getCurrentDeserializer();
        KeyValueInputMerger reader = new KeyValueInputMerger(kvReaderList, deserializer, new ObjectInspector[]{deserializer.getObjectInspector()}, ((MapWork)mapOp.getConf()).getSortCols());
        return reader;
    }

    private DummyStoreOperator getJoinParentOp(Operator<? extends OperatorDesc> mergeMapOp) {
        Iterator<Operator<OperatorDesc>> i$ = mergeMapOp.getChildOperators().iterator();
        if (i$.hasNext()) {
            Operator<OperatorDesc> childOp = i$.next();
            if (childOp.getChildOperators() == null || childOp.getChildOperators().isEmpty()) {
                return (DummyStoreOperator)childOp;
            }
            return this.getJoinParentOp(childOp);
        }
        return null;
    }

    @Override
    void run() throws Exception {
        while (this.sources[this.position].pushRecord()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        if (!this.abort) {
            this.abort = this.execContext.getIoCxt().getIOExceptions();
        }
        if (this.cache != null && this.cacheKeys != null) {
            for (String k : this.cacheKeys) {
                this.cache.release(k);
            }
        }
        try {
            List<HashTableDummyOperator> dummyOps;
            if (this.mapOp == null || this.mapWork == null) {
                return;
            }
            this.mapOp.close(this.abort);
            if (!this.mergeMapOpList.isEmpty()) {
                for (MapOperator mergeMapOp : this.mergeMapOpList) {
                    mergeMapOp.close(this.abort);
                }
            }
            if ((dummyOps = this.mapWork.getDummyOps()) != null) {
                for (Operator operator : dummyOps) {
                    operator.close(this.abort);
                }
            }
            ExecMapper.ReportStats rps = new ExecMapper.ReportStats((Reporter)this.reporter, (Configuration)this.jconf);
            this.mapOp.preorderMap(rps);
            return;
        }
        catch (Exception e) {
            if (!this.abort) {
                l4j.error((Object)"Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators", e);
            }
        }
        finally {
            Utilities.clearWorkMap();
            MapredContext.close();
        }
    }

    private MRInputLegacy getMRInput(Map<String, LogicalInput> inputs) throws Exception {
        MRInputLegacy theMRInput = null;
        HashSet<LogicalInput> li = new HashSet<LogicalInput>();
        for (LogicalInput logicalInput : inputs.values()) {
            if (!(logicalInput instanceof MRInputLegacy) && !(logicalInput instanceof MultiMRInput)) continue;
            logicalInput.start();
            li.add(logicalInput);
        }
        this.processorContext.waitForAllInputsReady(li);
        l4j.info((Object)("The input names are: " + Arrays.toString(inputs.keySet().toArray())));
        for (Map.Entry entry : inputs.entrySet()) {
            if (entry.getValue() instanceof MRInputLegacy) {
                if (theMRInput != null) {
                    throw new IllegalArgumentException("Only one MRInput is expected");
                }
                theMRInput = (MRInputLegacy)entry.getValue();
                continue;
            }
            if (!(entry.getValue() instanceof MultiMRInput)) continue;
            this.multiMRInputMap.put((String)entry.getKey(), (MultiMRInput)entry.getValue());
        }
        if (theMRInput != null) {
            theMRInput.init();
        } else {
            String alias = this.mapWork.getAliasToWork().keySet().iterator().next();
            if (inputs.get(alias) instanceof MultiMRInput) {
                this.mainWorkMultiMRInput = (MultiMRInput)inputs.get(alias);
            } else {
                throw new IOException("Unexpected input type found: " + inputs.get(alias).getClass().getCanonicalName());
            }
        }
        return theMRInput;
    }
}

