/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMultiSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class VectorMapJoinInnerBigOnlyLongOperator
extends VectorMapJoinInnerBigOnlyGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinInnerBigOnlyLongOperator.class.getName());
    private static final String CLASS_NAME = VectorMapJoinInnerBigOnlyLongOperator.class.getName();
    private transient VectorMapJoinLongHashMultiSet hashMultiSet;
    private transient boolean useMinMax;
    private transient long min;
    private transient long max;
    private transient int singleJoinColumn;

    public VectorMapJoinInnerBigOnlyLongOperator() {
    }

    public VectorMapJoinInnerBigOnlyLongOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.singleJoinColumn = this.bigTableKeyColumnMap[0];
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashMultiSet = (VectorMapJoinLongHashMultiSet)this.vectorMapJoinHashTable;
                this.useMinMax = this.hashMultiSet.useMinMax();
                if (this.useMinMax) {
                    this.min = this.hashMultiSet.min();
                    this.max = this.hashMultiSet.max();
                }
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " empty"));
                }
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            int numSel = 0;
            LongColumnVector joinColVector = (LongColumnVector)batch.cols[this.singleJoinColumn];
            long[] vector = joinColVector.vector;
            boolean allKeyInputColumnsRepeating = joinColVector.isRepeating;
            if (allKeyInputColumnsRepeating) {
                long key = vector[0];
                JoinUtil.JoinResult joinResult = this.useMinMax && (key < this.min || key > this.max) ? JoinUtil.JoinResult.NOMATCH : this.hashMultiSet.contains(key, this.hashMultiSetResults[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name()));
                }
                numSel = this.finishInnerBigOnlyRepeated(batch, joinResult, this.hashMultiSetResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated"));
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMultiSetResultCount = 0;
                int allMatchCount = 0;
                int equalKeySeriesCount = 0;
                int spillCount = 0;
                long saveKey = 0L;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block21: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    long currentKey = vector[batchIndex];
                    if (!haveSaveKey || currentKey != saveKey) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    ++equalKeySeriesCount;
                                    break;
                                }
                                case SPILL: {
                                    ++hashMultiSetResultCount;
                                    break;
                                }
                            }
                        }
                        haveSaveKey = true;
                        saveKey = currentKey;
                        saveJoinResult = this.useMinMax && (currentKey < this.min || currentKey > this.max) ? JoinUtil.JoinResult.NOMATCH : this.hashMultiSet.contains(currentKey, this.hashMultiSetResults[hashMultiSetResultCount]);
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.equalKeySeriesValueCounts[equalKeySeriesCount] = this.hashMultiSetResults[hashMultiSetResultCount].count();
                                this.equalKeySeriesAllMatchIndices[equalKeySeriesCount] = allMatchCount;
                                this.equalKeySeriesDuplicateCounts[equalKeySeriesCount] = 1;
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashMultiSetResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            int n = equalKeySeriesCount;
                            this.equalKeySeriesDuplicateCounts[n] = this.equalKeySeriesDuplicateCounts[n] + 1;
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block21;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMultiSetResultCount;
                            ++spillCount;
                            continue block21;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            ++equalKeySeriesCount;
                            break;
                        }
                        case SPILL: {
                            ++hashMultiSetResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " allMatchs " + VectorMapJoinInnerBigOnlyLongOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " equalKeySeriesValueCounts " + VectorMapJoinInnerBigOnlyLongOperator.longArrayToRangesString(this.equalKeySeriesValueCounts, equalKeySeriesCount) + " equalKeySeriesAllMatchIndices " + VectorMapJoinInnerBigOnlyLongOperator.intArrayToRangesString(this.equalKeySeriesAllMatchIndices, equalKeySeriesCount) + " equalKeySeriesDuplicateCounts " + VectorMapJoinInnerBigOnlyLongOperator.intArrayToRangesString(this.equalKeySeriesDuplicateCounts, equalKeySeriesCount) + " spills " + VectorMapJoinInnerBigOnlyLongOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinInnerBigOnlyLongOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMultiSetResults, 0, hashMultiSetResultCount))));
                }
                numSel = this.finishInnerBigOnly(batch, this.allMatchs, allMatchCount, this.equalKeySeriesValueCounts, this.equalKeySeriesAllMatchIndices, this.equalKeySeriesDuplicateCounts, equalKeySeriesCount, this.spills, this.spillHashMapResultIndices, spillCount, this.hashMultiSetResults, hashMultiSetResultCount);
            }
            batch.selectedInUse = true;
            batch.size = numSel;
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

