/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.DiskRange;
import org.apache.hadoop.hive.common.DiskRangeList;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.filters.BloomFilterIO;
import org.apache.hadoop.hive.ql.io.orc.BooleanColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatisticsImpl;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.DateColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.DecimalColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.DoubleColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.IntegerColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.MetadataReader;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderFactory;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderUtils;
import org.apache.hadoop.hive.ql.io.orc.StreamName;
import org.apache.hadoop.hive.ql.io.orc.StringColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.TimestampColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.TreeReaderFactory;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.io.Text;

class RecordReaderImpl
implements RecordReader {
    static final Log LOG = LogFactory.getLog(RecordReaderImpl.class);
    private static final boolean isLogDebugEnabled = LOG.isDebugEnabled();
    private final Path path;
    private final FSDataInputStream file;
    private final long firstRow;
    private final List<StripeInformation> stripes = new ArrayList<StripeInformation>();
    private OrcProto.StripeFooter stripeFooter;
    private final long totalRowCount;
    private final CompressionCodec codec;
    private final List<OrcProto.Type> types;
    private final int bufferSize;
    private final boolean[] included;
    private final long rowIndexStride;
    private long rowInStripe = 0L;
    private int currentStripe = -1;
    private long rowBaseInStripe = 0L;
    private long rowCountInStripe = 0L;
    private final Map<StreamName, InStream> streams = new HashMap<StreamName, InStream>();
    DiskRangeList bufferChunks = null;
    private final TreeReaderFactory.TreeReader reader;
    private final OrcProto.RowIndex[] indexes;
    private final OrcProto.BloomFilterIndex[] bloomFilterIndices;
    private final SargApplier sargApp;
    private boolean[] includedRowGroups = null;
    private final Configuration conf;
    private final MetadataReader metadata;
    private final RecordReaderUtils.ByteBufferAllocatorPool pool = new RecordReaderUtils.ByteBufferAllocatorPool();
    private final HadoopShims.ZeroCopyReaderShim zcr;

    static int findColumns(String[] columnNames, String columnName, int rootColumn) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (!columnName.equals(columnNames[i])) continue;
            return i + rootColumn;
        }
        return -1;
    }

    public static int[] mapSargColumns(List<PredicateLeaf> sargLeaves, String[] columnNames, int rootColumn) {
        int[] result = new int[sargLeaves.size()];
        Arrays.fill(result, -1);
        for (int i = 0; i < result.length; ++i) {
            String colName = sargLeaves.get(i).getColumnName();
            result[i] = RecordReaderImpl.findColumns(columnNames, colName, rootColumn);
        }
        return result;
    }

    protected RecordReaderImpl(List<StripeInformation> stripes, FileSystem fileSystem, Path path, Reader.Options options, List<OrcProto.Type> types, CompressionCodec codec, int bufferSize, long strideRate, Configuration conf) throws IOException {
        this.path = path;
        this.file = fileSystem.open(path);
        this.codec = codec;
        this.types = types;
        this.bufferSize = bufferSize;
        this.included = options.getInclude();
        this.conf = conf;
        this.rowIndexStride = strideRate;
        this.metadata = new MetadataReader(this.file, codec, bufferSize, types.size());
        SearchArgument sarg = options.getSearchArgument();
        this.sargApp = sarg != null && strideRate != 0L ? new SargApplier(sarg, options.getColumnNames(), strideRate, types, this.included.length) : null;
        long rows = 0L;
        long skippedRows = 0L;
        long offset = options.getOffset();
        long maxOffset = options.getMaxOffset();
        for (StripeInformation stripe : stripes) {
            long stripeStart = stripe.getOffset();
            if (offset > stripeStart) {
                skippedRows += stripe.getNumberOfRows();
                continue;
            }
            if (stripeStart >= maxOffset) continue;
            this.stripes.add(stripe);
            rows += stripe.getNumberOfRows();
        }
        boolean zeroCopy = conf != null && HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORC_ZEROCOPY);
        this.zcr = zeroCopy ? RecordReaderUtils.createZeroCopyShim(this.file, codec, this.pool) : null;
        this.firstRow = skippedRows;
        this.totalRowCount = rows;
        boolean skipCorrupt = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORC_SKIP_CORRUPT_DATA);
        this.reader = RecordReaderFactory.createTreeReader(0, conf, types, this.included, skipCorrupt);
        this.indexes = new OrcProto.RowIndex[types.size()];
        this.bloomFilterIndices = new OrcProto.BloomFilterIndex[types.size()];
        this.advanceToNextRow(this.reader, 0L, true);
    }

    OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
        return this.metadata.readStripeFooter(stripe);
    }

    static <T> Location compareToRange(Comparable<T> point, T min, T max) {
        int minCompare = point.compareTo(min);
        if (minCompare < 0) {
            return Location.BEFORE;
        }
        if (minCompare == 0) {
            return Location.MIN;
        }
        int maxCompare = point.compareTo(max);
        if (maxCompare > 0) {
            return Location.AFTER;
        }
        if (maxCompare == 0) {
            return Location.MAX;
        }
        return Location.MIDDLE;
    }

    static Object getMax(ColumnStatistics index) {
        if (index instanceof IntegerColumnStatistics) {
            return ((IntegerColumnStatistics)index).getMaximum();
        }
        if (index instanceof DoubleColumnStatistics) {
            return ((DoubleColumnStatistics)index).getMaximum();
        }
        if (index instanceof StringColumnStatistics) {
            return ((StringColumnStatistics)index).getMaximum();
        }
        if (index instanceof DateColumnStatistics) {
            return ((DateColumnStatistics)index).getMaximum();
        }
        if (index instanceof DecimalColumnStatistics) {
            return ((DecimalColumnStatistics)index).getMaximum();
        }
        if (index instanceof TimestampColumnStatistics) {
            return ((TimestampColumnStatistics)index).getMaximum();
        }
        if (index instanceof BooleanColumnStatistics) {
            if (((BooleanColumnStatistics)index).getTrueCount() != 0L) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    static Object getMin(ColumnStatistics index) {
        if (index instanceof IntegerColumnStatistics) {
            return ((IntegerColumnStatistics)index).getMinimum();
        }
        if (index instanceof DoubleColumnStatistics) {
            return ((DoubleColumnStatistics)index).getMinimum();
        }
        if (index instanceof StringColumnStatistics) {
            return ((StringColumnStatistics)index).getMinimum();
        }
        if (index instanceof DateColumnStatistics) {
            return ((DateColumnStatistics)index).getMinimum();
        }
        if (index instanceof DecimalColumnStatistics) {
            return ((DecimalColumnStatistics)index).getMinimum();
        }
        if (index instanceof TimestampColumnStatistics) {
            return ((TimestampColumnStatistics)index).getMinimum();
        }
        if (index instanceof BooleanColumnStatistics) {
            if (((BooleanColumnStatistics)index).getFalseCount() != 0L) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return null;
    }

    static SearchArgument.TruthValue evaluatePredicateProto(OrcProto.ColumnStatistics statsProto, PredicateLeaf predicate, OrcProto.BloomFilter bloomFilter) {
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize(statsProto);
        Object minValue = RecordReaderImpl.getMin(cs);
        Object maxValue = RecordReaderImpl.getMax(cs);
        BloomFilterIO bf = null;
        if (bloomFilter != null) {
            bf = new BloomFilterIO(bloomFilter);
        }
        return RecordReaderImpl.evaluatePredicateRange(predicate, minValue, maxValue, cs.hasNull(), bf);
    }

    static SearchArgument.TruthValue evaluatePredicate(ColumnStatistics stats, PredicateLeaf predicate, BloomFilterIO bloomFilter) {
        Object minValue = RecordReaderImpl.getMin(stats);
        Object maxValue = RecordReaderImpl.getMax(stats);
        return RecordReaderImpl.evaluatePredicateRange(predicate, minValue, maxValue, stats.hasNull(), bloomFilter);
    }

    static SearchArgument.TruthValue evaluatePredicateRange(PredicateLeaf predicate, Object min, Object max, boolean hasNull, BloomFilterIO bloomFilter) {
        SearchArgument.TruthValue result;
        if (min == null) {
            if (predicate.getOperator() == PredicateLeaf.Operator.IS_NULL) {
                return SearchArgument.TruthValue.YES;
            }
            return SearchArgument.TruthValue.NULL;
        }
        try {
            Object baseObj = predicate.getLiteral();
            Object minValue = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), min);
            Object maxValue = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), max);
            Object predObj = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), baseObj);
            result = RecordReaderImpl.evaluatePredicateMinMax(predicate, predObj, minValue, maxValue, hasNull);
            if (bloomFilter != null && result != SearchArgument.TruthValue.NO_NULL && result != SearchArgument.TruthValue.NO) {
                result = RecordReaderImpl.evaluatePredicateBloomFilter(predicate, predObj, bloomFilter, hasNull);
            }
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Exception when evaluating predicate. Skipping ORC PPD. Exception: " + ExceptionUtils.getStackTrace((Throwable)e)));
            }
            result = predicate.getOperator().equals((Object)PredicateLeaf.Operator.NULL_SAFE_EQUALS) || !hasNull ? SearchArgument.TruthValue.YES_NO : SearchArgument.TruthValue.YES_NO_NULL;
        }
        return result;
    }

    private static SearchArgument.TruthValue evaluatePredicateMinMax(PredicateLeaf predicate, Object predObj, Object minValue, Object maxValue, boolean hasNull) {
        switch (predicate.getOperator()) {
            case NULL_SAFE_EQUALS: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                if (loc == Location.BEFORE || loc == Location.AFTER) {
                    return SearchArgument.TruthValue.NO;
                }
                return SearchArgument.TruthValue.YES_NO;
            }
            case EQUALS: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                if (minValue.equals(maxValue) && loc == Location.MIN) {
                    return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                }
                if (loc == Location.BEFORE || loc == Location.AFTER) {
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
            }
            case LESS_THAN: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                if (loc == Location.AFTER) {
                    return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                }
                if (loc == Location.BEFORE || loc == Location.MIN) {
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
            }
            case LESS_THAN_EQUALS: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                if (loc == Location.AFTER || loc == Location.MAX) {
                    return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                }
                if (loc == Location.BEFORE) {
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
            }
            case IN: {
                if (minValue.equals(maxValue)) {
                    for (Object arg : predicate.getLiteralList()) {
                        predObj = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), arg);
                        Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                        if (loc != Location.MIN) continue;
                        return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                    }
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                for (Object arg : predicate.getLiteralList()) {
                    predObj = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), arg);
                    Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                    if (loc != Location.MIN && loc != Location.MIDDLE && loc != Location.MAX) continue;
                    return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
                }
                return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
            }
            case BETWEEN: {
                List args = predicate.getLiteralList();
                Object predObj1 = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), args.get(0));
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj1, minValue, maxValue);
                if (loc == Location.BEFORE || loc == Location.MIN) {
                    Object predObj2 = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), args.get(1));
                    Location loc2 = RecordReaderImpl.compareToRange((Comparable)predObj2, minValue, maxValue);
                    if (loc2 == Location.AFTER || loc2 == Location.MAX) {
                        return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                    }
                    if (loc2 == Location.BEFORE) {
                        return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                    }
                    return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
                }
                if (loc == Location.AFTER) {
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
            }
            case IS_NULL: {
                return hasNull ? SearchArgument.TruthValue.YES_NO : SearchArgument.TruthValue.NO;
            }
        }
        return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
    }

    private static SearchArgument.TruthValue evaluatePredicateBloomFilter(PredicateLeaf predicate, Object predObj, BloomFilterIO bloomFilter, boolean hasNull) {
        switch (predicate.getOperator()) {
            case NULL_SAFE_EQUALS: {
                return RecordReaderImpl.checkInBloomFilter(bloomFilter, predObj, false);
            }
            case EQUALS: {
                return RecordReaderImpl.checkInBloomFilter(bloomFilter, predObj, hasNull);
            }
            case IN: {
                for (Object arg : predicate.getLiteralList()) {
                    Object predObjItem = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), arg);
                    SearchArgument.TruthValue result = RecordReaderImpl.checkInBloomFilter(bloomFilter, predObjItem, hasNull);
                    if (result != SearchArgument.TruthValue.YES_NO_NULL && result != SearchArgument.TruthValue.YES_NO) continue;
                    return result;
                }
                return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
            }
        }
        return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
    }

    private static SearchArgument.TruthValue checkInBloomFilter(BloomFilterIO bf, Object predObj, boolean hasNull) {
        SearchArgument.TruthValue result;
        SearchArgument.TruthValue truthValue = result = hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
        if (predObj instanceof Long) {
            if (bf.testLong((Long)predObj)) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof Double) {
            if (bf.testDouble((Double)predObj)) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof String || predObj instanceof Text || predObj instanceof HiveDecimal || predObj instanceof BigDecimal) {
            if (bf.testString(predObj.toString())) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof Timestamp) {
            if (bf.testLong(((Timestamp)predObj).getTime())) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof TimestampWritable) {
            if (bf.testLong(((TimestampWritable)predObj).getTimestamp().getTime())) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof Date) {
            if (bf.testLong(DateWritable.dateToDays((Date)((Date)predObj)))) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else {
            result = predObj == null && !hasNull ? SearchArgument.TruthValue.NO : SearchArgument.TruthValue.YES_NO_NULL;
        }
        if (result == SearchArgument.TruthValue.YES_NO_NULL && !hasNull) {
            result = SearchArgument.TruthValue.YES_NO;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Bloom filter evaluation: " + result.toString()));
        }
        return result;
    }

    private static Object getBaseObjectForComparison(PredicateLeaf.Type type, Object obj) {
        if (obj != null) {
            if (obj instanceof ExprNodeConstantDesc) {
                obj = ((ExprNodeConstantDesc)obj).getValue();
            }
        } else {
            return null;
        }
        switch (type) {
            case BOOLEAN: {
                if (obj instanceof Boolean) {
                    return obj;
                }
                return Boolean.valueOf(obj.toString());
            }
            case DATE: {
                if (obj instanceof Date) {
                    return obj;
                }
                if (obj instanceof String) {
                    return Date.valueOf((String)obj);
                }
                if (!(obj instanceof Timestamp)) break;
                return DateWritable.timeToDate((long)(((Timestamp)obj).getTime() / 1000L));
            }
            case DECIMAL: {
                if (obj instanceof Boolean) {
                    return (Boolean)obj != false ? HiveDecimal.ONE : HiveDecimal.ZERO;
                }
                if (obj instanceof Integer) {
                    return HiveDecimal.create((int)((Integer)obj));
                }
                if (obj instanceof Long) {
                    return HiveDecimal.create((long)((Long)obj));
                }
                if (obj instanceof Float || obj instanceof Double || obj instanceof String) {
                    return HiveDecimal.create((String)obj.toString());
                }
                if (obj instanceof BigDecimal) {
                    return HiveDecimal.create((BigDecimal)((BigDecimal)obj));
                }
                if (obj instanceof HiveDecimal) {
                    return obj;
                }
                if (!(obj instanceof Timestamp)) break;
                return HiveDecimal.create((String)new Double(new TimestampWritable((Timestamp)obj).getDouble()).toString());
            }
            case FLOAT: {
                if (obj instanceof Number) {
                    return ((Number)obj).doubleValue();
                }
                if (obj instanceof HiveDecimal) {
                    return ((HiveDecimal)obj).doubleValue();
                }
                if (obj instanceof String) {
                    return Double.valueOf(obj.toString());
                }
                if (obj instanceof Timestamp) {
                    return new TimestampWritable((Timestamp)obj).getDouble();
                }
                if (obj instanceof HiveDecimal) {
                    return ((HiveDecimal)obj).doubleValue();
                }
                if (!(obj instanceof BigDecimal)) break;
                return ((BigDecimal)obj).doubleValue();
            }
            case INTEGER: 
            case LONG: {
                if (obj instanceof Number) {
                    return ((Number)obj).longValue();
                }
                if (obj instanceof HiveDecimal) {
                    return ((HiveDecimal)obj).longValue();
                }
                if (!(obj instanceof String)) break;
                return Long.valueOf(obj.toString());
            }
            case STRING: {
                if (obj == null) break;
                return obj.toString();
            }
            case TIMESTAMP: {
                if (obj instanceof Timestamp) {
                    return obj;
                }
                if (obj instanceof Float) {
                    return TimestampWritable.doubleToTimestamp((double)((Float)obj).doubleValue());
                }
                if (obj instanceof Double) {
                    return TimestampWritable.doubleToTimestamp((double)((Double)obj));
                }
                if (obj instanceof HiveDecimal) {
                    return TimestampWritable.decimalToTimestamp((HiveDecimal)((HiveDecimal)obj));
                }
                if (!(obj instanceof Date)) break;
                return new Timestamp(((Date)obj).getTime());
            }
        }
        throw new IllegalArgumentException(String.format("ORC SARGS could not convert from %s to %s", obj == null ? "(null)" : obj.getClass().getSimpleName(), type));
    }

    protected boolean[] pickRowGroups() throws IOException {
        if (this.sargApp == null) {
            return null;
        }
        this.readRowIndex(this.currentStripe, this.included, this.sargApp.sargColumns);
        return this.sargApp.pickRowGroups(this.stripes.get(this.currentStripe), this.indexes);
    }

    private void clearStreams() throws IOException {
        for (InStream is : this.streams.values()) {
            is.close();
        }
        if (this.bufferChunks != null) {
            if (this.zcr != null) {
                DiskRangeList range = this.bufferChunks;
                while (range != null) {
                    if (range instanceof BufferChunk) {
                        this.zcr.releaseBuffer(((BufferChunk)range).chunk);
                    }
                    range = range.next;
                }
            }
            this.bufferChunks = null;
        }
        this.streams.clear();
    }

    private void readStripe() throws IOException {
        StripeInformation stripe = this.beginReadStripe();
        this.includedRowGroups = this.pickRowGroups();
        if (this.includedRowGroups != null) {
            while (this.rowInStripe < this.rowCountInStripe && !this.includedRowGroups[(int)(this.rowInStripe / this.rowIndexStride)]) {
                this.rowInStripe = Math.min(this.rowCountInStripe, this.rowInStripe + this.rowIndexStride);
            }
        }
        if (this.rowInStripe < this.rowCountInStripe) {
            if (this.included == null && this.includedRowGroups == null) {
                this.readAllDataStreams(stripe);
            } else {
                this.readPartialDataStreams(stripe);
            }
            this.reader.startStripe(this.streams, this.stripeFooter);
            if (this.rowInStripe != 0L) {
                this.seekToRowEntry(this.reader, (int)(this.rowInStripe / this.rowIndexStride));
            }
        }
    }

    private StripeInformation beginReadStripe() throws IOException {
        int i;
        StripeInformation stripe = this.stripes.get(this.currentStripe);
        this.stripeFooter = this.readStripeFooter(stripe);
        this.clearStreams();
        this.rowCountInStripe = stripe.getNumberOfRows();
        this.rowInStripe = 0L;
        this.rowBaseInStripe = 0L;
        for (i = 0; i < this.currentStripe; ++i) {
            this.rowBaseInStripe += this.stripes.get(i).getNumberOfRows();
        }
        for (i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = null;
        }
        return stripe;
    }

    private void readAllDataStreams(StripeInformation stripe) throws IOException {
        long start = stripe.getIndexLength();
        long end = start + stripe.getDataLength();
        DiskRangeList toRead = new DiskRangeList(start, end);
        this.bufferChunks = RecordReaderUtils.readDiskRanges(this.file, this.zcr, stripe.getOffset(), toRead, false);
        List<OrcProto.Stream> streamDescriptions = this.stripeFooter.getStreamsList();
        this.createStreams(streamDescriptions, this.bufferChunks, null, this.codec, this.bufferSize, this.streams);
    }

    static DiskRangeList planReadPartialDataStreams(List<OrcProto.Stream> streamList, OrcProto.RowIndex[] indexes, boolean[] includedColumns, boolean[] includedRowGroups, boolean isCompressed, List<OrcProto.ColumnEncoding> encodings, List<OrcProto.Type> types, int compressionSize, boolean doMergeBuffers) {
        long offset = 0L;
        boolean[] hasNull = RecordReaderUtils.findPresentStreamsByColumn(streamList, types);
        DiskRangeList.DiskRangeListCreateHelper list = new DiskRangeList.DiskRangeListCreateHelper();
        for (OrcProto.Stream stream : streamList) {
            long length = stream.getLength();
            int column = stream.getColumn();
            OrcProto.Stream.Kind streamKind = stream.getKind();
            if (stream.hasKind() && StreamName.getArea(streamKind) == StreamName.Area.DATA && includedColumns[column]) {
                if (includedRowGroups == null || RecordReaderUtils.isDictionary(streamKind, encodings.get(column))) {
                    RecordReaderUtils.addEntireStreamToRanges(offset, length, list, doMergeBuffers);
                } else {
                    RecordReaderUtils.addRgFilteredStreamToRanges(stream, includedRowGroups, isCompressed, indexes[column], encodings.get(column), types.get(column), compressionSize, hasNull[column], offset, length, list, doMergeBuffers);
                }
            }
            offset += length;
        }
        return list.extract();
    }

    void createStreams(List<OrcProto.Stream> streamDescriptions, DiskRangeList ranges, boolean[] includeColumn, CompressionCodec codec, int bufferSize, Map<StreamName, InStream> streams) throws IOException {
        long streamOffset = 0L;
        for (OrcProto.Stream streamDesc : streamDescriptions) {
            int column = streamDesc.getColumn();
            if (includeColumn != null && !includeColumn[column] || streamDesc.hasKind() && StreamName.getArea(streamDesc.getKind()) != StreamName.Area.DATA) {
                streamOffset += streamDesc.getLength();
                continue;
            }
            List<DiskRange> buffers = RecordReaderUtils.getStreamBuffers(ranges, streamOffset, streamDesc.getLength());
            StreamName name = new StreamName(column, streamDesc.getKind());
            streams.put(name, InStream.create(name.toString(), buffers, streamDesc.getLength(), codec, bufferSize));
            streamOffset += streamDesc.getLength();
        }
    }

    private void readPartialDataStreams(StripeInformation stripe) throws IOException {
        List<OrcProto.Stream> streamList = this.stripeFooter.getStreamsList();
        DiskRangeList toRead = RecordReaderImpl.planReadPartialDataStreams(streamList, this.indexes, this.included, this.includedRowGroups, this.codec != null, this.stripeFooter.getColumnsList(), this.types, this.bufferSize, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("chunks = " + RecordReaderUtils.stringifyDiskRanges(toRead)));
        }
        this.bufferChunks = RecordReaderUtils.readDiskRanges(this.file, this.zcr, stripe.getOffset(), toRead, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("merge = " + RecordReaderUtils.stringifyDiskRanges(this.bufferChunks)));
        }
        this.createStreams(streamList, this.bufferChunks, this.included, this.codec, this.bufferSize, this.streams);
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.rowInStripe < this.rowCountInStripe;
    }

    private void advanceStripe() throws IOException {
        this.rowInStripe = this.rowCountInStripe;
        while (this.rowInStripe >= this.rowCountInStripe && this.currentStripe < this.stripes.size() - 1) {
            ++this.currentStripe;
            this.readStripe();
        }
    }

    private boolean advanceToNextRow(TreeReaderFactory.TreeReader reader, long nextRow, boolean canAdvanceStripe) throws IOException {
        int rowGroup;
        long nextRowInStripe = nextRow - this.rowBaseInStripe;
        if (this.rowIndexStride != 0L && this.includedRowGroups != null && nextRowInStripe < this.rowCountInStripe && !this.includedRowGroups[rowGroup = (int)(nextRowInStripe / this.rowIndexStride)]) {
            while (rowGroup < this.includedRowGroups.length && !this.includedRowGroups[rowGroup]) {
                ++rowGroup;
            }
            if (rowGroup >= this.includedRowGroups.length) {
                if (canAdvanceStripe) {
                    this.advanceStripe();
                }
                return canAdvanceStripe;
            }
            nextRowInStripe = Math.min(this.rowCountInStripe, (long)rowGroup * this.rowIndexStride);
        }
        if (nextRowInStripe >= this.rowCountInStripe) {
            if (canAdvanceStripe) {
                this.advanceStripe();
            }
            return canAdvanceStripe;
        }
        if (nextRowInStripe != this.rowInStripe) {
            if (this.rowIndexStride != 0L) {
                rowGroup = (int)(nextRowInStripe / this.rowIndexStride);
                this.seekToRowEntry(reader, rowGroup);
                reader.skipRows(nextRowInStripe - (long)rowGroup * this.rowIndexStride);
            } else {
                reader.skipRows(nextRowInStripe - this.rowInStripe);
            }
            this.rowInStripe = nextRowInStripe;
        }
        return true;
    }

    @Override
    public Object next(Object previous) throws IOException {
        try {
            Object result = this.reader.next(previous);
            ++this.rowInStripe;
            this.advanceToNextRow(this.reader, this.rowInStripe + this.rowBaseInStripe, true);
            return result;
        }
        catch (IOException e) {
            throw new IOException("Error reading file: " + this.path, e);
        }
    }

    @Override
    public VectorizedRowBatch nextBatch(VectorizedRowBatch previous) throws IOException {
        try {
            VectorizedRowBatch result;
            if (this.rowInStripe >= this.rowCountInStripe) {
                ++this.currentStripe;
                this.readStripe();
            }
            long batchSize = this.computeBatchSize(1024L);
            this.rowInStripe += batchSize;
            if (previous == null) {
                ColumnVector[] cols = (ColumnVector[])this.reader.nextVector(null, (int)batchSize);
                result = new VectorizedRowBatch(cols.length);
                result.cols = cols;
            } else {
                result = previous;
                result.selectedInUse = false;
                this.reader.nextVector(result.cols, (int)batchSize);
            }
            result.size = (int)batchSize;
            this.advanceToNextRow(this.reader, this.rowInStripe + this.rowBaseInStripe, true);
            return result;
        }
        catch (IOException e) {
            throw new IOException("Error reading file: " + this.path, e);
        }
    }

    private long computeBatchSize(long targetBatchSize) {
        long batchSize = 0L;
        if (this.rowIndexStride != 0L && this.includedRowGroups != null && this.rowInStripe < this.rowCountInStripe) {
            int endRowGroup;
            int startRowGroup = (int)(this.rowInStripe / this.rowIndexStride);
            if (!this.includedRowGroups[startRowGroup]) {
                while (startRowGroup < this.includedRowGroups.length && !this.includedRowGroups[startRowGroup]) {
                    ++startRowGroup;
                }
            }
            for (endRowGroup = startRowGroup; endRowGroup < this.includedRowGroups.length && this.includedRowGroups[endRowGroup]; ++endRowGroup) {
            }
            long markerPosition = (long)endRowGroup * this.rowIndexStride < this.rowCountInStripe ? (long)endRowGroup * this.rowIndexStride : this.rowCountInStripe;
            batchSize = Math.min(targetBatchSize, markerPosition - this.rowInStripe);
            if (isLogDebugEnabled && batchSize < targetBatchSize) {
                LOG.debug((Object)("markerPosition: " + markerPosition + " batchSize: " + batchSize));
            }
        } else {
            batchSize = Math.min(targetBatchSize, this.rowCountInStripe - this.rowInStripe);
        }
        return batchSize;
    }

    @Override
    public void close() throws IOException {
        this.clearStreams();
        this.pool.clear();
        this.file.close();
    }

    @Override
    public long getRowNumber() {
        return this.rowInStripe + this.rowBaseInStripe + this.firstRow;
    }

    @Override
    public float getProgress() {
        return ((float)this.rowBaseInStripe + (float)this.rowInStripe) / (float)this.totalRowCount;
    }

    private int findStripe(long rowNumber) {
        for (int i = 0; i < this.stripes.size(); ++i) {
            StripeInformation stripe = this.stripes.get(i);
            if (stripe.getNumberOfRows() > rowNumber) {
                return i;
            }
            rowNumber -= stripe.getNumberOfRows();
        }
        throw new IllegalArgumentException("Seek after the end of reader range");
    }

    Index readRowIndex(int stripeIndex, boolean[] included, boolean[] sargColumns) throws IOException {
        return this.readRowIndex(stripeIndex, included, null, null, sargColumns);
    }

    Index readRowIndex(int stripeIndex, boolean[] included, OrcProto.RowIndex[] indexes, OrcProto.BloomFilterIndex[] bloomFilterIndex, boolean[] sargColumns) throws IOException {
        StripeInformation stripe = this.stripes.get(stripeIndex);
        OrcProto.StripeFooter stripeFooter = null;
        if (stripeIndex == this.currentStripe) {
            stripeFooter = this.stripeFooter;
            indexes = indexes == null ? this.indexes : indexes;
            OrcProto.BloomFilterIndex[] bloomFilterIndexArray = bloomFilterIndex = bloomFilterIndex == null ? this.bloomFilterIndices : bloomFilterIndex;
            sargColumns = sargColumns == null ? (Object)(this.sargApp == null ? null : this.sargApp.sargColumns) : sargColumns;
        }
        return this.metadata.readRowIndex(stripe, stripeFooter, included, indexes, sargColumns, bloomFilterIndex);
    }

    private void seekToRowEntry(TreeReaderFactory.TreeReader reader, int rowEntry) throws IOException {
        PositionProvider[] index = new PositionProvider[this.indexes.length];
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] == null) continue;
            index[i] = new PositionProviderImpl(this.indexes[i].getEntry(rowEntry));
        }
        reader.seek(index);
    }

    @Override
    public void seekToRow(long rowNumber) throws IOException {
        if (rowNumber < 0L) {
            throw new IllegalArgumentException("Seek to a negative row number " + rowNumber);
        }
        if (rowNumber < this.firstRow) {
            throw new IllegalArgumentException("Seek before reader range " + rowNumber);
        }
        int rightStripe = this.findStripe(rowNumber -= this.firstRow);
        if (rightStripe != this.currentStripe) {
            this.currentStripe = rightStripe;
            this.readStripe();
        }
        this.readRowIndex(this.currentStripe, this.included, this.sargApp == null ? null : this.sargApp.sargColumns);
        this.advanceToNextRow(this.reader, rowNumber, true);
    }

    public static class BufferChunk
    extends DiskRangeList {
        final ByteBuffer chunk;

        BufferChunk(ByteBuffer chunk, long offset) {
            super(offset, offset + (long)chunk.remaining());
            this.chunk = chunk;
        }

        public boolean hasData() {
            return this.chunk != null;
        }

        public final String toString() {
            boolean makesSense = (long)this.chunk.remaining() == this.end - this.offset;
            return "data range [" + this.offset + ", " + this.end + "), size: " + this.chunk.remaining() + (makesSense ? "" : "(!)") + " type: " + (this.chunk.isDirect() ? "direct" : "array-backed");
        }

        public DiskRange sliceAndShift(long offset, long end, long shiftBy) {
            assert (offset <= end && offset >= this.offset && end <= this.end);
            assert (offset + shiftBy >= 0L);
            ByteBuffer sliceBuf = this.chunk.slice();
            int newPos = (int)(offset - this.offset);
            int newLimit = newPos + (int)(end - offset);
            try {
                sliceBuf.position(newPos);
                sliceBuf.limit(newLimit);
            }
            catch (Throwable t) {
                LOG.error((Object)("Failed to slice buffer chunk with range [" + this.offset + ", " + this.end + "), position: " + this.chunk.position() + " limit: " + this.chunk.limit() + ", " + (this.chunk.isDirect() ? "direct" : "array") + "; to [" + offset + ", " + end + ") " + t.getClass()));
                throw new RuntimeException(t);
            }
            return new BufferChunk(sliceBuf, offset + shiftBy);
        }

        public ByteBuffer getData() {
            return this.chunk;
        }
    }

    public static class SargApplier {
        private final SearchArgument sarg;
        private final List<PredicateLeaf> sargLeaves;
        private final int[] filterColumns;
        private final long rowIndexStride;
        private final OrcProto.BloomFilterIndex[] bloomFilterIndices;
        private final boolean[] sargColumns;

        public SargApplier(SearchArgument sarg, String[] columnNames, long rowIndexStride, List<OrcProto.Type> types, int includedCount) {
            this.sarg = sarg;
            this.sargLeaves = sarg.getLeaves();
            this.filterColumns = RecordReaderImpl.mapSargColumns(this.sargLeaves, columnNames, 0);
            this.bloomFilterIndices = new OrcProto.BloomFilterIndex[types.size()];
            this.rowIndexStride = rowIndexStride;
            this.sargColumns = new boolean[includedCount];
            for (int i : this.filterColumns) {
                if (i <= 0) continue;
                this.sargColumns[i] = true;
            }
        }

        public boolean[] pickRowGroups(StripeInformation stripe, OrcProto.RowIndex[] indexes) throws IOException {
            long rowsInStripe = stripe.getNumberOfRows();
            int groupsInStripe = (int)((rowsInStripe + this.rowIndexStride - 1L) / this.rowIndexStride);
            boolean[] result = new boolean[groupsInStripe];
            SearchArgument.TruthValue[] leafValues = new SearchArgument.TruthValue[this.sargLeaves.size()];
            for (int rowGroup = 0; rowGroup < result.length; ++rowGroup) {
                for (int pred = 0; pred < leafValues.length; ++pred) {
                    if (this.filterColumns[pred] != -1) {
                        OrcProto.ColumnStatistics stats = indexes[this.filterColumns[pred]].getEntry(rowGroup).getStatistics();
                        OrcProto.BloomFilter bf = null;
                        if (this.bloomFilterIndices[this.filterColumns[pred]] != null) {
                            bf = this.bloomFilterIndices[this.filterColumns[pred]].getBloomFilter(rowGroup);
                        }
                        leafValues[pred] = RecordReaderImpl.evaluatePredicateProto(stats, this.sargLeaves.get(pred), bf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Stats = " + stats));
                        LOG.debug((Object)("Setting " + this.sargLeaves.get(pred) + " to " + leafValues[pred]));
                        continue;
                    }
                    leafValues[pred] = SearchArgument.TruthValue.YES_NO_NULL;
                }
                result[rowGroup] = this.sarg.evaluate(leafValues).isNeeded();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Row group " + this.rowIndexStride * (long)rowGroup + " to " + (this.rowIndexStride * (long)(rowGroup + 1) - 1L) + " is " + (result[rowGroup] ? "" : "not ") + "included."));
            }
            for (boolean b : result) {
                if (b) continue;
                return result;
            }
            return null;
        }
    }

    static enum Location {
        BEFORE,
        MIN,
        MIDDLE,
        MAX,
        AFTER;

    }

    public static final class PositionProviderImpl
    implements PositionProvider {
        private final OrcProto.RowIndexEntry entry;
        private int index;

        public PositionProviderImpl(OrcProto.RowIndexEntry entry) {
            this(entry, 0);
        }

        public PositionProviderImpl(OrcProto.RowIndexEntry entry, int startPos) {
            this.entry = entry;
            this.index = startPos;
        }

        @Override
        public long getNext() {
            return this.entry.getPositions(this.index++);
        }
    }

    public static final class Index {
        OrcProto.RowIndex[] rowGroupIndex;
        OrcProto.BloomFilterIndex[] bloomFilterIndex;

        Index(OrcProto.RowIndex[] rgIndex, OrcProto.BloomFilterIndex[] bfIndex) {
            this.rowGroupIndex = rgIndex;
            this.bloomFilterIndex = bfIndex;
        }

        public OrcProto.RowIndex[] getRowGroupIndex() {
            return this.rowGroupIndex;
        }

        public OrcProto.BloomFilterIndex[] getBloomFilterIndex() {
            return this.bloomFilterIndex;
        }

        public void setRowGroupIndex(OrcProto.RowIndex[] rowGroupIndex) {
            this.rowGroupIndex = rowGroupIndex;
        }
    }
}

