/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.correlation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;

public class IntraQueryCorrelation {
    private boolean jobFlowCorrelation = false;
    private List<ReduceSinkOperator> bottomReduceSinkOperators;
    private int numReducers = -1;
    private final int minReducers;
    private final Set<ReduceSinkOperator> allReduceSinkOperators;
    private final Map<Integer, Integer> newTagToOldTag;
    private final Map<Integer, Integer> newTagToChildIndex;

    public IntraQueryCorrelation(int minReducers) {
        this.minReducers = minReducers;
        this.allReduceSinkOperators = new HashSet<ReduceSinkOperator>();
        this.newTagToOldTag = new HashMap<Integer, Integer>();
        this.newTagToChildIndex = new HashMap<Integer, Integer>();
    }

    public Map<Integer, Integer> getNewTagToOldTag() {
        return this.newTagToOldTag;
    }

    public Map<Integer, Integer> getNewTagToChildIndex() {
        return this.newTagToChildIndex;
    }

    public void setNewTag(Integer newTag, Integer oldTag, Integer childIndex) {
        this.newTagToOldTag.put(newTag, oldTag);
        this.newTagToChildIndex.put(newTag, childIndex);
    }

    public void addToAllReduceSinkOperators(ReduceSinkOperator rsop) {
        this.allReduceSinkOperators.add(rsop);
    }

    public Set<ReduceSinkOperator> getAllReduceSinkOperators() {
        return this.allReduceSinkOperators;
    }

    public void setJobFlowCorrelation(boolean jobFlowCorrelation, List<ReduceSinkOperator> bottomReduceSinkOperators) {
        this.jobFlowCorrelation = jobFlowCorrelation;
        this.bottomReduceSinkOperators = bottomReduceSinkOperators;
    }

    public boolean hasJobFlowCorrelation() {
        return this.jobFlowCorrelation;
    }

    public List<ReduceSinkOperator> getBottomReduceSinkOperators() {
        return this.bottomReduceSinkOperators;
    }

    public int getNumReducers() {
        return this.numReducers;
    }

    public boolean adjustNumReducers(int newNumReducers) {
        assert (newNumReducers != 0);
        if (newNumReducers > 0) {
            if (newNumReducers < this.minReducers) {
                return false;
            }
            if (this.numReducers > 0) {
                if (newNumReducers != this.numReducers) {
                    return false;
                }
            } else {
                this.numReducers = newNumReducers;
            }
        }
        return true;
    }
}

