/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MergeJoinWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.UnionWork;

public class GenTezWork
implements NodeProcessor {
    private static final Log LOG = LogFactory.getLog((String)GenTezWork.class.getName());
    private GenTezUtils utils = null;

    public GenTezWork(GenTezUtils utils) {
        this.utils = utils;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        BaseWork work;
        GenTezProcContext context = (GenTezProcContext)procContext;
        assert (context != null && context.currentTask != null && context.currentRootOperator != null);
        Operator operator = (Operator)nd;
        Operator<? extends OperatorDesc> root = context.currentRootOperator;
        LOG.debug((Object)("Root operator: " + root));
        LOG.debug((Object)("Leaf operator: " + operator));
        if (context.clonedReduceSinks.contains(operator)) {
            return null;
        }
        TezWork tezWork = (TezWork)context.currentTask.getWork();
        if (context.rootToWorkMap.containsKey(root)) {
            if (context.childToWorkMap.containsKey(operator)) {
                context.currentMapJoinOperators.clear();
                context.currentUnionOperators.clear();
                return null;
            }
            work = context.rootToWorkMap.get(root);
        } else {
            work = context.preceedingWork == null ? this.utils.createMapWork(context, root, tezWork, null) : this.utils.createReduceWork(context, root, tezWork);
            context.rootToWorkMap.put(root, work);
        }
        if (operator instanceof DummyStoreOperator) {
            work.addSortCols(root.getOpTraits().getSortCols().get(0));
        }
        if (!context.childToWorkMap.containsKey(operator)) {
            LinkedList<BaseWork> workItems = new LinkedList<BaseWork>();
            workItems.add(work);
            context.childToWorkMap.put(operator, workItems);
        } else {
            context.childToWorkMap.get(operator).add(work);
        }
        if (context.currentMergeJoinOperator != null) {
            TezEdgeProperty edgeProp;
            MergeJoinWork mergeJoinWork = null;
            if (context.opMergeJoinWorkMap.containsKey(context.currentMergeJoinOperator)) {
                mergeJoinWork = context.opMergeJoinWorkMap.get(context.currentMergeJoinOperator);
            } else {
                mergeJoinWork = new MergeJoinWork();
                mergeJoinWork.setMergeJoinOperator(context.currentMergeJoinOperator);
                tezWork.add(mergeJoinWork);
                context.opMergeJoinWorkMap.put(context.currentMergeJoinOperator, mergeJoinWork);
            }
            work.addSortCols(root.getOpTraits().getSortCols().get(0));
            mergeJoinWork.addMergedWork(work, null, context.leafOperatorToFollowingWork);
            Operator<? extends OperatorDesc> operator2 = this.getParentFromStack(context.currentMergeJoinOperator, stack);
            int pos = context.currentMergeJoinOperator.getTagForOperator(operator2);
            work.setTag(pos);
            tezWork.setVertexType(work, TezWork.VertexType.MULTI_INPUT_UNINITIALIZED_EDGES);
            for (BaseWork baseWork : tezWork.getParents(work)) {
                edgeProp = tezWork.getEdgeProperty(baseWork, work);
                tezWork.disconnect(baseWork, work);
                tezWork.connect(baseWork, mergeJoinWork, edgeProp);
            }
            for (BaseWork baseWork : tezWork.getChildren(work)) {
                edgeProp = tezWork.getEdgeProperty(work, baseWork);
                tezWork.disconnect(work, baseWork);
                tezWork.connect(mergeJoinWork, baseWork, edgeProp);
            }
            tezWork.remove(work);
            context.rootToWorkMap.put(root, mergeJoinWork);
            context.childToWorkMap.get(operator).remove(work);
            context.childToWorkMap.get(operator).add(mergeJoinWork);
            work = mergeJoinWork;
            context.currentMergeJoinOperator = null;
        }
        if (!context.currentMapJoinOperators.isEmpty()) {
            for (MapJoinOperator mapJoinOperator : context.currentMapJoinOperators) {
                Map<BaseWork, TezEdgeProperty> linkWorkMap;
                LOG.debug((Object)("Processing map join: " + mapJoinOperator));
                if (!context.mapJoinWorkMap.containsKey(mapJoinOperator)) {
                    LinkedList<BaseWork> workItems = new LinkedList<BaseWork>();
                    workItems.add(work);
                    context.mapJoinWorkMap.put(mapJoinOperator, workItems);
                } else {
                    context.mapJoinWorkMap.get(mapJoinOperator).add(work);
                }
                if (!context.linkOpWithWorkMap.containsKey(mapJoinOperator) || (linkWorkMap = context.linkOpWithWorkMap.get(mapJoinOperator)) == null) continue;
                if (context.linkChildOpWithDummyOp.containsKey(mapJoinOperator)) {
                    for (Operator operator3 : context.linkChildOpWithDummyOp.get(mapJoinOperator)) {
                        work.addDummyOp((HashTableDummyOperator)operator3);
                    }
                }
                for (Map.Entry entry : linkWorkMap.entrySet()) {
                    BaseWork parentWork = (BaseWork)entry.getKey();
                    LOG.debug((Object)("connecting " + parentWork.getName() + " with " + work.getName()));
                    TezEdgeProperty edgeProp = (TezEdgeProperty)entry.getValue();
                    tezWork.connect(parentWork, work, edgeProp);
                    if (edgeProp.getEdgeType() == TezEdgeProperty.EdgeType.CUSTOM_EDGE) {
                        tezWork.setVertexType(work, TezWork.VertexType.INITIALIZED_EDGES);
                    }
                    for (ReduceSinkOperator r : context.linkWorkWithReduceSinkMap.get(parentWork)) {
                        if (((ReduceSinkDesc)r.getConf()).getOutputName() != null) {
                            LOG.debug((Object)"Cloning reduce sink for multi-child broadcast edge");
                            r = (ReduceSinkOperator)OperatorFactory.getAndMakeChild((ReduceSinkDesc)((ReduceSinkDesc)r.getConf()).clone(), new RowSchema(r.getSchema()), r.getParentOperators());
                            context.clonedReduceSinks.add(r);
                        }
                        ((ReduceSinkDesc)r.getConf()).setOutputName(work.getName());
                        context.connectedReduceSinks.add(r);
                    }
                }
            }
            context.currentMapJoinOperators.clear();
        }
        for (Operator operator4 : new ArrayList<Operator<OperatorDesc>>(root.getParentOperators())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing " + operator4 + " as parent from " + root));
            }
            context.leafOperatorToFollowingWork.remove(operator4);
            context.leafOperatorToFollowingWork.put(operator4, work);
            root.removeParent(operator4);
        }
        if (!context.currentUnionOperators.isEmpty()) {
            UnionWork unionWork;
            if (context.unionWorkMap.containsKey(operator)) {
                assert (operator.getChildOperators().isEmpty());
                unionWork = (UnionWork)context.unionWorkMap.get(operator);
                this.connectUnionWorkWithWork(unionWork, work, tezWork, context);
            } else {
                unionWork = context.rootUnionWorkMap.get(root);
                if (unionWork == null) {
                    unionWork = this.utils.createUnionWork(context, root, operator, tezWork);
                    this.connectUnionWorkWithWork(unionWork, work, tezWork, context);
                }
            }
            context.currentUnionOperators.clear();
            work = unionWork;
        }
        if (context.leafOperatorToFollowingWork.containsKey(operator)) {
            BaseWork followingWork = context.leafOperatorToFollowingWork.get(operator);
            long l = context.conf.getLongVar(HiveConf.ConfVars.BYTESPERREDUCER);
            LOG.debug((Object)("Second pass. Leaf operator: " + operator + " has common downstream work:" + followingWork));
            if (operator instanceof DummyStoreOperator) {
                assert (followingWork instanceof MergeJoinWork);
                MergeJoinWork mergeJoinWork = (MergeJoinWork)followingWork;
                CommonMergeJoinOperator commonMergeJoinOperator = mergeJoinWork.getMergeJoinOperator();
                work.setTag(commonMergeJoinOperator.getTagForOperator(operator));
                mergeJoinWork.addMergedWork(null, work, context.leafOperatorToFollowingWork);
                tezWork.setVertexType(mergeJoinWork, TezWork.VertexType.MULTI_INPUT_UNINITIALIZED_EDGES);
                for (BaseWork parentWork : tezWork.getParents(work)) {
                    TezEdgeProperty edgeProp = tezWork.getEdgeProperty(parentWork, work);
                    tezWork.disconnect(parentWork, work);
                    tezWork.connect(parentWork, mergeJoinWork, edgeProp);
                }
                work = mergeJoinWork;
            } else {
                void var14_34;
                assert (operator instanceof ReduceSinkOperator && (followingWork instanceof ReduceWork || followingWork instanceof MergeJoinWork || followingWork instanceof UnionWork));
                ReduceSinkOperator rs = (ReduceSinkOperator)operator;
                Object var14_28 = null;
                if (followingWork instanceof MergeJoinWork) {
                    MergeJoinWork mergeJoinWork = (MergeJoinWork)followingWork;
                    ReduceWork reduceWork = (ReduceWork)mergeJoinWork.getMainWork();
                } else if (followingWork instanceof UnionWork) {
                    UnionWork unionWork = (UnionWork)followingWork;
                    int index = this.getFollowingWorkIndex(tezWork, unionWork, rs);
                    BaseWork baseWork = tezWork.getChildren(unionWork).get(index);
                    if (baseWork instanceof MergeJoinWork) {
                        MergeJoinWork mergeJoinWork = (MergeJoinWork)baseWork;
                        followingWork = mergeJoinWork;
                        ReduceWork reduceWork = (ReduceWork)mergeJoinWork.getMainWork();
                    } else {
                        ReduceWork reduceWork = (ReduceWork)baseWork;
                    }
                } else {
                    ReduceWork reduceWork = (ReduceWork)followingWork;
                }
                GenMapRedUtils.setKeyAndValueDesc((ReduceWork)var14_34, rs);
                int tag = ((ReduceSinkDesc)rs.getConf()).getTag();
                var14_34.getTagToInput().put(tag == -1 ? 0 : tag, work.getName());
                ((ReduceSinkDesc)rs.getConf()).setOutputName(var14_34.getName());
                if (!context.connectedReduceSinks.contains(rs)) {
                    TezEdgeProperty edgeProp = var14_34.isAutoReduceParallelism() ? new TezEdgeProperty(context.conf, TezEdgeProperty.EdgeType.SIMPLE_EDGE, true, var14_34.getMinReduceTasks(), var14_34.getMaxReduceTasks(), l) : new TezEdgeProperty(TezEdgeProperty.EdgeType.SIMPLE_EDGE);
                    tezWork.connect(work, followingWork, edgeProp);
                    context.connectedReduceSinks.add(rs);
                }
            }
        } else {
            LOG.debug((Object)("First pass. Leaf operator: " + operator));
        }
        if (!operator.getChildOperators().isEmpty()) {
            assert (operator.getChildOperators().size() == 1);
            context.parentOfRoot = operator;
            context.currentRootOperator = operator.getChildOperators().get(0);
            context.preceedingWork = work;
        }
        return null;
    }

    private int getFollowingWorkIndex(TezWork tezWork, UnionWork unionWork, ReduceSinkOperator rs) throws SemanticException {
        int index = 0;
        for (BaseWork baseWork : tezWork.getChildren(unionWork)) {
            TezEdgeProperty edgeProperty = tezWork.getEdgeProperty(unionWork, baseWork);
            if (edgeProperty.getEdgeType() != TezEdgeProperty.EdgeType.CONTAINS) {
                return index;
            }
            ++index;
        }
        throw new SemanticException("Following work not found for the reduce sink: " + rs.getName());
    }

    private Operator<? extends OperatorDesc> getParentFromStack(Node currentMergeJoinOperator, Stack<Node> stack) {
        int pos = stack.indexOf(currentMergeJoinOperator);
        return (Operator)stack.get(pos - 1);
    }

    private void connectUnionWorkWithWork(UnionWork unionWork, BaseWork work, TezWork tezWork, GenTezProcContext context) {
        LOG.debug((Object)("Connecting union work (" + unionWork + ") with work (" + work + ")"));
        TezEdgeProperty edgeProp = new TezEdgeProperty(TezEdgeProperty.EdgeType.CONTAINS);
        tezWork.connect(unionWork, work, edgeProp);
        unionWork.addUnionOperators(context.currentUnionOperators);
        context.workWithUnionOperators.add(work);
    }
}

