/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.HybridHashTableConf;
import org.apache.hadoop.hive.ql.exec.persistence.HybridHashTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinBytesTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class HashTableLoader
implements org.apache.hadoop.hive.ql.exec.HashTableLoader {
    private static final Log LOG = LogFactory.getLog((String)HashTableLoader.class.getName());
    private Configuration hconf;
    private MapJoinDesc desc;
    private TezContext tezContext;

    @Override
    public void init(ExecMapperContext context, MapredContext mrContext, Configuration hconf, MapJoinOperator joinOp) {
        this.tezContext = (TezContext)mrContext;
        this.hconf = hconf;
        this.desc = (MapJoinDesc)joinOp.getConf();
    }

    @Override
    public void load(MapJoinTableContainer[] mapJoinTables, MapJoinTableContainerSerDe[] mapJoinTableSerdes) throws HiveException {
        Map<Integer, String> parentToInput = this.desc.getParentToInput();
        Map<Integer, Long> parentKeyCounts = this.desc.getParentKeyCounts();
        boolean useOptimizedTables = HiveConf.getBoolVar(this.hconf, HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDTABLE);
        boolean useHybridGraceHashJoin = this.desc.isHybridHashJoin();
        boolean isFirstKey = true;
        long noConditionalTaskThreshold = HiveConf.getLongVar(this.hconf, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
        HybridHashTableConf nwayConf = null;
        long totalSize = 0L;
        int biggest = 0;
        if (useHybridGraceHashJoin && mapJoinTables.length > 2) {
            nwayConf = new HybridHashTableConf();
            long maxSize = 0L;
            for (int pos = 0; pos < mapJoinTables.length; ++pos) {
                if (pos == this.desc.getPosBigTable()) continue;
                totalSize += this.desc.getParentDataSizes().get(pos).longValue();
                biggest = this.desc.getParentDataSizes().get(pos) > maxSize ? pos : biggest;
                maxSize = this.desc.getParentDataSizes().get(pos) > maxSize ? this.desc.getParentDataSizes().get(pos) : maxSize;
            }
            float percentage = (float)maxSize / (float)totalSize;
            long memory = (long)((float)noConditionalTaskThreshold * percentage);
            int numPartitions = 0;
            try {
                numPartitions = HybridHashTableContainer.calcNumPartitions(memory, this.desc.getParentDataSizes().get(biggest), HiveConf.getIntVar(this.hconf, HiveConf.ConfVars.HIVEHYBRIDGRACEHASHJOINMINNUMPARTITIONS), HiveConf.getIntVar(this.hconf, HiveConf.ConfVars.HIVEHYBRIDGRACEHASHJOINMINWBSIZE), nwayConf);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            nwayConf.setNumberOfPartitions(numPartitions);
        }
        for (int pos = 0; pos < mapJoinTables.length; ++pos) {
            if (pos == this.desc.getPosBigTable()) continue;
            String inputName = parentToInput.get(pos);
            LogicalInput input = this.tezContext.getInput(inputName);
            try {
                input.start();
                this.tezContext.getTezProcessorContext().waitForAnyInputReady(Collections.singletonList(input));
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            try {
                ObjectInspector keyOi;
                KeyValueReader kvReader = (KeyValueReader)input.getReader();
                MapJoinObjectSerDeContext keyCtx = mapJoinTableSerdes[pos].getKeyContext();
                MapJoinObjectSerDeContext valCtx = mapJoinTableSerdes[pos].getValueContext();
                if (useOptimizedTables && !MapJoinBytesTableContainer.isSupportedKey(keyOi = keyCtx.getSerDe().getObjectInspector())) {
                    if (isFirstKey) {
                        useOptimizedTables = false;
                        LOG.info((Object)this.describeOi("Not using optimized hash table. Only a subset of mapjoin keys is supported. Unsupported key: ", keyOi));
                    } else {
                        throw new HiveException(this.describeOi("Only a subset of mapjoin keys is supported. Unsupported key: ", keyOi));
                    }
                }
                isFirstKey = false;
                Long keyCountObj = parentKeyCounts.get(pos);
                long keyCount = keyCountObj == null ? -1L : keyCountObj;
                long memory = 0L;
                if (useHybridGraceHashJoin) {
                    if (mapJoinTables.length > 2) {
                        float percentage = (float)this.desc.getParentDataSizes().get(pos).longValue() / (float)totalSize;
                        memory = (long)((float)noConditionalTaskThreshold * percentage);
                    } else {
                        memory = noConditionalTaskThreshold;
                    }
                }
                MapJoinTableContainer tableContainer = useOptimizedTables ? (useHybridGraceHashJoin ? new HybridHashTableContainer(this.hconf, keyCount, memory, this.desc.getParentDataSizes().get(pos), nwayConf) : new MapJoinBytesTableContainer(this.hconf, valCtx, keyCount, 0L)) : new HashMapWrapper(this.hconf, keyCount);
                LOG.info((Object)("Using tableContainer " + tableContainer.getClass().getSimpleName()));
                while (kvReader.next()) {
                    tableContainer.putRow(keyCtx, (Writable)kvReader.getCurrentKey(), valCtx, (Writable)kvReader.getCurrentValue());
                }
                tableContainer.seal();
                mapJoinTables[pos] = tableContainer;
                continue;
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
    }

    private String describeOi(String desc, ObjectInspector keyOi) {
        for (StructField structField : ((StructObjectInspector)keyOi).getAllStructFieldRefs()) {
            ObjectInspector oi = structField.getFieldObjectInspector();
            String cat = oi.getCategory().toString();
            if (oi.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                cat = ((PrimitiveObjectInspector)oi).getPrimitiveCategory().toString();
            }
            desc = desc + structField.getFieldName() + ":" + cat + ", ";
        }
        return desc;
    }
}

