/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLClassLoader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.ql.MapRedStats;
import org.apache.hadoop.hive.ql.exec.Registry;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManagerImpl;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.history.HiveHistoryImpl;
import org.apache.hadoop.hive.ql.history.HiveHistoryProxyHandler;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactoryImpl;
import org.apache.hadoop.hive.ql.session.CreateTableAutomaticGrant;
import org.apache.hadoop.hive.ql.session.DependencyResolver;
import org.apache.hadoop.hive.ql.session.LineageState;
import org.apache.hadoop.hive.ql.session.ResourceMaps;
import org.apache.hadoop.hive.ql.util.DosToUnix;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Shell;

public class SessionState {
    private static final Log LOG = LogFactory.getLog(SessionState.class);
    private static final String TMP_PREFIX = "_tmp_space.db";
    private static final String LOCAL_SESSION_PATH_KEY = "_hive.local.session.path";
    private static final String HDFS_SESSION_PATH_KEY = "_hive.hdfs.session.path";
    private static final String TMP_TABLE_SPACE_KEY = "_hive.tmp_table_space";
    private final Map<String, Map<String, Table>> tempTables = new HashMap<String, Map<String, Table>>();
    private final Map<String, Map<String, ColumnStatisticsObj>> tempTableColStats = new HashMap<String, Map<String, ColumnStatisticsObj>>();
    protected ClassLoader parentLoader;
    protected HiveConf conf;
    protected boolean isSilent;
    protected boolean isVerbose;
    private boolean isHiveServerQuery = false;
    protected HiveHistory hiveHist;
    public InputStream in;
    public PrintStream out;
    public PrintStream info;
    public PrintStream err;
    public PrintStream childOut;
    public PrintStream childErr;
    protected File tmpOutputFile;
    private HiveOperation commandType;
    private String lastCommand;
    private HiveAuthorizationProvider authorizer;
    private HiveAuthorizer authorizerV2;
    private HiveAuthenticationProvider authenticator;
    private CreateTableAutomaticGrant createTableGrants;
    private Map<String, MapRedStats> mapRedStats;
    private Map<String, String> hiveVariables;
    private Map<String, List<List<String>>> stackTraces;
    private Map<String, String> overriddenConfigurations;
    private Map<String, List<String>> localMapRedErrors;
    private TezSessionState tezSessionState;
    private String currentDatabase;
    private final String CONFIG_AUTHZ_SETTINGS_APPLIED_MARKER = "hive.internal.ss.authz.settings.applied.marker";
    private String userIpAddress;
    private SparkSession sparkSession;
    private HadoopShims.HdfsEncryptionShim hdfsEncryptionShim;
    LineageState ls;
    private PerfLogger perfLogger;
    private final String userName;
    private Path hdfsSessionPath;
    private Path hdfsTmpTableSpace;
    private Path localSessionPath;
    private String hdfsScratchDirURIString;
    private int nextValueTempTableSuffix = 1;
    private HiveTxnManager txnMgr = null;
    public static final long NO_CURRENT_TXN = -1L;
    private long currentTxn = -1L;
    private final boolean txnAutoCommit = true;
    private final Set<String> preReloadableAuxJars = new HashSet<String>();
    private final Registry registry = new Registry();
    private Timestamp queryCurrentTimestamp;
    private ResourceMaps resourceMaps;
    private DependencyResolver dependencyResolver;
    private static ThreadLocal<SessionStates> tss = new ThreadLocal<SessionStates>(){

        @Override
        protected SessionStates initialValue() {
            return new SessionStates();
        }
    };
    private static LogHelper _console;

    public LineageState getLineageState() {
        return this.ls;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public void setConf(HiveConf conf) {
        this.conf = conf;
    }

    public File getTmpOutputFile() {
        return this.tmpOutputFile;
    }

    public void setTmpOutputFile(File f) {
        this.tmpOutputFile = f;
    }

    public boolean getIsSilent() {
        if (this.conf != null) {
            return this.conf.getBoolVar(HiveConf.ConfVars.HIVESESSIONSILENT);
        }
        return this.isSilent;
    }

    public boolean isHiveServerQuery() {
        return this.isHiveServerQuery;
    }

    public void setIsSilent(boolean isSilent) {
        if (this.conf != null) {
            this.conf.setBoolVar(HiveConf.ConfVars.HIVESESSIONSILENT, isSilent);
        }
        this.isSilent = isSilent;
    }

    public boolean getIsVerbose() {
        return this.isVerbose;
    }

    public void setIsVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public void setIsHiveServerQuery(boolean isHiveServerQuery) {
        this.isHiveServerQuery = isHiveServerQuery;
    }

    public SessionState(HiveConf conf) {
        this(conf, null);
    }

    public SessionState(HiveConf conf, String userName) {
        this.conf = conf;
        this.userName = userName;
        this.isSilent = conf.getBoolVar(HiveConf.ConfVars.HIVESESSIONSILENT);
        this.ls = new LineageState();
        this.resourceMaps = new ResourceMaps();
        this.dependencyResolver = new DependencyResolver();
        this.overriddenConfigurations = new LinkedHashMap<String, String>();
        this.overriddenConfigurations.putAll(HiveConf.getConfSystemProperties());
        if (StringUtils.isEmpty(conf.getVar(HiveConf.ConfVars.HIVESESSIONID))) {
            conf.setVar(HiveConf.ConfVars.HIVESESSIONID, SessionState.makeSessionId());
        }
        this.parentLoader = JavaUtils.getClassLoader();
    }

    public void setCmd(String cmdString) {
        this.conf.setVar(HiveConf.ConfVars.HIVEQUERYSTRING, cmdString);
    }

    public String getCmd() {
        return this.conf.getVar(HiveConf.ConfVars.HIVEQUERYSTRING);
    }

    public String getQueryId() {
        return this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID);
    }

    public Map<String, String> getHiveVariables() {
        if (this.hiveVariables == null) {
            this.hiveVariables = new HashMap<String, String>();
        }
        return this.hiveVariables;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        this.hiveVariables = hiveVariables;
    }

    public String getSessionId() {
        return this.conf.getVar(HiveConf.ConfVars.HIVESESSIONID);
    }

    public HiveTxnManager initTxnMgr(HiveConf conf) throws LockException {
        if (this.txnMgr == null) {
            this.txnMgr = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        }
        return this.txnMgr;
    }

    public HiveTxnManager getTxnMgr() {
        return this.txnMgr;
    }

    public long getCurrentTxn() {
        return this.currentTxn;
    }

    public void setCurrentTxn(long currTxn) {
        this.currentTxn = currTxn;
    }

    public boolean isAutoCommit() {
        return true;
    }

    public HadoopShims.HdfsEncryptionShim getHdfsEncryptionShim() throws HiveException {
        if (this.hdfsEncryptionShim == null) {
            try {
                FileSystem fs = FileSystem.get((Configuration)this.conf);
                if ("hdfs".equals(fs.getUri().getScheme())) {
                    this.hdfsEncryptionShim = ShimLoader.getHadoopShims().createHdfsEncryptionShim(fs, this.conf);
                } else {
                    LOG.info((Object)"Could not get hdfsEncryptionShim, it is only applicable to hdfs filesystem.");
                }
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        return this.hdfsEncryptionShim;
    }

    public static SessionState start(HiveConf conf) {
        SessionState ss = new SessionState(conf);
        return SessionState.start(ss);
    }

    public static void setCurrentSessionState(SessionState startSs) {
        SessionState.tss.get().attach(startSs);
    }

    public static void detachSession() {
        tss.remove();
    }

    public static SessionState start(SessionState startSs) {
        block10: {
            SessionState.setCurrentSessionState(startSs);
            if (startSs.hiveHist == null) {
                startSs.hiveHist = startSs.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SESSION_HISTORY_ENABLED) ? new HiveHistoryImpl(startSs) : HiveHistoryProxyHandler.getNoOpHiveHistoryProxy();
            }
            try {
                Hive.get(new HiveConf(startSs.conf)).getMSC();
                UserGroupInformation sessionUGI = Utils.getUGI();
                FileSystem.get((Configuration)startSs.conf);
                startSs.createSessionDirs(sessionUGI.getShortUserName());
                if (startSs.getTmpOutputFile() != null) break block10;
                try {
                    startSs.setTmpOutputFile(SessionState.createTempFile(startSs.getConf()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (HiveConf.getVar(startSs.getConf(), HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") && !startSs.isHiveServerQuery) {
            try {
                if (startSs.tezSessionState == null) {
                    startSs.tezSessionState = new TezSessionState(startSs.getSessionId());
                }
                if (!startSs.tezSessionState.isOpen()) {
                    startSs.tezSessionState.open(startSs.conf);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return startSs;
    }

    private void createSessionDirs(String userName) throws IOException {
        HiveConf conf = this.getConf();
        Path rootHDFSDirPath = this.createRootHDFSDir(conf);
        String scratchDirPermission = HiveConf.getVar(conf, HiveConf.ConfVars.SCRATCHDIRPERMISSION);
        Path path = new Path(rootHDFSDirPath, userName);
        this.hdfsScratchDirURIString = path.toUri().toString();
        this.createPath(conf, path, scratchDirPermission, false, false);
        path = new Path(HiveConf.getVar(conf, HiveConf.ConfVars.LOCALSCRATCHDIR));
        this.createPath(conf, path, scratchDirPermission, true, false);
        path = new Path(HiveConf.getVar(conf, HiveConf.ConfVars.DOWNLOADED_RESOURCES_DIR));
        this.createPath(conf, path, scratchDirPermission, true, false);
        String sessionId = this.getSessionId();
        this.hdfsSessionPath = new Path(this.hdfsScratchDirURIString, sessionId);
        this.createPath(conf, this.hdfsSessionPath, scratchDirPermission, false, true);
        conf.set(HDFS_SESSION_PATH_KEY, this.hdfsSessionPath.toUri().toString());
        this.localSessionPath = new Path(HiveConf.getVar(conf, HiveConf.ConfVars.LOCALSCRATCHDIR), sessionId);
        this.createPath(conf, this.localSessionPath, scratchDirPermission, true, true);
        conf.set(LOCAL_SESSION_PATH_KEY, this.localSessionPath.toUri().toString());
        this.hdfsTmpTableSpace = new Path(this.hdfsSessionPath, TMP_PREFIX);
        this.createPath(conf, this.hdfsTmpTableSpace, scratchDirPermission, false, true);
        conf.set(TMP_TABLE_SPACE_KEY, this.hdfsTmpTableSpace.toUri().toString());
    }

    private Path createRootHDFSDir(HiveConf conf) throws IOException {
        Path rootHDFSDirPath = new Path(HiveConf.getVar(conf, HiveConf.ConfVars.SCRATCHDIR));
        FsPermission writableHDFSDirPermission = new FsPermission(475);
        FileSystem fs = rootHDFSDirPath.getFileSystem((Configuration)conf);
        if (!fs.exists(rootHDFSDirPath)) {
            Utilities.createDirsWithPermission(conf, rootHDFSDirPath, writableHDFSDirPermission, true);
        }
        FsPermission currentHDFSDirPermission = fs.getFileStatus(rootHDFSDirPath).getPermission();
        if (rootHDFSDirPath != null && rootHDFSDirPath.toUri() != null) {
            String schema = rootHDFSDirPath.toUri().getScheme();
            LOG.debug((Object)("HDFS root scratch dir: " + rootHDFSDirPath + " with schema " + schema + ", permission: " + currentHDFSDirPermission));
        } else {
            LOG.debug((Object)("HDFS root scratch dir: " + rootHDFSDirPath + ", permission: " + currentHDFSDirPermission));
        }
        if ((currentHDFSDirPermission.toShort() & writableHDFSDirPermission.toShort()) != writableHDFSDirPermission.toShort()) {
            throw new RuntimeException("The root scratch dir: " + rootHDFSDirPath + " on HDFS should be writable. Current permissions are: " + currentHDFSDirPermission);
        }
        return rootHDFSDirPath;
    }

    private void createPath(HiveConf conf, Path path, String permission, boolean isLocal, boolean isCleanUp) throws IOException {
        FsPermission fsPermission = new FsPermission(permission);
        Object fs = isLocal ? FileSystem.getLocal((Configuration)conf) : path.getFileSystem((Configuration)conf);
        if (!fs.exists(path)) {
            fs.mkdirs(path, fsPermission);
            String dirType = isLocal ? "local" : "HDFS";
            LOG.info((Object)("Created " + dirType + " directory: " + path.toString()));
        }
        if (isCleanUp) {
            fs.deleteOnExit(path);
        }
    }

    public String getHdfsScratchDirURIString() {
        return this.hdfsScratchDirURIString;
    }

    public static Path getLocalSessionPath(Configuration conf) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            String localPathString = conf.get(LOCAL_SESSION_PATH_KEY);
            Preconditions.checkNotNull(localPathString, "Conf local session path expected to be non-null");
            return new Path(localPathString);
        }
        Preconditions.checkNotNull(ss.localSessionPath, "Local session path expected to be non-null");
        return ss.localSessionPath;
    }

    public static Path getHDFSSessionPath(Configuration conf) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            String sessionPathString = conf.get(HDFS_SESSION_PATH_KEY);
            Preconditions.checkNotNull(sessionPathString, "Conf non-local session path expected to be non-null");
            return new Path(sessionPathString);
        }
        Preconditions.checkNotNull(ss.hdfsSessionPath, "Non-local session path expected to be non-null");
        return ss.hdfsSessionPath;
    }

    public static Path getTempTableSpace(Configuration conf) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            String tempTablePathString = conf.get(TMP_TABLE_SPACE_KEY);
            Preconditions.checkNotNull(tempTablePathString, "Conf temp table path expected to be non-null");
            return new Path(tempTablePathString);
        }
        return ss.getTempTableSpace();
    }

    public Path getTempTableSpace() {
        Preconditions.checkNotNull(this.hdfsTmpTableSpace, "Temp table path expected to be non-null");
        return this.hdfsTmpTableSpace;
    }

    private void dropSessionPaths(Configuration conf) throws IOException {
        if (this.hdfsSessionPath != null) {
            this.hdfsSessionPath.getFileSystem(conf).delete(this.hdfsSessionPath, true);
        }
        if (this.localSessionPath != null) {
            FileSystem.getLocal((Configuration)conf).delete(this.localSessionPath, true);
        }
    }

    private void setupAuth() {
        if (this.authenticator != null) {
            return;
        }
        try {
            this.authenticator = HiveUtils.getAuthenticator(this.conf, HiveConf.ConfVars.HIVE_AUTHENTICATOR_MANAGER);
            this.authenticator.setSessionState(this);
            String clsStr = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER);
            this.authorizer = HiveUtils.getAuthorizeProviderManager(this.conf, clsStr, this.authenticator, true);
            if (this.authorizer == null) {
                HiveAuthorizerFactory authorizerFactory = HiveUtils.getAuthorizerFactory(this.conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER);
                HiveAuthzSessionContext.Builder authzContextBuilder = new HiveAuthzSessionContext.Builder();
                authzContextBuilder.setClientType(this.isHiveServerQuery() ? HiveAuthzSessionContext.CLIENT_TYPE.HIVESERVER2 : HiveAuthzSessionContext.CLIENT_TYPE.HIVECLI);
                authzContextBuilder.setSessionString(this.getSessionId());
                this.authorizerV2 = authorizerFactory.createHiveAuthorizer(new HiveMetastoreClientFactoryImpl(), this.conf, this.authenticator, authzContextBuilder.build());
                this.setAuthorizerV2Config();
            }
            this.createTableGrants = CreateTableAutomaticGrant.create(this.conf);
        }
        catch (HiveException e) {
            LOG.error((Object)("Error setting up authorization: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            Object authorizationClass = this.getActiveAuthorizer();
            LOG.debug((Object)("Session is using authorization class " + authorizationClass.getClass()));
        }
    }

    private void setAuthorizerV2Config() throws HiveException {
        if (this.conf.get("hive.internal.ss.authz.settings.applied.marker", "").equals(Boolean.TRUE.toString())) {
            return;
        }
        this.conf.setVar(HiveConf.ConfVars.METASTORE_FILTER_HOOK, "org.apache.hadoop.hive.ql.security.authorization.plugin.AuthorizationMetaStoreFilterHook");
        this.authorizerV2.applyAuthorizationConfigPolicy(this.conf);
        try {
            Hive.get(this.conf).getMSC();
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
        this.conf.set("hive.internal.ss.authz.settings.applied.marker", Boolean.TRUE.toString());
    }

    public Object getActiveAuthorizer() {
        return this.getAuthorizationMode() == AuthorizationMode.V1 ? this.getAuthorizer() : this.getAuthorizerV2();
    }

    public Class getAuthorizerInterface() {
        return this.getAuthorizationMode() == AuthorizationMode.V1 ? HiveAuthorizationProvider.class : HiveAuthorizer.class;
    }

    public void setActiveAuthorizer(Object authorizer) {
        if (authorizer instanceof HiveAuthorizationProvider) {
            this.authorizer = (HiveAuthorizationProvider)authorizer;
        } else if (authorizer instanceof HiveAuthorizer) {
            this.authorizerV2 = (HiveAuthorizer)authorizer;
        } else if (authorizer != null) {
            throw new IllegalArgumentException("Invalid authorizer " + authorizer);
        }
    }

    private static File createTempFile(HiveConf conf) throws IOException {
        String lScratchDir = HiveConf.getVar(conf, HiveConf.ConfVars.LOCALSCRATCHDIR);
        File tmpDir = new File(lScratchDir);
        String sessionID = conf.getVar(HiveConf.ConfVars.HIVESESSIONID);
        if (!(tmpDir.exists() || tmpDir.mkdirs() || tmpDir.exists())) {
            throw new RuntimeException("Unable to create log directory " + lScratchDir);
        }
        File tmpFile = File.createTempFile(sessionID, ".pipeout", tmpDir);
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    public static SessionState get() {
        return tss.get().state;
    }

    public static HiveConf getSessionConf() {
        SessionStates state = tss.get();
        if (state.conf == null) {
            state.attach(new HiveConf());
        }
        return state.conf;
    }

    public static Registry getRegistry() {
        SessionState session = SessionState.get();
        return session != null ? session.registry : null;
    }

    public static Registry getRegistryForWrite() {
        Registry registry = SessionState.getRegistry();
        if (registry == null) {
            throw new RuntimeException("Function registery for session is not initialized");
        }
        return registry;
    }

    public HiveHistory getHiveHistory() {
        return this.hiveHist;
    }

    private static String makeSessionId() {
        return UUID.randomUUID().toString();
    }

    public String getLastCommand() {
        return this.lastCommand;
    }

    public void setLastCommand(String lastCommand) {
        this.lastCommand = lastCommand;
    }

    public static LogHelper getConsole() {
        if (_console == null) {
            Log LOG = LogFactory.getLog((String)"SessionState");
            _console = new LogHelper(LOG);
        }
        return _console;
    }

    public static String getUserFromAuthenticator() {
        if (SessionState.get() != null && SessionState.get().getAuthenticator() != null) {
            return SessionState.get().getAuthenticator().getUserName();
        }
        return null;
    }

    static void validateFiles(List<String> newFiles) throws IllegalArgumentException {
        SessionState ss = SessionState.get();
        Configuration conf = ss == null ? new Configuration() : ss.getConf();
        for (String newFile : newFiles) {
            try {
                if (Utilities.realFile(newFile, conf) != null) continue;
                String message = newFile + " does not exist";
                throw new IllegalArgumentException(message);
            }
            catch (IOException e) {
                String message = "Unable to validate " + newFile;
                throw new IllegalArgumentException(message, e);
            }
        }
    }

    public void reloadAuxJars() throws IOException {
        HashSet<String> reloadedAuxJars = new HashSet<String>();
        String renewableJarPath = this.conf.getVar(HiveConf.ConfVars.HIVERELOADABLEJARS);
        if (renewableJarPath == null || renewableJarPath.isEmpty()) {
            return;
        }
        Set<String> jarPaths = Utilities.getJarFilesByPath(renewableJarPath);
        if (!jarPaths.isEmpty()) {
            reloadedAuxJars.addAll(jarPaths);
        }
        try {
            if (this.preReloadableAuxJars != null && !this.preReloadableAuxJars.isEmpty()) {
                Utilities.removeFromClassPath(this.preReloadableAuxJars.toArray(new String[0]));
            }
        }
        catch (Exception e) {
            String msg = "Fail to remove the reloaded jars loaded last time: " + e;
            throw new IOException(msg, e);
        }
        try {
            if (reloadedAuxJars != null && !reloadedAuxJars.isEmpty()) {
                URLClassLoader currentCLoader = (URLClassLoader)SessionState.get().getConf().getClassLoader();
                currentCLoader = (URLClassLoader)Utilities.addToClassPath(currentCLoader, reloadedAuxJars.toArray(new String[0]));
                this.conf.setClassLoader(currentCLoader);
                Thread.currentThread().setContextClassLoader(currentCLoader);
            }
            this.preReloadableAuxJars.clear();
            this.preReloadableAuxJars.addAll(reloadedAuxJars);
        }
        catch (Exception e) {
            String msg = "Fail to add jars from the path specified in hive.reloadable.aux.jars.path property: " + e;
            throw new IOException(msg, e);
        }
    }

    static void registerJars(List<String> newJars) throws IllegalArgumentException {
        LogHelper console = SessionState.getConsole();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ClassLoader newLoader = Utilities.addToClassPath(loader, newJars.toArray(new String[0]));
            Thread.currentThread().setContextClassLoader(newLoader);
            SessionState.get().getConf().setClassLoader(newLoader);
            console.printInfo("Added " + newJars + " to class path");
        }
        catch (Exception e) {
            String message = "Unable to register " + newJars;
            throw new IllegalArgumentException(message, e);
        }
    }

    static boolean unregisterJar(List<String> jarsToUnregister) {
        LogHelper console = SessionState.getConsole();
        try {
            Utilities.removeFromClassPath(jarsToUnregister.toArray(new String[0]));
            console.printInfo("Deleted " + jarsToUnregister + " from class path");
            return true;
        }
        catch (Exception e) {
            console.printError("Unable to unregister " + jarsToUnregister + "\nException: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return false;
        }
    }

    public static ResourceType find_resource_type(String s) {
        s = s.trim().toUpperCase();
        try {
            return ResourceType.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            if (!s.endsWith("S")) {
                return null;
            }
            s = s.substring(0, s.length() - 1);
            try {
                return ResourceType.valueOf(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    public String add_resource(ResourceType t, String value) throws RuntimeException {
        return this.add_resource(t, value, false);
    }

    public String add_resource(ResourceType t, String value, boolean convertToUnix) throws RuntimeException {
        List<String> added = this.add_resources(t, Arrays.asList(value), convertToUnix);
        if (added == null || added.isEmpty()) {
            return null;
        }
        return added.get(0);
    }

    public List<String> add_resources(ResourceType t, Collection<String> values) throws RuntimeException {
        return this.add_resources(t, values, false);
    }

    public List<String> add_resources(ResourceType t, Collection<String> values, boolean convertToUnix) throws RuntimeException {
        Set<String> resourceSet = this.resourceMaps.getResourceSet(t);
        Map<String, Set<String>> resourcePathMap = this.resourceMaps.getResourcePathMap(t);
        Map<String, Set<String>> reverseResourcePathMap = this.resourceMaps.getReverseResourcePathMap(t);
        ArrayList<String> localized = new ArrayList<String>();
        try {
            for (String value : values) {
                List<URI> downloadedURLs = this.resolveAndDownload(t, value, convertToUnix);
                String key = SessionState.getURLType(value).equals("ivy") ? SessionState.createURI(value).getAuthority() : downloadedURLs.get(0).toString();
                HashSet<String> downloadedValues = new HashSet<String>();
                for (URI uri : downloadedURLs) {
                    String resourceValue = uri.toString();
                    downloadedValues.add(resourceValue);
                    localized.add(resourceValue);
                    if (reverseResourcePathMap.containsKey(resourceValue)) {
                        if (reverseResourcePathMap.get(resourceValue).contains(key)) continue;
                        reverseResourcePathMap.get(resourceValue).add(key);
                        continue;
                    }
                    HashSet<String> addSet = new HashSet<String>();
                    addSet.add(key);
                    reverseResourcePathMap.put(resourceValue, addSet);
                }
                resourcePathMap.put(key, downloadedValues);
            }
            t.preHook(resourceSet, localized);
        }
        catch (RuntimeException e) {
            SessionState.getConsole().printError(e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        catch (URISyntaxException e) {
            SessionState.getConsole().printError(e.getMessage());
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            SessionState.getConsole().printError(e.getMessage());
            throw new RuntimeException(e);
        }
        SessionState.getConsole().printInfo("Added resources: " + values);
        resourceSet.addAll(localized);
        return localized;
    }

    private static URI createURI(String path) throws URISyntaxException {
        if (!Shell.WINDOWS) {
            return new URI(path);
        }
        return new Path(path).toUri();
    }

    private static String getURLType(String value) throws URISyntaxException {
        String scheme;
        URI uri = SessionState.createURI(value);
        String string = scheme = uri.getScheme() == null ? null : uri.getScheme().toLowerCase();
        if (scheme == null || scheme.equals("file")) {
            return "file";
        }
        if (scheme.equals("hdfs") || scheme.equals("ivy")) {
            return scheme;
        }
        throw new RuntimeException("invalid url: " + uri + ", expecting ( file | hdfs | ivy)  as url scheme. ");
    }

    List<URI> resolveAndDownload(ResourceType t, String value, boolean convertToUnix) throws URISyntaxException, IOException {
        URI uri = SessionState.createURI(value);
        if (SessionState.getURLType(value).equals("file")) {
            return Arrays.asList(uri);
        }
        if (SessionState.getURLType(value).equals("ivy")) {
            return this.dependencyResolver.downloadDependencies(uri);
        }
        if (SessionState.getURLType(value).equals("hdfs")) {
            return Arrays.asList(SessionState.createURI(this.downloadResource(value, convertToUnix)));
        }
        throw new RuntimeException("Invalid url " + uri);
    }

    public static boolean canDownloadResource(String value) {
        String scheme = new Path(value).toUri().getScheme();
        return scheme != null && !scheme.equalsIgnoreCase("file");
    }

    private String downloadResource(String value, boolean convertToUnix) {
        block7: {
            if (SessionState.canDownloadResource(value)) {
                SessionState.getConsole().printInfo("converting to local " + value);
                File resourceDir = new File(this.getConf().getVar(HiveConf.ConfVars.DOWNLOADED_RESOURCES_DIR));
                String destinationName = new Path(value).getName();
                File destinationFile = new File(resourceDir, destinationName);
                if (resourceDir.exists() && !resourceDir.isDirectory()) {
                    throw new RuntimeException("The resource directory is not a directory, resourceDir is set to" + resourceDir);
                }
                if (!resourceDir.exists() && !resourceDir.mkdirs()) {
                    throw new RuntimeException("Couldn't create directory " + resourceDir);
                }
                try {
                    FileSystem fs = FileSystem.get((URI)SessionState.createURI(value), (Configuration)this.conf);
                    fs.copyToLocalFile(new Path(value), new Path(destinationFile.getCanonicalPath()));
                    value = destinationFile.getCanonicalPath();
                    FileUtil.chmod((String)value, (String)"ugo+rx", (boolean)true);
                    if (!convertToUnix || !DosToUnix.isWindowsScript(destinationFile)) break block7;
                    try {
                        DosToUnix.convertWindowsScriptToUnix(destinationFile);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Caught exception while converting file " + destinationFile + " to unix line endings", e);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to read external resource " + value, e);
                }
            }
        }
        return value;
    }

    public void delete_resources(ResourceType t, List<String> values) {
        Set<String> resources = this.resourceMaps.getResourceSet(t);
        if (resources == null || resources.isEmpty()) {
            return;
        }
        Map<String, Set<String>> resourcePathMap = this.resourceMaps.getResourcePathMap(t);
        Map<String, Set<String>> reverseResourcePathMap = this.resourceMaps.getReverseResourcePathMap(t);
        LinkedList<String> deleteList = new LinkedList<String>();
        Iterator<String> i$ = values.iterator();
        while (i$.hasNext()) {
            String value;
            String key = value = i$.next();
            try {
                if (SessionState.getURLType(value).equals("ivy")) {
                    key = SessionState.createURI(value).getAuthority();
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid uri string " + value + ", " + e.getMessage());
            }
            Set<String> resourcePaths = resourcePathMap.get(key);
            if (resourcePaths == null) {
                return;
            }
            for (String resourceValue : resourcePaths) {
                reverseResourcePathMap.get(resourceValue).remove(key);
                if (!reverseResourcePathMap.get(resourceValue).isEmpty()) continue;
                deleteList.add(resourceValue);
                reverseResourcePathMap.remove(resourceValue);
            }
            resourcePathMap.remove(key);
        }
        t.postHook(resources, deleteList);
        resources.removeAll(deleteList);
    }

    public Set<String> list_resource(ResourceType t, List<String> filter) {
        Set<String> orig = this.resourceMaps.getResourceSet(t);
        if (orig == null) {
            return null;
        }
        if (filter == null) {
            return orig;
        }
        HashSet<String> fnl = new HashSet<String>();
        for (String one : orig) {
            if (!filter.contains(one)) continue;
            fnl.add(one);
        }
        return fnl;
    }

    public void delete_resources(ResourceType t) {
        Set<String> resources = this.resourceMaps.getResourceSet(t);
        if (resources != null && !resources.isEmpty()) {
            this.delete_resources(t, new ArrayList<String>(resources));
            this.resourceMaps.getResourceMap().remove((Object)t);
        }
    }

    public String getCommandType() {
        if (this.commandType == null) {
            return null;
        }
        return this.commandType.getOperationName();
    }

    public HiveOperation getHiveOperation() {
        return this.commandType;
    }

    public void setCommandType(HiveOperation commandType) {
        this.commandType = commandType;
    }

    public HiveAuthorizationProvider getAuthorizer() {
        this.setupAuth();
        return this.authorizer;
    }

    public void setAuthorizer(HiveAuthorizationProvider authorizer) {
        this.authorizer = authorizer;
    }

    public HiveAuthorizer getAuthorizerV2() {
        this.setupAuth();
        return this.authorizerV2;
    }

    public HiveAuthenticationProvider getAuthenticator() {
        this.setupAuth();
        return this.authenticator;
    }

    public void setAuthenticator(HiveAuthenticationProvider authenticator) {
        this.authenticator = authenticator;
    }

    public CreateTableAutomaticGrant getCreateTableGrants() {
        this.setupAuth();
        return this.createTableGrants;
    }

    public void setCreateTableGrants(CreateTableAutomaticGrant createTableGrants) {
        this.createTableGrants = createTableGrants;
    }

    public Map<String, MapRedStats> getMapRedStats() {
        return this.mapRedStats;
    }

    public void setMapRedStats(Map<String, MapRedStats> mapRedStats) {
        this.mapRedStats = mapRedStats;
    }

    public void setStackTraces(Map<String, List<List<String>>> stackTraces) {
        this.stackTraces = stackTraces;
    }

    public Map<String, List<List<String>>> getStackTraces() {
        return this.stackTraces;
    }

    public Map<String, String> getOverriddenConfigurations() {
        if (this.overriddenConfigurations == null) {
            this.overriddenConfigurations = new LinkedHashMap<String, String>();
        }
        return this.overriddenConfigurations;
    }

    public void setOverriddenConfigurations(Map<String, String> overriddenConfigurations) {
        this.overriddenConfigurations = overriddenConfigurations;
    }

    public Map<String, List<String>> getLocalMapRedErrors() {
        return this.localMapRedErrors;
    }

    public void addLocalMapRedErrors(String id, List<String> localMapRedErrors) {
        if (!this.localMapRedErrors.containsKey(id)) {
            this.localMapRedErrors.put(id, new ArrayList());
        }
        this.localMapRedErrors.get(id).addAll(localMapRedErrors);
    }

    public void setLocalMapRedErrors(Map<String, List<String>> localMapRedErrors) {
        this.localMapRedErrors = localMapRedErrors;
    }

    public String getCurrentDatabase() {
        if (this.currentDatabase == null) {
            this.currentDatabase = "default";
        }
        return this.currentDatabase;
    }

    public void setCurrentDatabase(String currentDatabase) {
        this.currentDatabase = currentDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.registry.clear();
        if (this.txnMgr != null) {
            this.txnMgr.closeTxnManager();
        }
        JavaUtils.closeClassLoadersTo(this.conf.getClassLoader(), this.parentLoader);
        File resourceDir = new File(this.getConf().getVar(HiveConf.ConfVars.DOWNLOADED_RESOURCES_DIR));
        LOG.debug((Object)("Removing resource dir " + resourceDir));
        try {
            if (resourceDir.exists()) {
                FileUtils.deleteDirectory((File)resourceDir);
            }
        }
        catch (IOException e) {
            LOG.info((Object)("Error removing session resource dir " + resourceDir), (Throwable)e);
        }
        finally {
            SessionState.detachSession();
        }
        try {
            if (this.tezSessionState != null) {
                TezSessionPoolManager.getInstance().close(this.tezSessionState, false);
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Error closing tez session", (Throwable)e);
        }
        finally {
            this.tezSessionState = null;
        }
        if (this.sparkSession != null) {
            try {
                SparkSessionManagerImpl.getInstance().closeSession(this.sparkSession);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error closing spark session.", (Throwable)ex);
            }
            finally {
                this.sparkSession = null;
            }
        }
        this.dropSessionPaths(this.conf);
    }

    public AuthorizationMode getAuthorizationMode() {
        this.setupAuth();
        if (this.authorizer != null) {
            return AuthorizationMode.V1;
        }
        if (this.authorizerV2 != null) {
            return AuthorizationMode.V2;
        }
        throw new AssertionError((Object)"Authorization plugins not initialized!");
    }

    public boolean isAuthorizationModeV2() {
        return this.getAuthorizationMode() == AuthorizationMode.V2;
    }

    public PerfLogger getPerfLogger(boolean resetPerfLogger) {
        if (this.perfLogger == null || resetPerfLogger) {
            try {
                this.perfLogger = (PerfLogger)ReflectionUtils.newInstance((Class)this.conf.getClassByName(this.conf.getVar(HiveConf.ConfVars.HIVE_PERF_LOGGER)), (Configuration)this.conf);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Performance Logger Class not found:" + e.getMessage()));
                this.perfLogger = new PerfLogger();
            }
        }
        return this.perfLogger;
    }

    public TezSessionState getTezSession() {
        return this.tezSessionState;
    }

    public void setTezSession(TezSessionState session) {
        this.tezSessionState = session;
    }

    public String getUserName() {
        return this.userName;
    }

    public void applyAuthorizationPolicy() throws HiveException {
        this.setupAuth();
    }

    public Map<String, Map<String, Table>> getTempTables() {
        return this.tempTables;
    }

    public Map<String, Map<String, ColumnStatisticsObj>> getTempTableColStats() {
        return this.tempTableColStats;
    }

    public String getUserIpAddress() {
        return this.userIpAddress;
    }

    public void setUserIpAddress(String userIpAddress) {
        this.userIpAddress = userIpAddress;
    }

    public SparkSession getSparkSession() {
        return this.sparkSession;
    }

    public void setSparkSession(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
    }

    public String getNextValuesTempTableSuffix() {
        return Integer.toString(this.nextValueTempTableSuffix++);
    }

    public void setupQueryCurrentTimestamp() {
        String overrideTimestampString;
        this.queryCurrentTimestamp = new Timestamp(System.currentTimeMillis());
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && (overrideTimestampString = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVETESTCURRENTTIMESTAMP, null)) != null && overrideTimestampString.length() > 0) {
            this.queryCurrentTimestamp = Timestamp.valueOf(overrideTimestampString);
        }
    }

    public Timestamp getQueryCurrentTimestamp() {
        return this.queryCurrentTimestamp;
    }

    public static enum ResourceType {
        FILE,
        JAR{

            @Override
            public void preHook(Set<String> cur, List<String> s) throws IllegalArgumentException {
                super.preHook(cur, s);
                SessionState.registerJars(s);
            }

            @Override
            public void postHook(Set<String> cur, List<String> s) {
                SessionState.unregisterJar(s);
            }
        }
        ,
        ARCHIVE;


        public void preHook(Set<String> cur, List<String> s) throws IllegalArgumentException {
            SessionState.validateFiles(s);
        }

        public void postHook(Set<String> cur, List<String> s) {
        }
    }

    public static class LogHelper {
        protected Log LOG;
        protected boolean isSilent;

        public LogHelper(Log LOG) {
            this(LOG, false);
        }

        public LogHelper(Log LOG, boolean isSilent) {
            this.LOG = LOG;
            this.isSilent = isSilent;
        }

        public PrintStream getOutStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.out != null ? ss.out : System.out;
        }

        public PrintStream getInfoStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.info != null ? ss.info : this.getErrStream();
        }

        public PrintStream getErrStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.err != null ? ss.err : System.err;
        }

        public PrintStream getChildOutStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.childOut != null ? ss.childOut : System.out;
        }

        public PrintStream getChildErrStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.childErr != null ? ss.childErr : System.err;
        }

        public boolean getIsSilent() {
            SessionState ss = SessionState.get();
            return ss != null ? ss.getIsSilent() : this.isSilent;
        }

        public void logInfo(String info) {
            this.logInfo(info, null);
        }

        public void logInfo(String info, String detail) {
            this.LOG.info((Object)(info + StringUtils.defaultString(detail)));
        }

        public void printInfo(String info) {
            this.printInfo(info, null);
        }

        public void printInfo(String info, String detail) {
            if (!this.getIsSilent()) {
                this.getInfoStream().println(info);
            }
            this.LOG.info((Object)(info + StringUtils.defaultString(detail)));
        }

        public void printError(String error) {
            this.printError(error, null);
        }

        public void printError(String error, String detail) {
            this.getErrStream().println(error);
            this.LOG.error((Object)(error + StringUtils.defaultString(detail)));
        }
    }

    private static class SessionStates {
        private SessionState state;
        private HiveConf conf;

        private SessionStates() {
        }

        private void attach(SessionState state) {
            this.state = state;
            this.attach(state.getConf());
        }

        private void attach(HiveConf conf) {
            this.conf = conf;
            ClassLoader classLoader = conf.getClassLoader();
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    public static enum AuthorizationMode {
        V1,
        V2;

    }
}

