/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.io.api.LlapIo;

public class LlapProxy {
    private static final String IMPL_CLASS = "org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl";
    private static LlapIo io = null;
    private static boolean isDaemon = false;

    public static void setDaemon(boolean isDaemon) {
        LlapProxy.isDaemon = isDaemon;
    }

    public static boolean isDaemon() {
        return isDaemon;
    }

    public static LlapIo getIo() {
        return io;
    }

    public static void initializeLlapIo(Configuration conf) {
        if (io != null) {
            return;
        }
        try {
            io = LlapProxy.createIoImpl(conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot initialize local server", e);
        }
    }

    private static LlapIo createIoImpl(Configuration conf) throws IOException {
        try {
            Class<?> clazz = Class.forName(IMPL_CLASS);
            Constructor<?> ctor = clazz.getDeclaredConstructor(Configuration.class);
            ctor.setAccessible(true);
            return (LlapIo)ctor.newInstance(conf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create impl class", e);
        }
    }

    public static void close() {
        if (io != null) {
            io.close();
        }
    }
}

