/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;

public class SerializationTest {
    private final String topic = "testTopic";
    private final Map<Class<Object>, List<Object>> testData = new HashMap(){
        {
            this.put(String.class, Arrays.asList("my string"));
            this.put(Short.class, Arrays.asList((short)Short.MAX_VALUE, (short)Short.MIN_VALUE));
            this.put(Integer.class, Arrays.asList(423412424, -41243432));
            this.put(Long.class, Arrays.asList(0xCCCCCCCCCCCCCCCL, -922337203685477581L));
            this.put(Float.class, Arrays.asList(Float.valueOf(5678567.0f), Float.valueOf(-5678567.0f)));
            this.put(Double.class, Arrays.asList(5678567.12312, -5678567.12341));
            this.put(byte[].class, Arrays.asList(new byte[][]{"my string".getBytes()}));
            this.put(ByteBuffer.class, Arrays.asList(ByteBuffer.allocate(10).put("my string".getBytes())));
            this.put(Bytes.class, Arrays.asList(new Bytes("my string".getBytes())));
        }
    };

    @Test
    public void allSerdesShouldRoundtripInput() {
        for (Map.Entry<Class<Object>, List<Object>> test : this.testData.entrySet()) {
            Serde serde = Serdes.serdeFrom(test.getKey());
            Throwable throwable = null;
            try {
                for (Object value : test.getValue()) {
                    Assert.assertEquals((String)("Should get the original " + test.getKey().getSimpleName() + " after serialization and deserialization"), (Object)value, (Object)serde.deserializer().deserialize("testTopic", serde.serializer().serialize("testTopic", value)));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (serde == null) continue;
                if (throwable != null) {
                    try {
                        serde.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                serde.close();
            }
        }
    }

    @Test
    public void allSerdesShouldSupportNull() {
        for (Class<Object> cls : this.testData.keySet()) {
            Serde serde = Serdes.serdeFrom(cls);
            Throwable throwable = null;
            try {
                MatcherAssert.assertThat((String)("Should support null in " + cls.getSimpleName() + " serialization"), (Object)serde.serializer().serialize("testTopic", null), (Matcher)IsNull.nullValue());
                MatcherAssert.assertThat((String)("Should support null in " + cls.getSimpleName() + " deserialization"), (Object)serde.deserializer().deserialize("testTopic", null), (Matcher)IsNull.nullValue());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (serde == null) continue;
                if (throwable != null) {
                    try {
                        serde.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                serde.close();
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSerdeFromUnknown() {
        Serdes.serdeFrom(DummyClass.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSerdeFromNotNull() {
        try (Serde serde = Serdes.Long();){
            Serdes.serdeFrom(null, (Deserializer)serde.deserializer());
        }
    }

    @Test
    public void stringSerdeShouldSupportDifferentEncodings() {
        String str = "my string";
        List<String> encodings = Arrays.asList("UTF8", "UTF-16");
        for (String encoding : encodings) {
            Serde<String> serDeser = this.getStringSerde(encoding);
            Throwable throwable = null;
            try {
                Serializer serializer = serDeser.serializer();
                Deserializer deserializer = serDeser.deserializer();
                Assert.assertEquals((String)("Should get the original string after serialization and deserialization with encoding " + encoding), (Object)str, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", (Object)str)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (serDeser == null) continue;
                if (throwable != null) {
                    try {
                        serDeser.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                serDeser.close();
            }
        }
    }

    @Test(expected=SerializationException.class)
    public void floatDeserializerShouldThrowSerializationExceptionOnZeroBytes() {
        try (Serde serde = Serdes.Float();){
            serde.deserializer().deserialize("testTopic", new byte[0]);
        }
    }

    @Test(expected=SerializationException.class)
    public void floatDeserializerShouldThrowSerializationExceptionOnTooFewBytes() {
        try (Serde serde = Serdes.Float();){
            serde.deserializer().deserialize("testTopic", new byte[3]);
        }
    }

    @Test(expected=SerializationException.class)
    public void floatDeserializerShouldThrowSerializationExceptionOnTooManyBytes() {
        try (Serde serde = Serdes.Float();){
            serde.deserializer().deserialize("testTopic", new byte[5]);
        }
    }

    @Test
    public void floatSerdeShouldPreserveNaNValues() {
        int someNaNAsIntBits = 2139095041;
        float someNaN = Float.intBitsToFloat(someNaNAsIntBits);
        int anotherNaNAsIntBits = 2139095042;
        float anotherNaN = Float.intBitsToFloat(anotherNaNAsIntBits);
        try (Serde serde = Serdes.Float();){
            Float roundtrip = (Float)serde.deserializer().deserialize("testTopic", serde.serializer().serialize("testTopic", (Object)Float.valueOf(someNaN)));
            MatcherAssert.assertThat((Object)Float.floatToRawIntBits(roundtrip.floatValue()), (Matcher)CoreMatchers.equalTo((Object)someNaNAsIntBits));
            Float otherRoundtrip = (Float)serde.deserializer().deserialize("testTopic", serde.serializer().serialize("testTopic", (Object)Float.valueOf(anotherNaN)));
            MatcherAssert.assertThat((Object)Float.floatToRawIntBits(otherRoundtrip.floatValue()), (Matcher)CoreMatchers.equalTo((Object)anotherNaNAsIntBits));
        }
    }

    private Serde<String> getStringSerde(String encoder) {
        HashMap<String, String> serializerConfigs = new HashMap<String, String>();
        serializerConfigs.put("key.serializer.encoding", encoder);
        Serializer serializer = Serdes.String().serializer();
        serializer.configure(serializerConfigs, true);
        HashMap<String, String> deserializerConfigs = new HashMap<String, String>();
        deserializerConfigs.put("key.deserializer.encoding", encoder);
        Deserializer deserializer = Serdes.String().deserializer();
        deserializer.configure(deserializerConfigs, true);
        return Serdes.serdeFrom((Serializer)serializer, (Deserializer)deserializer);
    }

    private class DummyClass {
        private DummyClass() {
        }
    }
}

