/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class KafkaFutureTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testCompleteFutures() throws Exception {
        KafkaFutureImpl future123 = new KafkaFutureImpl();
        Assert.assertTrue((boolean)future123.complete((Object)123));
        Assert.assertEquals((Object)123, (Object)future123.get());
        Assert.assertFalse((boolean)future123.complete((Object)456));
        Assert.assertTrue((boolean)future123.isDone());
        Assert.assertFalse((boolean)future123.isCancelled());
        Assert.assertFalse((boolean)future123.isCompletedExceptionally());
        KafkaFuture future456 = KafkaFuture.completedFuture((Object)456);
        Assert.assertEquals((Object)456, (Object)future456.get());
        KafkaFutureImpl futureFail = new KafkaFutureImpl();
        futureFail.completeExceptionally((Throwable)new RuntimeException("We require more vespene gas"));
        try {
            futureFail.get();
            Assert.fail((String)"Expected an exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(RuntimeException.class, e.getCause().getClass());
            Assert.assertEquals((Object)"We require more vespene gas", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testCompletingFutures() throws Exception {
        KafkaFutureImpl future = new KafkaFutureImpl();
        CompleterThread<String> myThread = new CompleterThread<String>(future, "You must construct additional pylons.");
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCompletedExceptionally());
        Assert.assertFalse((boolean)future.isCancelled());
        Assert.assertEquals((Object)"I am ready", (Object)future.getNow((Object)"I am ready"));
        myThread.start();
        String str = (String)future.get(5L, TimeUnit.MINUTES);
        Assert.assertEquals((Object)"You must construct additional pylons.", (Object)str);
        Assert.assertEquals((Object)"You must construct additional pylons.", (Object)future.getNow((Object)"I am ready"));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCompletedExceptionally());
        Assert.assertFalse((boolean)future.isCancelled());
        myThread.join();
        Assert.assertEquals(null, (Object)myThread.testException);
    }

    @Test
    public void testThenApply() throws Exception {
        KafkaFutureImpl future = new KafkaFutureImpl();
        KafkaFuture doubledFuture = future.thenApply(integer -> 2 * integer);
        Assert.assertFalse((boolean)doubledFuture.isDone());
        KafkaFuture tripledFuture = future.thenApply(integer -> 3 * integer);
        Assert.assertFalse((boolean)tripledFuture.isDone());
        future.complete((Object)21);
        Assert.assertEquals((Object)21, (Object)future.getNow((Object)-1));
        Assert.assertEquals((Object)42, (Object)doubledFuture.getNow((Object)-1));
        Assert.assertEquals((Object)63, (Object)tripledFuture.getNow((Object)-1));
        KafkaFuture quadrupledFuture = future.thenApply(integer -> 4 * integer);
        Assert.assertEquals((Object)84, (Object)quadrupledFuture.getNow((Object)-1));
        KafkaFutureImpl futureFail = new KafkaFutureImpl();
        KafkaFuture futureAppliedFail = futureFail.thenApply(integer -> 2 * integer);
        futureFail.completeExceptionally((Throwable)new RuntimeException());
        Assert.assertTrue((boolean)futureFail.isCompletedExceptionally());
        Assert.assertTrue((boolean)futureAppliedFail.isCompletedExceptionally());
    }

    @Test
    public void testAllOfFutures() throws Exception {
        int i;
        int numThreads = 5;
        ArrayList<KafkaFutureImpl> futures = new ArrayList<KafkaFutureImpl>();
        for (int i2 = 0; i2 < 5; ++i2) {
            futures.add(new KafkaFutureImpl());
        }
        KafkaFuture allFuture = KafkaFuture.allOf((KafkaFuture[])futures.toArray(new KafkaFuture[0]));
        ArrayList<CompleterThread<Integer>> completerThreads = new ArrayList<CompleterThread<Integer>>();
        ArrayList<WaiterThread<Integer>> waiterThreads = new ArrayList<WaiterThread<Integer>>();
        for (i = 0; i < 5; ++i) {
            completerThreads.add(new CompleterThread<Integer>((KafkaFutureImpl)futures.get(i), i));
            waiterThreads.add(new WaiterThread<Integer>((KafkaFutureImpl)futures.get(i), i));
        }
        Assert.assertFalse((boolean)allFuture.isDone());
        for (i = 0; i < 5; ++i) {
            ((WaiterThread)waiterThreads.get(i)).start();
        }
        for (i = 0; i < 4; ++i) {
            ((CompleterThread)completerThreads.get(i)).start();
        }
        Assert.assertFalse((boolean)allFuture.isDone());
        ((CompleterThread)completerThreads.get(4)).start();
        allFuture.get();
        Assert.assertTrue((boolean)allFuture.isDone());
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)i, (Object)((KafkaFutureImpl)futures.get(i)).get());
        }
        for (i = 0; i < 5; ++i) {
            ((CompleterThread)completerThreads.get(i)).join();
            ((WaiterThread)waiterThreads.get(i)).join();
            Assert.assertEquals(null, (Object)((CompleterThread)completerThreads.get((int)i)).testException);
            Assert.assertEquals(null, (Object)((WaiterThread)waiterThreads.get((int)i)).testException);
        }
    }

    @Test
    public void testAllOfFuturesHandlesZeroFutures() throws Exception {
        KafkaFuture allFuture = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[0]);
        Assert.assertTrue((boolean)allFuture.isDone());
        Assert.assertFalse((boolean)allFuture.isCancelled());
        Assert.assertFalse((boolean)allFuture.isCompletedExceptionally());
        allFuture.get();
    }

    @Test(expected=TimeoutException.class)
    public void testFutureTimeoutWithZeroWait() throws Exception {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.get(0L, TimeUnit.MILLISECONDS);
    }

    private static class WaiterThread<T>
    extends Thread {
        private final KafkaFutureImpl<T> future;
        private final T expected;
        Throwable testException = null;

        WaiterThread(KafkaFutureImpl<T> future, T expected) {
            this.future = future;
            this.expected = expected;
        }

        @Override
        public void run() {
            try {
                Object value = this.future.get();
                Assert.assertEquals(this.expected, (Object)value);
            }
            catch (Throwable testException) {
                this.testException = testException;
            }
        }
    }

    private static class CompleterThread<T>
    extends Thread {
        private final KafkaFutureImpl<T> future;
        private final T value;
        Throwable testException = null;

        CompleterThread(KafkaFutureImpl<T> future, T value) {
            this.future = future;
            this.value = value;
        }

        @Override
        public void run() {
            try {
                try {
                    Thread.sleep(0L, 200);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.future.complete(this.value);
            }
            catch (Throwable testException) {
                this.testException = testException;
            }
        }
    }
}

