/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.HashSet;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ApiMessageType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ApiMessageTypeTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testFromApiKey() {
        for (ApiMessageType type : ApiMessageType.values()) {
            ApiMessageType type2 = ApiMessageType.fromApiKey(type.apiKey());
            Assert.assertEquals((Object)((Object)type2), (Object)((Object)type));
        }
    }

    @Test
    public void testInvalidFromApiKey() {
        try {
            ApiMessageType.fromApiKey((short)-1);
            Assert.fail((String)"expected to get an UnsupportedVersionException");
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            // empty catch block
        }
    }

    @Test
    public void testUniqueness() {
        HashSet<Short> ids = new HashSet<Short>();
        HashSet<String> requestNames = new HashSet<String>();
        HashSet<String> responseNames = new HashSet<String>();
        for (ApiMessageType type : ApiMessageType.values()) {
            Assert.assertFalse((String)("found two ApiMessageType objects with id " + type.apiKey()), (boolean)ids.contains(type.apiKey()));
            ids.add(type.apiKey());
            String requestName = type.newRequest().getClass().getSimpleName();
            Assert.assertFalse((String)("found two ApiMessageType objects with requestName " + requestName), (boolean)requestNames.contains(requestName));
            requestNames.add(requestName);
            String responseName = type.newResponse().getClass().getSimpleName();
            Assert.assertFalse((String)("found two ApiMessageType objects with responseName " + responseName), (boolean)responseNames.contains(responseName));
            responseNames.add(responseName);
        }
        Assert.assertEquals((long)ApiMessageType.values().length, (long)ids.size());
        Assert.assertEquals((long)ApiMessageType.values().length, (long)requestNames.size());
        Assert.assertEquals((long)ApiMessageType.values().length, (long)responseNames.size());
    }
}

