/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.File;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;

public class CertStores {
    public static final Set<String> KEYSTORE_PROPS = Utils.mkSet((Object[])new String[]{"ssl.keystore.location", "ssl.keystore.type", "ssl.keystore.password", "ssl.key.password"});
    public static final Set<String> TRUSTSTORE_PROPS = Utils.mkSet((Object[])new String[]{"ssl.truststore.location", "ssl.truststore.type", "ssl.truststore.password"});
    private final Map<String, Object> sslConfig;

    public CertStores(boolean server, String hostName) throws Exception {
        this(server, hostName, new TestSslUtils.CertificateBuilder());
    }

    public CertStores(boolean server, String commonName, String sanHostName) throws Exception {
        this(server, commonName, new TestSslUtils.CertificateBuilder().sanDnsName(sanHostName));
    }

    public CertStores(boolean server, String commonName, InetAddress hostAddress) throws Exception {
        this(server, commonName, new TestSslUtils.CertificateBuilder().sanIpAddress(hostAddress));
    }

    private CertStores(boolean server, String commonName, TestSslUtils.CertificateBuilder certBuilder) throws Exception {
        String name = server ? "server" : "client";
        Mode mode = server ? Mode.SERVER : Mode.CLIENT;
        File truststoreFile = File.createTempFile(name + "TS", ".jks");
        this.sslConfig = TestSslUtils.createSslConfig(!server, true, mode, truststoreFile, name, commonName, certBuilder);
    }

    public Map<String, Object> getTrustingConfig(CertStores truststoreConfig) {
        HashMap<String, Object> config = new HashMap<String, Object>(this.sslConfig);
        for (String propName : TRUSTSTORE_PROPS) {
            config.put(propName, truststoreConfig.sslConfig.get(propName));
        }
        return config;
    }

    public Map<String, Object> getUntrustingConfig() {
        return this.sslConfig;
    }

    public Map<String, Object> keyStoreProps() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String propName : KEYSTORE_PROPS) {
            props.put(propName, this.sslConfig.get(propName));
        }
        return props;
    }

    public Map<String, Object> trustStoreProps() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String propName : TRUSTSTORE_PROPS) {
            props.put(propName, this.sslConfig.get(propName));
        }
        return props;
    }
}

