/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.auth;

import java.net.InetAddress;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.PrincipalBuilder;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.security.kerberos.KerberosName;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultKafkaPrincipalBuilderTest {
    @Test
    public void testUseOldPrincipalBuilderForPlaintextIfProvided() throws Exception {
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class);
        Authenticator authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        PrincipalBuilder oldPrincipalBuilder = (PrincipalBuilder)Mockito.mock(PrincipalBuilder.class);
        Mockito.when((Object)oldPrincipalBuilder.buildPrincipal((TransportLayer)ArgumentMatchers.any(), (Authenticator)ArgumentMatchers.any())).thenReturn((Object)new DummyPrincipal("foo"));
        DefaultKafkaPrincipalBuilder builder = DefaultKafkaPrincipalBuilder.fromOldPrincipalBuilder((Authenticator)authenticator, (TransportLayer)transportLayer, (PrincipalBuilder)oldPrincipalBuilder, null);
        KafkaPrincipal principal = builder.build((AuthenticationContext)new PlaintextAuthenticationContext(InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name()));
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)"foo", (Object)principal.getName());
        builder.close();
        ((PrincipalBuilder)Mockito.verify((Object)oldPrincipalBuilder)).buildPrincipal(transportLayer, authenticator);
        ((PrincipalBuilder)Mockito.verify((Object)oldPrincipalBuilder)).close();
    }

    @Test
    public void testReturnAnonymousPrincipalForPlaintext() throws Exception {
        try (DefaultKafkaPrincipalBuilder builder = new DefaultKafkaPrincipalBuilder(null, null);){
            Assert.assertEquals((Object)KafkaPrincipal.ANONYMOUS, (Object)builder.build((AuthenticationContext)new PlaintextAuthenticationContext(InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name())));
        }
    }

    @Test
    public void testUseOldPrincipalBuilderForSslIfProvided() throws Exception {
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class);
        Authenticator authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        PrincipalBuilder oldPrincipalBuilder = (PrincipalBuilder)Mockito.mock(PrincipalBuilder.class);
        SSLSession session = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)oldPrincipalBuilder.buildPrincipal((TransportLayer)ArgumentMatchers.any(), (Authenticator)ArgumentMatchers.any())).thenReturn((Object)new DummyPrincipal("foo"));
        DefaultKafkaPrincipalBuilder builder = DefaultKafkaPrincipalBuilder.fromOldPrincipalBuilder((Authenticator)authenticator, (TransportLayer)transportLayer, (PrincipalBuilder)oldPrincipalBuilder, null);
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SslAuthenticationContext(session, InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name()));
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)"foo", (Object)principal.getName());
        builder.close();
        ((PrincipalBuilder)Mockito.verify((Object)oldPrincipalBuilder)).buildPrincipal(transportLayer, authenticator);
        ((PrincipalBuilder)Mockito.verify((Object)oldPrincipalBuilder)).close();
    }

    @Test
    public void testUseSessionPeerPrincipalForSsl() throws Exception {
        SSLSession session = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)session.getPeerPrincipal()).thenReturn((Object)new DummyPrincipal("foo"));
        DefaultKafkaPrincipalBuilder builder = new DefaultKafkaPrincipalBuilder(null, null);
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SslAuthenticationContext(session, InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name()));
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)"foo", (Object)principal.getName());
        builder.close();
        ((SSLSession)Mockito.verify((Object)session, (VerificationMode)Mockito.atLeastOnce())).getPeerPrincipal();
    }

    @Test
    public void testPrincipalIfSSLPeerIsNotAuthenticated() throws Exception {
        SSLSession session = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)session.getPeerPrincipal()).thenReturn((Object)KafkaPrincipal.ANONYMOUS);
        DefaultKafkaPrincipalBuilder builder = new DefaultKafkaPrincipalBuilder(null, null);
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SslAuthenticationContext(session, InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name()));
        Assert.assertEquals((Object)KafkaPrincipal.ANONYMOUS, (Object)principal);
        builder.close();
        ((SSLSession)Mockito.verify((Object)session, (VerificationMode)Mockito.atLeastOnce())).getPeerPrincipal();
    }

    @Test
    public void testPrincipalWithSslPrincipalMapper() throws Exception {
        SSLSession session = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)session.getPeerPrincipal()).thenReturn((Object)new X500Principal("CN=Duke, OU=ServiceUsers, O=Org, C=US")).thenReturn((Object)new X500Principal("CN=Duke, OU=SME, O=mycp, L=Fulton, ST=MD, C=US")).thenReturn((Object)new X500Principal("CN=duke, OU=JavaSoft, O=Sun Microsystems")).thenReturn((Object)new X500Principal("OU=JavaSoft, O=Sun Microsystems, C=US"));
        List<String> rules = Arrays.asList("RULE:^CN=(.*),OU=ServiceUsers.*$/$1/L", "RULE:^CN=(.*),OU=(.*),O=(.*),L=(.*),ST=(.*),C=(.*)$/$1@$2/L", "RULE:^.*[Cc][Nn]=([a-zA-Z0-9.]*).*$/$1/U", "DEFAULT");
        SslPrincipalMapper mapper = SslPrincipalMapper.fromRules(rules);
        DefaultKafkaPrincipalBuilder builder = new DefaultKafkaPrincipalBuilder(null, mapper);
        SslAuthenticationContext sslContext = new SslAuthenticationContext(session, InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name());
        KafkaPrincipal principal = builder.build((AuthenticationContext)sslContext);
        Assert.assertEquals((Object)"duke", (Object)principal.getName());
        principal = builder.build((AuthenticationContext)sslContext);
        Assert.assertEquals((Object)"duke@sme", (Object)principal.getName());
        principal = builder.build((AuthenticationContext)sslContext);
        Assert.assertEquals((Object)"DUKE", (Object)principal.getName());
        principal = builder.build((AuthenticationContext)sslContext);
        Assert.assertEquals((Object)"OU=JavaSoft,O=Sun Microsystems,C=US", (Object)principal.getName());
        builder.close();
        ((SSLSession)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)4))).getPeerPrincipal();
    }

    @Test
    public void testPrincipalBuilderScram() throws Exception {
        SaslServer server = (SaslServer)Mockito.mock(SaslServer.class);
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)ScramMechanism.SCRAM_SHA_256.mechanismName());
        Mockito.when((Object)server.getAuthorizationID()).thenReturn((Object)"foo");
        DefaultKafkaPrincipalBuilder builder = new DefaultKafkaPrincipalBuilder(null, null);
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SaslAuthenticationContext(server, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLocalHost(), SecurityProtocol.SASL_PLAINTEXT.name()));
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)"foo", (Object)principal.getName());
        builder.close();
        ((SaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((SaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getAuthorizationID();
    }

    @Test
    public void testPrincipalBuilderGssapi() throws Exception {
        SaslServer server = (SaslServer)Mockito.mock(SaslServer.class);
        KerberosShortNamer kerberosShortNamer = (KerberosShortNamer)Mockito.mock(KerberosShortNamer.class);
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"GSSAPI");
        Mockito.when((Object)server.getAuthorizationID()).thenReturn((Object)"foo/host@REALM.COM");
        Mockito.when((Object)kerberosShortNamer.shortName((KerberosName)ArgumentMatchers.any())).thenReturn((Object)"foo");
        DefaultKafkaPrincipalBuilder builder = new DefaultKafkaPrincipalBuilder(kerberosShortNamer, null);
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SaslAuthenticationContext(server, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLocalHost(), SecurityProtocol.SASL_PLAINTEXT.name()));
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)"foo", (Object)principal.getName());
        builder.close();
        ((SaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((SaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getAuthorizationID();
        ((KerberosShortNamer)Mockito.verify((Object)kerberosShortNamer, (VerificationMode)Mockito.atLeastOnce())).shortName((KerberosName)ArgumentMatchers.any());
    }

    private static class DummyPrincipal
    implements Principal {
        private final String name;

        private DummyPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

