/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WriteTxnMarkersRequestTest {
    private static long producerId = 10L;
    private static short producerEpoch = (short)2;
    private static int coordinatorEpoch = 1;
    private static TransactionResult result = TransactionResult.COMMIT;
    private static TopicPartition topicPartition = new TopicPartition("topic", 73);
    protected static int throttleTimeMs = 10;
    private static List<WriteTxnMarkersRequest.TxnMarkerEntry> markers;

    @BeforeEach
    public void setUp() {
        markers = Collections.singletonList(new WriteTxnMarkersRequest.TxnMarkerEntry(producerId, producerEpoch, coordinatorEpoch, result, Collections.singletonList(topicPartition)));
    }

    @Test
    public void testConstructor() {
        WriteTxnMarkersRequest.Builder builder = new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), markers);
        Iterator iterator = ApiKeys.WRITE_TXN_MARKERS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            WriteTxnMarkersRequest request = builder.build(version);
            Assertions.assertEquals((int)1, (int)request.markers().size());
            WriteTxnMarkersRequest.TxnMarkerEntry marker = (WriteTxnMarkersRequest.TxnMarkerEntry)request.markers().get(0);
            Assertions.assertEquals((long)producerId, (long)marker.producerId());
            Assertions.assertEquals((short)producerEpoch, (short)marker.producerEpoch());
            Assertions.assertEquals((int)coordinatorEpoch, (int)marker.coordinatorEpoch());
            Assertions.assertEquals((Object)result, (Object)marker.transactionResult());
            Assertions.assertEquals(Collections.singletonList(topicPartition), (Object)marker.partitions());
        }
    }

    @Test
    public void testGetErrorResponse() {
        WriteTxnMarkersRequest.Builder builder = new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), markers);
        Iterator iterator = ApiKeys.WRITE_TXN_MARKERS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            WriteTxnMarkersRequest request = builder.build(version);
            WriteTxnMarkersResponse errorResponse = request.getErrorResponse(throttleTimeMs, (Throwable)Errors.UNKNOWN_PRODUCER_ID.exception());
            Assertions.assertEquals(Collections.singletonMap(topicPartition, Errors.UNKNOWN_PRODUCER_ID), errorResponse.errorsByProducerId().get(producerId));
            Assertions.assertEquals(Collections.singletonMap(Errors.UNKNOWN_PRODUCER_ID, 1), (Object)errorResponse.errorCounts());
            Assertions.assertEquals((int)0, (int)errorResponse.throttleTimeMs());
        }
    }
}

