/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.SnapshotWriter;

public interface RaftClient<T>
extends Closeable {
    public void initialize() throws IOException;

    public void register(Listener<T> var1);

    public LeaderAndEpoch leaderAndEpoch();

    public Long scheduleAppend(int var1, List<T> var2);

    public Long scheduleAtomicAppend(int var1, List<T> var2);

    public CompletableFuture<Void> shutdown(int var1);

    public SnapshotWriter<T> createSnapshot(OffsetAndEpoch var1) throws IOException;

    public static interface Listener<T> {
        public void handleCommit(BatchReader<T> var1);

        default public void handleClaim(int epoch) {
        }

        default public void handleResign(int epoch) {
        }
    }
}

