/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.internals.AbstractSegments;
import org.apache.kafka.streams.state.internals.KeyValueSegment;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;

class KeyValueSegments
extends AbstractSegments<KeyValueSegment> {
    private final RocksDBMetricsRecorder metricsRecorder;

    KeyValueSegments(String name, String metricsScope, long retentionPeriod, long segmentInterval) {
        super(name, retentionPeriod, segmentInterval);
        this.metricsRecorder = new RocksDBMetricsRecorder(metricsScope, Thread.currentThread().getName(), name);
    }

    @Override
    public KeyValueSegment getOrCreateSegment(long segmentId, InternalProcessorContext context) {
        if (this.segments.containsKey(segmentId)) {
            return (KeyValueSegment)this.segments.get(segmentId);
        }
        KeyValueSegment newSegment = new KeyValueSegment(this.segmentName(segmentId), this.name, segmentId, this.metricsRecorder);
        if (this.segments.put(segmentId, newSegment) != null) {
            throw new IllegalStateException("KeyValueSegment already exists. Possible concurrent access.");
        }
        newSegment.openDB(context);
        return newSegment;
    }

    @Override
    public void openExisting(InternalProcessorContext context, long streamTime) {
        this.metricsRecorder.init(context.metrics(), context.taskId());
        super.openExisting(context, streamTime);
    }
}

