/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.agent;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.kafka.trogdor.agent.Agent;
import org.apache.kafka.trogdor.rest.AgentFaultsResponse;
import org.apache.kafka.trogdor.rest.AgentStatusResponse;
import org.apache.kafka.trogdor.rest.CreateAgentFaultRequest;
import org.apache.kafka.trogdor.rest.Empty;

@Path(value="/agent")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AgentRestResource {
    private final AtomicReference<Agent> agent = new AtomicReference<Object>(null);
    @Context
    private ServletContext context;

    public void setAgent(Agent myAgent) {
        this.agent.set(myAgent);
    }

    @GET
    @Path(value="/status")
    public AgentStatusResponse getStatus() throws Throwable {
        return new AgentStatusResponse(this.agent().startTimeMs());
    }

    @GET
    @Path(value="/faults")
    public AgentFaultsResponse getAgentFaults() throws Throwable {
        return this.agent().faults();
    }

    @PUT
    @Path(value="/fault")
    public Empty putAgentFault(CreateAgentFaultRequest request) throws Throwable {
        this.agent().createFault(request);
        return Empty.INSTANCE;
    }

    @PUT
    @Path(value="/shutdown")
    public Empty shutdown() throws Throwable {
        this.agent().beginShutdown();
        return Empty.INSTANCE;
    }

    private Agent agent() {
        Agent myAgent = this.agent.get();
        if (myAgent == null) {
            throw new RuntimeException("AgentRestResource has not been initialized yet.");
        }
        return myAgent;
    }
}

