/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.coordinator;

import com.fasterxml.jackson.core.type.TypeReference;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.rest.CoordinatorFaultsResponse;
import org.apache.kafka.trogdor.rest.CoordinatorStatusResponse;
import org.apache.kafka.trogdor.rest.CreateCoordinatorFaultRequest;
import org.apache.kafka.trogdor.rest.Empty;
import org.apache.kafka.trogdor.rest.JsonRestServer;

public class CoordinatorClient {
    private final String target;

    public CoordinatorClient(String host, int port) {
        this(String.format("%s:%d", host, port));
    }

    public CoordinatorClient(String target) {
        this.target = target;
    }

    private String url(String suffix) {
        return String.format("http://%s%s", this.target, suffix);
    }

    public CoordinatorStatusResponse getStatus() throws Exception {
        JsonRestServer.HttpResponse<CoordinatorStatusResponse> resp = JsonRestServer.httpRequest(this.url("/coordinator/status"), "GET", null, new TypeReference<CoordinatorStatusResponse>(){});
        return resp.body();
    }

    public CoordinatorFaultsResponse getFaults() throws Exception {
        JsonRestServer.HttpResponse<CoordinatorFaultsResponse> resp = JsonRestServer.httpRequest(this.url("/coordinator/faults"), "GET", null, new TypeReference<CoordinatorFaultsResponse>(){});
        return resp.body();
    }

    public void putFault(CreateCoordinatorFaultRequest request) throws Exception {
        JsonRestServer.HttpResponse<CreateCoordinatorFaultRequest> resp = JsonRestServer.httpRequest(this.url("/coordinator/fault"), "PUT", request, new TypeReference<CreateCoordinatorFaultRequest>(){});
        resp.body();
    }

    public void shutdown() throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.url("/coordinator/shutdown"), "PUT", null, new TypeReference<Empty>(){});
        resp.body();
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"trogdor-coordinator-client").defaultHelp(true).description("The Trogdor fault injection coordinator client.");
        parser.addArgument(new String[]{"target"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("target").metavar(new String[]{"TARGET"}).help("A colon-separated host and port pair.  For example, example.com:8889");
        MutuallyExclusiveGroup actions = parser.addMutuallyExclusiveGroup();
        actions.addArgument(new String[]{"--status"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("status").help("Get coordinator status.");
        actions.addArgument(new String[]{"--get-faults"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("get_faults").help("Get coordinator faults.");
        actions.addArgument(new String[]{"--create-fault"}).action((ArgumentAction)Arguments.store()).type(String.class).dest("create_fault").metavar(new String[]{"FAULT_JSON"}).help("Create a new fault.");
        actions.addArgument(new String[]{"--shutdown"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("shutdown").help("Trigger coordinator shutdown");
        Namespace res = null;
        try {
            res = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit((int)0);
            }
            parser.handleError(e);
            Exit.exit((int)1);
        }
        String target = res.getString("target");
        CoordinatorClient client = new CoordinatorClient(target);
        if (res.getBoolean("status").booleanValue()) {
            System.out.println("Got coordinator status: " + JsonUtil.toPrettyJsonString(client.getStatus()));
        } else if (res.getBoolean("get_faults").booleanValue()) {
            System.out.println("Got coordinator faults: " + JsonUtil.toPrettyJsonString(client.getFaults()));
        } else if (res.getString("create_fault") != null) {
            client.putFault((CreateCoordinatorFaultRequest)JsonUtil.JSON_SERDE.readValue(res.getString("create_fault"), CreateCoordinatorFaultRequest.class));
            System.out.println("Created fault.");
        } else if (res.getBoolean("shutdown").booleanValue()) {
            client.shutdown();
            System.out.println("Sent shutdown request.");
        } else {
            System.out.println("You must choose an action. Type --help for help.");
            Exit.exit((int)1);
        }
    }
}

