/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import java.util.Objects;
import java.util.Set;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.Topology;
import org.apache.kafka.trogdor.fault.DoneState;
import org.apache.kafka.trogdor.fault.Fault;
import org.apache.kafka.trogdor.fault.FaultSpec;
import org.apache.kafka.trogdor.fault.FaultState;
import org.apache.kafka.trogdor.fault.PendingState;
import org.apache.kafka.trogdor.fault.RunningState;

public abstract class AbstractFault
implements Fault {
    private final String id;
    private final FaultSpec spec;
    private FaultState state;

    public AbstractFault(String id, FaultSpec spec) {
        this.id = id;
        this.spec = spec;
        this.state = new PendingState();
    }

    @Override
    public final String id() {
        return this.id;
    }

    @Override
    public final FaultSpec spec() {
        return this.spec;
    }

    @Override
    public synchronized FaultState state() {
        return this.state;
    }

    @Override
    public synchronized void setState(FaultState state) {
        this.state = state;
    }

    @Override
    public final void activate(long now, Platform platform) throws Exception {
        try {
            this.handleActivation(now, platform);
            this.setState(new RunningState(now));
        }
        catch (Exception e) {
            this.setState(new DoneState(now, e.getMessage()));
            throw e;
        }
    }

    protected abstract void handleActivation(long var1, Platform var3) throws Exception;

    @Override
    public final void deactivate(long now, Platform platform) throws Exception {
        try {
            this.handleDeactivation(now, platform);
            this.setState(new DoneState(now, ""));
        }
        catch (Exception e) {
            this.setState(new DoneState(now, e.getMessage()));
            throw e;
        }
    }

    protected abstract void handleDeactivation(long var1, Platform var3) throws Exception;

    @Override
    public abstract Set<String> targetNodes(Topology var1);

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public final int hashCode() {
        return Objects.hashCode(this.toString());
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(id=" + this.id + ", spec=" + JsonUtil.toJsonString(this.spec) + ", state=" + JsonUtil.toJsonString(this.state()) + ")";
    }
}

