/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.Topology;
import org.apache.kafka.trogdor.fault.AbstractFault;
import org.apache.kafka.trogdor.fault.FaultSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpFault
extends AbstractFault {
    private static final Logger log = LoggerFactory.getLogger(NoOpFault.class);

    public NoOpFault(String id, FaultSpec spec) {
        super(id, spec);
    }

    @Override
    protected void handleActivation(long now, Platform platform) throws Exception {
        log.info("Activating NoOpFault...");
    }

    @Override
    protected void handleDeactivation(long now, Platform platform) throws Exception {
        log.info("Deactivating NoOpFault...");
    }

    @Override
    public Set<String> targetNodes(Topology topology) {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry entry : topology.nodes().entrySet()) {
            if (Node.Util.getTrogdorAgentPort((Node)entry.getValue()) <= 0) continue;
            set.add((String)entry.getKey());
        }
        return set;
    }
}

