/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.cluster.Broker;
import kafka.common.BrokerNotAvailableException;
import kafka.common.KafkaException;
import kafka.utils.Json$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Broker$
implements Serializable {
    public static final Broker$ MODULE$;

    static {
        new Broker$();
    }

    public Broker createBroker(int n, String string) {
        if (string == null) {
            throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %s does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
        }
        try {
            Option<Object> option = Json$.MODULE$.parseFull(string);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object object = some.x();
                Map map = (Map)object;
                String string2 = (String)map.get((Object)"host").get();
                int n2 = BoxesRunTime.unboxToInt((Object)map.get((Object)"port").get());
                Broker broker = new Broker(n, string2, n2);
                return broker;
            }
            None$ none$ = None$.MODULE$;
            Option<Object> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %d does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
            }
            throw new MatchError(option);
        }
        catch (Throwable throwable) {
            throw new KafkaException(new StringBuilder().append((Object)"Failed to parse the broker info from zookeeper: ").append((Object)string).toString(), throwable);
        }
    }

    public Broker readFrom(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        String string = ApiUtils$.MODULE$.readShortString(byteBuffer);
        int n2 = byteBuffer.getInt();
        return new Broker(n, string, n2);
    }

    public Broker apply(int n, String string, int n2) {
        return new Broker(n, string, n2);
    }

    public Option<Tuple3<Object, String, Object>> unapply(Broker broker) {
        return broker == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)broker.id()), (Object)broker.host(), (Object)BoxesRunTime.boxToInteger((int)broker.port())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Broker$() {
        MODULE$ = this;
    }
}

