/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}u!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+GO\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKR\u001c\"!\u0003\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0012\u0002\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0003\u0017\u0013\u0011%q#\u0001\u0004de\u0016\fG/\u001a\u000b\u00051\u0001b\u0013\u0007\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005\u0019a.[8\u000b\u0003u\tAA[1wC&\u0011qD\u0007\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B\u0011\u0016\u0001\u0004\u0011\u0013!D8gMN,GoQ8v]R,'\u000f\u0005\u0002$U5\tAE\u0003\u0002&M\u00051\u0011\r^8nS\u000eT!a\n\u0015\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002*9\u0005!Q\u000f^5m\u0013\tYCE\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDQ!L\u000bA\u00029\n\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\u0005!y\u0013B\u0001\u0019\u0003\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\rC\u00033+\u0001\u00071'\u0001\u0005nKN\u001c\u0018mZ3t!\riAGN\u0005\u0003k9\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\tAq'\u0003\u00029\u0005\t9Q*Z:tC\u001e,\u0007\"\u0002\u001e\n\t\u0003Y\u0014A\u00033fG>l\u0007O]3tgR\u0019A(!%\u0011\u0005!id\u0001\u0002\u0006\u0003\u0001y\u001a2!P C!\tA\u0001)\u0003\u0002B\u0005\tQQ*Z:tC\u001e,7+\u001a;\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015#\u0011!B;uS2\u001c\u0018BA$E\u0005\u001daunZ4j]\u001eD\u0001\"S\u001f\u0003\u0006\u0004%\tAS\u0001\u0007EV4g-\u001a:\u0016\u0003aA\u0001\u0002T\u001f\u0003\u0002\u0003\u0006I\u0001G\u0001\bEV4g-\u001a:!Q\tYe\n\u0005\u0002P%6\t\u0001K\u0003\u0002R\u001d\u0005)!-Z1og&\u00111\u000b\u0015\u0002\r\u0005\u0016\fg\u000e\u0015:pa\u0016\u0014H/\u001f\u0005\u0006+v\"\tAV\u0001\nO\u0016$()\u001e4gKJ$\u0012\u0001\u0007\u0005\u0006'u\"\t\u0001\u0017\u000b\u0003yeCQ!S,A\u0002aAqaW\u001fA\u0002\u0013%A,A\u000btQ\u0006dGn\\<WC2LGMQ=uK\u000e{WO\u001c;\u0016\u0003u\u0003\"!\u00040\n\u0005}s!aA%oi\"9\u0011-\u0010a\u0001\n\u0013\u0011\u0017!G:iC2dwn\u001e,bY&$')\u001f;f\u0007>,h\u000e^0%KF$\"a\u00194\u0011\u00055!\u0017BA3\u000f\u0005\u0011)f.\u001b;\t\u000f\u001d\u0004\u0017\u0011!a\u0001;\u0006\u0019\u0001\u0010J\u0019\t\r%l\u0004\u0015)\u0003^\u0003Y\u0019\b.\u00197m_^4\u0016\r\\5e\u0005f$XmQ8v]R\u0004\u0003\"B\n>\t\u0003YGc\u0001\u001fm[\")QF\u001ba\u0001]!)!G\u001ba\u0001g!)1#\u0010C\u0001_R!A\b]9s\u0011\u0015ic\u000e1\u0001/\u0011\u0015\tc\u000e1\u0001#\u0011\u0015\u0011d\u000e1\u00014\u0011\u0015\u0019R\b\"\u0001u)\taT\u000fC\u00033g\u0002\u00071\u0007C\u0003x{\u0011%A,A\ttQ\u0006dGn\\<WC2LGMQ=uKNDQ!_\u001f\u0005\u0002i\fqa\u001e:ji\u0016$v\u000e\u0006\u0004^w\u0006\u001d\u0011\u0011\u0003\u0005\u0006yb\u0004\r!`\u0001\bG\"\fgN\\3m!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001\u000e\u0002\u0011\rD\u0017M\u001c8fYNL1!!\u0002\u0000\u0005Q9\u0015\r\u001e5fe&twMQ=uK\u000eC\u0017M\u001c8fY\"9\u0011\u0011\u0002=A\u0002\u0005-\u0011AB8gMN,G\u000fE\u0002\u000e\u0003\u001bI1!a\u0004\u000f\u0005\u0011auN\\4\t\r\u0005M\u0001\u00101\u0001^\u0003\u0011\u0019\u0018N_3\t\u000f\u0005]Q\b\"\u0011\u0002\u001a\u0005A\u0011\u000e^3sCR|'/\u0006\u0002\u0002\u001cA1\u0011QDA\u0017\u0003gqA!a\b\u0002*9!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&\u0019\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0007\u0005-b\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0012\u0011\u0007\u0002\t\u0013R,'/\u0019;pe*\u0019\u00111\u0006\b\u0011\u0007!\t)$C\u0002\u00028\t\u0011\u0001#T3tg\u0006<W-\u00118e\u001f\u001a47/\u001a;\t\u000f\u0005mR\b\"\u0001\u0002\u001a\u0005y1\u000f[1mY><\u0018\n^3sCR|'\u000fC\u0004\u0002@u\"I!!\u0011\u0002!%tG/\u001a:oC2LE/\u001a:bi>\u0014H\u0003BA\u000e\u0003\u0007B!\"!\u0012\u0002>A\u0005\t\u0019AA$\u0003%I7o\u00155bY2|w\u000fE\u0002\u000e\u0003\u0013J1!a\u0013\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u0014>\t\u0003!\u0011\u0011K\u0001\u000eCN\u001c\u0018n\u001a8PM\u001a\u001cX\r^:\u0015\u000bq\n\u0019&!\u0016\t\r\u0005\ni\u00051\u0001#\u0011\u001d\t9&!\u0014A\u00029\nQaY8eK\u000eDa!a\u0017>\t\u0003a\u0016aC:ju\u0016LeNQ=uKNDa!a\u0018>\t\u0003a\u0016A\u0003<bY&$')\u001f;fg\"9\u00111M\u001f\u0005B\u0005\u0015\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002H\u0005\u001d\u0004\u0002CA5\u0003C\u0002\r!a\u001b\u0002\u000b=$\b.\u001a:\u0011\u00075\ti'C\u0002\u0002p9\u00111!\u00118z\u0011\u001d\t\u0019(\u0010C!\u0003k\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002;\"I\u0011\u0011P\u001f\u0012\u0002\u0013%\u00111P\u0001\u001bS:$XM\u001d8bY&#XM]1u_J$C-\u001a4bk2$H%M\u000b\u0003\u0003{RC!a\u0012\u0002\u0000-\u0012\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bi)\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003%)hn\u00195fG.,GMC\u0002\u0002\f:\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty)!\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0003\u0004s\u0001\u0007a\u0007C\u0004\u0002\u0016&!I!a&\u0002\u0019]\u0014\u0018\u000e^3NKN\u001c\u0018mZ3\u0015\u000f\r\fI*a'\u0002\u001e\"1\u0011*a%A\u0002aAaaAAJ\u0001\u00041\u0004\u0002CA\u0005\u0003'\u0003\r!a\u0003")
public class ByteBufferMessageSet
extends MessageSet
implements Logging {
    private final ByteBuffer buffer;
    private int shallowValidByteCount;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static ByteBufferMessageSet decompress(Message message) {
        return ByteBufferMessageSet$.MODULE$.decompress(message);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ByteBufferMessageSet byteBufferMessageSet = this;
        synchronized (byteBufferMessageSet) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    private int shallowValidByteCount() {
        return this.shallowValidByteCount;
    }

    private void shallowValidByteCount_$eq(int n) {
        this.shallowValidByteCount = n;
    }

    private int shallowValidBytes() {
        if (this.shallowValidByteCount() < 0) {
            int n = 0;
            Iterator<MessageAndOffset> iterator = this.kafka$message$ByteBufferMessageSet$$internalIterator(true);
            while (iterator.hasNext()) {
                MessageAndOffset messageAndOffset = (MessageAndOffset)iterator.next();
                n += MessageSet$.MODULE$.entrySize(messageAndOffset.message());
            }
            this.shallowValidByteCount_$eq(n);
        }
        return this.shallowValidByteCount();
    }

    @Override
    public int writeTo(GatheringByteChannel gatheringByteChannel, long l, int n) {
        int n2;
        ((Buffer)this.buffer()).mark();
        for (n2 = 0; n2 < this.sizeInBytes(); n2 += gatheringByteChannel.write(this.buffer())) {
        }
        ((Buffer)this.buffer()).reset();
        return n2;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.kafka$message$ByteBufferMessageSet$$internalIterator(this.kafka$message$ByteBufferMessageSet$$internalIterator$default$1());
    }

    public Iterator<MessageAndOffset> shallowIterator() {
        return this.kafka$message$ByteBufferMessageSet$$internalIterator(true);
    }

    public Iterator<MessageAndOffset> kafka$message$ByteBufferMessageSet$$internalIterator(boolean bl) {
        return new IteratorTemplate<MessageAndOffset>(this, bl){
            private ByteBuffer topIter;
            private Iterator<MessageAndOffset> innerIter;
            private final boolean isShallow$1;

            private ByteBuffer topIter() {
                return this.topIter;
            }

            private void topIter_$eq(ByteBuffer byteBuffer) {
                this.topIter = byteBuffer;
            }

            private Iterator<MessageAndOffset> innerIter() {
                return this.innerIter;
            }

            private void innerIter_$eq(Iterator<MessageAndOffset> iterator) {
                this.innerIter = iterator;
            }

            private boolean innerDone() {
                return this.innerIter() == null || !this.innerIter().hasNext();
            }

            private MessageAndOffset makeNextOuter() {
                MessageAndOffset messageAndOffset;
                if (this.topIter().remaining() < 12) {
                    return (MessageAndOffset)this.allDone();
                }
                long l = this.topIter().getLong();
                int n = this.topIter().getInt();
                if (n < Message$.MODULE$.MinHeaderSize()) {
                    throw new InvalidMessageException(new StringBuilder().append((Object)"Message found with corrupt size (").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)")").toString());
                }
                if (this.topIter().remaining() < n) {
                    return (MessageAndOffset)this.allDone();
                }
                ByteBuffer byteBuffer = this.topIter().slice();
                ((Buffer)byteBuffer).limit(n);
                ((Buffer)this.topIter()).position(this.topIter().position() + n);
                Message message = new Message(byteBuffer);
                if (this.isShallow$1) {
                    messageAndOffset = new MessageAndOffset(message, l);
                } else {
                    MessageAndOffset messageAndOffset2;
                    CompressionCodec compressionCodec = message.compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    if (!(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null)) {
                        this.innerIter_$eq(null);
                        messageAndOffset2 = new MessageAndOffset(message, l);
                    } else {
                        ByteBufferMessageSet byteBufferMessageSet = ByteBufferMessageSet$.MODULE$.decompress(message);
                        boolean bl = byteBufferMessageSet.kafka$message$ByteBufferMessageSet$$internalIterator$default$1();
                        this.innerIter_$eq(byteBufferMessageSet.kafka$message$ByteBufferMessageSet$$internalIterator(bl));
                        if (!this.innerIter().hasNext()) {
                            this.innerIter_$eq(null);
                        }
                        messageAndOffset2 = this.makeNext();
                    }
                    messageAndOffset = messageAndOffset2;
                }
                return messageAndOffset;
            }

            public MessageAndOffset makeNext() {
                return this.isShallow$1 ? this.makeNextOuter() : (this.innerDone() ? this.makeNextOuter() : (MessageAndOffset)this.innerIter().next());
            }
            {
                this.isShallow$1 = bl;
                this.topIter = byteBufferMessageSet.buffer().slice();
                this.innerIter = null;
            }
        };
    }

    public boolean kafka$message$ByteBufferMessageSet$$internalIterator$default$1() {
        return false;
    }

    public ByteBufferMessageSet assignOffsets(AtomicLong atomicLong, CompressionCodec compressionCodec) {
        ByteBufferMessageSet byteBufferMessageSet;
        CompressionCodec compressionCodec2 = compressionCodec;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
            ((Buffer)this.buffer()).mark();
            for (int i = 0; i < this.sizeInBytes() - MessageSet$.MODULE$.LogOverhead(); i += MessageSet$.MODULE$.LogOverhead() + this.buffer().getInt()) {
                ((Buffer)this.buffer()).position(i);
                this.buffer().putLong(atomicLong.getAndIncrement());
            }
            ((Buffer)this.buffer()).reset();
            byteBufferMessageSet = this;
        } else {
            Iterator iterator = this.kafka$message$ByteBufferMessageSet$$internalIterator(false).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Message apply(MessageAndOffset messageAndOffset) {
                    return messageAndOffset.message();
                }
            });
            byteBufferMessageSet = new ByteBufferMessageSet(compressionCodec, atomicLong, (Seq<Message>)iterator.toBuffer());
        }
        return byteBufferMessageSet;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer().limit();
    }

    public int validBytes() {
        return this.shallowValidBytes();
    }

    public boolean equals(Object object) {
        boolean bl;
        Object object2 = object;
        if (object2 instanceof ByteBufferMessageSet) {
            ByteBufferMessageSet byteBufferMessageSet = (ByteBufferMessageSet)object2;
            bl = this.buffer().equals(byteBufferMessageSet.buffer());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.buffer().hashCode();
    }

    public ByteBuffer getBuffer() {
        return this.buffer();
    }

    public ByteBufferMessageSet(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        Logging$class.$init$(this);
        this.shallowValidByteCount = -1;
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, Seq<Message> seq) {
        this(ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(new AtomicLong(0L), compressionCodec, seq));
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, AtomicLong atomicLong, Seq<Message> seq) {
        this(ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(atomicLong, compressionCodec, seq));
    }

    public ByteBufferMessageSet(Seq<Message> seq) {
        this(NoCompressionCodec$.MODULE$, new AtomicLong(0L), seq);
    }
}

