/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.common.QueueFullException;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.producer.KeyedMessage;
import kafka.producer.Partitioner;
import kafka.producer.Producer$;
import kafka.producer.ProducerClosedException;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.ProducerTopicStats;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.DefaultEventHandler$;
import kafka.producer.async.EventHandler;
import kafka.producer.async.ProducerSendThread;
import kafka.serializer.Encoder;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0002\u0015:pIV\u001cWM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001Qc\u0001\u0005*gM\u0019\u0001!C\b\u0011\u0005)iQ\"A\u0006\u000b\u00031\tQa]2bY\u0006L!AD\u0006\u0003\r\u0005s\u0017PU3g!\t\u00012#D\u0001\u0012\u0015\t\u0011B!A\u0003vi&d7/\u0003\u0002\u0015#\t9Aj\\4hS:<\u0007\u0002\u0003\f\u0001\u0005\u000b\u0007I\u0011A\f\u0002\r\r|gNZ5h+\u0005A\u0002CA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u00059\u0001&o\u001c3vG\u0016\u00148i\u001c8gS\u001eD\u0001\"\b\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\bG>tg-[4!\u0011!y\u0002A!b\u0001\n\u0013\u0001\u0013\u0001D3wK:$\b*\u00198eY\u0016\u0014X#A\u0011\u0011\t\t*sEM\u0007\u0002G)\u0011AEA\u0001\u0006CNLhnY\u0005\u0003M\r\u0012A\"\u0012<f]RD\u0015M\u001c3mKJ\u0004\"\u0001K\u0015\r\u0001\u0011)!\u0006\u0001b\u0001W\t\t1*\u0005\u0002-_A\u0011!\"L\u0005\u0003]-\u0011qAT8uQ&tw\r\u0005\u0002\u000ba%\u0011\u0011g\u0003\u0002\u0004\u0003:L\bC\u0001\u00154\t\u0015!\u0004A1\u0001,\u0005\u00051\u0006\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u001b\u00154XM\u001c;IC:$G.\u001a:!\u0011\u0015A\u0004\u0001\"\u0001:\u0003\u0019a\u0014N\\5u}Q\u0019!h\u000f\u001f\u0011\te\u0001qE\r\u0005\u0006-]\u0002\r\u0001\u0007\u0005\u0006?]\u0002\r!\t\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u0003-A\u0017m]*ikR$wn\u001e8\u0016\u0003\u0001\u0003\"!\u0011&\u000e\u0003\tS!a\u0011#\u0002\r\u0005$x.\\5d\u0015\t)e)\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0012%\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0013\u0006!!.\u0019<b\u0013\tY%IA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002!\u0002\u0019!\f7o\u00155vi\u0012|wO\u001c\u0011\t\u000f=\u0003!\u0019!C\u0005!\u0006)\u0011/^3vKV\t\u0011\u000bE\u0002S'Vk\u0011\u0001R\u0005\u0003)\u0012\u00131\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016\u0004B!\u0007,(e%\u0011qK\u0001\u0002\r\u0017\u0016LX\rZ'fgN\fw-\u001a\u0005\u00073\u0002\u0001\u000b\u0011B)\u0002\rE,X-^3!\u0011\u001dY\u0006\u00011A\u0005\nq\u000bAa]=oGV\tQ\f\u0005\u0002\u000b=&\u0011ql\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0007\u00011A\u0005\n\t\f\u0001b]=oG~#S-\u001d\u000b\u0003G\u001a\u0004\"A\u00033\n\u0005\u0015\\!\u0001B+oSRDqa\u001a1\u0002\u0002\u0003\u0007Q,A\u0002yIEBa!\u001b\u0001!B\u0013i\u0016!B:z]\u000e\u0004\u0003bB6\u0001\u0001\u0004%I\u0001\\\u0001\u0013aJ|G-^2feN+g\u000e\u001a+ie\u0016\fG-F\u0001n!\u0011\u0011cn\n\u001a\n\u0005=\u001c#A\u0005)s_\u0012,8-\u001a:TK:$G\u000b\u001b:fC\u0012Dq!\u001d\u0001A\u0002\u0013%!/\u0001\fqe>$WoY3s'\u0016tG\r\u00165sK\u0006$w\fJ3r)\t\u00197\u000fC\u0004ha\u0006\u0005\t\u0019A7\t\rU\u0004\u0001\u0015)\u0003n\u0003M\u0001(o\u001c3vG\u0016\u00148+\u001a8e)\"\u0014X-\u00193!\u0011\u001d9\bA1A\u0005\na\fA\u0001\\8dWV\t\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}\u0011\u0006!A.\u00198h\u0013\tq8P\u0001\u0004PE*,7\r\u001e\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003z\u0003\u0015awnY6!\u0011%\t)\u0001\u0001b\u0001\n\u0013\t9!\u0001\nqe>$WoY3s)>\u0004\u0018nY*uCR\u001cXCAA\u0005!\rI\u00121B\u0005\u0004\u0003\u001b\u0011!A\u0005)s_\u0012,8-\u001a:U_BL7m\u0015;biND\u0001\"!\u0005\u0001A\u0003%\u0011\u0011B\u0001\u0014aJ|G-^2feR{\u0007/[2Ti\u0006$8\u000f\t\u0005\u0007q\u0001!\t!!\u0006\u0015\u0007i\n9\u0002\u0003\u0004\u0017\u0003'\u0001\r\u0001\u0007\u0005\b\u00037\u0001A\u0011AA\u000f\u0003\u0011\u0019XM\u001c3\u0015\u0007\r\fy\u0002\u0003\u0005\u0002\"\u0005e\u0001\u0019AA\u0012\u0003!iWm]:bO\u0016\u001c\b\u0003\u0002\u0006\u0002&UK1!a\n\f\u0005)a$/\u001a9fCR,GM\u0010\u0005\b\u0003W\u0001A\u0011BA\u0017\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0007\r\fy\u0003\u0003\u0005\u0002\"\u0005%\u0002\u0019AA\u0019!\u0015\t\u0019$a\u0011V\u001d\u0011\t)$a\u0010\u000f\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f\u0007\u0003\u0019a$o\\8u}%\tA\"C\u0002\u0002B-\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002F\u0005\u001d#aA*fc*\u0019\u0011\u0011I\u0006\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N\u0005I\u0011m]=oGN+g\u000e\u001a\u000b\u0004G\u0006=\u0003\u0002CA\u0011\u0003\u0013\u0002\r!!\r\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V\u0005)1\r\\8tKR\t1\r")
public class Producer<K, V>
implements Logging {
    private final ProducerConfig config;
    private final EventHandler<K, V> eventHandler;
    private final AtomicBoolean hasShutdown;
    private final LinkedBlockingQueue<KeyedMessage<K, V>> kafka$producer$Producer$$queue;
    private boolean sync;
    private ProducerSendThread<K, V> producerSendThread;
    private final Object lock;
    private final ProducerTopicStats kafka$producer$Producer$$producerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Producer producer = this;
        synchronized (producer) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public ProducerConfig config() {
        return this.config;
    }

    private EventHandler<K, V> eventHandler() {
        return this.eventHandler;
    }

    private AtomicBoolean hasShutdown() {
        return this.hasShutdown;
    }

    public LinkedBlockingQueue<KeyedMessage<K, V>> kafka$producer$Producer$$queue() {
        return this.kafka$producer$Producer$$queue;
    }

    private boolean sync() {
        return this.sync;
    }

    private void sync_$eq(boolean bl) {
        this.sync = bl;
    }

    private ProducerSendThread<K, V> producerSendThread() {
        return this.producerSendThread;
    }

    private void producerSendThread_$eq(ProducerSendThread<K, V> producerSendThread) {
        this.producerSendThread = producerSendThread;
    }

    private Object lock() {
        return this.lock;
    }

    public ProducerTopicStats kafka$producer$Producer$$producerTopicStats() {
        return this.kafka$producer$Producer$$producerTopicStats;
    }

    public void send(Seq<KeyedMessage<K, V>> seq) {
        Object object = this.lock();
        synchronized (object) {
            boolean bl;
            block9: {
                block8: {
                    block7: {
                        if (this.hasShutdown().get()) {
                            throw new ProducerClosedException();
                        }
                        this.recordStats(seq);
                        bl = this.sync();
                        if (!bl) break block7;
                        this.eventHandler().handle(seq);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    if (bl) break block9;
                    this.asyncSend(seq);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
    }

    private void recordStats(Seq<KeyedMessage<K, V>> seq) {
        seq.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Producer $outer;

            public final void apply(KeyedMessage<K, V> keyedMessage) {
                this.$outer.kafka$producer$Producer$$producerTopicStats().getProducerTopicStats(keyedMessage.topic()).messageRate().mark();
                this.$outer.kafka$producer$Producer$$producerTopicStats().getProducerAllTopicsStats().messageRate().mark();
            }
            {
                if (producer == null) {
                    throw new NullPointerException();
                }
                this.$outer = producer;
            }
        });
    }

    private void asyncSend(Seq<KeyedMessage<K, V>> seq) {
        seq.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Producer $outer;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void apply(KeyedMessage<K, V> keyedMessage) {
                boolean bl;
                int n = this.$outer.config().queueEnqueueTimeoutMs();
                switch (n) {
                    default: {
                        try {
                            boolean bl3;
                            boolean bl4;
                            boolean bl2 = bl4 = this.$outer.config().queueEnqueueTimeoutMs() < 0;
                            if (bl4) {
                                this.$outer.kafka$producer$Producer$$queue().put(keyedMessage);
                                bl3 = true;
                            } else {
                                bl3 = this.$outer.kafka$producer$Producer$$queue().offer(keyedMessage, this.$outer.config().queueEnqueueTimeoutMs(), TimeUnit.MILLISECONDS);
                            }
                            bl = bl3;
                        }
                        catch (InterruptedException interruptedException) {
                            bl = false;
                        }
                        break;
                    }
                    case 0: {
                        bl = this.$outer.kafka$producer$Producer$$queue().offer(keyedMessage);
                        break;
                    }
                }
                boolean bl3 = bl;
                if (bl3) {
                    this.$outer.trace((Function0<String>)new Serializable(this, keyedMessage){
                        public static final long serialVersionUID = 0L;
                        private final KeyedMessage message$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Added to send queue an event: ").append((Object)this.message$1.toString()).toString();
                        }
                        {
                            this.message$1 = var2_2;
                        }
                    });
                    this.$outer.trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$asyncSend$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Remaining queue size: ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$producer$Producer$$anonfun$$$outer().kafka$producer$Producer$$queue().remainingCapacity())).toString();
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                        }
                    });
                    return;
                }
                this.$outer.kafka$producer$Producer$$producerTopicStats().getProducerTopicStats(keyedMessage.topic()).droppedMessageRate().mark();
                this.$outer.kafka$producer$Producer$$producerTopicStats().getProducerAllTopicsStats().droppedMessageRate().mark();
                throw new QueueFullException(new StringBuilder().append((Object)"Event queue is full of unsent messages, could not send event: ").append((Object)keyedMessage.toString()).toString());
            }

            public /* synthetic */ Producer kafka$producer$Producer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if (producer == null) {
                    throw new NullPointerException();
                }
                this.$outer = producer;
            }
        });
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            boolean bl = this.hasShutdown().compareAndSet(false, true);
            if (bl) {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Shutting down producer";
                    }
                });
                if (this.producerSendThread() != null) {
                    this.producerSendThread().shutdown();
                }
                this.eventHandler().close();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public Producer(ProducerConfig producerConfig, EventHandler<K, V> eventHandler) {
        String string;
        block4: {
            block3: {
                block2: {
                    this.config = producerConfig;
                    this.eventHandler = eventHandler;
                    Logging$class.$init$(this);
                    this.hasShutdown = new AtomicBoolean(false);
                    this.kafka$producer$Producer$$queue = new LinkedBlockingQueue(producerConfig.queueBufferingMaxMessages());
                    this.sync = true;
                    this.producerSendThread = null;
                    this.lock = new Object();
                    String string2 = string = producerConfig.producerType();
                    if ("sync" != null ? !"sync".equals(string2) : string2 != null) break block2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                String string3 = string;
                if ("async" != null ? !"async".equals(string3) : string3 != null) break block4;
                this.sync_$eq(false);
                this.producerSendThread_$eq(new ProducerSendThread<K, V>(new StringBuilder().append((Object)"ProducerSendThread-").append((Object)producerConfig.clientId()).toString(), this.kafka$producer$Producer$$queue(), eventHandler, producerConfig.queueBufferingMaxMs(), producerConfig.batchNumMessages(), producerConfig.clientId()));
                this.producerSendThread().start();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.kafka$producer$Producer$$producerTopicStats = ProducerTopicStatsRegistry$.MODULE$.getProducerTopicStats(producerConfig.clientId());
            KafkaMetricsReporter$.MODULE$.startReporters(producerConfig.props());
            return;
        }
        throw new MatchError((Object)string);
    }

    public Producer(ProducerConfig producerConfig) {
        this(producerConfig, new DefaultEventHandler(producerConfig, (Partitioner)Utils$.MODULE$.createObject(producerConfig.partitionerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{producerConfig.props()})), (Encoder)Utils$.MODULE$.createObject(producerConfig.serializerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{producerConfig.props()})), (Encoder)Utils$.MODULE$.createObject(producerConfig.keySerializerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{producerConfig.props()})), new ProducerPool(producerConfig), DefaultEventHandler$.MODULE$.$lessinit$greater$default$6()));
    }
}

