/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.TopicAndPartition;
import kafka.server.HighwaterMarkCheckpoint$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.StringAdd$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001i<Q!\u0001\u0002\t\u0002\u001d\tq\u0003S5hQ^\fG/\u001a:NCJ\\7\t[3dWB|\u0017N\u001c;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0002-\u0011q\u0003S5hQ^\fG/\u001a:NCJ\\7\t[3dWB|\u0017N\u001c;\u0014\u0005%a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0013\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a#\u0003b\u0001\n\u00039\u0012!\u00065jO\"<\u0016\r^3s[\u0006\u00148NR5mK:\u000bW.Z\u000b\u00021A\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0005Y\u0006twMC\u0001\u001e\u0003\u0011Q\u0017M^1\n\u0005}Q\"AB*ue&tw\r\u0003\u0004\"\u0013\u0001\u0006I\u0001G\u0001\u0017Q&<\u0007nV1uKJl\u0017M]6GS2,g*Y7fA!91%\u0003b\u0001\n\u0003!\u0013aH2veJ,g\u000e\u001e%jO\"<\u0018\r^3s\u001b\u0006\u00148NR5mKZ+'o]5p]V\tQ\u0005\u0005\u0002\u000eM%\u0011qE\u0004\u0002\u0004\u0013:$\bBB\u0015\nA\u0003%Q%\u0001\u0011dkJ\u0014XM\u001c;IS\u001eDw/\u0019;fe6\u000b'o\u001b$jY\u00164VM]:j_:\u0004c\u0001\u0002\u0006\u0003\u0001-\u001a2A\u000b\u0007-!\ti\u0003'D\u0001/\u0015\tyC!A\u0003vi&d7/\u0003\u00022]\t9Aj\\4hS:<\u0007\u0002C\u001a+\u0005\u000b\u0007I\u0011\u0001\u001b\u0002\tA\fG\u000f[\u000b\u0002kA\u0011a'\u000f\b\u0003\u001b]J!\u0001\u000f\b\u0002\rA\u0013X\rZ3g\u0013\ty\"H\u0003\u00029\u001d!AAH\u000bB\u0001B\u0003%Q'A\u0003qCRD\u0007\u0005C\u0003\u0014U\u0011\u0005a\b\u0006\u0002@\u0001B\u0011\u0001B\u000b\u0005\u0006gu\u0002\r!\u000e\u0005\b\u0005*\u0012\r\u0011\"\u0001\u0018\u0003\u0011q\u0017-\\3\t\r\u0011S\u0003\u0015!\u0003\u0019\u0003\u0015q\u0017-\\3!\u0011\u001d1%F1A\u0005\n\u001d\u000ba\u0001[<GS2,W#\u0001%\u0011\u0005%cU\"\u0001&\u000b\u0005-c\u0012AA5p\u0013\ti%J\u0001\u0003GS2,\u0007BB(+A\u0003%\u0001*A\u0004io\u001aKG.\u001a\u0011\t\u000fES#\u0019!C\u0005%\u0006Q\u0001n\u001e$jY\u0016dunY6\u0016\u0003M\u0003\"\u0001V.\u000e\u0003US!AV,\u0002\u000b1|7m[:\u000b\u0005aK\u0016AC2p]\u000e,(O]3oi*\u0011!\fH\u0001\u0005kRLG.\u0003\u0002]+\ni!+Z3oiJ\fg\u000e\u001e'pG.DaA\u0018\u0016!\u0002\u0013\u0019\u0016a\u00035x\r&dW\rT8dW\u0002BQ\u0001\u0019\u0016\u0005\u0002\u0005\fQa\u001e:ji\u0016$\"AY3\u0011\u00055\u0019\u0017B\u00013\u000f\u0005\u0011)f.\u001b;\t\u000b\u0019|\u0006\u0019A4\u00025!Lw\r[<bi\u0016\u0014X*\u0019:lgB+'\u000fU1si&$\u0018n\u001c8\u0011\tYB'\u000e]\u0005\u0003Sj\u00121!T1q!\tYg.D\u0001m\u0015\tiG!\u0001\u0004d_6lwN\\\u0005\u0003_2\u0014\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\ti\u0011/\u0003\u0002s\u001d\t!Aj\u001c8h\u0011\u0015!(\u0006\"\u0001v\u0003\u0011\u0011X-\u00193\u0015\u0007A4\b\u0010C\u0003xg\u0002\u0007Q'A\u0003u_BL7\rC\u0003zg\u0002\u0007Q%A\u0005qCJ$\u0018\u000e^5p]\u0002")
public class HighwaterMarkCheckpoint
implements Logging {
    private final String path;
    private final String name;
    private final File hwFile;
    private final ReentrantLock hwFileLock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static int currentHighwaterMarkFileVersion() {
        return HighwaterMarkCheckpoint$.MODULE$.currentHighwaterMarkFileVersion();
    }

    public static String highWatermarkFileName() {
        return HighwaterMarkCheckpoint$.MODULE$.highWatermarkFileName();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        HighwaterMarkCheckpoint highwaterMarkCheckpoint = this;
        synchronized (highwaterMarkCheckpoint) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public String path() {
        return this.path;
    }

    public String name() {
        return this.name;
    }

    private File hwFile() {
        return this.hwFile;
    }

    private ReentrantLock hwFileLock() {
        return this.hwFileLock;
    }

    public void write(Map<TopicAndPartition, Object> map) {
        this.hwFileLock().lock();
        try {
            File file = new File(StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.hwFile()), ".tmp"));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(((Object)BoxesRunTime.boxToInteger((int)HighwaterMarkCheckpoint$.MODULE$.currentHighwaterMarkFileVersion())).toString());
            bufferedWriter.newLine();
            bufferedWriter.write(((Object)BoxesRunTime.boxToInteger((int)map.size())).toString());
            bufferedWriter.newLine();
            map.foreach((Function1)new Serializable(this, bufferedWriter){
                public static final long serialVersionUID = 0L;
                private final BufferedWriter hwFileWriter$1;

                public final void apply(Tuple2<TopicAndPartition, Object> tuple2) {
                    this.hwFileWriter$1.write(new StringOps(Predef$.MODULE$.augmentString("%s %s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TopicAndPartition)tuple2._1()).topic(), BoxesRunTime.boxToInteger((int)((TopicAndPartition)tuple2._1()).partition()), BoxesRunTime.boxToLong((long)tuple2._2$mcJ$sp())})));
                    this.hwFileWriter$1.newLine();
                }
                {
                    this.hwFileWriter$1 = bufferedWriter;
                }
            });
            bufferedWriter.flush();
            bufferedWriter.close();
            if (!file.renameTo(this.hwFile())) {
                this.hwFile().delete();
                if (!file.renameTo(this.hwFile())) {
                    this.fatal((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Attempt to swap the new high watermark file with the old one failed";
                        }
                    });
                    System.exit(1);
                }
            }
            return;
        }
        finally {
            this.hwFileLock().unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long read(String string, int n) {
        this.hwFileLock().lock();
        try {
            long l;
            long l2 = this.hwFile().length();
            if (0L == l2) {
                this.warn((Function0<String>)new Serializable(this, string, n){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;
                    private final int partition$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("No highwatermark file is found. Returning 0 as the highwatermark for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                    }
                    {
                        this.topic$1 = string;
                        this.partition$1 = n;
                    }
                });
                l = 0L;
                return l;
            } else {
                long l3;
                short s;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.hwFile()));
                short s2 = s = new StringOps(Predef$.MODULE$.augmentString(bufferedReader.readLine())).toShort();
                if (HighwaterMarkCheckpoint$.MODULE$.currentHighwaterMarkFileVersion() == s2) {
                    long l4;
                    Option option;
                    int n2 = new StringOps(Predef$.MODULE$.augmentString(bufferedReader.readLine())).toInt();
                    IndexedSeq indexedSeq = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n2).map((Function1)new Serializable(this, bufferedReader){
                        public static final long serialVersionUID = 0L;
                        private final BufferedReader hwFileReader$1;

                        public final Tuple2<TopicAndPartition, Object> apply(int n) {
                            String string = this.hwFileReader$1.readLine();
                            String[] stringArray = string.split(" ");
                            String string2 = stringArray[0];
                            int n2 = new StringOps(Predef$.MODULE$.augmentString(stringArray[1])).toInt();
                            long l = new StringOps(Predef$.MODULE$.augmentString(stringArray[2])).toLong();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(string2, n2)), (Object)BoxesRunTime.boxToLong((long)l));
                        }
                        {
                            this.hwFileReader$1 = bufferedReader;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    bufferedReader.close();
                    Option option2 = option = indexedSeq.toMap(Predef$.MODULE$.conforms()).get((Object)new TopicAndPartition(string, n));
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        long l5 = BoxesRunTime.unboxToLong((Object)some.x());
                        this.debug((Function0<String>)new Serializable(this, string, n, l5){
                            public static final long serialVersionUID = 0L;
                            private final String topic$1;
                            private final int partition$1;
                            private final long hw$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Read hw %d for partition [%s,%d] from highwatermark checkpoint file")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.hw$1), this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                            }
                            {
                                this.topic$1 = string;
                                this.partition$1 = n;
                                this.hw$1 = l;
                            }
                        });
                        l4 = l5;
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option3 = option2;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError((Object)option2);
                        this.warn((Function0<String>)new Serializable(this, string, n){
                            public static final long serialVersionUID = 0L;
                            private final String topic$1;
                            private final int partition$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("No previously checkpointed highwatermark value found for topic %s ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("partition %d. Returning 0 as the highwatermark")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.partition$1)}))).toString();
                            }
                            {
                                this.topic$1 = string;
                                this.partition$1 = n;
                            }
                        });
                        l4 = 0L;
                    }
                    l3 = l4;
                } else {
                    this.fatal((Function0<String>)new Serializable(this, s){
                        public static final long serialVersionUID = 0L;
                        private final short version$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Unrecognized version of the highwatermark checkpoint file ").append((Object)BoxesRunTime.boxToShort((short)this.version$1)).toString();
                        }
                        {
                            this.version$1 = s;
                        }
                    });
                    System.exit(1);
                    l3 = -1L;
                }
                l = l3;
            }
            return l;
        }
        finally {
            this.hwFileLock().unlock();
        }
    }

    public HighwaterMarkCheckpoint(String string) {
        this.path = string;
        Logging$class.$init$(this);
        this.name = new StringBuilder().append((Object)string).append((Object)File.separator).append((Object)HighwaterMarkCheckpoint$.MODULE$.highWatermarkFileName()).toString();
        this.hwFile = new File(this.name());
        this.hwFileLock = new ReentrantLock();
    }
}

