/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import kafka.common.InvalidOffsetException;
import kafka.log.AbstractIndex;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.CoreUtils$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0005\u0013)a!#D\u0001\u0003\u0013\tY!AA\u0007BEN$(/Y2u\u0013:$W\r\u001f\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0005\u0019>tw\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\u0004\u0013:$\b\u0002\u0003\f\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\t\u0019LG.\u001a\t\u00031ui\u0011!\u0007\u0006\u00035m\t!![8\u000b\u0003q\tAA[1wC&\u0011a$\u0007\u0002\u0005\r&dW\rC\u0005!\u0001\t\u0005\t\u0015!\u0003\rC\u0005Q!-Y:f\u001f\u001a47/\u001a;\n\u0005\u0001R\u0001\"C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n%\u00031i\u0017\r_%oI\u0016D8+\u001b>f\u0013\t\u0019#\u0002C\u0005'\u0001\t\u0005\t\u0015!\u0003(U\u0005AqO]5uC\ndW\r\u0005\u0002\u000eQ%\u0011\u0011F\u0004\u0002\b\u0005>|G.Z1o\u0013\t1#\u0002C\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0006]=\u0002\u0014G\r\t\u0003\u0013\u0001AQAF\u0016A\u0002]AQ\u0001I\u0016A\u00021AqaI\u0016\u0011\u0002\u0003\u0007!\u0003C\u0004'WA\u0005\t\u0019A\u0014\t\u000bQ\u0002A\u0011I\u001b\u0002\u0013\u0015tGO]=TSj,W#\u0001\n\t\r]\u0002\u0001\u0015)\u0003\r\u0003-yF.Y:u\u001f\u001a47/\u001a;\t\u000be\u0002A\u0011\u0002\u001e\u0002\u00131\f7\u000f^#oiJLX#A\u001e\u0011\u0005%a\u0014BA\u001f\u0003\u00059yeMZ:fiB{7/\u001b;j_:DQa\u0010\u0001\u0005\u0002\u0001\u000b!\u0002\\1ti>3gm]3u+\u0005a\u0001\"\u0002\"\u0001\t\u0003\u0019\u0015A\u00027p_.,\b\u000f\u0006\u0002<\t\")Q)\u0011a\u0001\u0019\u0005aA/\u0019:hKR|eMZ:fi\")q\t\u0001C\u0001\u0011\u0006)b-\u001a;dQV\u0003\b/\u001a:C_VtGm\u00144gg\u0016$HcA%M\u001dB\u0019QBS\u001e\n\u0005-s!AB(qi&|g\u000eC\u0003N\r\u0002\u00071(A\u0006gKR\u001c\u0007n\u00144gg\u0016$\b\"B(G\u0001\u0004\u0011\u0012!\u00034fi\u000eD7+\u001b>f\u0011\u0015\t\u0006\u0001\"\u0003S\u00039\u0011X\r\\1uSZ,wJ\u001a4tKR$2AE*\\\u0011\u0015!\u0006\u000b1\u0001V\u0003\u0019\u0011WO\u001a4feB\u0011a+W\u0007\u0002/*\u0011\u0001lG\u0001\u0004]&|\u0017B\u0001.X\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u00069B\u0003\rAE\u0001\u0002]\")a\f\u0001C\u0005?\u0006A\u0001\u000f[=tS\u000e\fG\u000eF\u0002\u0013A\u0006DQ\u0001V/A\u0002UCQ\u0001X/A\u0002IAQa\u0019\u0001\u0005B\u0011\f!\u0002]1sg\u0016,e\u000e\u001e:z)\r)\u0007.\u001b\t\u0003\u0013\u0019L!a\u001a\u0002\u0003\u0015%sG-\u001a=F]R\u0014\u0018\u0010C\u0003UE\u0002\u0007Q\u000bC\u0003]E\u0002\u0007!\u0003C\u0003l\u0001\u0011\u0005A.A\u0003f]R\u0014\u0018\u0010\u0006\u0002<[\")AL\u001ba\u0001%!)q\u000e\u0001C\u0001a\u00061\u0011\r\u001d9f]\u0012$2!\u001d;w!\ti!/\u0003\u0002t\u001d\t!QK\\5u\u0011\u0015)h\u000e1\u0001\r\u0003\u0019ygMZ:fi\")qO\u001ca\u0001%\u0005A\u0001o\\:ji&|g\u000eC\u0003z\u0001\u0011\u0005#0\u0001\u0005ueVt7-\u0019;f)\u0005\t\b\"\u0002?\u0001\t\u0003j\u0018A\u0003;sk:\u001c\u0017\r^3U_R\u0011\u0011O \u0005\u0006kn\u0004\r\u0001\u0004\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0003E!(/\u001e8dCR,Gk\\#oiJLWm\u001d\u000b\u0004c\u0006\u0015\u0001BBA\u0004\u007f\u0002\u0007!#A\u0004f]R\u0014\u0018.Z:\t\r\u0005-\u0001\u0001\"\u0011{\u0003-\u0019\u0018M\\5us\u000eCWmY6\t\u0019\u0005=\u0001\u0001%A\u0002\u0002\u0003%I!\u000e\u0013\u0002%M,\b/\u001a:%[\u0006D\u0018J\u001c3fqNK'0\u001a\u0005\r\u0003'\u0001\u0001\u0013aA\u0001\u0002\u0013%\u0001)I\u0001\u0011gV\u0004XM\u001d\u0013cCN,wJ\u001a4tKR<\u0011\"a\u0006\u0003\u0003\u0003E\t!!\u0007\u0002\u0017=3gm]3u\u0013:$W\r\u001f\t\u0004\u0013\u0005ma\u0001C\u0001\u0003\u0003\u0003E\t!!\b\u0014\t\u0005m\u0011q\u0004\t\u0004\u001b\u0005\u0005\u0012bAA\u0012\u001d\t1\u0011I\\=SK\u001aDq\u0001LA\u000e\t\u0003\t9\u0003\u0006\u0002\u0002\u001a!Q\u00111FA\u000e#\u0003%\t!!\f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tyCK\u0002\u0013\u0003cY#!a\r\u0011\t\u0005U\u0012qH\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{q\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011IA\u001c\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003\u000b\nY\"%A\u0005\u0002\u0005\u001d\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002J)\u001aq%!\r")
public class OffsetIndex
extends AbstractIndex<Object, Object> {
    public final File kafka$log$OffsetIndex$$file;
    public long kafka$log$OffsetIndex$$_lastOffset;

    public static boolean $lessinit$greater$default$4() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public /* synthetic */ int kafka$log$OffsetIndex$$super$maxIndexSize() {
        return super.maxIndexSize();
    }

    public /* synthetic */ long kafka$log$OffsetIndex$$super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 8;
    }

    public OffsetPosition kafka$log$OffsetIndex$$lastEntry() {
        return (OffsetPosition)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final OffsetPosition apply() {
                OffsetPosition offsetPosition;
                int n = this.$outer._entries();
                switch (n) {
                    default: {
                        offsetPosition = (OffsetPosition)this.$outer.parseEntry(this.$outer.mmap(), n - 1);
                        break;
                    }
                    case 0: {
                        offsetPosition = new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$super$baseOffset(), 0);
                    }
                }
                return offsetPosition;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public long lastOffset() {
        return this.kafka$log$OffsetIndex$$_lastOffset;
    }

    public OffsetPosition lookup(long targetOffset) {
        return (OffsetPosition)this.maybeLock(this.lock(), new Serializable(this, targetOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long targetOffset$1;

            public final OffsetPosition apply() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.targetOffset$1, IndexSearchType$.MODULE$.KEY());
                return slot == -1 ? new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$super$baseOffset(), 0) : (OffsetPosition)this.$outer.parseEntry(idx, slot);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetOffset$1 = targetOffset$1;
            }
        });
    }

    public Option<OffsetPosition> fetchUpperBoundOffset(OffsetPosition fetchOffset, int fetchSize) {
        return (Option)this.maybeLock(this.lock(), new Serializable(this, fetchOffset, fetchSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final OffsetPosition fetchOffset$1;
            private final int fetchSize$1;

            public final Option<OffsetPosition> apply() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.smallestUpperBoundSlotFor(idx, this.fetchOffset$1.position() + this.fetchSize$1, IndexSearchType$.MODULE$.VALUE());
                return slot == -1 ? None$.MODULE$ : new Some((Object)((OffsetPosition)this.$outer.parseEntry(idx, slot)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchOffset$1 = fetchOffset$1;
                this.fetchSize$1 = fetchSize$1;
            }
        });
    }

    public int kafka$log$OffsetIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize());
    }

    public int kafka$log$OffsetIndex$$physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 4);
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(super.baseOffset() + (long)this.kafka$log$OffsetIndex$$relativeOffset(buffer, n), this.kafka$log$OffsetIndex$$physical(buffer, n));
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int n$1;

            public final OffsetPosition apply() {
                if (this.n$1 >= this.$outer._entries()) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$1), BoxesRunTime.boxToInteger((int)this.$outer._entries())})));
                }
                ByteBuffer idx = this.$outer.mmap().duplicate();
                return new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, this.n$1), this.$outer.kafka$log$OffsetIndex$$physical(idx, this.n$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
            }
        });
    }

    public void append(long offset2, int position) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset2, position){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            public final long offset$1;
            public final int position$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.require(!this.$outer.isFull(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$append$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Attempt to append to a full index (size = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer()._entries())).append((Object)").").toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (this.$outer._entries() == 0 || this.offset$1 > this.$outer.kafka$log$OffsetIndex$$_lastOffset) {
                    this.$outer.debug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.position$1), this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$file.getName()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.mmap().putInt((int)(this.offset$1 - this.$outer.kafka$log$OffsetIndex$$super$baseOffset()));
                    this.$outer.mmap().putInt(this.position$1);
                    this.$outer._entries_$eq(this.$outer._entries() + 1);
                    this.$outer.kafka$log$OffsetIndex$$_lastOffset = this.offset$1;
                    Predef$.MODULE$.require(this.$outer._entries() * this.$outer.entrySize() == this.$outer.mmap().position(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().entries()).append((Object)" entries but file position in index is ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().mmap().position())).append((Object)".").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.entries()), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$_lastOffset), this.$outer.kafka$log$OffsetIndex$$file.getAbsolutePath()})));
            }

            public /* synthetic */ OffsetIndex kafka$log$OffsetIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$1 = offset$1;
                this.position$1 = position$1;
            }
        });
    }

    @Override
    public void truncate() {
        this.kafka$log$OffsetIndex$$truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long offset$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.offset$2, IndexSearchType$.MODULE$.KEY());
                int newEntries = slot < 0 ? 0 : ((long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, slot) == this.offset$2 - this.$outer.kafka$log$OffsetIndex$$super$baseOffset() ? slot : slot + 1);
                this.$outer.kafka$log$OffsetIndex$$truncateToEntries(newEntries);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
    }

    public void kafka$log$OffsetIndex$$truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, entries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int entries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer._entries_$eq(this.entries$1);
                this.$outer.mmap().position(this.$outer._entries() * this.$outer.entrySize());
                this.$outer.kafka$log$OffsetIndex$$_lastOffset = this.$outer.kafka$log$OffsetIndex$$lastEntry().offset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entries$1 = entries$1;
            }
        });
    }

    @Override
    public void sanityCheck() {
        Predef$.MODULE$.require(this._entries() == 0 || this.kafka$log$OffsetIndex$$_lastOffset > super.baseOffset(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt index found, index file (", ") has non-zero size but the last offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$OffsetIndex$$file.getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is no larger than the base offset ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$_lastOffset), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$super$baseOffset())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long len = this.kafka$log$OffsetIndex$$file.length();
        Predef$.MODULE$.require(len % (long)this.entrySize() == 0L, (Function0)new Serializable(this, len){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long len$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Index file ").append((Object)this.$outer.kafka$log$OffsetIndex$$file.getAbsolutePath()).append((Object)" is corrupt, found ").append((Object)BoxesRunTime.boxToLong((long)this.len$1)).append((Object)" bytes which is not positive or not a multiple of 8.").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.len$1 = len$1;
            }
        });
    }

    public OffsetIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        this.kafka$log$OffsetIndex$$file = file;
        super(file, baseOffset, maxIndexSize, writable);
        this.kafka$log$OffsetIndex$$_lastOffset = this.kafka$log$OffsetIndex$$lastEntry().offset();
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Loaded index file %s with maxEntries = %d, maxIndexSize = %d, entries = %d, lastOffset = %d, file position = %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$OffsetIndex$$file.getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.maxEntries()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$super$maxIndexSize()), BoxesRunTime.boxToInteger((int)this.$outer._entries()), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$_lastOffset), BoxesRunTime.boxToInteger((int)this.$outer.mmap().position())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

