/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.common.BrokerNotAvailableException;
import kafka.common.KafkaException;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Broker$
implements Serializable {
    public static final Broker$ MODULE$;
    private final String HostKey;
    private final String PortKey;
    private final String VersionKey;
    private final String EndpointsKey;
    private final String kafka$cluster$Broker$$RackKey;
    private final String JmxPortKey;
    private final String ListenerSecurityProtocolMapKey;
    private final String TimestampKey;

    static {
        new Broker$();
    }

    private String HostKey() {
        return this.HostKey;
    }

    private String PortKey() {
        return this.PortKey;
    }

    private String VersionKey() {
        return this.VersionKey;
    }

    private String EndpointsKey() {
        return this.EndpointsKey;
    }

    public String kafka$cluster$Broker$$RackKey() {
        return this.kafka$cluster$Broker$$RackKey;
    }

    private String JmxPortKey() {
        return this.JmxPortKey;
    }

    private String ListenerSecurityProtocolMapKey() {
        return this.ListenerSecurityProtocolMapKey;
    }

    private String TimestampKey() {
        return this.TimestampKey;
    }

    public Broker createBroker(int id, String brokerInfoString) {
        if (brokerInfoString == null) {
            throw new BrokerNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
        }
        try {
            Option<JsonValue> option = Json$.MODULE$.parseFull(brokerInfoString);
            if (option instanceof Some) {
                Seq seq;
                Some some = (Some)option;
                JsonValue js = (JsonValue)some.x();
                JsonObject brokerInfo = js.asJsonObject();
                int version = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
                if (version < 1) {
                    throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported version of broker registration: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerInfoString})));
                }
                if (version == 1) {
                    String host = brokerInfo.apply(this.HostKey()).to(DecodeJson$DecodeString$.MODULE$);
                    int port = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.PortKey()).to(DecodeJson$DecodeInt$.MODULE$));
                    SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
                    EndPoint endPoint = new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol2), securityProtocol2);
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endPoint}));
                } else {
                    Option securityProtocolMap = brokerInfo.get(this.ListenerSecurityProtocolMapKey()).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final scala.collection.immutable.Map<ListenerName, SecurityProtocol> apply(JsonValue x$1) {
                            return (scala.collection.immutable.Map)((TraversableLike)x$1.to(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeString$.MODULE$, Map$.MODULE$.canBuildFrom()))).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<ListenerName, SecurityProtocol> apply(Tuple2<String, String> x0$1) {
                                    Tuple2<String, String> tuple2 = x0$1;
                                    if (tuple2 != null) {
                                        String listenerName = (String)tuple2._1();
                                        String securityProtocol2 = (String)tuple2._2();
                                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ListenerName(listenerName)), (Object)SecurityProtocol.forName((String)securityProtocol2));
                                        return tuple22;
                                    }
                                    throw new MatchError(tuple2);
                                }
                            }, Map$.MODULE$.canBuildFrom());
                        }
                    });
                    Seq listeners = (Seq)brokerInfo.apply(this.EndpointsKey()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                    seq = (Seq)listeners.map((Function1)new Serializable(securityProtocolMap){
                        public static final long serialVersionUID = 0L;
                        private final Option securityProtocolMap$1;

                        public final EndPoint apply(String x$2) {
                            return EndPoint$.MODULE$.createEndPoint(x$2, (Option<Map<ListenerName, SecurityProtocol>>)this.securityProtocolMap$1);
                        }
                        {
                            this.securityProtocolMap$1 = securityProtocolMap$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
                Seq endpoints = seq;
                Option rack = brokerInfo.get(this.kafka$cluster$Broker$$RackKey()).flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(JsonValue x$3) {
                        return x$3.to(DecodeJson$.MODULE$.decodeOption(DecodeJson$DecodeString$.MODULE$));
                    }
                });
                Broker broker = new Broker(id, (Seq<EndPoint>)endpoints, (Option<String>)rack);
                return broker;
            }
            if (None$.MODULE$.equals(option)) {
                throw new BrokerNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
            }
            throw new MatchError(option);
        }
        catch (Throwable throwable) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse the broker info from zookeeper: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerInfoString})), throwable);
        }
    }

    public String toJson(int version, int id, String host, int port, Seq<EndPoint> advertisedEndpoints, int jmxPort, Option<String> rack) {
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey()), (Object)BoxesRunTime.boxToInteger((int)version)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HostKey()), (Object)host), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PortKey()), (Object)BoxesRunTime.boxToInteger((int)port)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EndpointsKey()), ((TraversableOnce)advertisedEndpoints.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(EndPoint x$4) {
                return x$4.connectionString();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.JmxPortKey()), (Object)BoxesRunTime.boxToInteger((int)jmxPort)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TimestampKey()), (Object)((Object)BoxesRunTime.boxToLong((long)Time.SYSTEM.milliseconds())).toString())}));
        rack.foreach((Function1)new Serializable(version, jsonMap){
            public static final long serialVersionUID = 0L;
            private final int version$1;
            private final scala.collection.mutable.Map jsonMap$1;

            public final Object apply(String rack) {
                return this.version$1 >= 3 ? this.jsonMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.kafka$cluster$Broker$$RackKey()), (Object)rack)) : BoxedUnit.UNIT;
            }
            {
                this.version$1 = version$1;
                this.jsonMap$1 = jsonMap$1;
            }
        });
        Object object = version >= 4 ? jsonMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ListenerSecurityProtocolMapKey()), (Object)((TraversableOnce)advertisedEndpoints.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(EndPoint endPoint) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endPoint.listenerName().value()), (Object)endPoint.securityProtocol().name);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()))) : BoxedUnit.UNIT;
        return Json$.MODULE$.encode(jsonMap);
    }

    public Broker apply(int id, Seq<EndPoint> endPoints, Option<String> rack) {
        return new Broker(id, endPoints, rack);
    }

    public Option<Tuple3<Object, Seq<EndPoint>, Option<String>>> unapply(Broker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.id()), x$0.endPoints(), x$0.rack()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Broker$() {
        MODULE$ = this;
        this.HostKey = "host";
        this.PortKey = "port";
        this.VersionKey = "version";
        this.EndpointsKey = "endpoints";
        this.kafka$cluster$Broker$$RackKey = "rack";
        this.JmxPortKey = "jmx_port";
        this.ListenerSecurityProtocolMapKey = "listener_security_protocol_map";
        this.TimestampKey = "timestamp";
    }
}

