/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.AwaitingSync$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupMetadata$$anonfun$completePendingTxnOffsetCommit$1$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberSummary;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r]v!B\u0001\u0003\u0011\u0013I\u0011!D$s_V\u0004X*\u001a;bI\u0006$\u0018M\u0003\u0002\u0004\t\u0005)qM]8va*\u0011QAB\u0001\fG>|'\u000fZ5oCR|'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AC\u0006\u000e\u0003\t1Q\u0001\u0004\u0002\t\n5\u0011Qb\u0012:pkBlU\r^1eCR\f7CA\u0006\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Qc\u0003C\u0001-\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\b1-\u0011\r\u0011\"\u0003\u001a\u0003M1\u0018\r\\5e!J,g/[8vgN#\u0018\r^3t+\u0005Q\u0002\u0003B\u000e\u001fC\u0011r!a\u0004\u000f\n\u0005u\u0001\u0012A\u0002)sK\u0012,g-\u0003\u0002 A\t\u0019Q*\u00199\u000b\u0005u\u0001\u0002C\u0001\u0006#\u0013\t\u0019#A\u0001\u0006He>,\bo\u0015;bi\u0016\u00042aG\u0013\"\u0013\t1\u0003EA\u0002TKRDa\u0001K\u0006!\u0002\u0013Q\u0012\u0001\u0006<bY&$\u0007K]3wS>,8o\u0015;bi\u0016\u001c\b\u0005C\u0003+\u0017\u0011\u00051&A\u0005m_\u0006$wI]8vaRyAfa&\u0004\u001a\u000em5QTBP\u0007C\u001b\u0019\u000b\u0005\u0002\u000b[\u0019)AB\u0001\u0001\u0003]M\u0019QFD\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I2\u0011!B;uS2\u001c\u0018B\u0001\u001b2\u0005\u001daunZ4j]\u001eD\u0001BN\u0017\u0003\u0006\u0004%\taN\u0001\bOJ|W\u000f]%e+\u0005A\u0004CA\u000e:\u0013\tQ\u0004E\u0001\u0004TiJLgn\u001a\u0005\ty5\u0012\t\u0011)A\u0005q\u0005AqM]8va&#\u0007\u0005\u0003\u0005?[\t\u0005\t\u0015!\u0003\"\u00031Ig.\u001b;jC2\u001cF/\u0019;f\u0011\u0015)R\u0006\"\u0001A)\ra\u0013I\u0011\u0005\u0006m}\u0002\r\u0001\u000f\u0005\u0006}}\u0002\r!\t\u0005\t\t6\u0012\r\u0011\"\u0001\u0003\u000b\u0006!An\\2l+\u00051\u0005CA$Q\u001b\u0005A%BA%K\u0003\u0015awnY6t\u0015\tYE*\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u0014(\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u001f\u0006!!.\u0019<b\u0013\t\t\u0006JA\u0007SK\u0016tGO]1oi2{7m\u001b\u0005\u0007'6\u0002\u000b\u0011\u0002$\u0002\u000b1|7m\u001b\u0011\t\u000fUk\u0003\u0019!C\u0005-\u0006)1\u000f^1uKV\t\u0011\u0005C\u0004Y[\u0001\u0007I\u0011B-\u0002\u0013M$\u0018\r^3`I\u0015\fHC\u0001.^!\ty1,\u0003\u0002]!\t!QK\\5u\u0011\u001dqv+!AA\u0002\u0005\n1\u0001\u001f\u00132\u0011\u0019\u0001W\u0006)Q\u0005C\u000511\u000f^1uK\u0002BqAY\u0017A\u0002\u0013\u00051-\u0001\u0007qe>$xnY8m)f\u0004X-F\u0001e!\ryQ\rO\u0005\u0003MB\u0011aa\u00149uS>t\u0007b\u00025.\u0001\u0004%\t![\u0001\u0011aJ|Go\\2pYRK\b/Z0%KF$\"A\u00176\t\u000fy;\u0017\u0011!a\u0001I\"1A.\fQ!\n\u0011\fQ\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016\u0004\u0003b\u00028.\u0001\u0004%\ta\\\u0001\rO\u0016tWM]1uS>t\u0017\nZ\u000b\u0002aB\u0011q\"]\u0005\u0003eB\u00111!\u00138u\u0011\u001d!X\u00061A\u0005\u0002U\f\u0001cZ3oKJ\fG/[8o\u0013\u0012|F%Z9\u0015\u0005i3\bb\u00020t\u0003\u0003\u0005\r\u0001\u001d\u0005\u0007q6\u0002\u000b\u0015\u00029\u0002\u001b\u001d,g.\u001a:bi&|g.\u00133!\u0011\u001dQX\u00061A\u0005\n\r\f\u0001\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0005\by6\u0002\r\u0011\"\u0003~\u00031aW-\u00193fe&#w\fJ3r)\tQf\u0010C\u0004_w\u0006\u0005\t\u0019\u00013\t\u000f\u0005\u0005Q\u0006)Q\u0005I\u0006IA.Z1eKJLE\r\t\u0005\t\u0003\u000bi\u0003\u0019!C\u0005G\u0006A\u0001O]8u_\u000e|G\u000eC\u0005\u0002\n5\u0002\r\u0011\"\u0003\u0002\f\u0005a\u0001O]8u_\u000e|Gn\u0018\u0013fcR\u0019!,!\u0004\t\u0011y\u000b9!!AA\u0002\u0011Dq!!\u0005.A\u0003&A-A\u0005qe>$xnY8mA!I\u0011QC\u0017C\u0002\u0013%\u0011qC\u0001\b[\u0016l'-\u001a:t+\t\tI\u0002E\u0004\u0002\u001c\u0005\u0015\u0002(!\u000b\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\tq!\\;uC\ndWMC\u0002\u0002$A\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9#!\b\u0003\u000f!\u000b7\u000f['baB\u0019!\"a\u000b\n\u0007\u00055\"A\u0001\bNK6\u0014WM]'fi\u0006$\u0017\r^1\t\u0011\u0005ER\u0006)A\u0005\u00033\t\u0001\"\\3nE\u0016\u00148\u000f\t\u0005\n\u0003ki#\u0019!C\u0005\u0003o\tqa\u001c4gg\u0016$8/\u0006\u0002\u0002:AA\u00111DA\u0013\u0003w\t\t\u0006\u0005\u0003\u0002>\u00055SBAA \u0015\u0011\t\t%a\u0011\u0002\r\r|W.\\8o\u0015\r9\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0017\n1a\u001c:h\u0013\u0011\ty%a\u0010\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0019!\"a\u0015\n\u0007\u0005U#AA\u000fD_6l\u0017\u000e\u001e*fG>\u0014H-T3uC\u0012\fG/Y!oI>3gm]3u\u0011!\tI&\fQ\u0001\n\u0005e\u0012\u0001C8gMN,Go\u001d\u0011\t\u0013\u0005uSF1A\u0005\n\u0005}\u0013\u0001\u00069f]\u0012LgnZ(gMN,GoQ8n[&$8/\u0006\u0002\u0002bAA\u00111DA\u0013\u0003w\t\u0019\u0007\u0005\u0003\u0002f\u0005%TBAA4\u0015\r\t\tEB\u0005\u0005\u0003W\n9GA\tPM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006D\u0001\"a\u001c.A\u0003%\u0011\u0011M\u0001\u0016a\u0016tG-\u001b8h\u001f\u001a47/\u001a;D_6l\u0017\u000e^:!\u0011%\t\u0019(\fb\u0001\n\u0013\t)(A\u0011qK:$\u0017N\\4Ue\u0006t7/Y2uS>t\u0017\r\\(gMN,GoQ8n[&$8/\u0006\u0002\u0002xAA\u00111DA\u0013\u0003s\ny\bE\u0002\u0010\u0003wJ1!! \u0011\u0005\u0011auN\\4\u0011\u0011\u0005m\u0011\u0011QA\u001e\u0003#J1aHA\u000f\u0011!\t))\fQ\u0001\n\u0005]\u0014A\t9f]\u0012Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\fGn\u00144gg\u0016$8i\\7nSR\u001c\b\u0005C\u0005\u0002\n6\u0002\r\u0011\"\u0003\u0002\f\u0006\u0011#/Z2fSZ,G\r\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cu.\\7jiN,\"!!$\u0011\u0007=\ty)C\u0002\u0002\u0012B\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002\u00166\u0002\r\u0011\"\u0003\u0002\u0018\u00061#/Z2fSZ,G\r\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cu.\\7jiN|F%Z9\u0015\u0007i\u000bI\nC\u0005_\u0003'\u000b\t\u00111\u0001\u0002\u000e\"A\u0011QT\u0017!B\u0013\ti)A\u0012sK\u000e,\u0017N^3e)J\fgn]1di&|g.\u00197PM\u001a\u001cX\r^\"p[6LGo\u001d\u0011\t\u0013\u0005\u0005V\u00061A\u0005\n\u0005-\u0015!\b:fG\u0016Lg/\u001a3D_:\u001cX/\\3s\u001f\u001a47/\u001a;D_6l\u0017\u000e^:\t\u0013\u0005\u0015V\u00061A\u0005\n\u0005\u001d\u0016!\t:fG\u0016Lg/\u001a3D_:\u001cX/\\3s\u001f\u001a47/\u001a;D_6l\u0017\u000e^:`I\u0015\fHc\u0001.\u0002*\"Ia,a)\u0002\u0002\u0003\u0007\u0011Q\u0012\u0005\t\u0003[k\u0003\u0015)\u0003\u0002\u000e\u0006q\"/Z2fSZ,GmQ8ogVlWM](gMN,GoQ8n[&$8\u000f\t\u0005\n\u0003ck\u0003\u0019!C\u0001\u0003\u0017\u000baB\\3x\u001b\u0016l'-\u001a:BI\u0012,G\rC\u0005\u000266\u0002\r\u0011\"\u0001\u00028\u0006\u0011b.Z<NK6\u0014WM]!eI\u0016$w\fJ3r)\rQ\u0016\u0011\u0018\u0005\n=\u0006M\u0016\u0011!a\u0001\u0003\u001bC\u0001\"!0.A\u0003&\u0011QR\u0001\u0010]\u0016<X*Z7cKJ\fE\rZ3eA!9\u0011\u0011Y\u0017\u0005\u0002\u0005\r\u0017AB5o\u0019>\u001c7.\u0006\u0003\u0002F\u0006-G\u0003BAd\u0003;\u0004B!!3\u0002L2\u0001A\u0001CAg\u0003\u007f\u0013\r!a4\u0003\u0003Q\u000bB!!5\u0002XB\u0019q\"a5\n\u0007\u0005U\u0007CA\u0004O_RD\u0017N\\4\u0011\u0007=\tI.C\u0002\u0002\\B\u00111!\u00118z\u0011%\ty.a0\u0005\u0002\u0004\t\t/A\u0002gk:\u0004RaDAr\u0003\u000fL1!!:\u0011\u0005!a$-\u001f8b[\u0016t\u0004bBAu[\u0011\u0005\u00111^\u0001\u0003SN$B!!$\u0002n\"9\u0011q^At\u0001\u0004\t\u0013AC4s_V\u00048\u000b^1uK\"9\u00111_\u0017\u0005\u0002\u0005U\u0018a\u00018piR!\u0011QRA|\u0011\u001d\ty/!=A\u0002\u0005Bq!a?.\t\u0003\ti0A\u0002iCN$B!!$\u0002\u0000\"9!\u0011AA}\u0001\u0004A\u0014\u0001C7f[\n,'/\u00133\t\u000f\t\u0015Q\u0006\"\u0001\u0003\b\u0005\u0019q-\u001a;\u0015\t\u0005%\"\u0011\u0002\u0005\b\u0005\u0003\u0011\u0019\u00011\u00019\u0011\u001d\u0011i!\fC\u0001\u0005\u001f\t\u0001\"[:MK\u0006$WM\u001d\u000b\u0005\u0003\u001b\u0013\t\u0002C\u0004\u0003\u0002\t-\u0001\u0019\u0001\u001d\t\r\tUQ\u0006\"\u00018\u00031aW-\u00193fe>\u0013h*\u001e7m\u0011\u0019\u0011I\"\fC\u0001o\u0005q\u0001O]8u_\u000e|Gn\u0014:Ok2d\u0007b\u0002B\u000f[\u0011\u0005!qD\u0001\u0004C\u0012$Gc\u0001.\u0003\"!A!1\u0005B\u000e\u0001\u0004\tI#\u0001\u0004nK6\u0014WM\u001d\u0005\b\u0005OiC\u0011\u0001B\u0015\u0003\u0019\u0011X-\\8wKR\u0019!La\u000b\t\u000f\t\u0005!Q\u0005a\u0001q!1!qF\u0017\u0005\u0002Y\u000bAbY;se\u0016tGo\u0015;bi\u0016DqAa\r.\t\u0003\u0011)$A\u000bo_RLV\r\u001e*fU>Lg.\u001a3NK6\u0014WM]:\u0016\u0005\t]\u0002C\u0002B\u001d\u0005\u007f\tICD\u0002\u0010\u0005wI1A!\u0010\u0011\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0011\u0003D\t!A*[:u\u0015\r\u0011i\u0004\u0005\u0005\b\u0005\u000fjC\u0011\u0001B%\u0003)\tG\u000e\\'f[\n,'o]\u000b\u0003\u0005\u0017\u0002RA!\u0014\u0003Paj!!!\t\n\u0007\u0019\n\t\u0003C\u0004\u0003T5\"\tA!\u000e\u0002#\u0005dG.T3nE\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0003\u0004\u0003X5\"\ta\\\u0001\u0013e\u0016\u0014\u0017\r\\1oG\u0016$\u0016.\\3pkRl5\u000fC\u0004\u0003\\5\"\tA!\u0018\u0002-\u001d,g.\u001a:bi\u0016lU-\u001c2fe&#7+\u001e4gSb,\"Aa\u0018\u0011\t\t\u0005$qM\u0007\u0003\u0005GR1A!\u001aO\u0003\u0011a\u0017M\\4\n\u0007i\u0012\u0019\u0007C\u0004\u0003l5\"\t!a#\u0002\u0019\r\fgNU3cC2\fgnY3\t\u000f\t=T\u0006\"\u0001\u0003r\u0005aAO]1og&$\u0018n\u001c8U_R\u0019!La\u001d\t\u000f\u0005=(Q\u000ea\u0001C!1!qO\u0017\u0005\u0002]\nab]3mK\u000e$\bK]8u_\u000e|G\u000eC\u0004\u0003|5\"IA! \u0002%\r\fg\u000eZ5eCR,\u0007K]8u_\u000e|Gn]\u000b\u0003\u0005\u007f\u0002RA!!\u0003\bbj!Aa!\u000b\t\t\u0015\u0015\u0011E\u0001\nS6lW\u000f^1cY\u0016L1A\nBB\u0011\u001d\u0011Y)\fC\u0001\u0005\u001b\u000b\u0011c];qa>\u0014Ho\u001d)s_R|7m\u001c7t)\u0011\tiIa$\t\u0011\tE%\u0011\u0012a\u0001\u0005'\u000bq\"\\3nE\u0016\u0014\bK]8u_\u000e|Gn\u001d\t\u00047\u0015B\u0004b\u0002BL[\u0011\u0005!\u0011T\u0001\u0013S:LGOT3yi\u001e+g.\u001a:bi&|g\u000eF\u0001[\u0011\u001d\u0011i*\fC\u0001\u0005?\u000bQcY;se\u0016tG/T3nE\u0016\u0014X*\u001a;bI\u0006$\u0018-\u0006\u0002\u0003\"B)1D\b\u001d\u0003$B)qB!*\u0003*&\u0019!q\u0015\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0007=\u0011Y+C\u0002\u0003.B\u0011AAQ=uK\"9!\u0011W\u0017\u0005\u0002\tM\u0016aB:v[6\f'/_\u000b\u0003\u0005k\u00032A\u0003B\\\u0013\r\u0011IL\u0001\u0002\r\u000fJ|W\u000f]*v[6\f'/\u001f\u0005\b\u0005{kC\u0011\u0001B`\u0003!yg/\u001a:wS\u0016<XC\u0001Ba!\rQ!1Y\u0005\u0004\u0005\u000b\u0014!!D$s_V\u0004xJ^3sm&,w\u000fC\u0004\u0003J6\"\tAa3\u0002#%t\u0017\u000e^5bY&TXm\u00144gg\u0016$8\u000fF\u0003[\u0005\u001b\u0014\u0019\u000e\u0003\u0005\u00026\t\u001d\u0007\u0019\u0001Bh!!\u0011iE!5\u0002<\u0005E\u0013bA\u0010\u0002\"!A!Q\u001bBd\u0001\u0004\u00119.A\tqK:$\u0017N\\4Uq:|eMZ:fiN\u0004ba\u0007\u0010\u0002z\u0005}\u0004b\u0002Bn[\u0011\u0005!Q\\\u0001\u0015_:|eMZ:fi\u000e{W.\\5u\u0003B\u0004XM\u001c3\u0015\u000bi\u0013yNa9\t\u0011\t\u0005(\u0011\u001ca\u0001\u0003w\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0003f\ne\u0007\u0019AA)\u0003yygMZ:fi^KG\u000f[\"p[6LGOU3d_J$W*\u001a;bI\u0006$\u0018\rC\u0004\u0003j6\"\tAa;\u0002-\u0019\f\u0017\u000e\u001c)f]\u0012LgnZ(gMN,Go\u0016:ji\u0016$RA\u0017Bw\u0005_D\u0001B!9\u0003h\u0002\u0007\u00111\b\u0005\t\u0005c\u00149\u000f1\u0001\u0002d\u00051qN\u001a4tKRDqA!>.\t\u0003\u001190A\nqe\u0016\u0004\u0018M]3PM\u001a\u001cX\r^\"p[6LG\u000fF\u0002[\u0005sD\u0001\"!\u000e\u0003t\u0002\u0007!1 \t\u00077y\tY$a\u0019\t\u000f\t}X\u0006\"\u0001\u0004\u0002\u00051\u0002O]3qCJ,G\u000b\u001f8PM\u001a\u001cX\r^\"p[6LG\u000fF\u0003[\u0007\u0007\u00199\u0001\u0003\u0005\u0004\u0006\tu\b\u0019AA=\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\t\u0003k\u0011i\u00101\u0001\u0003|\"911B\u0017\u0005\u0002\u0005-\u0015A\t5bgJ+7-Z5wK\u0012\u001cuN\\:jgR,g\u000e^(gMN,GoQ8n[&$8\u000fC\u0004\u0004\u00105\"\ta!\u0005\u00025\u0019\f\u0017\u000e\u001c)f]\u0012Lgn\u001a+y]>3gm]3u\u0007>lW.\u001b;\u0015\u000bi\u001b\u0019b!\u0006\t\u0011\r\u00151Q\u0002a\u0001\u0003sB\u0001B!9\u0004\u000e\u0001\u0007\u00111\b\u0005\b\u00073iC\u0011AB\u000e\u0003]yg\u000e\u0016=o\u001f\u001a47/\u001a;D_6l\u0017\u000e^!qa\u0016tG\rF\u0004[\u0007;\u0019yb!\t\t\u0011\r\u00151q\u0003a\u0001\u0003sB\u0001B!9\u0004\u0018\u0001\u0007\u00111\b\u0005\t\u0007G\u00199\u00021\u0001\u0002R\u0005i2m\\7nSR\u0014VmY8sI6+G/\u00193bi\u0006\fe\u000eZ(gMN,G\u000fC\u0004\u0004(5\"\ta!\u000b\u0002=\r|W\u000e\u001d7fi\u0016\u0004VM\u001c3j]\u001e$\u0006P\\(gMN,GoQ8n[&$H#\u0002.\u0004,\r5\u0002\u0002CB\u0003\u0007K\u0001\r!!\u001f\t\u0011\r=2Q\u0005a\u0001\u0003\u001b\u000b\u0001\"[:D_6l\u0017\u000e\u001e\u0005\b\u0007giC\u0011AB\u001b\u0003=\t7\r^5wKB\u0013x\u000eZ;dKJ\u001cXCAB\u001c!\u0019\u0011iEa\u0014\u0002z!911H\u0017\u0005\u0002\ru\u0012a\t5bgB+g\u000eZ5oO>3gm]3u\u0007>lW.\u001b;t\rJ|W\u000e\u0015:pIV\u001cWM\u001d\u000b\u0005\u0003\u001b\u001by\u0004\u0003\u0005\u0004\u0006\re\u0002\u0019AA=\u0011\u001d\u0019\u0019%\fC\u0001\u0007\u000b\nQB]3n_Z,wJ\u001a4tKR\u001cH\u0003BB$\u0007\u0017\u0002\u0002B!!\u0004J\u0005m\u00121M\u0005\u0004?\t\r\u0005\u0002CB'\u0007\u0003\u0002\raa\u0014\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004bA!\u0014\u0004R\u0005m\u0012\u0002BB*\u0003C\u00111aU3r\u0011\u001d\u00199&\fC\u0001\u00073\nAC]3n_Z,W\t\u001f9je\u0016$wJ\u001a4tKR\u001cH\u0003\u0002B~\u00077B\u0001b!\u0018\u0004V\u0001\u0007\u0011\u0011P\u0001\bgR\f'\u000f^'t\u0011\u001d\u0019\t'\fC\u0001\u0007G\n!\"\u00197m\u001f\u001a47/\u001a;t+\t\u00199\u0005C\u0004\u0003r6\"\taa\u001a\u0015\t\r%41\u000e\t\u0005\u001f\u0015\f\u0019\u0007\u0003\u0005\u0003b\u000e\u0015\u0004\u0019AA\u001e\u0011!\u0019y'\fC\u0001\u0005\rE\u0014\u0001G8gMN,GoV5uQJ+7m\u001c:e\u001b\u0016$\u0018\rZ1uCR!11OB;!\u0011yQ-!\u0015\t\u0011\t\u00058Q\u000ea\u0001\u0003wAaa!\u001f.\t\u0003y\u0017A\u00038v[>3gm]3ug\"91QP\u0017\u0005\u0002\u0005-\u0015A\u00035bg>3gm]3ug\"91\u0011Q\u0017\u0005\n\r\r\u0015!F1tg\u0016\u0014HOV1mS\u0012$&/\u00198tSRLwN\u001c\u000b\u00045\u000e\u0015\u0005bBBD\u0007\u007f\u0002\r!I\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\rC\u0004\u0004\f6\"\te!$\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\u000f\u0015\u0004[\rE\u0005c\u0001\u0019\u0004\u0014&\u00191QS\u0019\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0011\u00151\u0014\u00061\u00019\u0011\u0015q\u0014\u00061\u0001\"\u0011\u0015q\u0017\u00061\u0001q\u0011\u0015\u0011\u0017\u00061\u00019\u0011\u0019\t)!\u000ba\u0001q!)!0\u000ba\u0001q!9\u0011QC\u0015A\u0002\r\u0015\u0006CBBT\u0007g\u000bIC\u0004\u0003\u0004*\nmb\u0002BBV\u0007ck!a!,\u000b\u0007\r=\u0006\"\u0001\u0004=e>|GOP\u0005\u0002#%!1Q\u0017B\"\u0005!IE/\u001a:bE2,\u0007")
public class GroupMetadata
implements Logging {
    private final String groupId;
    private final ReentrantLock lock;
    private GroupState state;
    private Option<String> protocolType;
    private int generationId;
    private Option<String> kafka$coordinator$group$GroupMetadata$$leaderId;
    private Option<String> kafka$coordinator$group$GroupMetadata$$protocol;
    private final HashMap<String, MemberMetadata> members;
    private final HashMap<TopicPartition, CommitRecordMetadataAndOffset> kafka$coordinator$group$GroupMetadata$$offsets;
    private final HashMap<TopicPartition, OffsetAndMetadata> kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits;
    private final HashMap<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits;
    private boolean receivedTransactionalOffsetCommits;
    private boolean receivedConsumerOffsetCommits;
    private boolean newMemberAdded;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static GroupMetadata loadGroup(String string, GroupState groupState, int n, String string2, String string3, String string4, Iterable<MemberMetadata> iterable) {
        return GroupMetadata$.MODULE$.loadGroup(string, groupState, n, string2, string3, string4, iterable);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        GroupMetadata groupMetadata = this;
        synchronized (groupMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String groupId() {
        return this.groupId;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    private GroupState state() {
        return this.state;
    }

    private void state_$eq(GroupState x$1) {
        this.state = x$1;
    }

    public Option<String> protocolType() {
        return this.protocolType;
    }

    public void protocolType_$eq(Option<String> x$1) {
        this.protocolType = x$1;
    }

    public int generationId() {
        return this.generationId;
    }

    public void generationId_$eq(int x$1) {
        this.generationId = x$1;
    }

    private Option<String> kafka$coordinator$group$GroupMetadata$$leaderId() {
        return this.kafka$coordinator$group$GroupMetadata$$leaderId;
    }

    public void kafka$coordinator$group$GroupMetadata$$leaderId_$eq(Option<String> x$1) {
        this.kafka$coordinator$group$GroupMetadata$$leaderId = x$1;
    }

    public Option<String> kafka$coordinator$group$GroupMetadata$$protocol() {
        return this.kafka$coordinator$group$GroupMetadata$$protocol;
    }

    public void kafka$coordinator$group$GroupMetadata$$protocol_$eq(Option<String> x$1) {
        this.kafka$coordinator$group$GroupMetadata$$protocol = x$1;
    }

    private HashMap<String, MemberMetadata> members() {
        return this.members;
    }

    public HashMap<TopicPartition, CommitRecordMetadataAndOffset> kafka$coordinator$group$GroupMetadata$$offsets() {
        return this.kafka$coordinator$group$GroupMetadata$$offsets;
    }

    public HashMap<TopicPartition, OffsetAndMetadata> kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits() {
        return this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits;
    }

    public HashMap<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits() {
        return this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits;
    }

    private boolean receivedTransactionalOffsetCommits() {
        return this.receivedTransactionalOffsetCommits;
    }

    private void receivedTransactionalOffsetCommits_$eq(boolean x$1) {
        this.receivedTransactionalOffsetCommits = x$1;
    }

    private boolean receivedConsumerOffsetCommits() {
        return this.receivedConsumerOffsetCommits;
    }

    private void receivedConsumerOffsetCommits_$eq(boolean x$1) {
        this.receivedConsumerOffsetCommits = x$1;
    }

    public boolean newMemberAdded() {
        return this.newMemberAdded;
    }

    public void newMemberAdded_$eq(boolean x$1) {
        this.newMemberAdded = x$1;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public boolean is(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return !(groupState2 != null ? !groupState2.equals(groupState3) : groupState3 != null);
    }

    public boolean not(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return groupState2 != null ? !groupState2.equals(groupState3) : groupState3 != null;
    }

    public boolean has(String memberId) {
        return this.members().contains((Object)memberId);
    }

    public MemberMetadata get(String memberId) {
        return (MemberMetadata)this.members().apply((Object)memberId);
    }

    public boolean isLeader(String memberId) {
        return this.kafka$coordinator$group$GroupMetadata$$leaderId().contains((Object)memberId);
    }

    public String leaderOrNull() {
        return (String)this.kafka$coordinator$group$GroupMetadata$$leaderId().orNull(Predef$.MODULE$.$conforms());
    }

    public String protocolOrNull() {
        return (String)this.kafka$coordinator$group$GroupMetadata$$protocol().orNull(Predef$.MODULE$.$conforms());
    }

    public void add(MemberMetadata member) {
        if (this.members().isEmpty()) {
            this.protocolType_$eq((Option<String>)new Some((Object)member.protocolType()));
        }
        String string = this.groupId();
        String string2 = member.groupId();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Object object = this.protocolType().orNull(Predef$.MODULE$.$conforms());
        String string3 = member.protocolType();
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string3) : string3 != null));
        Predef$.MODULE$.assert(this.supportsProtocols(member.protocols()));
        if (this.kafka$coordinator$group$GroupMetadata$$leaderId().isEmpty()) {
            this.kafka$coordinator$group$GroupMetadata$$leaderId_$eq((Option<String>)new Some((Object)member.memberId()));
        }
        this.members().put((Object)member.memberId(), (Object)member);
    }

    public void remove(String memberId) {
        this.members().remove((Object)memberId);
        if (this.isLeader(memberId)) {
            this.kafka$coordinator$group$GroupMetadata$$leaderId_$eq((Option<String>)(this.members().isEmpty() ? None$.MODULE$ : new Some(this.members().keys().head())));
        }
    }

    public GroupState currentState() {
        return this.state();
    }

    public List<MemberMetadata> notYetRejoinedMembers() {
        return ((TraversableOnce)this.members().values().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MemberMetadata x$1) {
                return x$1.awaitingJoinCallback() == null;
            }
        })).toList();
    }

    public Set<String> allMembers() {
        return this.members().keySet();
    }

    public List<MemberMetadata> allMemberMetadata() {
        return this.members().values().toList();
    }

    public int rebalanceTimeoutMs() {
        return BoxesRunTime.unboxToInt((Object)this.members().values().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int timeout, MemberMetadata member) {
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(timeout), member.rebalanceTimeoutMs());
            }
        }));
    }

    public String generateMemberIdSuffix() {
        return UUID.randomUUID().toString();
    }

    public boolean canRebalance() {
        return ((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply((Object)PreparingRebalance$.MODULE$)).contains((Object)this.state());
    }

    public void transitionTo(GroupState groupState) {
        this.assertValidTransition(groupState);
        this.state_$eq(groupState);
    }

    public String selectProtocol() {
        if (this.members().isEmpty()) {
            throw new IllegalStateException("Cannot select protocol for empty group");
        }
        scala.collection.immutable.Set<String> candidates = this.candidateProtocols();
        List votes = ((TraversableLike)this.allMemberMetadata().map((Function1)new Serializable(this, candidates){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set candidates$1;

            public final String apply(MemberMetadata x$2) {
                return x$2.vote((scala.collection.immutable.Set<String>)this.candidates$1);
            }
            {
                this.candidates$1 = candidates$1;
            }
        }, List$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        }).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(List<String> x$3) {
                return x$3.size();
            }
        }).toList();
        return (String)((Tuple2)votes.maxBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<String, Object> x$4) {
                return x$4._2$mcI$sp();
            }
        }, (Ordering)Ordering.Int$.MODULE$))._1();
    }

    private scala.collection.immutable.Set<String> candidateProtocols() {
        return (scala.collection.immutable.Set)((LinearSeqOptimized)this.allMemberMetadata().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<String> apply(MemberMetadata x$5) {
                return x$5.protocols();
            }
        }, List$.MODULE$.canBuildFrom())).reduceLeft((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<String> apply(scala.collection.immutable.Set<String> commonProtocols, scala.collection.immutable.Set<String> protocols2) {
                return (scala.collection.immutable.Set)commonProtocols.$amp(protocols2);
            }
        });
    }

    public boolean supportsProtocols(scala.collection.immutable.Set<String> memberProtocols) {
        return this.members().isEmpty() || ((TraversableOnce)memberProtocols.$amp(this.candidateProtocols())).nonEmpty();
    }

    public void initNextGeneration() {
        List<MemberMetadata> list = this.notYetRejoinedMembers();
        List list2 = List$.MODULE$.empty();
        Predef$.MODULE$.assert(!(list != null ? !list.equals((Object)list2) : list2 != null));
        if (this.members().nonEmpty()) {
            this.generationId_$eq(this.generationId() + 1);
            this.kafka$coordinator$group$GroupMetadata$$protocol_$eq((Option<String>)new Some((Object)this.selectProtocol()));
            this.transitionTo(AwaitingSync$.MODULE$);
        } else {
            this.generationId_$eq(this.generationId() + 1);
            this.kafka$coordinator$group$GroupMetadata$$protocol_$eq((Option<String>)None$.MODULE$);
            this.transitionTo(Empty$.MODULE$);
        }
        this.receivedConsumerOffsetCommits_$eq(false);
        this.receivedTransactionalOffsetCommits_$eq(false);
    }

    public scala.collection.immutable.Map<String, byte[]> currentMemberMetadata() {
        if (this.is(Dead$.MODULE$) || this.is(PreparingRebalance$.MODULE$)) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Cannot obtain member metadata for group in state %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state()})));
        }
        return ((TraversableOnce)this.members().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadata $outer;

            public final Tuple2<String, byte[]> apply(Tuple2<String, MemberMetadata> x0$1) {
                Tuple2<String, MemberMetadata> tuple2 = x0$1;
                if (tuple2 != null) {
                    String memberId = (String)tuple2._1();
                    MemberMetadata memberMetadata = (MemberMetadata)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)memberId, (Object)memberMetadata.metadata((String)this.$outer.kafka$coordinator$group$GroupMetadata$$protocol().get()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public GroupSummary summary() {
        GroupSummary groupSummary;
        if (this.is(Stable$.MODULE$)) {
            String protocol = this.protocolOrNull();
            if (protocol == null) {
                throw new IllegalStateException("Invalid null group protocol for stable group");
            }
            Iterable members = (Iterable)this.members().values().map((Function1)new Serializable(this, protocol){
                public static final long serialVersionUID = 0L;
                private final String protocol$1;

                public final MemberSummary apply(MemberMetadata member) {
                    return member.summary(this.protocol$1);
                }
                {
                    this.protocol$1 = protocol$1;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            groupSummary = new GroupSummary(this.state().toString(), (String)this.protocolType().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }), protocol, (List<MemberSummary>)members.toList());
        } else {
            Iterable members = (Iterable)this.members().values().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final MemberSummary apply(MemberMetadata member) {
                    return member.summaryNoMetadata();
                }
            }, Iterable$.MODULE$.canBuildFrom());
            groupSummary = new GroupSummary(this.state().toString(), (String)this.protocolType().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }), GroupCoordinator$.MODULE$.NoProtocol(), (List<MemberSummary>)members.toList());
        }
        return groupSummary;
    }

    public GroupOverview overview() {
        return new GroupOverview(this.groupId(), (String)this.protocolType().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }));
    }

    public void initializeOffsets(Map<TopicPartition, CommitRecordMetadataAndOffset> offsets, scala.collection.immutable.Map<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTxnOffsets) {
        this.kafka$coordinator$group$GroupMetadata$$offsets().$plus$plus$eq(offsets);
        this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().$plus$plus$eq(pendingTxnOffsets);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onOffsetCommitAppend(TopicPartition topicPartition, CommitRecordMetadataAndOffset offsetWithCommitRecordMetadata) {
        Object object;
        if (this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().contains((Object)topicPartition)) {
            if (offsetWithCommitRecordMetadata.appendedBatchOffset().isEmpty()) {
                throw new IllegalStateException("Cannot complete offset commit write without providing the metadata of the record in the log.");
            }
            object = this.kafka$coordinator$group$GroupMetadata$$offsets().contains((Object)topicPartition) && !((CommitRecordMetadataAndOffset)this.kafka$coordinator$group$GroupMetadata$$offsets().apply((Object)topicPartition)).olderThan(offsetWithCommitRecordMetadata) ? BoxedUnit.UNIT : this.kafka$coordinator$group$GroupMetadata$$offsets().put((Object)topicPartition, (Object)offsetWithCommitRecordMetadata);
        } else {
            object = BoxedUnit.UNIT;
        }
        Option option = this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().get((Object)topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetAndMetadata stagedOffset = (OffsetAndMetadata)some.x();
            OffsetAndMetadata offsetAndMetadata = offsetWithCommitRecordMetadata.offsetAndMetadata();
            OffsetAndMetadata offsetAndMetadata2 = stagedOffset;
            if (!(offsetAndMetadata != null ? !((Object)offsetAndMetadata).equals(offsetAndMetadata2) : offsetAndMetadata2 != null)) {
                this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().remove((Object)topicPartition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void failPendingOffsetWrite(TopicPartition topicPartition, OffsetAndMetadata offset2) {
        Option option = this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().get((Object)topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetAndMetadata pendingOffset = (OffsetAndMetadata)some.x();
            OffsetAndMetadata offsetAndMetadata = offset2;
            OffsetAndMetadata offsetAndMetadata2 = pendingOffset;
            if (!(offsetAndMetadata != null ? !((Object)offsetAndMetadata).equals(offsetAndMetadata2) : offsetAndMetadata2 != null)) {
                this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().remove((Object)topicPartition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void prepareOffsetCommit(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.receivedConsumerOffsetCommits_$eq(true);
        this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().$plus$plus$eq(offsets);
    }

    public void prepareTxnOffsetCommit(long producerId, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.trace((Function0<String>)new Serializable(this, producerId, offsets){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadata $outer;
            private final long producerId$1;
            private final scala.collection.immutable.Map offsets$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " is pending"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId$1), this.$outer.groupId(), this.offsets$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerId$1 = producerId$1;
                this.offsets$1 = offsets$1;
            }
        });
        this.receivedTransactionalOffsetCommits_$eq(true);
        scala.collection.mutable.Map producerOffsets = (scala.collection.mutable.Map)this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)producerId), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset> apply() {
                return Map$.MODULE$.empty();
            }
        });
        offsets.foreach((Function1)new Serializable(this, producerOffsets){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map producerOffsets$1;

            public final Option<CommitRecordMetadataAndOffset> apply(Tuple2<TopicPartition, OffsetAndMetadata> x0$2) {
                Tuple2<TopicPartition, OffsetAndMetadata> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)tuple2._2();
                    Option option = this.producerOffsets$1.put((Object)topicPartition, (Object)new CommitRecordMetadataAndOffset((Option<Object>)None$.MODULE$, offsetAndMetadata));
                    return option;
                }
                throw new MatchError(tuple2);
            }
            {
                this.producerOffsets$1 = producerOffsets$1;
            }
        });
    }

    public boolean hasReceivedConsistentOffsetCommits() {
        return !this.receivedConsumerOffsetCommits() || !this.receivedTransactionalOffsetCommits();
    }

    public void failPendingTxnOffsetCommit(long producerId, TopicPartition topicPartition) {
        Option option = this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().get((Object)BoxesRunTime.boxToLong((long)producerId));
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            scala.collection.mutable.Map pendingOffsets = (scala.collection.mutable.Map)some.x();
            Option pendingOffsetCommit = pendingOffsets.remove((Object)topicPartition);
            this.trace((Function0<String>)new Serializable(this, producerId, pendingOffsetCommit){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GroupMetadata $outer;
                private final long producerId$2;
                private final Option pendingOffsetCommit$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " failed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId$2), this.$outer.groupId(), this.pendingOffsetCommit$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to be appended to the log"})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerId$2 = producerId$2;
                    this.pendingOffsetCommit$1 = pendingOffsetCommit$1;
                }
            });
            if (pendingOffsets.isEmpty()) {
                this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().remove((Object)BoxesRunTime.boxToLong((long)producerId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onTxnOffsetCommitAppend(long producerId, TopicPartition topicPartition, CommitRecordMetadataAndOffset commitRecordMetadataAndOffset) {
        block3: {
            block2: {
                var5_4 = this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().get((Object)BoxesRunTime.boxToLong((long)producerId));
                if (!(var5_4 instanceof Some)) break block2;
                var6_5 = (Some)var5_4;
                pendingOffset = (scala.collection.mutable.Map)var6_5.x();
                if (!pendingOffset.contains((Object)topicPartition)) ** GOTO lbl-1000
                v0 = ((CommitRecordMetadataAndOffset)pendingOffset.apply((Object)topicPartition)).offsetAndMetadata();
                var9_7 = commitRecordMetadataAndOffset.offsetAndMetadata();
                if (!(v0 != null ? v0.equals(var9_7) == false : var9_7 != null)) {
                    pendingOffset.update((Object)topicPartition, (Object)commitRecordMetadataAndOffset);
                    v1 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = BoxedUnit.UNIT;
                }
                var8_8 = v1;
                break block3;
            }
            var8_9 = BoxedUnit.UNIT;
        }
    }

    public void completePendingTxnOffsetCommit(long producerId, boolean isCommit) {
        Option pendingOffsetsOpt = this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().remove((Object)BoxesRunTime.boxToLong((long)producerId));
        if (isCommit) {
            pendingOffsetsOpt.foreach((Function1)new Serializable(this, producerId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GroupMetadata $outer;
                public final long producerId$3;

                public final void apply(scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset> pendingOffsets) {
                    pendingOffsets.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$completePendingTxnOffsetCommit$1 $outer;

                        public final Object apply(Tuple2<TopicPartition, CommitRecordMetadataAndOffset> x0$3) {
                            Tuple2<TopicPartition, CommitRecordMetadataAndOffset> tuple2 = x0$3;
                            if (tuple2 != null) {
                                BoxedUnit boxedUnit;
                                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                                CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
                                if (commitRecordMetadataAndOffset.appendedBatchOffset().isEmpty()) {
                                    throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to complete a transactional offset commit for producerId ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.producerId$3)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and groupId ", " even though the the offset commit record itself hasn't been appended to the log."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().groupId()}))).toString());
                                }
                                Option currentOffsetOpt = this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().kafka$coordinator$group$GroupMetadata$$offsets().get((Object)topicPartition);
                                if (currentOffsetOpt.forall((Function1)new Serializable(this, commitRecordMetadataAndOffset){
                                    public static final long serialVersionUID = 0L;
                                    private final CommitRecordMetadataAndOffset commitRecordMetadataAndOffset$1;

                                    public final boolean apply(CommitRecordMetadataAndOffset x$6) {
                                        return x$6.olderThan(this.commitRecordMetadataAndOffset$1);
                                    }
                                    {
                                        this.commitRecordMetadataAndOffset$1 = commitRecordMetadataAndOffset$1;
                                    }
                                })) {
                                    this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().trace((Function0<String>)new Serializable(this, commitRecordMetadataAndOffset){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$completePendingTxnOffsetCommit$1$$anonfun$apply$1 $outer;
                                        private final CommitRecordMetadataAndOffset commitRecordMetadataAndOffset$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$anonfun$$$outer().producerId$3), this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$anonfun$$$outer().kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().groupId(), this.commitRecordMetadataAndOffset$1}))).append((Object)"committed and loaded into the cache.").toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.commitRecordMetadataAndOffset$1 = commitRecordMetadataAndOffset$1;
                                        }
                                    });
                                    boxedUnit = this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().kafka$coordinator$group$GroupMetadata$$offsets().put((Object)topicPartition, (Object)commitRecordMetadataAndOffset);
                                } else {
                                    this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().trace((Function0<String>)new Serializable(this, commitRecordMetadataAndOffset, currentOffsetOpt){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$completePendingTxnOffsetCommit$1$$anonfun$apply$1 $outer;
                                        private final CommitRecordMetadataAndOffset commitRecordMetadataAndOffset$1;
                                        private final Option currentOffsetOpt$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$anonfun$$$outer().producerId$3), this.$outer.kafka$coordinator$group$GroupMetadata$$anonfun$$anonfun$$$outer().kafka$coordinator$group$GroupMetadata$$anonfun$$$outer().groupId(), this.commitRecordMetadataAndOffset$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"committed, but not loaded since its offset is older than current offset ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentOffsetOpt$1}))).toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.commitRecordMetadataAndOffset$1 = commitRecordMetadataAndOffset$1;
                                            this.currentOffsetOpt$1 = currentOffsetOpt$1;
                                        }
                                    });
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return boxedUnit2;
                            }
                            throw new MatchError(tuple2);
                        }

                        public /* synthetic */ $anonfun$completePendingTxnOffsetCommit$1 kafka$coordinator$group$GroupMetadata$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ GroupMetadata kafka$coordinator$group$GroupMetadata$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerId$3 = producerId$3;
                }
            });
        } else {
            this.trace((Function0<String>)new Serializable(this, producerId, pendingOffsetsOpt){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GroupMetadata $outer;
                private final long producerId$3;
                private final Option pendingOffsetsOpt$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " aborted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId$3), this.$outer.groupId(), this.pendingOffsetsOpt$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerId$3 = producerId$3;
                    this.pendingOffsetsOpt$1 = pendingOffsetsOpt$1;
                }
            });
        }
    }

    public Set<Object> activeProducers() {
        return this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().keySet();
    }

    public boolean hasPendingOffsetCommitsFromProducer(long producerId) {
        return this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().contains((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeOffsets(Seq<TopicPartition> topicPartitions) {
        return ((TraversableOnce)topicPartitions.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadata $outer;

            public final Iterable<Tuple2<TopicPartition, OffsetAndMetadata>> apply(TopicPartition topicPartition) {
                this.$outer.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().remove((Object)topicPartition);
                this.$outer.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().foreach((Function1)new Serializable(this, topicPartition){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$1;

                    public final Option<CommitRecordMetadataAndOffset> apply(Tuple2<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> x0$4) {
                        Tuple2<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> tuple2 = x0$4;
                        if (tuple2 != null) {
                            scala.collection.mutable.Map pendingOffsets = (scala.collection.mutable.Map)tuple2._2();
                            Option option = pendingOffsets.remove((Object)this.topicPartition$1);
                            return option;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.topicPartition$1 = topicPartition$1;
                    }
                });
                Option removedOffset = this.$outer.kafka$coordinator$group$GroupMetadata$$offsets().remove((Object)topicPartition);
                return Option$.MODULE$.option2Iterable(removedOffset.map((Function1)new Serializable(this, topicPartition){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$1;

                    public final Tuple2<TopicPartition, OffsetAndMetadata> apply(CommitRecordMetadataAndOffset x$7) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition$1), (Object)x$7.offsetAndMetadata());
                    }
                    {
                        this.topicPartition$1 = topicPartition$1;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeExpiredOffsets(long startMs) {
        HashMap expiredOffsets = (HashMap)((TraversableLike)this.kafka$coordinator$group$GroupMetadata$$offsets().filter((Function1)new Serializable(this, startMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadata $outer;
            private final long startMs$1;

            public final boolean apply(Tuple2<TopicPartition, CommitRecordMetadataAndOffset> x0$5) {
                Tuple2<TopicPartition, CommitRecordMetadataAndOffset> tuple2 = x0$5;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
                    boolean bl = commitRecordMetadataAndOffset.offsetAndMetadata().expireTimestamp() < this.startMs$1 && !this.$outer.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().contains((Object)topicPartition);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.startMs$1 = startMs$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, OffsetAndMetadata> apply(Tuple2<TopicPartition, CommitRecordMetadataAndOffset> x0$6) {
                Tuple2<TopicPartition, CommitRecordMetadataAndOffset> tuple2 = x0$6;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    CommitRecordMetadataAndOffset commitRecordOffsetAndMetadata = (CommitRecordMetadataAndOffset)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)commitRecordOffsetAndMetadata.offsetAndMetadata());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, HashMap$.MODULE$.canBuildFrom());
        this.kafka$coordinator$group$GroupMetadata$$offsets().$minus$minus$eq((TraversableOnce)expiredOffsets.keySet());
        return expiredOffsets.toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> allOffsets() {
        return ((TraversableOnce)this.kafka$coordinator$group$GroupMetadata$$offsets().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, OffsetAndMetadata> apply(Tuple2<TopicPartition, CommitRecordMetadataAndOffset> x0$7) {
                Tuple2<TopicPartition, CommitRecordMetadataAndOffset> tuple2 = x0$7;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)commitRecordMetadataAndOffset.offsetAndMetadata());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<OffsetAndMetadata> offset(TopicPartition topicPartition) {
        return this.kafka$coordinator$group$GroupMetadata$$offsets().get((Object)topicPartition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final OffsetAndMetadata apply(CommitRecordMetadataAndOffset x$8) {
                return x$8.offsetAndMetadata();
            }
        });
    }

    public Option<CommitRecordMetadataAndOffset> offsetWithRecordMetadata(TopicPartition topicPartition) {
        return this.kafka$coordinator$group$GroupMetadata$$offsets().get((Object)topicPartition);
    }

    public int numOffsets() {
        return this.kafka$coordinator$group$GroupMetadata$$offsets().size();
    }

    public boolean hasOffsets() {
        return this.kafka$coordinator$group$GroupMetadata$$offsets().nonEmpty() || this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits().nonEmpty() || this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits().nonEmpty();
    }

    private void assertValidTransition(GroupState targetState) {
        if (((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply((Object)targetState)).contains((Object)this.state())) {
            return;
        }
        throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Group %s should be in the %s states before moving to %s state. Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.groupId(), ((TraversableOnce)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply((Object)targetState)).mkString(","), targetState, this.state()})));
    }

    public String toString() {
        return new StringBuilder().append((Object)"GroupMetadata(").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"groupId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.groupId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"generation=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.generationId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"protocolType=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.protocolType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentState=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentState()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"members=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.members()}))).toString();
    }

    public GroupMetadata(String groupId, GroupState initialState) {
        this.groupId = groupId;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        this.state = initialState;
        this.protocolType = None$.MODULE$;
        this.generationId = 0;
        this.kafka$coordinator$group$GroupMetadata$$leaderId = None$.MODULE$;
        this.kafka$coordinator$group$GroupMetadata$$protocol = None$.MODULE$;
        this.members = new HashMap();
        this.kafka$coordinator$group$GroupMetadata$$offsets = new HashMap();
        this.kafka$coordinator$group$GroupMetadata$$pendingOffsetCommits = new HashMap();
        this.kafka$coordinator$group$GroupMetadata$$pendingTransactionalOffsetCommits = new HashMap();
        this.receivedTransactionalOffsetCommits = false;
        this.receivedConsumerOffsetCommits = false;
        this.newMemberAdded = false;
    }
}

