/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import kafka.log.BatchMetadata;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerStateEntry;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Crc32C;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ProducerStateManager$ {
    public static final ProducerStateManager$ MODULE$;
    private final short ProducerSnapshotVersion;
    private final String VersionField;
    private final String CrcField;
    private final String kafka$log$ProducerStateManager$$ProducerIdField;
    private final String kafka$log$ProducerStateManager$$LastSequenceField;
    private final String kafka$log$ProducerStateManager$$ProducerEpochField;
    private final String kafka$log$ProducerStateManager$$LastOffsetField;
    private final String kafka$log$ProducerStateManager$$OffsetDeltaField;
    private final String kafka$log$ProducerStateManager$$TimestampField;
    private final String kafka$log$ProducerStateManager$$ProducerEntriesField;
    private final String kafka$log$ProducerStateManager$$CoordinatorEpochField;
    private final String kafka$log$ProducerStateManager$$CurrentTxnFirstOffsetField;
    private final int VersionOffset;
    private final int CrcOffset;
    private final int ProducerEntriesOffset;
    private final Schema ProducerSnapshotEntrySchema;
    private final Schema PidSnapshotMapSchema;

    static {
        new ProducerStateManager$();
    }

    private short ProducerSnapshotVersion() {
        return this.ProducerSnapshotVersion;
    }

    private String VersionField() {
        return this.VersionField;
    }

    private String CrcField() {
        return this.CrcField;
    }

    public String kafka$log$ProducerStateManager$$ProducerIdField() {
        return this.kafka$log$ProducerStateManager$$ProducerIdField;
    }

    public String kafka$log$ProducerStateManager$$LastSequenceField() {
        return this.kafka$log$ProducerStateManager$$LastSequenceField;
    }

    public String kafka$log$ProducerStateManager$$ProducerEpochField() {
        return this.kafka$log$ProducerStateManager$$ProducerEpochField;
    }

    public String kafka$log$ProducerStateManager$$LastOffsetField() {
        return this.kafka$log$ProducerStateManager$$LastOffsetField;
    }

    public String kafka$log$ProducerStateManager$$OffsetDeltaField() {
        return this.kafka$log$ProducerStateManager$$OffsetDeltaField;
    }

    public String kafka$log$ProducerStateManager$$TimestampField() {
        return this.kafka$log$ProducerStateManager$$TimestampField;
    }

    public String kafka$log$ProducerStateManager$$ProducerEntriesField() {
        return this.kafka$log$ProducerStateManager$$ProducerEntriesField;
    }

    public String kafka$log$ProducerStateManager$$CoordinatorEpochField() {
        return this.kafka$log$ProducerStateManager$$CoordinatorEpochField;
    }

    public String kafka$log$ProducerStateManager$$CurrentTxnFirstOffsetField() {
        return this.kafka$log$ProducerStateManager$$CurrentTxnFirstOffsetField;
    }

    private int VersionOffset() {
        return this.VersionOffset;
    }

    private int CrcOffset() {
        return this.CrcOffset;
    }

    private int ProducerEntriesOffset() {
        return this.ProducerEntriesOffset;
    }

    public Schema ProducerSnapshotEntrySchema() {
        return this.ProducerSnapshotEntrySchema;
    }

    public Schema PidSnapshotMapSchema() {
        return this.PidSnapshotMapSchema;
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<ProducerStateEntry> readSnapshot(File file) {
        try {
            void var5_4;
            byte[] buffer = Files.readAllBytes(file.toPath());
            Struct struct = this.PidSnapshotMapSchema().read(ByteBuffer.wrap(buffer));
            Short version = struct.getShort(this.VersionField());
            if (BoxesRunTime.equalsNumObject((Number)version, (Object)BoxesRunTime.boxToShort((short)this.ProducerSnapshotVersion()))) {
                void var7_6;
                void var6_5;
                long computedCrc;
                Long crc = struct.getUnsignedInt(this.CrcField());
                if (BoxesRunTime.equalsNumObject((Number)crc, (Object)BoxesRunTime.boxToLong((long)(computedCrc = Crc32C.compute((byte[])buffer, (int)this.ProducerEntriesOffset(), (int)(buffer.length - this.ProducerEntriesOffset())))))) {
                    return (Iterable)Predef$.MODULE$.refArrayOps(struct.getArray(this.kafka$log$ProducerStateManager$$ProducerEntriesField())).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final ProducerStateEntry apply(Object producerEntryObj) {
                            Struct producerEntryStruct = (Struct)producerEntryObj;
                            long producerId = Predef$.MODULE$.Long2long(producerEntryStruct.getLong(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$ProducerIdField()));
                            Short producerEpoch = producerEntryStruct.getShort(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$ProducerEpochField());
                            Integer seq = producerEntryStruct.getInt(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$LastSequenceField());
                            Long offset2 = producerEntryStruct.getLong(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$LastOffsetField());
                            Long timestamp = producerEntryStruct.getLong(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$TimestampField());
                            Integer offsetDelta = producerEntryStruct.getInt(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$OffsetDeltaField());
                            Integer coordinatorEpoch = producerEntryStruct.getInt(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$CoordinatorEpochField());
                            Long currentTxnFirstOffset = producerEntryStruct.getLong(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$CurrentTxnFirstOffsetField());
                            ProducerStateEntry newEntry = new ProducerStateEntry(producerId, (Queue<BatchMetadata>)((Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{new BatchMetadata(Predef$.MODULE$.Integer2int(seq), Predef$.MODULE$.Long2long(offset2), Predef$.MODULE$.Integer2int(offsetDelta), Predef$.MODULE$.Long2long(timestamp))}))), Predef$.MODULE$.Short2short(producerEpoch), Predef$.MODULE$.Integer2int(coordinatorEpoch), (Option<Object>)(Predef$.MODULE$.Long2long(currentTxnFirstOffset) >= 0L ? new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(currentTxnFirstOffset))) : None$.MODULE$));
                            return newEntry;
                        }
                    }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                }
                throw new CorruptSnapshotException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Snapshot is corrupt (CRC is no longer valid). "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stored crc: ", ". Computed crc: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_5, BoxesRunTime.boxToLong((long)var7_6)}))).toString());
            }
            throw new CorruptSnapshotException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Snapshot contained an unknown file version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var5_4})));
        }
        catch (SchemaException schemaException) {
            throw new CorruptSnapshotException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Snapshot failed schema validation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schemaException.getMessage()})));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void kafka$log$ProducerStateManager$$writeSnapshot(File file, Map<Object, ProducerStateEntry> entries) {
        Struct struct = new Struct(this.PidSnapshotMapSchema());
        struct.set(this.VersionField(), (Object)BoxesRunTime.boxToShort((short)this.ProducerSnapshotVersion()));
        struct.set(this.CrcField(), (Object)BoxesRunTime.boxToLong((long)0L));
        Struct[] entriesArray = (Struct[])((TraversableOnce)entries.map((Function1)new Serializable(struct){
            public static final long serialVersionUID = 0L;
            private final Struct struct$1;

            public final Struct apply(Tuple2<Object, ProducerStateEntry> x0$1) {
                Tuple2<Object, ProducerStateEntry> tuple2 = x0$1;
                if (tuple2 != null) {
                    long producerId = tuple2._1$mcJ$sp();
                    ProducerStateEntry entry2 = (ProducerStateEntry)tuple2._2();
                    Struct producerEntryStruct = this.struct$1.instance(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$ProducerEntriesField());
                    producerEntryStruct.set(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$ProducerIdField(), (Object)BoxesRunTime.boxToLong((long)producerId)).set(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$ProducerEpochField(), (Object)BoxesRunTime.boxToShort((short)entry2.producerEpoch())).set(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$LastSequenceField(), (Object)BoxesRunTime.boxToInteger((int)entry2.lastSeq())).set(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$LastOffsetField(), (Object)BoxesRunTime.boxToLong((long)entry2.lastDataOffset())).set(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$OffsetDeltaField(), (Object)BoxesRunTime.boxToInteger((int)entry2.lastOffsetDelta())).set(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$TimestampField(), (Object)BoxesRunTime.boxToLong((long)entry2.lastTimestamp())).set(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$CoordinatorEpochField(), (Object)BoxesRunTime.boxToInteger((int)entry2.coordinatorEpoch())).set(ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$CurrentTxnFirstOffsetField(), entry2.currentTxnFirstOffset().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return -1L;
                        }
                    }));
                    Struct struct = producerEntryStruct;
                    return struct;
                }
                throw new MatchError(tuple2);
            }
            {
                this.struct$1 = struct$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Struct.class));
        struct.set(this.kafka$log$ProducerStateManager$$ProducerEntriesField(), (Object)entriesArray);
        ByteBuffer buffer = ByteBuffer.allocate(struct.sizeOf());
        struct.writeTo(buffer);
        buffer.flip();
        long crc = Crc32C.compute((ByteBuffer)buffer, (int)this.ProducerEntriesOffset(), (int)(buffer.limit() - this.ProducerEntriesOffset()));
        ByteUtils.writeUnsignedInt((ByteBuffer)buffer, (int)this.CrcOffset(), (long)crc);
        FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        try {
            fileChannel.write(buffer);
        }
        catch (Throwable throwable) {
            void var8_7;
            var8_7.close();
            throw throwable;
        }
        fileChannel.close();
    }

    public boolean kafka$log$ProducerStateManager$$isSnapshotFile(File file) {
        return file.getName().endsWith(Log$.MODULE$.ProducerSnapshotFileSuffix());
    }

    public Seq<File> listSnapshotFiles(File dir) {
        return dir.exists() && dir.isDirectory() ? (Seq)Option$.MODULE$.apply((Object)dir.listFiles()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply(File[] files) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File f) {
                        return f.isFile() && ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$isSnapshotFile(f);
                    }
                })).toSeq();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        }) : (Seq)Seq$.MODULE$.empty();
    }

    public void deleteSnapshotsBefore(File dir, long offset2) {
        this.kafka$log$ProducerStateManager$$deleteSnapshotFiles(dir, (Function1<Object, Object>)new Serializable(offset2){
            public static final long serialVersionUID = 0L;
            private final long offset$2;

            public final boolean apply(long x$2) {
                return this.apply$mcZJ$sp(x$2);
            }

            public boolean apply$mcZJ$sp(long x$2) {
                return x$2 < this.offset$2;
            }
            {
                this.offset$2 = offset$2;
            }
        });
    }

    public void kafka$log$ProducerStateManager$$deleteSnapshotFiles(File dir, Function1<Object, Object> predicate) {
        ((IterableLike)this.listSnapshotFiles(dir).filter((Function1)new Serializable(predicate){
            public static final long serialVersionUID = 0L;
            private final Function1 predicate$1;

            public final boolean apply(File file) {
                return this.predicate$1.apply$mcZJ$sp(Log$.MODULE$.offsetFromFile(file));
            }
            {
                this.predicate$1 = predicate$1;
            }
        })).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return Files.deleteIfExists(file.toPath());
            }
        });
    }

    public Function1<Object, Object> kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$3) {
                return this.apply$mcZJ$sp(x$3);
            }

            public boolean apply$mcZJ$sp(long x$3) {
                return true;
            }
        };
    }

    public int $lessinit$greater$default$3() {
        return 3600000;
    }

    private ProducerStateManager$() {
        MODULE$ = this;
        this.ProducerSnapshotVersion = 1;
        this.VersionField = "version";
        this.CrcField = "crc";
        this.kafka$log$ProducerStateManager$$ProducerIdField = "producer_id";
        this.kafka$log$ProducerStateManager$$LastSequenceField = "last_sequence";
        this.kafka$log$ProducerStateManager$$ProducerEpochField = "epoch";
        this.kafka$log$ProducerStateManager$$LastOffsetField = "last_offset";
        this.kafka$log$ProducerStateManager$$OffsetDeltaField = "offset_delta";
        this.kafka$log$ProducerStateManager$$TimestampField = "timestamp";
        this.kafka$log$ProducerStateManager$$ProducerEntriesField = "producer_entries";
        this.kafka$log$ProducerStateManager$$CoordinatorEpochField = "coordinator_epoch";
        this.kafka$log$ProducerStateManager$$CurrentTxnFirstOffsetField = "current_txn_first_offset";
        this.VersionOffset = 0;
        this.CrcOffset = this.VersionOffset() + 2;
        this.ProducerEntriesOffset = this.CrcOffset() + 4;
        this.ProducerSnapshotEntrySchema = new Schema(new Field[]{new Field(this.kafka$log$ProducerStateManager$$ProducerIdField(), (Type)Type.INT64, "The producer ID"), new Field(this.kafka$log$ProducerStateManager$$ProducerEpochField(), (Type)Type.INT16, "Current epoch of the producer"), new Field(this.kafka$log$ProducerStateManager$$LastSequenceField(), (Type)Type.INT32, "Last written sequence of the producer"), new Field(this.kafka$log$ProducerStateManager$$LastOffsetField(), (Type)Type.INT64, "Last written offset of the producer"), new Field(this.kafka$log$ProducerStateManager$$OffsetDeltaField(), (Type)Type.INT32, "The difference of the last sequence and first sequence in the last written batch"), new Field(this.kafka$log$ProducerStateManager$$TimestampField(), (Type)Type.INT64, "Max timestamp from the last written entry"), new Field(this.kafka$log$ProducerStateManager$$CoordinatorEpochField(), (Type)Type.INT32, "The epoch of the last transaction coordinator to send an end transaction marker"), new Field(this.kafka$log$ProducerStateManager$$CurrentTxnFirstOffsetField(), (Type)Type.INT64, "The first offset of the on-going transaction (-1 if there is none)")});
        this.PidSnapshotMapSchema = new Schema(new Field[]{new Field(this.VersionField(), (Type)Type.INT16, "Version of the snapshot file"), new Field(this.CrcField(), (Type)Type.UNSIGNED_INT32, "CRC of the snapshot data"), new Field(this.kafka$log$ProducerStateManager$$ProducerEntriesField(), (Type)new ArrayOf((Type)this.ProducerSnapshotEntrySchema()), "The entries in the producer table")});
    }
}

