/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Optional;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\r\u001da\u0001B\u0001\u0003\u0001\u001d\u0011ACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IA\u0004\r\u0002\t9\fW.\u001a\t\u0003\u001fUq!\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\ta\u0001\u0015:fI\u00164\u0017B\u0001\f\u0018\u0005\u0019\u0019FO]5oO*\u0011A#E\u0005\u0003\u001beI!AG\u000e\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0006\u00039\u0011\tQ!\u001e;jYND\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"\u0001\u0005\u0011\n\u0005\u0005\n\"aA%oi\"I1\u0005\u0001B\u0001B\u0003%AEK\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003K!j\u0011A\n\u0006\u0003O\u0011\tqa\u00197vgR,'/\u0003\u0002*M\tq!I]8lKJ,e\u000e\u001a)pS:$\u0018BA\u0012\u000b\u0011!a\u0003A!A!\u0002\u0013i\u0013\u0001\u00042s_.,'oQ8oM&<\u0007CA\u0005/\u0013\ty#AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\bCA\u00054\u0013\t!$A\u0001\tGC&dW\r\u001a)beRLG/[8og\"Aa\u0007\u0001B\u0001B\u0003%q'\u0001\u0006sKBd\u0017nY1NOJ\u0004\"!\u0003\u001d\n\u0005e\u0012!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u00059Q.\u001a;sS\u000e\u001c\bCA\u001fG\u001b\u0005q$BA\u001e@\u0015\t\u0001\u0015)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\tS!a\u0011#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0015aA8sO&\u0011qI\u0010\u0002\b\u001b\u0016$(/[2t\u0011!I\u0005A!A!\u0002\u0013Q\u0015\u0001\u0002;j[\u0016\u0004\"aS'\u000e\u00031S!\u0001H \n\u00059c%\u0001\u0002+j[\u0016D\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!U\u0001\u0006cV|G/\u0019\t\u0003\u0013IK!a\u0015\u0002\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\t\u0011U\u0003!\u0011!Q\u0001\nY\u000b!\u0004\\3bI\u0016\u0014XI\u001c3q_&tGO\u00117pG.LgnZ*f]\u0012\u00042\u0001E,Z\u0013\tA\u0016C\u0001\u0004PaRLwN\u001c\t\u0003\u0013iK!a\u0017\u0002\u0003\u0019\tcwnY6j]\u001e\u001cVM\u001c3\t\u000bu\u0003A\u0011\u00010\u0002\rqJg.\u001b;?)-y\u0006-\u00192dI\u00164w\r[5\u0011\u0005%\u0001\u0001\"B\u0007]\u0001\u0004q\u0001\"\u0002\u0010]\u0001\u0004y\u0002\"B\u0012]\u0001\u0004!\u0003\"\u0002\u0017]\u0001\u0004i\u0003\"B\u0019]\u0001\u0004\u0011\u0004\"\u0002\u001c]\u0001\u00049\u0004\"B\u001e]\u0001\u0004a\u0004\"B%]\u0001\u0004Q\u0005\"\u0002)]\u0001\u0004\t\u0006bB+]!\u0003\u0005\rA\u0016\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0003%\u0011X\r\u001d7jG\u0006LE-F\u0001 \u0011\u0019q\u0007\u0001)A\u0005?\u0005Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\t\u000fA\u0004!\u0019!C\u0005c\u0006QAn\\4D_:$X\r\u001f;\u0016\u0003I\u0004\"aS:\n\u0005Qd%A\u0003'pO\u000e{g\u000e^3yi\"1a\u000f\u0001Q\u0001\nI\f1\u0002\\8h\u0007>tG/\u001a=uA!9\u0001\u0010\u0001b\u0001\n\u0013I\u0018A\u00047fC\u0012,'/\u00128ea>Lg\u000e^\u000b\u00023\"11\u0010\u0001Q\u0001\ne\u000bq\u0002\\3bI\u0016\u0014XI\u001c3q_&tG\u000f\t\u0005\t{\u0002\u0011\r\u0011\"\u0001\u0003}\u0006\u0019b-\u001a;dQJ+\u0017/^3tiZ+'o]5p]V\tq\u0010E\u0002\u0011\u0003\u0003I1!a\u0001\u0012\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\t9\u0001\u0001Q\u0001\n}\fACZ3uG\"\u0014V-];fgR4VM]:j_:\u0004\u0003\"CA\u0006\u0001\t\u0007I\u0011\u0001\u0002\u007f\u0003\tzgMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3tiZ+'o]5p]\"9\u0011q\u0002\u0001!\u0002\u0013y\u0018aI8gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cHOV3sg&|g\u000e\t\u0005\n\u0003'\u0001!\u0019!C\u0001\u0005y\f\u0001\u0004\\5ti>3gm]3u%\u0016\fX/Z:u-\u0016\u00148/[8o\u0011\u001d\t9\u0002\u0001Q\u0001\n}\f\u0011\u0004\\5ti>3gm]3u%\u0016\fX/Z:u-\u0016\u00148/[8oA!I\u00111\u0004\u0001C\u0002\u0013%\u0011QD\u0001\b[\u0006Dx+Y5u+\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\t1\fgn\u001a\u0006\u0003\u0003S\tAA[1wC&!\u0011QFA\u0012\u0005\u001dIe\u000e^3hKJD\u0001\"!\r\u0001A\u0003%\u0011qD\u0001\t[\u0006Dx+Y5uA!I\u0011Q\u0007\u0001C\u0002\u0013%\u0011QD\u0001\t[&t')\u001f;fg\"A\u0011\u0011\b\u0001!\u0002\u0013\ty\"A\u0005nS:\u0014\u0015\u0010^3tA!I\u0011Q\b\u0001C\u0002\u0013%\u0011QD\u0001\t[\u0006D()\u001f;fg\"A\u0011\u0011\t\u0001!\u0002\u0013\ty\"A\u0005nCb\u0014\u0015\u0010^3tA!I\u0011Q\t\u0001C\u0002\u0013%\u0011QD\u0001\nM\u0016$8\r[*ju\u0016D\u0001\"!\u0013\u0001A\u0003%\u0011qD\u0001\u000bM\u0016$8\r[*ju\u0016\u0004\u0003\"CA'\u0001\t\u0007I\u0011BA(\u0003\u0001\u0012'o\\6feN+\b\u000f]8siNdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;\u0016\u0005\u0005E\u0003c\u0001\t\u0002T%\u0019\u0011QK\t\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\f\u0001!\u0002\u0013\t\t&A\u0011ce>\\WM]*vaB|'\u000f^:MK\u0006$WM]#q_\u000eD'+Z9vKN$\b\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0003\u0002`\u0005\u0019b-\u001a;dQN+7o]5p]\"\u000bg\u000e\u001a7feV\u0011\u0011\u0011\r\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011qM!\u0002\u000f\rd\u0017.\u001a8ug&!\u00111NA3\u0005M1U\r^2i'\u0016\u001c8/[8o\u0011\u0006tG\r\\3s\u0011!\ty\u0007\u0001Q\u0001\n\u0005\u0005\u0014\u0001\u00064fi\u000eD7+Z:tS>t\u0007*\u00198eY\u0016\u0014\b\u0005C\u0004\u0002t\u0001!\t&!\u001e\u0002\u00171\fG/Z:u\u000bB|7\r\u001b\u000b\u0005\u0003o\nI\bE\u0002\u0011/~A\u0001\"a\u001f\u0002r\u0001\u0007\u0011QP\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\ty(!!\u000e\u0003}J1!a!@\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a\"\u0001\t#\nI)\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000f\u0006\u0003\u0002\f\u0006E\u0005c\u0001\t\u0002\u000e&\u0019\u0011qR\t\u0003\t1{gn\u001a\u0005\t\u0003w\n)\t1\u0001\u0002~!9\u0011Q\u0013\u0001\u0005R\u0005]\u0015!E3oI>3gm]3u\r>\u0014X\t]8dQR1\u0011\u0011TAQ\u0003G\u0003B\u0001E,\u0002\u001cB\u0019\u0011\"!(\n\u0007\u0005}%A\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u0011\u0005m\u00141\u0013a\u0001\u0003{Bq!!*\u0002\u0014\u0002\u0007q$A\u0003fa>\u001c\u0007\u000eC\u0004\u0002*\u0002!\t%a+\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGCAA)\u0011\u001d\ty\u000b\u0001C!\u0003c\u000bQ\"Y<bSR\u001c\u0006.\u001e;e_^tGCAAZ!\r\u0001\u0012QW\u0005\u0004\u0003o\u000b\"\u0001B+oSRDq!a/\u0001\t\u0003\ni,\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0003\u007f\u000bi-a4\u0002TB!\u0001cVAa!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'bAAd\t\u0005\u0019An\\4\n\t\u0005-\u0017Q\u0019\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u0011\u0005m\u0014\u0011\u0018a\u0001\u0003{B\u0001\"!5\u0002:\u0002\u0007\u00111R\u0001\fM\u0016$8\r[(gMN,G\u000f\u0003\u0005\u0002V\u0006e\u0006\u0019AAl\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!\u0011\u0011\\An\u001b\u0005\u0001\u0011bAAo\u0015\tIa)\u001a;dQ\u0012\u000bG/\u0019\u0005\b\u0003C\u0004A\u0011AAr\u0003mi\u0017-\u001f2f/\u0006\u0014h.\u00134Pm\u0016\u00148/\u001b>fIJ+7m\u001c:egR1\u00111WAs\u0003kD\u0001\"a:\u0002`\u0002\u0007\u0011\u0011^\u0001\be\u0016\u001cwN\u001d3t!\u0011\tY/!=\u000e\u0005\u00055(bAAx\u007f\u00051!/Z2pe\u0012LA!a=\u0002n\niQ*Z7pef\u0014VmY8sIND\u0001\"a\u001f\u0002`\u0002\u0007\u0011Q\u0010\u0005\b\u0003s\u0004A\u0011KA~\u0003=1W\r^2i\rJ|W\u000eT3bI\u0016\u0014H\u0003BA\u007f\u00057\u0001b!a@\u0003\u0010\tUa\u0002\u0002B\u0001\u0005\u0017qAAa\u0001\u0003\n5\u0011!Q\u0001\u0006\u0004\u0005\u000f1\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\r\u0011i!E\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\tBa\u0005\u0003\u0007M+\u0017OC\u0002\u0003\u000eE\u0001r\u0001\u0005B\f\u0003{\n9.C\u0002\u0003\u001aE\u0011a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\u000f\u0003o\u0004\rAa\b\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\t\u0005\"Q\u0006\b\u0005\u0005G\u0011I#\u0004\u0002\u0003&)\u0019!qE \u0002\u0011I,\u0017/^3tiNLAAa\u000b\u0003&\u0005aa)\u001a;dQJ+\u0017/^3ti&!!q\u0006B\u0019\u0005\u001d\u0011U/\u001b7eKJTAAa\u000b\u0003&!9!Q\u0007\u0001\u0005R\t]\u0012!\b4fi\u000eDW)\u0019:mS\u0016\u001cHo\u00144gg\u0016$hI]8n\u0019\u0016\fG-\u001a:\u0015\r\u0005-%\u0011\bB\u001e\u0011!\tYHa\rA\u0002\u0005u\u0004b\u0002B\u001f\u0005g\u0001\raH\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0004\u0003B\u0001!\tFa\u0011\u00027\u0019,Go\u00195MCR,7\u000f^(gMN,GO\u0012:p[2+\u0017\rZ3s)\u0019\tYI!\u0012\u0003H!A\u00111\u0010B \u0001\u0004\ti\bC\u0004\u0003>\t}\u0002\u0019A\u0010\t\u000f\t-\u0003\u0001\"\u0003\u0003N\u0005)b-\u001a;dQ>3gm]3u\rJ|W\u000eT3bI\u0016\u0014H\u0003CAF\u0005\u001f\u0012\tFa\u0015\t\u0011\u0005m$\u0011\na\u0001\u0003{BqA!\u0010\u0003J\u0001\u0007q\u0004\u0003\u0005\u0003V\t%\u0003\u0019AAF\u0003A)\u0017M\u001d7jKN$xJ\u001d'bi\u0016\u001cH\u000fC\u0004\u0003Z\u0001!\tEa\u0017\u0002\u0015\t,\u0018\u000e\u001c3GKR\u001c\u0007\u000e\u0006\u0003\u0003^\tU\u0004C\u0002B0\u0005[\u0012\u0019H\u0004\u0003\u0003b\t%d\u0002\u0002B2\u0005OrAAa\u0001\u0003f%\tQ!\u0003\u0002\u0004\t%\u0019!1\u000e\u0002\u0002+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI&!!q\u000eB9\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8og*\u0019!1\u000e\u0002\u0011\tA9&q\u0004\u0005\t\u0005o\u00129\u00061\u0001\u0003z\u0005a\u0001/\u0019:uSRLwN\\'baBA!1\u0010BA\u0003{\u0012))\u0004\u0002\u0003~)\u0019!qP\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0004\nu$aA'baB\u0019\u0011Ba\"\n\u0007\t%%AA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X\rC\u0004\u0003\u000e\u0002!\tEa$\u0002\u0011Q\u0014XO\\2bi\u0016$b!a-\u0003\u0012\nU\u0005\u0002\u0003BJ\u0005\u0017\u0003\r!! \u0002\u0005Q\u0004\b\u0002\u0003BL\u0005\u0017\u0003\rA!'\u0002+=4gm]3u)J,hnY1uS>t7\u000b^1uKB\u0019\u0011Ba'\n\u0007\tu%AA\u000bPM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\t\u000f\t\u0005\u0006\u0001\"\u0015\u0003$\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0007\u0003g\u0013)Ka*\t\u0011\u0005m$q\u0014a\u0001\u0003{B\u0001B!+\u0003 \u0002\u0007\u00111R\u0001\u0007_\u001a47/\u001a;\t\u000f\t5\u0006\u0001\"\u0011\u00030\u0006!b-\u001a;dQ\u0016\u0003xn\u00195F]\u0012|eMZ:fiN$BA!-\u0003:BA!1\u0010BA\u0003{\u0012\u0019\f\u0005\u0003\u0003$\tU\u0016\u0002\u0002B\\\u0005K\u0011a\"\u00129pG\",e\u000eZ(gMN,G\u000f\u0003\u0005\u0003<\n-\u0006\u0019\u0001B_\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\t\u0005w\u0012\t)! \u0003@B!\u0011\u0011\u001cBa\u0013\r\u0011\u0019M\u0003\u0002\n\u000bB|7\r\u001b#bi\u0006DqAa2\u0001\t\u0003\ny%A\u0010jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012DqAa3\u0001\t\u0013\u0011i-\u0001\ftQ>,H\u000e\u001a$pY2|w/\u001a:UQJ|G\u000f\u001e7f)\u0019\t\tFa4\u0003R\"1\u0001K!3A\u0002EC\u0001\"a\u001f\u0003J\u0002\u0007\u0011Q\u0010\u0005\u000e\u0005+\u0004\u0001\u0013aA\u0001\u0002\u0013%!q\u001b\u0016\u0002%M,\b/\u001a:%g>,(oY3Ce>\\WM]\u000b\u0002I\u001dI!1\u001c\u0002\u0002\u0002#\u0005!Q\\\u0001\u0015%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193\u0011\u0007%\u0011yN\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001Bq'\u0011\u0011yNa9\u0011\u0007A\u0011)/C\u0002\u0003hF\u0011a!\u00118z%\u00164\u0007bB/\u0003`\u0012\u0005!1\u001e\u000b\u0003\u0005;D!Ba<\u0003`F\u0005I\u0011\u0001By\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA*\"Aa=+\u0007Y\u0013)p\u000b\u0002\u0003xB!!\u0011`B\u0002\u001b\t\u0011YP\u0003\u0003\u0003~\n}\u0018!C;oG\",7m[3e\u0015\r\u0019\t!E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0003\u0005w\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    public final int kafka$server$ReplicaFetcherThread$$fetcherId;
    public final KafkaConfig kafka$server$ReplicaFetcherThread$$brokerConfig;
    public final ReplicaManager kafka$server$ReplicaFetcherThread$$replicaMgr;
    public final Metrics kafka$server$ReplicaFetcherThread$$metrics;
    public final Time kafka$server$ReplicaFetcherThread$$time;
    public final ReplicaQuota kafka$server$ReplicaFetcherThread$$quota;
    private final int kafka$server$ReplicaFetcherThread$$replicaId;
    private final LogContext kafka$server$ReplicaFetcherThread$$logContext;
    private final BlockingSend kafka$server$ReplicaFetcherThread$$leaderEndpoint;
    private final short fetchRequestVersion;
    private final short offsetForLeaderEpochRequestVersion;
    private final short listOffsetRequestVersion;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer kafka$server$ReplicaFetcherThread$$fetchSize;
    private final boolean brokerSupportsLeaderEpochRequest;
    private final FetchSessionHandler fetchSessionHandler;

    public static Option<BlockingSend> $lessinit$greater$default$10() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
    }

    public /* synthetic */ BrokerEndPoint kafka$server$ReplicaFetcherThread$$super$sourceBroker() {
        return super.sourceBroker();
    }

    public int kafka$server$ReplicaFetcherThread$$replicaId() {
        return this.kafka$server$ReplicaFetcherThread$$replicaId;
    }

    public LogContext kafka$server$ReplicaFetcherThread$$logContext() {
        return this.kafka$server$ReplicaFetcherThread$$logContext;
    }

    public BlockingSend kafka$server$ReplicaFetcherThread$$leaderEndpoint() {
        return this.kafka$server$ReplicaFetcherThread$$leaderEndpoint;
    }

    public short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    public short offsetForLeaderEpochRequestVersion() {
        return this.offsetForLeaderEpochRequestVersion;
    }

    public short listOffsetRequestVersion() {
        return this.listOffsetRequestVersion;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    public Integer kafka$server$ReplicaFetcherThread$$fetchSize() {
        return this.kafka$server$ReplicaFetcherThread$$fetchSize;
    }

    private boolean brokerSupportsLeaderEpochRequest() {
        return this.brokerSupportsLeaderEpochRequest;
    }

    private FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.kafka$server$ReplicaFetcherThread$$replicaMgr.localReplicaOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.kafka$server$ReplicaFetcherThread$$replicaMgr.localReplicaOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.kafka$server$ReplicaFetcherThread$$replicaMgr.localReplicaOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().initiateClose();
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaFetcherThread $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to initiate shutdown of leader endpoint ", " after initiating replica fetcher thread shutdown"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$ReplicaFetcherThread$$leaderEndpoint()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable t$1;

                    public final Throwable apply() {
                        return this.t$1;
                    }
                    {
                        this.t$1 = t$1;
                    }
                });
            }
        }
        return (boolean)var1_1;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().close();
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaFetcherThread $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to close leader endpoint ", " after shutting down replica fetcher thread"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$ReplicaFetcherThread$$leaderEndpoint()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$2;

                public final Throwable apply() {
                    return this.t$2;
                }
                {
                    this.t$2 = t$2;
                }
            });
        }
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Replica replica = this.kafka$server$ReplicaFetcherThread$$replicaMgr.localReplicaOrException(topicPartition);
        Partition partition = (Partition)this.kafka$server$ReplicaFetcherThread$$replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != replica.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)replica.logEndOffset())})));
        }
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)new Serializable(this, topicPartition, partitionData, replica, records){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final FetchResponse.PartitionData partitionData$1;
                private final Replica replica$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.replica$1.logEndOffset()), this.topicPartition$1, BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.partitionData$1.highWatermark)}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.partitionData$1 = partitionData$1;
                    this.replica$1 = replica$1;
                    this.records$1 = records$1;
                }
            });
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)new Serializable(this, topicPartition, replica, records){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final Replica replica$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.replica$1.logEndOffset()), BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), this.topicPartition$1}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.replica$1 = replica$1;
                    this.records$1 = records$1;
                }
            });
        }
        long followerHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(replica.logEndOffset()), partitionData.highWatermark);
        long leaderLogStartOffset = partitionData.logStartOffset;
        replica.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        replica.maybeIncrementLogStartOffset(leaderLogStartOffset);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)new Serializable(this, topicPartition, followerHighWatermark){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final long followerHighWatermark$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower set replica high watermark for partition ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, BoxesRunTime.boxToLong((long)this.followerHighWatermark$1)}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.followerHighWatermark$1 = followerHighWatermark$1;
                }
            });
        }
        if (this.kafka$server$ReplicaFetcherThread$$quota.isThrottled(topicPartition)) {
            this.kafka$server$ReplicaFetcherThread$$quota.record(records.sizeInBytes());
        }
        this.kafka$server$ReplicaFetcherThread$$replicaMgr.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        return logAppendInfo;
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (this.fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$2}))).append((Object)"This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append((Object)"message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append((Object)"equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString();
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                }
            });
        }
    }

    @Override
    public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        try {
            ClientResponse clientResponse = this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
            FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
            return this.fetchSessionHandler().handleResponse(fetchResponse) ? ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData()).asScala()).toSeq() : Nil$.MODULE$;
        }
        catch (Throwable throwable) {
            this.fetchSessionHandler().handleError(throwable);
            throw throwable;
        }
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -2L);
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -1L);
    }

    private long fetchOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch, long earliestOrLatest) {
        ListOffsetRequest.PartitionData requestPartitionData = new ListOffsetRequest.PartitionData(earliestOrLatest, Optional.of(Predef$.MODULE$.int2Integer(currentLeaderEpoch)));
        Map requestPartitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)requestPartitionData)}));
        ListOffsetRequest.Builder requestBuilder = ListOffsetRequest.Builder.forReplica((short)this.listOffsetRequestVersion(), (int)this.kafka$server$ReplicaFetcherThread$$replicaId()).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(requestPartitions).asJava());
        ClientResponse clientResponse = this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder);
        ListOffsetResponse response = (ListOffsetResponse)clientResponse.responseBody();
        ListOffsetResponse.PartitionData responsePartitionData = (ListOffsetResponse.PartitionData)response.responseData().get(topicPartition);
        Errors errors = responsePartitionData.error;
        if (Errors.NONE.equals(errors)) {
            long l = this.kafka$server$ReplicaFetcherThread$$brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(responsePartitionData.offset) : Predef$.MODULE$.Long2long((Long)responsePartitionData.offsets.get(0));
            return l;
        }
        throw errors.exception();
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        None$ none$;
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder();
        partitionMap.foreach((Function1)new Serializable(this, partitionsWithError, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;
            private final scala.collection.mutable.Set partitionsWithError$1;
            private final FetchSessionHandler.Builder builder$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(Tuple2<TopicPartition, PartitionFetchState> x0$1) {
                BoxedUnit boxedUnit;
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                PartitionFetchState fetchState2 = (PartitionFetchState)tuple2._2();
                if (fetchState2.isReadyForFetch() && !this.$outer.kafka$server$ReplicaFetcherThread$$shouldFollowerThrottle(this.$outer.kafka$server$ReplicaFetcherThread$$quota, topicPartition)) {
                    try {
                        long logStartOffset2 = this.$outer.kafka$server$ReplicaFetcherThread$$replicaMgr.localReplicaOrException(topicPartition).logStartOffset();
                        this.builder$1.add(topicPartition, new FetchRequest.PartitionData(fetchState2.fetchOffset(), logStartOffset2, Predef$.MODULE$.Integer2int(this.$outer.kafka$server$ReplicaFetcherThread$$fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState2.currentLeaderEpoch()))));
                        boxedUnit = BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        boxedUnit = this.partitionsWithError$1.$plus$eq((Object)topicPartition);
                    }
                    return boxedUnit;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionsWithError$1 = partitionsWithError$1;
                this.builder$1 = builder$1;
            }
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        if (fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)this.fetchRequestVersion(), (int)this.kafka$server$ReplicaFetcherThread$$replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget()).metadata(fetchData.metadata());
            none$ = new Some((Object)requestBuilder);
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Replica replica = this.kafka$server$ReplicaFetcherThread$$replicaMgr.localReplicaOrException(tp);
        Partition partition = (Partition)this.kafka$server$ReplicaFetcherThread$$replicaMgr.getPartition(tp).get();
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.offset() < replica.highWatermark().messageOffset()) {
            this.warn((Function0<String>)new Serializable(this, tp, offsetTruncationState, replica){
                public static final long serialVersionUID = 0L;
                private final TopicPartition tp$1;
                private final OffsetTruncationState offsetTruncationState$1;
                private final Replica replica$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncating ", " to offset ", " below high watermark "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1, BoxesRunTime.boxToLong((long)this.offsetTruncationState$1.offset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.replica$2.highWatermark().messageOffset())}))).toString();
                }
                {
                    this.tp$1 = tp$1;
                    this.offsetTruncationState$1 = offsetTruncationState$1;
                    this.replica$2 = replica$2;
                }
            });
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.kafka$server$ReplicaFetcherThread$$replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset2) {
        Partition partition = (Partition)this.kafka$server$ReplicaFetcherThread$$replicaMgr.getPartition(topicPartition).get();
        partition.truncateFullyAndStartAt(offset2, false);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        Map map;
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Skipping leaderEpoch request since all partitions do not have an epoch";
                }
            });
            return Map$.MODULE$.empty();
        }
        OffsetsForLeaderEpochRequest.Builder epochRequest = OffsetsForLeaderEpochRequest.Builder.forFollower((short)this.offsetForLeaderEpochRequestVersion(), (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava()), (int)this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
        this.debug((Function0<String>)new Serializable(this, epochRequest){
            public static final long serialVersionUID = 0L;
            private final OffsetsForLeaderEpochRequest.Builder epochRequest$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending offset for leader epoch request ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.epochRequest$1}));
            }
            {
                this.epochRequest$1 = epochRequest$1;
            }
        });
        try {
            ClientResponse response = this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)new Serializable(this, response){
                public static final long serialVersionUID = 0L;
                private final ClientResponse response$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received leaderEpoch response ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$1}));
                }
                {
                    this.response$1 = response$1;
                }
            });
            map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(responseBody.responses()).asScala();
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)new Serializable(this, partitions){
                public static final long serialVersionUID = 0L;
                private final Map partitions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when sending leader epoch request for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitions$1}));
                }
                {
                    this.partitions$1 = partitions$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$3;

                public final Throwable apply() {
                    return this.t$3;
                }
                {
                    this.t$3 = t$3;
                }
            });
            Errors error = Errors.forException((Throwable)throwable);
            map = (Map)partitions.map((Function1)new Serializable(this, error){
                public static final long serialVersionUID = 0L;
                private final Errors error$1;

                public final Tuple2<TopicPartition, EpochEndOffset> apply(Tuple2<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> x0$2) {
                    Tuple2<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(this.error$1, -1, -1L));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.error$1 = error$1;
                }
            }, Map$.MODULE$.canBuildFrom());
        }
        return map;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.brokerSupportsLeaderEpochRequest();
    }

    public boolean kafka$server$ReplicaFetcherThread$$shouldFollowerThrottle(ReplicaQuota quota, TopicPartition topicPartition) {
        boolean isReplicaInSync = this.fetcherLagStats().isReplicaInSync(topicPartition);
        return !isReplicaInSync && quota.isThrottled(topicPartition) && quota.isQuotaExceeded();
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig2, FailedPartitions failedPartitions, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.kafka$server$ReplicaFetcherThread$$fetcherId = fetcherId;
        this.kafka$server$ReplicaFetcherThread$$brokerConfig = brokerConfig2;
        this.kafka$server$ReplicaFetcherThread$$replicaMgr = replicaMgr;
        this.kafka$server$ReplicaFetcherThread$$metrics = metrics;
        this.kafka$server$ReplicaFetcherThread$$time = time;
        this.kafka$server$ReplicaFetcherThread$$quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig2.replicaFetchBackoffMs()), false);
        this.kafka$server$ReplicaFetcherThread$$replicaId = brokerConfig2.brokerId();
        this.kafka$server$ReplicaFetcherThread$$logContext = new LogContext(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ReplicaFetcher replicaId=", ", leaderId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaFetcherThread$$replicaId()), BoxesRunTime.boxToInteger((int)super.sourceBroker().id())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fetcherId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fetcherId)}))).toString());
        this.logIdent_$eq(this.kafka$server$ReplicaFetcherThread$$logContext().logPrefix());
        this.kafka$server$ReplicaFetcherThread$$leaderEndpoint = (BlockingSend)leaderEndpointBlockingSend.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;

            public final ReplicaFetcherBlockingSend apply() {
                return new ReplicaFetcherBlockingSend(this.$outer.kafka$server$ReplicaFetcherThread$$super$sourceBroker(), this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig, this.$outer.kafka$server$ReplicaFetcherThread$$metrics, this.$outer.kafka$server$ReplicaFetcherThread$$time, this.$outer.kafka$server$ReplicaFetcherThread$$fetcherId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker-", "-fetcher-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$replicaId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$fetcherId)})), this.$outer.kafka$server$ReplicaFetcherThread$$logContext());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.fetchRequestVersion = (short)(brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 11 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV2$.MODULE$) ? 10 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 8 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)))))))));
        this.offsetForLeaderEpochRequestVersion = (short)(brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 3 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 2 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV0$.MODULE$) ? 1 : 0)));
        this.listOffsetRequestVersion = (short)(brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV1$.MODULE$) ? 5 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 4 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 3 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 2 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? 1 : 0)))));
        this.maxWait = brokerConfig2.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig2.replicaFetchMinBytes();
        this.maxBytes = brokerConfig2.replicaFetchResponseMaxBytes();
        this.kafka$server$ReplicaFetcherThread$$fetchSize = brokerConfig2.replicaFetchMaxBytes();
        this.brokerSupportsLeaderEpochRequest = brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.fetchSessionHandler = new FetchSessionHandler(this.kafka$server$ReplicaFetcherThread$$logContext(), super.sourceBroker().id());
    }
}

