/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.CompletedTxn;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\rh\u0001B)S\u0001]C\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u001a\u0005\te\u0002\u0011\t\u0011)A\u0005K\"A1\u000f\u0001BC\u0002\u0013\u0005A\u000f\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003v\u0011!Q\bA!b\u0001\n\u0003Y\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011\u0002?\t\u0015\u0005\u0005\u0001A!b\u0001\n\u0003\t\u0019\u0001\u0003\u0006\u0002\f\u0001\u0011\t\u0011)A\u0005\u0003\u000bA!\"!\u0004\u0001\u0005\u000b\u0007I\u0011AA\b\u0011)\t9\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0003\u0005\u000b\u00033\u0001!Q1A\u0005\u0002\u0005m\u0001BCA\u0012\u0001\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u0011Q\u0005\u0001\u0003\u0006\u0004%\t!a\u0004\t\u0015\u0005\u001d\u0002A!A!\u0002\u0013\t\t\u0002\u0003\u0006\u0002*\u0001\u0011)\u0019!C\u0001\u0003WA!\"a\u000e\u0001\u0005\u0003\u0005\u000b\u0011BA\u0017\u0011!\tI\u0004\u0001C\u0001%\u0006m\u0002bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\t\t\b\u0001C\u0001\u0003gB\u0011\"!\u001f\u0001\u0001\u0004%I!a\u0004\t\u0013\u0005m\u0004\u00011A\u0005\n\u0005u\u0004\u0002CAB\u0001\u0001\u0006K!!\u0005\t\u0013\u0005\u0015\u0005\u00011A\u0005\n\u0005m\u0001\"CAD\u0001\u0001\u0007I\u0011BAE\u0011!\ti\t\u0001Q!\n\u0005u\u0001\"CAH\u0001\u0001\u0007I\u0011BAI\u0011%\tI\n\u0001a\u0001\n\u0013\tY\n\u0003\u0005\u0002 \u0002\u0001\u000b\u0015BAJ\u0011%\t\t\u000b\u0001a\u0001\n\u0013\ty\u0001C\u0005\u0002$\u0002\u0001\r\u0011\"\u0003\u0002&\"A\u0011\u0011\u0016\u0001!B\u0013\t\t\u0002C\u0005\u00024\u0002\u0001\r\u0011\"\u0003\u0002\u0010!I\u0011Q\u0017\u0001A\u0002\u0013%\u0011q\u0017\u0005\t\u0003w\u0003\u0001\u0015)\u0003\u0002\u0012!9\u0011q\u000e\u0001\u0005\u0002\u0005m\u0001bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003\u000f\u0004A\u0011AAe\u0011\u001d\tI\u000f\u0001C\u0005\u0003WDq!a<\u0001\t\u0013\t\t\u0010C\u0004\u0003\u0004\u0001!\tA!\u0002\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010!9!\u0011\u0005\u0001\u0005\n\t\r\u0002\u0002\u0003B\u001d\u0001\u0011\u0005!Ka\u000f\t\u0015\tM\u0004!%A\u0005\u0002I\u0013)\bC\u0004\u0003\f\u0002!\tA!$\t\u0013\tE\u0006!%A\u0005\u0002\tM\u0006\"\u0003B\\\u0001E\u0005I\u0011\u0001B]\u0011\u001d\u0011i\f\u0001C\u0001\u0005\u007fCqAa4\u0001\t\u0003\u0011\t\u000eC\u0005\u0003j\u0002\t\n\u0011\"\u0001\u0003l\"9!q\u001e\u0001\u0005\n\tE\bb\u0002Bz\u0001\u0011\u0005!Q\u001f\u0005\b\u0005o\u0004A\u0011\u0001B}\u0011\u001d\u0019I\u0001\u0001C!\u0007\u0017Aqa!\b\u0001\t\u0003\u0019y\u0002C\u0004\u0004&\u0001!\t!a\u0004\t\u000f\r%\u0002\u0001\"\u0001\u0003r\"91Q\u0006\u0001\u0005\u0002\r=\u0002bBB!\u0001\u0011\u000511\t\u0005\b\u00077\u0002A\u0011\u0001By\u0011\u001d\u0019i\u0006\u0001C\u0001\u0007?Bqa!\u001b\u0001\t\u0003\u0019Y\u0007C\u0005\u0004~\u0001\t\n\u0011\"\u0001\u00034\"91q\u0010\u0001\u0005\u0002\tE\bbBBA\u0001\u0011\u0005!\u0011\u001f\u0005\b\u0007\u0007\u0003A\u0011\u0001By\u0011\u001d\u0019)\t\u0001C\u0001\u0003\u001fAq!!5\u0001\t\u0003\ty\u0001C\u0004\u0004\b\u0002!\ta!#\b\u000f\r\u0005&\u000b#\u0001\u0004$\u001a1\u0011K\u0015E\u0001\u0007KCq!!\u000fI\t\u0003\u00199\u000bC\u0004\u0004*\"#\taa+\t\u0013\r5\u0007*%A\u0005\u0002\te\u0006\"CBh\u0011F\u0005I\u0011\u0001B;\u0011%\u0019\t\u000eSI\u0001\n\u0003\u0011I\fC\u0005\u0004T\"\u000b\n\u0011\"\u0001\u0004V\"911\u0011%\u0005\u0002\re\u0007\"CBq\u0011F\u0005I\u0011ABk\u0005)aunZ*fO6,g\u000e\u001e\u0006\u0003'R\u000b1\u0001\\8h\u0015\u0005)\u0016!B6bM.\f7\u0001A\n\u0004\u0001as\u0006CA-]\u001b\u0005Q&\"A.\u0002\u000bM\u001c\u0017\r\\1\n\u0005uS&AB!osJ+g\r\u0005\u0002`E6\t\u0001M\u0003\u0002b)\u0006)Q\u000f^5mg&\u00111\r\u0019\u0002\b\u0019><w-\u001b8h+\u0005)\u0007C\u00014q\u001b\u00059'B\u00015j\u0003\u0019\u0011XmY8sI*\u0011!n[\u0001\u0007G>lWn\u001c8\u000b\u0005Uc'BA7o\u0003\u0019\t\u0007/Y2iK*\tq.A\u0002pe\u001eL!!]4\u0003\u0017\u0019KG.\u001a*fG>\u0014Hm]\u0001\u0005Y><\u0007%A\u0006pM\u001a\u001cX\r^%oI\u0016DX#A;\u0011\u0005Y<X\"\u0001*\n\u0005a\u0014&aC(gMN,G/\u00138eKb\fAb\u001c4gg\u0016$\u0018J\u001c3fq\u0002\n\u0011\u0002^5nK&sG-\u001a=\u0016\u0003q\u0004\"A^?\n\u0005y\u0014&!\u0003+j[\u0016Le\u000eZ3y\u0003)!\u0018.\\3J]\u0012,\u0007\u0010I\u0001\tibt\u0017J\u001c3fqV\u0011\u0011Q\u0001\t\u0004m\u0006\u001d\u0011bAA\u0005%\n\u0001BK]1og\u0006\u001cG/[8o\u0013:$W\r_\u0001\nibt\u0017J\u001c3fq\u0002\n!BY1tK>3gm]3u+\t\t\t\u0002E\u0002Z\u0003'I1!!\u0006[\u0005\u0011auN\\4\u0002\u0017\t\f7/Z(gMN,G\u000fI\u0001\u0013S:$W\r_%oi\u0016\u0014h/\u00197CsR,7/\u0006\u0002\u0002\u001eA\u0019\u0011,a\b\n\u0007\u0005\u0005\"LA\u0002J]R\f1#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fg\u0002\nAB]8mY*KG\u000f^3s\u001bN\fQB]8mY*KG\u000f^3s\u001bN\u0004\u0013\u0001\u0002;j[\u0016,\"!!\f\u0011\t\u0005=\u00121G\u0007\u0003\u0003cQ!!Y5\n\t\u0005U\u0012\u0011\u0007\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0013qIA%\u0003\u0017\ni\u0005\u0005\u0002w\u0001!)1+\u0005a\u0001K\")1/\u0005a\u0001k\")!0\u0005a\u0001y\"9\u0011\u0011A\tA\u0002\u0005\u0015\u0001bBA\u0007#\u0001\u0007\u0011\u0011\u0003\u0005\b\u00033\t\u0002\u0019AA\u000f\u0011\u001d\t)#\u0005a\u0001\u0003#Aq!!\u000b\u0012\u0001\u0004\ti#\u0001\u0006tQ>,H\u000e\u001a*pY2$B!a\u0015\u0002ZA\u0019\u0011,!\u0016\n\u0007\u0005]#LA\u0004C_>dW-\u00198\t\u000f\u0005m#\u00031\u0001\u0002^\u0005Q!o\u001c7m!\u0006\u0014\u0018-\\:\u0011\u0007Y\fy&C\u0002\u0002bI\u0013!BU8mYB\u000b'/Y7t\u00035\u0011Xm]5{K&sG-\u001a=fgR!\u0011qMA7!\rI\u0016\u0011N\u0005\u0004\u0003WR&\u0001B+oSRDq!a\u001c\u0014\u0001\u0004\ti\"\u0001\u0003tSj,\u0017aC:b]&$\u0018p\u00115fG.$B!a\u001a\u0002v!9\u0011q\u000f\u000bA\u0002\u0005M\u0013!\u0007;j[\u0016Le\u000eZ3y\r&dWMT3xYf\u001c%/Z1uK\u0012\fqa\u0019:fCR,G-A\u0006de\u0016\fG/\u001a3`I\u0015\fH\u0003BA4\u0003\u007fB\u0011\"!!\u0017\u0003\u0003\u0005\r!!\u0005\u0002\u0007a$\u0013'\u0001\u0005de\u0016\fG/\u001a3!\u0003a\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/_\u0001\u001dEf$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJLx\fJ3r)\u0011\t9'a#\t\u0013\u0005\u0005\u0015$!AA\u0002\u0005u\u0011!\u00072zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss\u0002\nQC]8mY&twMQ1tK\u0012$\u0016.\\3ti\u0006l\u0007/\u0006\u0002\u0002\u0014B)\u0011,!&\u0002\u0012%\u0019\u0011q\u0013.\u0003\r=\u0003H/[8o\u0003e\u0011x\u000e\u001c7j]\u001e\u0014\u0015m]3e)&lWm\u001d;b[B|F%Z9\u0015\t\u0005\u001d\u0014Q\u0014\u0005\n\u0003\u0003c\u0012\u0011!a\u0001\u0003'\u000baC]8mY&twMQ1tK\u0012$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\u0012[\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014\u0018!F7bqRKW.Z:uC6\u00048k\u001c$be~#S-\u001d\u000b\u0005\u0003O\n9\u000bC\u0005\u0002\u0002~\t\t\u00111\u0001\u0002\u0012\u0005\u0011R.\u0019=US6,7\u000f^1naN{g)\u0019:!Q\r\u0001\u0013Q\u0016\t\u00043\u0006=\u0016bAAY5\nAao\u001c7bi&dW-\u0001\u000bpM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e]\u0001\u0019_\u001a47/\u001a;PM6\u000b\u0007\u0010V5nKN$\u0018-\u001c9`I\u0015\fH\u0003BA4\u0003sC\u0011\"!!#\u0003\u0003\u0005\r!!\u0005\u0002+=4gm]3u\u001f\u001al\u0015\r\u001f+j[\u0016\u001cH/Y7qA!\u001a1%!,\u00025\r\fgnQ8om\u0016\u0014H\u000fV8SK2\fG/\u001b<f\u001f\u001a47/\u001a;\u0015\t\u0005M\u00131\u0019\u0005\b\u0003\u000b,\u0003\u0019AA\t\u0003\u0019ygMZ:fi\u00061\u0011\r\u001d9f]\u0012$\"\"a\u001a\u0002L\u0006=\u00171[Al\u0011\u001d\tiM\na\u0001\u0003#\tQ\u0002\\1sO\u0016\u001cHo\u00144gg\u0016$\bbBAiM\u0001\u0007\u0011\u0011C\u0001\u0011Y\u0006\u0014x-Z:u)&lWm\u001d;b[BDq!!6'\u0001\u0004\t\t\"A\u000etQ\u0006dGn\\<PM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e\u001d\u0005\b\u000334\u0003\u0019AAn\u0003\u001d\u0011XmY8sIN\u00042AZAo\u0013\r\tyn\u001a\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:)\u0007\u0019\n\u0019\u000fE\u0002`\u0003KL1!a:a\u00055qwN\u001c;ie\u0016\fGm]1gK\u0006\u0019RM\\:ve\u0016|eMZ:fi&s'+\u00198hKR!\u0011qMAw\u0011\u001d\t)m\na\u0001\u0003#\t1#\u00199qK:$7\t[;oW\u001a\u0013x.\u001c$jY\u0016$\u0002\"!\b\u0002t\u0006U\u0018\u0011 \u0005\u0007\u00033D\u0003\u0019A3\t\u000f\u0005]\b\u00061\u0001\u0002\u001e\u0005A\u0001o\\:ji&|g\u000eC\u0004\u0002|\"\u0002\r!!@\u0002\u001d\t,hMZ3s'V\u0004\b\u000f\\5feB\u0019a-a@\n\u0007\t\u0005qM\u0001\bCk\u001a4WM]*vaBd\u0017.\u001a:\u0002\u001d\u0005\u0004\b/\u001a8e\rJ|WNR5mKR1\u0011Q\u0004B\u0004\u0005\u0013Aa!!7*\u0001\u0004)\u0007b\u0002B\u0006S\u0001\u0007\u0011QD\u0001\u0006gR\f'\u000f^\u0001\u000fkB$\u0017\r^3Uq:Le\u000eZ3y)\u0019\t9G!\u0005\u0003\u001c!9!1\u0003\u0016A\u0002\tU\u0011\u0001D2p[BdW\r^3e)bt\u0007c\u0001<\u0003\u0018%\u0019!\u0011\u0004*\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\u000f\tu!\u00061\u0001\u0002\u0012\u0005\u0001B.Y:u'R\f'\r\\3PM\u001a\u001cX\r\u001e\u0015\u0004U\u0005\r\u0018aE;qI\u0006$X\r\u0015:pIV\u001cWM]*uCR,GCBA4\u0005K\u0011y\u0003C\u0004\u0003(-\u0002\rA!\u000b\u0002)A\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s!\r1(1F\u0005\u0004\u0005[\u0011&\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'\u000fC\u0004\u00032-\u0002\rAa\r\u0002\u000b\t\fGo\u00195\u0011\u0007\u0019\u0014)$C\u0002\u00038\u001d\u00141BU3d_J$')\u0019;dQ\u0006yAO]1og2\fG/Z(gMN,G\u000f\u0006\u0004\u0003>\t\u0015$q\r\t\u0005\u0005\u007f\u0011yF\u0004\u0003\u0003B\tmc\u0002\u0002B\"\u00053rAA!\u0012\u0003X9!!q\tB+\u001d\u0011\u0011IEa\u0015\u000f\t\t-#\u0011K\u0007\u0003\u0005\u001bR1Aa\u0014W\u0003\u0019a$o\\8u}%\tq.\u0003\u0002n]&\u0011Q\u000b\\\u0005\u0003U.L!\u0001[5\n\u0007\tus-A\u0006GS2,'+Z2pe\u0012\u001c\u0018\u0002\u0002B1\u0005G\u0012\u0011\u0003T8h\u001f\u001a47/\u001a;Q_NLG/[8o\u0015\r\u0011if\u001a\u0005\b\u0003\u000bd\u0003\u0019AA\t\u0011%\u0011I\u0007\fI\u0001\u0002\u0004\ti\"\u0001\u000bti\u0006\u0014H/\u001b8h\r&dW\rU8tSRLwN\u001c\u0015\u0004Y\t5\u0004cA0\u0003p%\u0019!\u0011\u000f1\u0003\u0015QD'/Z1eg\u00064W-A\rue\u0006t7\u000f\\1uK>3gm]3uI\u0011,g-Y;mi\u0012\u0012TC\u0001B<U\u0011\tiB!\u001f,\u0005\tm\u0004\u0003\u0002B?\u0005\u000fk!Aa \u000b\t\t\u0005%1Q\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\"[\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0013\u0013yHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAA]3bIRa!q\u0012BN\u0005?\u0013\u0019Ka*\u0003,B!!\u0011\u0013BL\u001b\t\u0011\u0019JC\u0002\u0003\u0016R\u000baa]3sm\u0016\u0014\u0018\u0002\u0002BM\u0005'\u0013QBR3uG\"$\u0015\r^1J]\u001a|\u0007b\u0002BO]\u0001\u0007\u0011\u0011C\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0003\":\u0002\r!a%\u0002\u00135\f\u0007p\u00144gg\u0016$\bb\u0002BS]\u0001\u0007\u0011QD\u0001\b[\u0006D8+\u001b>f\u0011%\u0011IK\fI\u0001\u0002\u0004\t\t\"A\u0006nCb\u0004vn]5uS>t\u0007\"\u0003BW]A\u0005\t\u0019AA*\u00035i\u0017N\\(oK6+7o]1hK\"\u001aaF!\u001c\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u0017\u0016\u0005\u0003#\u0011I(\u0001\bsK\u0006$G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tm&\u0006BA*\u0005s\nQCZ3uG\",\u0006\u000f]3s\u0005>,h\u000eZ(gMN,G\u000f\u0006\u0004\u0002\u0014\n\u0005'1\u001a\u0005\b\u0005\u0007\f\u0004\u0019\u0001Bc\u0003M\u0019H/\u0019:u\u001f\u001a47/\u001a;Q_NLG/[8o!\r1(qY\u0005\u0004\u0005\u0013\u0014&AD(gMN,G\u000fU8tSRLwN\u001c\u0005\b\u0005\u001b\f\u0004\u0019AA\u000f\u0003%1W\r^2i'&TX-A\u0004sK\u000e|g/\u001a:\u0015\r\u0005u!1\u001bBk\u0011\u001d\u00119C\ra\u0001\u0005SA\u0011Ba63!\u0003\u0005\rA!7\u0002!1,\u0017\rZ3s\u000bB|7\r[\"bG\",\u0007#B-\u0002\u0016\nm\u0007\u0003\u0002Bo\u0005Gl!Aa8\u000b\t\t\u0005(1S\u0001\u0006KB|7\r[\u0005\u0005\u0005K\u0014yN\u0001\u000bMK\u0006$WM]#q_\u000eDg)\u001b7f\u0007\u0006\u001c\u0007.\u001a\u0015\u0004e\u0005\r\u0018!\u0005:fG>4XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u001e\u0016\u0005\u00053\u0014I(\u0001\u000bm_\u0006$G*\u0019:hKN$H+[7fgR\fW\u000e\u001d\u000b\u0003\u0003O\n1\u0002[1t\u001fZ,'O\u001a7poV\u0011\u00111K\u0001\u0013G>dG.Z2u\u0003\n|'\u000f^3e)bt7\u000f\u0006\u0004\u0003|\u000e\u00051Q\u0001\t\u0004m\nu\u0018b\u0001B\u0000%\n!B\u000b\u001f8J]\u0012,\u0007pU3be\u000eD'+Z:vYRDqaa\u00017\u0001\u0004\t\t\"A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bbBB\u0004m\u0001\u0007\u0011\u0011C\u0001\u0011kB\u0004XM\u001d\"pk:$wJ\u001a4tKR\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007\u001b\u0001Baa\u0004\u0004\u001a5\u00111\u0011\u0003\u0006\u0005\u0007'\u0019)\"\u0001\u0003mC:<'BAB\f\u0003\u0011Q\u0017M^1\n\t\rm1\u0011\u0003\u0002\u0007'R\u0014\u0018N\\4\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000e\u0006\u0003\u0002\u001e\r\u0005\u0002bBAcq\u0001\u0007\u0011\u0011\u0003\u0015\u0004q\u0005\r\u0018A\u0004:fC\u0012tU\r\u001f;PM\u001a\u001cX\r\u001e\u0015\u0004s\t5\u0014!\u00024mkND\u0007f\u0001\u001e\u0003n\u0005IQ\u000f\u001d3bi\u0016$\u0015N\u001d\u000b\u0005\u0003O\u001a\t\u0004C\u0004\u00044m\u0002\ra!\u000e\u0002\u0007\u0011L'\u000f\u0005\u0003\u00048\ruRBAB\u001d\u0015\u0011\u0019Yd!\u0006\u0002\u0005%|\u0017\u0002BB \u0007s\u0011AAR5mK\u0006\u00112\r[1oO\u00164\u0015\u000e\\3Tk\u001a4\u0017\u000e_3t)\u0019\t9g!\u0012\u0004X!91q\t\u001fA\u0002\r%\u0013!C8mIN+hMZ5y!\u0011\u0019Yea\u0015\u000f\t\r53q\n\t\u0004\u0005\u0017R\u0016bAB)5\u00061\u0001K]3eK\u001aLAaa\u0007\u0004V)\u00191\u0011\u000b.\t\u000f\reC\b1\u0001\u0004J\u0005Ia.Z<Tk\u001a4\u0017\u000e_\u0001\u0018_:\u0014UmY8nK&s\u0017m\u0019;jm\u0016\u001cVmZ7f]R\f\u0011\u0003^5nK^\u000b\u0017\u000e^3e\r>\u0014(k\u001c7m)\u0019\t\tb!\u0019\u0004f!911\r A\u0002\u0005E\u0011a\u00018po\"91q\r A\u0002\u0005E\u0011\u0001E7fgN\fw-\u001a+j[\u0016\u001cH/Y7q\u0003U1\u0017N\u001c3PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[B$ba!\u001c\u0004v\re\u0004#B-\u0002\u0016\u000e=\u0004\u0003\u0002B \u0007cJAaa\u001d\u0003d\t\u0011B+[7fgR\fW\u000e]!oI>3gm]3u\u0011\u001d\u00199h\u0010a\u0001\u0003#\t\u0011\u0002^5nKN$\u0018-\u001c9\t\u0013\rmt\b%AA\u0002\u0005E\u0011AD:uCJ$\u0018N\\4PM\u001a\u001cX\r^\u0001 M&tGm\u00144gg\u0016$()\u001f+j[\u0016\u001cH/Y7qI\u0011,g-Y;mi\u0012\u0012\u0014!B2m_N,\u0017!D2m_N,\u0007*\u00198eY\u0016\u00148/\u0001\beK2,G/Z%g\u000bbL7\u000f^:\u0002\u00191\f7\u000f^'pI&4\u0017.\u001a3\u0002!1\f7\u000f^'pI&4\u0017.\u001a3`I\u0015\fH\u0003BBF\u00077\u0003Ba!$\u0004\u00186\u00111q\u0012\u0006\u0005\u0007#\u001b\u0019*\u0001\u0003gS2,'\u0002BBK\u0007+\t1A\\5p\u0013\u0011\u0019Ija$\u0003\tA\u000bG\u000f\u001b\u0005\b\u0007;3\u0005\u0019AA\t\u0003\ti7\u000fK\u0002\u0001\u0003G\f!\u0002T8h'\u0016<W.\u001a8u!\t1\bj\u0005\u0002I1R\u001111U\u0001\u0005_B,g\u000e\u0006\n\u0002>\r56qVBY\u0007w\u001bil!1\u0004F\u000e%\u0007bBB\u001a\u0015\u0002\u00071Q\u0007\u0005\b\u0003\u001bQ\u0005\u0019AA\t\u0011\u001d\u0019\u0019L\u0013a\u0001\u0007k\u000baaY8oM&<\u0007c\u0001<\u00048&\u00191\u0011\u0018*\u0003\u00131{wmQ8oM&<\u0007bBA\u0015\u0015\u0002\u0007\u0011Q\u0006\u0005\n\u0007\u007fS\u0005\u0013!a\u0001\u0003'\n\u0011CZ5mK\u0006c'/Z1es\u0016C\u0018n\u001d;t\u0011%\u0019\u0019M\u0013I\u0001\u0002\u0004\ti\"\u0001\u0007j]&$h)\u001b7f'&TX\rC\u0005\u0004H*\u0003\n\u00111\u0001\u0002T\u0005Y\u0001O]3bY2|7-\u0019;f\u0011%\u0019YM\u0013I\u0001\u0002\u0004\u0019I%\u0001\u0006gS2,7+\u001e4gSb\fab\u001c9f]\u0012\"WMZ1vYR$S'\u0001\bpa\u0016tG\u0005Z3gCVdG\u000f\n\u001c\u0002\u001d=\u0004XM\u001c\u0013eK\u001a\fW\u000f\u001c;%o\u0005qq\u000e]3oI\u0011,g-Y;mi\u0012BTCABlU\u0011\u0019IE!\u001f\u0015\u0011\u0005\u001d41\\Bo\u0007?Dqaa\rP\u0001\u0004\u0019)\u0004C\u0004\u0002\u000e=\u0003\r!!\u0005\t\u0013\r-w\n%AA\u0002\r%\u0013\u0001\u00073fY\u0016$X-\u00134Fq&\u001cHo\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final OffsetIndex offsetIndex;
    private final TimeIndex timeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private Option<Object> rollingBasedTimestamp;
    private volatile long maxTimestampSoFar;
    private volatile long offsetOfMaxTimestamp;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return LogSegment$.MODULE$.deleteIfExists$default$3();
    }

    public static String open$default$8() {
        return LogSegment$.MODULE$.open$default$8();
    }

    public static boolean open$default$7() {
        return LogSegment$.MODULE$.open$default$7();
    }

    public static int open$default$6() {
        return LogSegment$.MODULE$.open$default$6();
    }

    public static boolean open$default$5() {
        return LogSegment$.MODULE$.open$default$5();
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public OffsetIndex offsetIndex() {
        return this.offsetIndex;
    }

    public TimeIndex timeIndex() {
        return this.timeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size) {
        this.offsetIndex().resize(size);
        this.timeIndex().resize(size);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (!this.offsetIndex().file().exists()) {
            throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append(this.offsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
        }
        this.offsetIndex().sanityCheck();
        Object object = timeIndexFileNewlyCreated ? BoxesRunTime.boxToBoolean((boolean)this.timeIndex().resize(0)) : BoxedUnit.UNIT;
        this.timeIndex().sanityCheck();
        this.txnIndex().sanityCheck();
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private long maxTimestampSoFar() {
        return this.maxTimestampSoFar;
    }

    private void maxTimestampSoFar_$eq(long x$1) {
        this.maxTimestampSoFar = x$1;
    }

    private long offsetOfMaxTimestamp() {
        return this.offsetOfMaxTimestamp;
    }

    private void offsetOfMaxTimestamp_$eq(long x$1) {
        this.offsetOfMaxTimestamp = x$1;
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        block3: {
            if (records.sizeInBytes() <= 0) break block3;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Inserting ").append(records.sizeInBytes()).append(" bytes at end offset ").append(largestOffset).append(" at position ").append(this.log().sizeInBytes()).append(" ").append(new StringBuilder(42).append("with largest timestamp ").append(largestTimestamp).append(" at shallow offset ").append(shallowOffsetOfMaxTimestamp).toString()).toString());
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.ensureOffsetInRange(largestOffset);
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append(this.log().file()).append(" at end offset ").append(largestOffset).toString());
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampSoFar_$eq(largestTimestamp);
                this.offsetOfMaxTimestamp_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(largestOffset, physicalPosition);
                this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), this.timeIndex().maybeAppend$default$3());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        Iterator nextBatches = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batchesFrom(position)).asScala()).iterator();
        nextBatches.takeWhile((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(maxTimestamp, offsetOfMaxTimestamp, maxOffset, bytesToAppend, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        block0: {
            if (!completedTxn.isAborted()) break block0;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn).append(" to transaction index, last stable offset is ").append(lastStableOffset).toString());
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset));
        }
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, false);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
                LogSegment.$anonfun$updateProducerState$1(this, producerStateManager, completedTxn);
                return BoxedUnit.UNIT;
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int n;
        int adjustedMaxSize;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
        }
        int logSize = this.log().sizeInBytes();
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        int n2 = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        }
        Option<Object> option = maxOffset;
        if (None$.MODULE$.equals(option)) {
            n = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            long offset = BoxesRunTime.unboxToLong((Object)some.value());
            if (offset < startOffset) {
                return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, false, FetchDataInfo$.MODULE$.apply$default$4());
            }
            FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, startPosition);
            int endPosition = mapping == null ? logSize : mapping.position;
            n = (int)package$.MODULE$.min(package$.MODULE$.min(maxPosition, (long)endPosition) - (long)startPosition, (long)adjustedMaxSize);
        } else {
            throw new MatchError(option);
        }
        int fetchSize = n;
        return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, FetchDataInfo$.MODULE$.apply$default$4());
    }

    public long read$default$4() {
        return this.size();
    }

    public boolean read$default$5() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset()));
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.maxTimestampSoFar_$eq(-1L);
        try {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                LogSegment.$anonfun$recover$1(this, validBytes, lastIndexEntry, leaderEpochCache, producerStateManager, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (CorruptRecordException e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes$1.elem), e.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append(this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        block0: {
            TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
            this.maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
            this.offsetOfMaxTimestamp_$eq(lastTimeIndexEntry.offset());
            OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
            FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
            if (maxTimestampOffsetAfterLastEntry.timestamp <= lastTimeIndexEntry.timestamp()) break block0;
            this.maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
            this.offsetOfMaxTimestamp_$eq(maxTimestampOffsetAfterLastEntry.offset);
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder(30).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(")").toString();
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        block1: {
            FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
            this.offsetIndex().truncateTo(offset);
            this.timeIndex().truncateTo(offset);
            this.txnIndex().truncateTo(offset);
            this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
            this.timeIndex().resize(this.timeIndex().maxIndexSize());
            int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
            if (this.log().sizeInBytes() == 0) {
                this.created_$eq(this.time().milliseconds());
                this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
            }
            this.bytesSinceLastIndexEntry_$eq(0);
            if (this.maxTimestampSoFar() < 0L) break block1;
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes(), this.read$default$4(), this.read$default$5());
        return fetchData == null ? this.baseOffset() : BoxesRunTime.unboxToLong((Object)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).lastOption().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.nextOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.baseOffset()));
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.log().flush();
            this.offsetIndex().flush();
            this.timeIndex().flush();
            this.txnIndex().flush();
        });
    }

    public void updateDir(File dir) {
        this.log().setFile(new File(dir, this.log().file().getName()));
        this.offsetIndex().file_$eq(new File(dir, this.offsetIndex().file().getName()));
        this.timeIndex().file_$eq(new File(dir, this.timeIndex().file().getName()));
        this.txnIndex().file_$eq(new File(dir, this.txnIndex().file().getName()));
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.offsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.offsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.timeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.timeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        Some some;
        long t;
        Option<Object> option;
        java.util.Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
        }
        long l = (option = this.rollingBasedTimestamp()) instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).value())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public Option<FileRecords.TimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset));
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), true), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.offsetIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.offsetIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().closeHandlers(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.log().deleteIfExists(), "log", this.log().file(), true), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.offsetIndex().deleteIfExists(), "offset index", this.offsetIndex().file(), true), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.timeIndex().deleteIfExists(), "time index", this.timeIndex().file(), true), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.txnIndex().deleteIfExists(), "transaction index", this.txnIndex().file(), false)}))));
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public long largestTimestamp() {
        return this.maxTimestampSoFar() >= 0L ? this.maxTimestampSoFar() : this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.offsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.timeIndex().file().toPath(), fileTime);
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, IntRef bytesToAppend$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$updateProducerState$1(LogSegment $this, ProducerStateManager producerStateManager$1, CompletedTxn completedTxn) {
        long lastStableOffset = producerStateManager$1.completeTxn(completedTxn);
        $this.updateTxnIndex(completedTxn, lastStableOffset);
    }

    public static final /* synthetic */ void $anonfun$recover$2(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        block0: {
            if (batch$1.partitionLeaderEpoch() <= 0 || !cache.latestEpoch().forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> batch$1.partitionLeaderEpoch() > x$2)) break block0;
            cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
        }
    }

    public static final /* synthetic */ void $anonfun$recover$1(LogSegment $this, IntRef validBytes$1, IntRef lastIndexEntry$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2, FileLogInputStream.FileChannelRecordBatch batch) {
        block2: {
            batch.ensureValid();
            $this.ensureOffsetInRange(batch.lastOffset());
            if (batch.maxTimestamp() > $this.maxTimestampSoFar()) {
                $this.maxTimestampSoFar_$eq(batch.maxTimestamp());
                $this.offsetOfMaxTimestamp_$eq(batch.lastOffset());
            }
            if (validBytes$1.elem - lastIndexEntry$1.elem > $this.indexIntervalBytes()) {
                $this.offsetIndex().append(batch.lastOffset(), validBytes$1.elem);
                $this.timeIndex().maybeAppend($this.maxTimestampSoFar(), $this.offsetOfMaxTimestamp(), $this.timeIndex().maybeAppend$default$3());
                lastIndexEntry$1.elem = validBytes$1.elem;
            }
            validBytes$1.elem += batch.sizeInBytes();
            if (batch.magic() < 2) break block2;
            leaderEpochCache$1.foreach((Function1 & Serializable & scala.Serializable)cache -> {
                LogSegment.$anonfun$recover$2(batch, cache);
                return BoxedUnit.UNIT;
            });
            $this.updateProducerState(producerStateManager$2, (RecordBatch)batch);
        }
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(fileType).append(" ").append(file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public LogSegment(FileRecords log, OffsetIndex offsetIndex, TimeIndex timeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.offsetIndex = offsetIndex;
        this.timeIndex = timeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this.maxTimestampSoFar = timeIndex.lastEntry().timestamp();
        this.offsetOfMaxTimestamp = timeIndex.lastEntry().offset();
    }
}

