/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.api.LeaderAndIsr$;
import kafka.server.AdminManager;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u000194Aa\u0003\u0007\u0001#!Ia\u0003\u0001B\u0001B\u0003%q#\b\u0005\t=\u0001\u0011\t\u0011)A\u0005?!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015a\u0006\u0001\"\u0011\\\u0011\u0015i\u0006\u0001\"\u0003_\u0011\u0015I\u0007\u0001\"\u0003k\u0005]!U\r\\1zK\u0012\u001c%/Z1uKB\u000b'\u000f^5uS>t7O\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\tA\"\u0003\u0002\u0016\u0019\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\\\u0001\bI\u0016d\u0017-_'t!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0011auN\\4\n\u0005Y!\u0012AD2sK\u0006$X-T3uC\u0012\fG/\u0019\t\u0004A\r*S\"A\u0011\u000b\u0005\tJ\u0012AC2pY2,7\r^5p]&\u0011A%\t\u0002\u0004'\u0016\f\bCA\n'\u0013\t9CB\u0001\rDe\u0016\fG/\u001a)beRLG/[8og6+G/\u00193bi\u0006\fA\"\u00193nS:l\u0015M\\1hKJ\u0004\"a\u0005\u0016\n\u0005-b!\u0001D!e[&tW*\u00198bO\u0016\u0014\u0018\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u0011Ab\u0006M&\n\u0005=J\"!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u0001\u0013g\r \n\u0005I\n#aA'baB\u0011Ag\u000f\b\u0003ke\u0002\"AN\r\u000e\u0003]R!\u0001\u000f\t\u0002\rq\u0012xn\u001c;?\u0013\tQ\u0014$\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e\u001a!\ty\u0014*D\u0001A\u0015\t\t%)\u0001\u0005sKF,Xm\u001d;t\u0015\t\u0019E)\u0001\u0004d_6lwN\u001c\u0006\u0003\u001f\u0015S!AR$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0015aA8sO&\u0011!\n\u0011\u0002\t\u0003BLWI\u001d:peB\u0011\u0001\u0004T\u0005\u0003\u001bf\u0011A!\u00168ji\u00061A(\u001b8jiz\"R\u0001U)S'R\u0003\"a\u0005\u0001\t\u000bY)\u0001\u0019A\f\t\u000by)\u0001\u0019A\u0010\t\u000b!*\u0001\u0019A\u0015\t\u000b1*\u0001\u0019A\u0017\u0002\u0017Q\u0014\u0018pQ8na2,G/\u001a\u000b\u0002/B\u0011\u0001\u0004W\u0005\u00033f\u0011qAQ8pY\u0016\fg.\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016$\u0012aS\u0001\r_:,\u0005\u0010]5sCRLwN\\\u0001\u0013[&\u001c8/\u001b8h\u0019\u0016\fG-\u001a:D_VtG\u000fF\u0002`E\u0012\u0004\"\u0001\u00071\n\u0005\u0005L\"aA%oi\")1-\u0003a\u0001g\u0005)Ao\u001c9jG\")Q-\u0003a\u0001M\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u0007\u0001:w,\u0003\u0002iC\t\u00191+\u001a;\u0002\u001f%\u001cX*[:tS:<G*Z1eKJ$2aV6m\u0011\u0015\u0019'\u00021\u00014\u0011\u0015i'\u00021\u0001`\u0003%\u0001\u0018M\u001d;ji&|g\u000e")
public class DelayedCreatePartitions
extends DelayedOperation {
    private final Seq<CreatePartitionsMetadata> createMetadata;
    private final AdminManager adminManager;
    private final Function1<Map<String, ApiError>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Trying to complete operation for ").append($this.createMetadata).toString());
        int leaderlessPartitionCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.createMetadata.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedCreatePartitions.$anonfun$tryComplete$2(x$1)))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)DelayedCreatePartitions.$anonfun$tryComplete$3(this, BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
        if (leaderlessPartitionCount == 0) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "All partitions have a leader, completing the delayed operation");
            return this.forceComplete();
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append(leaderlessPartitionCount).append(" partitions do not have a leader, not completing the delayed operation").toString());
        return false;
    }

    @Override
    public void onComplete() {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Completing operation for ").append($this.createMetadata).toString());
        scala.collection.immutable.Map results = ((TraversableOnce)this.createMetadata.map((Function1 & Serializable & scala.Serializable)metadata -> {
            if (metadata.error().isSuccess() && this.missingLeaderCount(metadata.topic(), metadata.partitions()) > 0) {
                return new Tuple2((Object)metadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null));
            }
            return new Tuple2((Object)metadata.topic(), (Object)metadata.error());
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.responseCallback.apply((Object)results);
    }

    @Override
    public void onExpiration() {
    }

    private int missingLeaderCount(String topic, Set<Object> partitions) {
        return BoxesRunTime.unboxToInt((Object)partitions.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            if (this.isMissingLeader(topic, x1$1)) {
                return x0$1 + 1;
            }
            return x0$1;
        }));
    }

    private boolean isMissingLeader(String topic, int partition) {
        Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionInfo = this.adminManager.metadataCache().getPartitionInfo(topic, partition);
        if (partitionInfo == null) {
            throw null;
        }
        boolean bl = partitionInfo.isEmpty() || DelayedCreatePartitions.$anonfun$isMissingLeader$1((UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfo.get());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$2(CreatePartitionsMetadata x$1) {
        return x$1.error().isSuccess();
    }

    public static final /* synthetic */ int $anonfun$tryComplete$3(DelayedCreatePartitions $this, int x0$1, CreatePartitionsMetadata x1$1) {
        return x0$1 + $this.missingLeaderCount(x1$1.topic(), x1$1.partitions());
    }

    public static final /* synthetic */ boolean $anonfun$isMissingLeader$1(UpdateMetadataRequestData.UpdateMetadataPartitionState x$2) {
        return x$2.leader() == LeaderAndIsr$.MODULE$.NoLeader();
    }

    public DelayedCreatePartitions(long delayMs, Seq<CreatePartitionsMetadata> createMetadata, AdminManager adminManager, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        this.createMetadata = createMetadata;
        this.adminManager = adminManager;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }

    public static final /* synthetic */ Object $anonfun$isMissingLeader$1$adapted(UpdateMetadataRequestData.UpdateMetadataPartitionState x$2) {
        return BoxesRunTime.boxToBoolean((boolean)DelayedCreatePartitions.$anonfun$isMissingLeader$1(x$2));
    }
}

