/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.TestPurgatoryPerformance;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.utils.CommandLineUtils$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.VolatileLongRef;

public final class TestPurgatoryPerformance$ {
    public static TestPurgatoryPerformance$ MODULE$;

    static {
        new TestPurgatoryPerformance$();
    }

    public void main(String[] args) {
        None$ none$;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec keySpaceSizeOpt = parser.accepts("key-space-size", "The total number of possible keys").withRequiredArg().describedAs("total_num_possible_keys").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(100), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec numRequestsOpt = parser.accepts("num", "The number of requests").withRequiredArg().describedAs("num_requests").ofType(Double.class);
        ArgumentAcceptingOptionSpec requestRateOpt = parser.accepts("rate", "The request rate per second").withRequiredArg().describedAs("request_per_second").ofType(Double.class);
        ArgumentAcceptingOptionSpec requestDataSizeOpt = parser.accepts("size", "The request data size in bytes").withRequiredArg().describedAs("num_bytes").ofType(Long.class);
        ArgumentAcceptingOptionSpec numKeysOpt = parser.accepts("keys", "The number of keys for each request").withRequiredArg().describedAs("num_keys").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(3), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec timeoutOpt = parser.accepts("timeout", "The request timeout in ms").withRequiredArg().describedAs("timeout_milliseconds").ofType(Long.class);
        ArgumentAcceptingOptionSpec pct75Opt = parser.accepts("pct75", "75th percentile of request latency in ms (log-normal distribution)").withRequiredArg().describedAs("75th_percentile").ofType(Double.class);
        ArgumentAcceptingOptionSpec pct50Opt = parser.accepts("pct50", "50th percentile of request latency in ms (log-normal distribution)").withRequiredArg().describedAs("50th_percentile").ofType(Double.class);
        ArgumentAcceptingOptionSpec verboseOpt = parser.accepts("verbose", "show additional information").withRequiredArg().describedAs("true|false").ofType(Boolean.class).defaultsTo((Object)Predef$.MODULE$.boolean2Boolean(true), (Object[])new Boolean[0]);
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{numRequestsOpt, requestRateOpt, requestDataSizeOpt, pct75Opt, pct50Opt}));
        int numRequests = ((Double)options.valueOf((OptionSpec)numRequestsOpt)).intValue();
        double requestRate = (Double)options.valueOf((OptionSpec)requestRateOpt);
        int requestDataSize = ((Long)options.valueOf((OptionSpec)requestDataSizeOpt)).intValue();
        int numPossibleKeys = (Integer)options.valueOf((OptionSpec)keySpaceSizeOpt);
        int numKeys = (Integer)options.valueOf((OptionSpec)numKeysOpt);
        long timeout = (Long)options.valueOf((OptionSpec)timeoutOpt);
        double pct75 = (Double)options.valueOf((OptionSpec)pct75Opt);
        double pct50 = (Double)options.valueOf((OptionSpec)pct50Opt);
        boolean verbose = (Boolean)options.valueOf((OptionSpec)verboseOpt);
        Buffer gcMXBeans = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getGarbageCollectorMXBeans()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), (Ordering)Ordering.String$.MODULE$);
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        TestPurgatoryPerformance.LatencySamples latencySamples = new TestPurgatoryPerformance.LatencySamples(1000000, pct75, pct50);
        TestPurgatoryPerformance.IntervalSamples intervalSamples = new TestPurgatoryPerformance.IntervalSamples(1000000, requestRate);
        DelayedOperationPurgatory purgatory = DelayedOperationPurgatory$.MODULE$.apply("fake purgatory", DelayedOperationPurgatory$.MODULE$.apply$default$2(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        TestPurgatoryPerformance.CompletionQueue queue = new TestPurgatoryPerformance.CompletionQueue();
        Buffer gcNames = (Buffer)gcMXBeans.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Buffer$.MODULE$.canBuildFrom());
        Option<Object> initialCpuTimeNano = this.getProcessCpuTimeNanos(osMXBean);
        CountDownLatch latch = new CountDownLatch(numRequests);
        long start = System.currentTimeMillis();
        Random rand = new Random();
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq keys = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, numKeys).map((Function1 & Serializable & scala.Serializable)x$3 -> TestPurgatoryPerformance$.$anonfun$main$3(rand, numPossibleKeys, BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom());
        VolatileLongRef requestArrivalTime = VolatileLongRef.create((long)start);
        VolatileLongRef end = VolatileLongRef.create((long)0L);
        Runnable generator = new Runnable(numRequests, intervalSamples, latencySamples, requestArrivalTime, timeout, requestDataSize, latch, queue, purgatory, keys, end){
            private final int numRequests$1;
            private final TestPurgatoryPerformance.IntervalSamples intervalSamples$1;
            private final TestPurgatoryPerformance.LatencySamples latencySamples$1;
            private final VolatileLongRef requestArrivalTime$1;
            private final long timeout$1;
            private final int requestDataSize$1;
            private final CountDownLatch latch$1;
            private final TestPurgatoryPerformance.CompletionQueue queue$1;
            private final DelayedOperationPurgatory purgatory$1;
            private final IndexedSeq keys$1;
            private final VolatileLongRef end$1;

            public void run() {
                int i = this.numRequests$1;
                while (i > 0) {
                    --i;
                    long requestArrivalInterval = this.intervalSamples$1.next();
                    long latencyToComplete = this.latencySamples$1.next();
                    long now = System.currentTimeMillis();
                    this.requestArrivalTime$1.elem += requestArrivalInterval;
                    if (this.requestArrivalTime$1.elem > now) {
                        Thread.sleep(this.requestArrivalTime$1.elem - now);
                    }
                    TestPurgatoryPerformance.FakeOperation request = new TestPurgatoryPerformance.FakeOperation(this.timeout$1, this.requestDataSize$1, latencyToComplete, this.latch$1);
                    if (latencyToComplete < this.timeout$1) {
                        this.queue$1.add(request);
                    }
                    this.purgatory$1.tryCompleteElseWatch((DelayedOperation)request, (Seq)this.keys$1);
                }
                this.end$1.elem = System.currentTimeMillis();
            }
            {
                this.numRequests$1 = numRequests$1;
                this.intervalSamples$1 = intervalSamples$1;
                this.latencySamples$1 = latencySamples$1;
                this.requestArrivalTime$1 = requestArrivalTime$1;
                this.timeout$1 = timeout$1;
                this.requestDataSize$1 = requestDataSize$1;
                this.latch$1 = latch$1;
                this.queue$1 = queue$1;
                this.purgatory$1 = purgatory$1;
                this.keys$1 = keys$1;
                this.end$1 = end$1;
            }
        };
        Thread generatorThread = new Thread(generator);
        generatorThread.start();
        generatorThread.join();
        latch.await();
        long done = System.currentTimeMillis();
        queue.shutdown();
        if (verbose) {
            latencySamples.printStats();
            intervalSamples.printStats();
            String string = "# enqueue rate (%d requests):";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numRequests)})));
            String gcCountHeader = ((TraversableOnce)gcNames.map((Function1 & Serializable & scala.Serializable)x$4 -> new StringBuilder(8).append("<").append((String)x$4).append(" count>").toString(), Buffer$.MODULE$.canBuildFrom())).mkString(" ");
            String gcTimeHeader = ((TraversableOnce)gcNames.map((Function1 & Serializable & scala.Serializable)x$5 -> new StringBuilder(10).append("<").append((String)x$5).append(" time ms>").toString(), Buffer$.MODULE$.canBuildFrom())).mkString(" ");
            String string2 = "# <elapsed time ms>\t<target rate>\t<actual rate>\t<process cpu time ms>\t%s\t%s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Predef$.MODULE$.println((Object)new StringOps(string2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gcCountHeader, gcTimeHeader})));
        }
        double targetRate = (double)numRequests * 1000.0 / (double)(requestArrivalTime.elem - start);
        double actualRate = (double)numRequests * 1000.0 / (double)(end.elem - start);
        Option<Object> option = this.getProcessCpuTimeNanos(osMXBean);
        if (option == null) {
            throw null;
        }
        Option<Object> map_this = option;
        if (map_this.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            long l = BoxesRunTime.unboxToLong((Object)map_this.get());
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)TestPurgatoryPerformance$.$anonfun$main$6(initialCpuTimeNano, l)));
        }
        Buffer gcCounts = (Buffer)gcMXBeans.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.getCollectionCount()), Buffer$.MODULE$.canBuildFrom());
        Buffer gcTimes = (Buffer)gcMXBeans.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.getCollectionTime()), Buffer$.MODULE$.canBuildFrom());
        String string = "%d\t%f\t%f\t%d\t%s\t%s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Object[] objectArray = new Object[6];
        objectArray[0] = BoxesRunTime.boxToLong((long)(done - start));
        objectArray[1] = BoxesRunTime.boxToDouble((double)targetRate);
        objectArray[2] = BoxesRunTime.boxToDouble((double)actualRate);
        if (none$ == null) {
            throw null;
        }
        Object object = none$.isEmpty() ? BoxesRunTime.boxToLong((long)TestPurgatoryPerformance$.$anonfun$main$9()) : none$.get();
        objectArray[3] = object;
        objectArray[4] = gcCounts.mkString(" ");
        objectArray[5] = gcTimes.mkString(" ");
        Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
        purgatory.shutdown();
    }

    private Option<Object> getProcessCpuTimeNanos(OperatingSystemMXBean osMXBean) {
        try {
            return new Some((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)Class.forName("com.sun.management.OperatingSystemMXBean").getMethod("getProcessCpuTime", new Class[0]).invoke((Object)osMXBean, new Object[0]))));
        }
        catch (Throwable throwable) {
            try {
                return new Some((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)Class.forName("com.ibm.lang.management.OperatingSystemMXBean").getMethod("getProcessCpuTimeByNS", new Class[0]).invoke((Object)osMXBean, new Object[0]))));
            }
            catch (Throwable throwable2) {
                return None$.MODULE$;
            }
        }
    }

    public static final /* synthetic */ String $anonfun$main$3(Random rand$1, int numPossibleKeys$1, int x$3) {
        String string = "fakeKey%d";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rand$1.nextInt(numPossibleKeys$1))}));
    }

    public static final /* synthetic */ long $anonfun$main$6(Option initialCpuTimeNano$1, long x) {
        return (x - BoxesRunTime.unboxToLong((Object)initialCpuTimeNano$1.get())) / 1000000L;
    }

    public static final /* synthetic */ long $anonfun$main$9() {
        return -1L;
    }

    private TestPurgatoryPerformance$() {
        MODULE$ = this;
    }
}

