/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Predef;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4AAC\u0006\u0001!!)Q\u0003\u0001C\u0001-!9\u0001\u0004\u0001b\u0001\n\u0013I\u0002B\u0002\u0012\u0001A\u0003%!\u0004C\u0004$\u0001\t\u0007I\u0011\u0001\u0013\t\r-\u0002\u0001\u0015!\u0003&\u0011\u0015a\u0003\u0001\"\u0011.\u0011\u0015I\u0004\u0001\"\u0011;\u0011\u0015!\u0005\u0001\"\u0001;\u0011\u0015I\u0005\u0001\"\u0003K\u0005u\tE\r\u001a)beRLG/[8ogR{G\u000b\u001f8SKF,Xm\u001d;UKN$(B\u0001\u0007\u000e\u0003\u0019\u0019XM\u001d<fe*\ta\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0014\u001b\u0005Y\u0011B\u0001\u000b\f\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0018!\t\u0011\u0002!\u0001\u0004u_BL7-M\u000b\u00025A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0005Y\u0006twMC\u0001 \u0003\u0011Q\u0017M^1\n\u0005\u0005b\"AB*ue&tw-A\u0004u_BL7-\r\u0011\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t+\u0005)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#aA%oi\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\tq\u0013\u0007\u0005\u0002'_%\u0011\u0001g\n\u0002\u0005+:LG\u000fC\u00033\r\u0001\u00071'\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0010\u0002\tU$\u0018\u000e\\\u0005\u0003qU\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0015\u0019X\r^+q)\u0005q\u0003FA\u0004=!\ti$)D\u0001?\u0015\ty\u0004)A\u0003kk:LGOC\u0001B\u0003\ry'oZ\u0005\u0003\u0007z\u0012aAQ3g_J,\u0017\u0001P:i_VdGMU3dK&4Xm\u00149fe\u0006$\u0018n\u001c8O_R\fE\u000f^3naR,Gm\u00165f]>#\b.\u001a:QCJ$\u0018\u000e^5p]\"\u000b7/\u0012:s_JD#\u0001\u0003$\u0011\u0005u:\u0015B\u0001%?\u0005\u0011!Vm\u001d;\u0002\u001b\r\u0014X-\u0019;f%\u0016\fX/Z:u)\tYe\u000b\u0005\u0002M)6\tQJ\u0003\u0002O\u001f\u0006A!/Z9vKN$8O\u0003\u0002Q#\u000611m\\7n_:T!A\u0004*\u000b\u0005M\u0003\u0015AB1qC\u000eDW-\u0003\u0002V\u001b\nI\u0012\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o%\u0016\fX/Z:u\u0011\u00159\u0016\u00021\u0001Y\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u00043\u0006$gB\u0001.`\u001d\tYf,D\u0001]\u0015\tiv\"\u0001\u0004=e>|GOP\u0005\u0002Q%\u0011\u0001mJ\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00117M\u0001\u0003MSN$(B\u00011(!\t)g-D\u0001P\u0013\t9wJ\u0001\bU_BL7\rU1si&$\u0018n\u001c8")
public class AddPartitionsToTxnRequestTest
extends BaseRequestTest {
    private final String topic1;
    private final int numPartitions;

    private String topic1() {
        return this.topic1;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic1(), this.numPartitions(), this.servers().size(), new Properties());
    }

    @Test
    public void shouldReceiveOperationNotAttemptedWhenOtherPartitionHasError() {
        TopicPartition nonExistentTopic = new TopicPartition("unknownTopic", 0);
        TopicPartition createdTopicPartition = new TopicPartition(this.topic1(), 0);
        AddPartitionsToTxnRequest request = this.createRequest((List<TopicPartition>)new .colon.colon((Object)createdTopicPartition, (List)new .colon.colon((Object)nonExistentTopic, (List)Nil$.MODULE$)));
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        AddPartitionsToTxnResponse response = (AddPartitionsToTxnResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AddPartitionsToTxnResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assert.assertEquals((long)2L, (long)response.errors().size());
        Assert.assertTrue((boolean)response.errors().containsKey(createdTopicPartition));
        Assert.assertEquals((Object)Errors.OPERATION_NOT_ATTEMPTED, response.errors().get(createdTopicPartition));
        Assert.assertTrue((boolean)response.errors().containsKey(nonExistentTopic));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.errors().get(nonExistentTopic));
    }

    private AddPartitionsToTxnRequest createRequest(List<TopicPartition> partitions) {
        String transactionalId = "foobar";
        long producerId = 1000L;
        short producerEpoch = 0;
        return (AddPartitionsToTxnRequest)new AddPartitionsToTxnRequest.Builder(transactionalId, producerId, producerEpoch, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitions).asJava()).build();
    }

    public AddPartitionsToTxnRequestTest() {
        this.topic1 = "foobartopic";
        this.numPartitions = 3;
    }
}

