/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import kafka.admin.ElectionTypeConverter$;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.server.util.CommandDefaultOptions;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0005\n\u0007/!AQ\u0005\u0001B\u0001B\u0003%a\u0005C\u00038\u0001\u0011\u0005\u0001\bC\u0004=\u0001\t\u0007I\u0011A\u001f\t\r\u0011\u0003\u0001\u0015!\u0003?\u0011\u001d)\u0005A1A\u0005\u0002uBaA\u0012\u0001!\u0002\u0013q\u0004bB$\u0001\u0005\u0004%\t!\u0010\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002 \t\u000f%\u0003!\u0019!C\u0001{!1!\n\u0001Q\u0001\nyBqa\u0013\u0001C\u0002\u0013\u0005A\n\u0003\u0004W\u0001\u0001\u0006I!\u0014\u0005\b/\u0002\u0011\r\u0011\"\u0001Y\u0011\u0019a\u0006\u0001)A\u00053\"9Q\f\u0001b\u0001\n\u0003q\u0006B\u00024\u0001A\u0003%qL\u0001\u000fMK\u0006$WM]#mK\u000e$\u0018n\u001c8D_6l\u0017M\u001c3PaRLwN\\:\u000b\u0005M!\u0012!B1e[&t'\"A\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033\rj\u0011A\u0007\u0006\u00037q\tA!\u001e;jY*\u0011QDH\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005Uy\"B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001eL!\u0001\n\u000e\u0003+\r{W.\\1oI\u0012+g-Y;mi>\u0003H/[8og\u0006!\u0011M]4t!\r9#\u0006L\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t)\u0011I\u001d:bsB\u0011Q\u0006\u000e\b\u0003]I\u0002\"a\f\u0015\u000e\u0003AR!!\r\f\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0004&\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a)\u0003\u0019a\u0014N\\5u}Q\u0011\u0011h\u000f\t\u0003u\u0001i\u0011A\u0005\u0005\u0006K\t\u0001\rAJ\u0001\u0010E>|Go\u001d;sCB\u001cVM\u001d<feV\ta\bE\u0002@\u00052j\u0011\u0001\u0011\u0006\u0002\u0003\u0006Q!n\u001c9ug&l\u0007\u000f\\3\n\u0005\r\u0003%aG!sOVlWM\u001c;BG\u000e,\u0007\u000f^5oO>\u0003H/[8o'B,7-\u0001\tc_>$8\u000f\u001e:baN+'O^3sA\u0005\t\u0012\rZ7j]\u000ec\u0017.\u001a8u\u0007>tg-[4\u0002%\u0005$W.\u001b8DY&,g\u000e^\"p]\u001aLw\rI\u0001\u000fa\u0006$\b\u000eV8Kg>tg)\u001b7f\u0003=\u0001\u0018\r\u001e5U_*\u001bxN\u001c$jY\u0016\u0004\u0013!\u0002;pa&\u001c\u0017A\u0002;pa&\u001c\u0007%A\u0005qCJ$\u0018\u000e^5p]V\tQ\nE\u0002@\u0005:\u0003\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\t1\fgn\u001a\u0006\u0002'\u0006!!.\u0019<b\u0013\t)\u0006KA\u0004J]R,w-\u001a:\u0002\u0015A\f'\u000f^5uS>t\u0007%\u0001\nbY2$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cX#A-\u0011\u0005}R\u0016BA.A\u0005Ey\u0005\u000f^5p]N\u0003Xm\u0019\"vS2$WM]\u0001\u0014C2dGk\u001c9jGB\u000b'\u000f^5uS>t7\u000fI\u0001\rK2,7\r^5p]RK\b/Z\u000b\u0002?B\u0019qH\u00111\u0011\u0005\u0005$W\"\u00012\u000b\u0005\rt\u0012AB2p[6|g.\u0003\u0002fE\naQ\t\\3di&|g\u000eV=qK\u0006iQ\r\\3di&|g\u000eV=qK\u0002\u0002")
public final class LeaderElectionCommandOptions
extends CommandDefaultOptions {
    private final ArgumentAcceptingOptionSpec<String> bootstrapServer;
    private final ArgumentAcceptingOptionSpec<String> adminClientConfig;
    private final ArgumentAcceptingOptionSpec<String> pathToJsonFile;
    private final ArgumentAcceptingOptionSpec<String> topic;
    private final ArgumentAcceptingOptionSpec<Integer> partition;
    private final OptionSpecBuilder allTopicPartitions;
    private final ArgumentAcceptingOptionSpec<ElectionType> electionType;

    public ArgumentAcceptingOptionSpec<String> bootstrapServer() {
        return this.bootstrapServer;
    }

    public ArgumentAcceptingOptionSpec<String> adminClientConfig() {
        return this.adminClientConfig;
    }

    public ArgumentAcceptingOptionSpec<String> pathToJsonFile() {
        return this.pathToJsonFile;
    }

    public ArgumentAcceptingOptionSpec<String> topic() {
        return this.topic;
    }

    public ArgumentAcceptingOptionSpec<Integer> partition() {
        return this.partition;
    }

    public OptionSpecBuilder allTopicPartitions() {
        return this.allTopicPartitions;
    }

    public ArgumentAcceptingOptionSpec<ElectionType> electionType() {
        return this.electionType;
    }

    public LeaderElectionCommandOptions(String[] args) {
        super(args);
        this.bootstrapServer = this.parser.accepts("bootstrap-server", "A hostname and port for the broker to connect to, in the form host:port. Multiple comma separated URLs can be given. REQUIRED.").withRequiredArg().describedAs("host:port").ofType(String.class);
        this.adminClientConfig = this.parser.accepts("admin.config", "Configuration properties files to pass to the admin client").withRequiredArg().describedAs("config file").ofType(String.class);
        this.pathToJsonFile = this.parser.accepts("path-to-json-file", "The JSON file with the list  of partition for which leader elections should be performed. This is an example format. \n{\"partitions\":\n\t[{\"topic\": \"foo\", \"partition\": 1},\n\t {\"topic\": \"foobar\", \"partition\": 2}]\n}\nNot allowed if --all-topic-partitions or --topic flags are specified.").withRequiredArg().describedAs("Path to JSON file").ofType(String.class);
        this.topic = this.parser.accepts("topic", "Name of topic for which to perform an election. Not allowed if --path-to-json-file or --all-topic-partitions is specified.").withRequiredArg().describedAs("topic name").ofType(String.class);
        this.partition = this.parser.accepts("partition", "Partition id for which to perform an election. REQUIRED if --topic is specified.").withRequiredArg().describedAs("partition id").ofType(Integer.class);
        this.allTopicPartitions = this.parser.accepts("all-topic-partitions", "Perform election on all of the eligible topic partitions based on the type of election (see the --election-type flag). Not allowed if --topic or --path-to-json-file is specified.");
        this.electionType = this.parser.accepts("election-type", "Type of election to attempt. Possible values are \"preferred\" for preferred leader election or \"unclean\" for unclean leader election. If preferred election is selection, the election is only performed if the current leader is not the preferred leader for the topic partition. If unclean election is selected, the election is only performed if there are no leader for the topic partition. REQUIRED.").withRequiredArg().describedAs("election type").withValuesConvertedBy((ValueConverter)ElectionTypeConverter$.MODULE$);
        this.options = this.parser.parse(args);
    }
}

