/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.JoinGroupResult$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.SyncGroupResult;
import kafka.coordinator.group.SyncGroupResult$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.SetOps;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001B%K\u0001ECQ\u0001\u0017\u0001\u0005\u0002eCq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004g\u0001\u0001\u0006IA\u0018\u0005\bO\u0002\u0011\r\u0011\"\u0003^\u0011\u0019A\u0007\u0001)A\u0005=\"9\u0011\u000e\u0001b\u0001\n\u0013Q\u0007B\u00028\u0001A\u0003%1\u000eC\u0004p\u0001\t\u0007I\u0011B/\t\rA\u0004\u0001\u0015!\u0003_\u0011\u001d\t\bA1A\u0005\nuCaA\u001d\u0001!\u0002\u0013q\u0006bB:\u0001\u0005\u0004%I!\u0018\u0005\u0007i\u0002\u0001\u000b\u0011\u00020\t\u000fU\u0004!\u0019!C\u0005m\"1!\u0010\u0001Q\u0001\n]Dqa\u001f\u0001C\u0002\u0013%a\u000f\u0003\u0004}\u0001\u0001\u0006Ia\u001e\u0005\b\u0017\u0002\u0001\r\u0011\"\u0003~\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0004\u0002\u0012\u0001\u0001\u000b\u0015\u0002@\t\u0013\u0005M\u0001\u00011A\u0005\n\u0005U\u0001\"CA\u000f\u0001\u0001\u0007I\u0011BA\u0010\u0011!\t\u0019\u0003\u0001Q!\n\u0005]\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003w\u0001A\u0011AA\u0014\u0011\u001d\t)\u0005\u0001C\u0001\u0003OAq!!\u0013\u0001\t\u0003\t9\u0003C\u0004\u0002N\u0001!\t!a\n\t\u000f\u0005E\u0003\u0001\"\u0001\u0002(!9\u0011Q\u000b\u0001\u0005\u0002\u0005\u001d\u0002bBA-\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003;\u0002A\u0011AA\u0014\u0011\u001d\t\t\u0007\u0001C\u0001\u0003OAq!!\u001a\u0001\t\u0003\t9\u0003C\u0004\u0002j\u0001!\t!a\n\t\u000f\u00055\u0004\u0001\"\u0001\u0002(!9\u00111\u0010\u0001\u0005\u0002\u0005\u001d\u0002bBA@\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003\u0007\u0003A\u0011AA\u0014\u0011\u001d\t9\t\u0001C\u0001\u0003OAq!a#\u0001\t\u0003\t9\u0003C\u0004\u0002\u0010\u0002!\t!a\n\t\u000f\u0005E\u0005\u0001\"\u0001\u0002(!9\u0011Q\u0013\u0001\u0005\u0002\u0005\u001d\u0002bBAM\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003;\u0003A\u0011AA\u0014\u0011\u001d\t\t\u000b\u0001C\u0001\u0003OAq!!*\u0001\t\u0003\t9\u0003C\u0004\u0002*\u0002!\t!a\n\t\u000f\u00055\u0006\u0001\"\u0001\u0002(!9\u0011\u0011\u0017\u0001\u0005\u0002\u0005\u001d\u0002bBA[\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003s\u0003A\u0011AA\u0014\u0011\u001d\ti\f\u0001C\u0001\u0003OAq!!1\u0001\t\u0003\t9\u0003C\u0004\u0002F\u0002!\t!a\n\t\u000f\u0005%\u0007\u0001\"\u0001\u0002(!9\u0011Q\u001a\u0001\u0005\u0002\u0005\u001d\u0002bBAi\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003+\u0004A\u0011AA\u0014\u0011\u001d\tI\u000e\u0001C\u0001\u0003OAq!!8\u0001\t\u0003\t9\u0003C\u0004\u0002|\u0002!\t!a\n\t\u000f\u0005}\b\u0001\"\u0001\u0002(!9!1\u0001\u0001\u0005\u0002\u0005\u001d\u0002b\u0002B\u0004\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0005\u0017\u0001A\u0011AA\u0014\u0011\u001d\u0011y\u0001\u0001C\u0001\u0003OAqAa\u0005\u0001\t\u0003\t9\u0003C\u0004\u0003\u0018\u0001!\t!a\n\t\u000f\tm\u0001\u0001\"\u0003\u0003\u001e!9!1\u0006\u0001\u0005\n\t5\"!E$s_V\u0004X*\u001a;bI\u0006$\u0018\rV3ti*\u00111\nT\u0001\u0006OJ|W\u000f\u001d\u0006\u0003\u001b:\u000b1bY8pe\u0012Lg.\u0019;pe*\tq*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0006CA*W\u001b\u0005!&\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00025B\u00111\fA\u0007\u0002\u0015\u0006a\u0001O]8u_\u000e|G\u000eV=qKV\ta\f\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006!A.\u00198h\u0015\u0005\u0019\u0017\u0001\u00026bm\u0006L!!\u001a1\u0003\rM#(/\u001b8h\u00035\u0001(o\u001c;pG>dG+\u001f9fA\u00059qM]8va&#\u0017\u0001C4s_V\u0004\u0018\n\u001a\u0011\u0002\u001f\u001d\u0014x.\u001e9J]N$\u0018M\\2f\u0013\u0012,\u0012a\u001b\t\u0004'2t\u0016BA7U\u0005\u0011\u0019v.\\3\u0002!\u001d\u0014x.\u001e9J]N$\u0018M\\2f\u0013\u0012\u0004\u0013\u0001C7f[\n,'/\u00133\u0002\u00135,WNY3s\u0013\u0012\u0004\u0013\u0001C2mS\u0016tG/\u00133\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0013AC2mS\u0016tG\u000fS8ti\u0006Y1\r\\5f]RDun\u001d;!\u0003I\u0011XMY1mC:\u001cW\rV5nK>,H/T:\u0016\u0003]\u0004\"a\u0015=\n\u0005e$&aA%oi\u0006\u0019\"/\u001a2bY\u0006t7-\u001a+j[\u0016|W\u000f^'tA\u0005\u00012/Z:tS>tG+[7f_V$Xj]\u0001\u0012g\u0016\u001c8/[8o)&lWm\\;u\u001bN\u0004S#\u0001@\u0011\u0005m{\u0018bAA\u0001\u0015\niqI]8va6+G/\u00193bi\u0006\f\u0011b\u001a:pkB|F%Z9\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004'\u0006%\u0011bAA\u0006)\n!QK\\5u\u0011!\tyaEA\u0001\u0002\u0004q\u0018a\u0001=%c\u00051qM]8va\u0002\na!\\3nE\u0016\u0014XCAA\f!\rY\u0016\u0011D\u0005\u0004\u00037Q%AD'f[\n,'/T3uC\u0012\fG/Y\u0001\u000b[\u0016l'-\u001a:`I\u0015\fH\u0003BA\u0004\u0003CA\u0011\"a\u0004\u0017\u0003\u0003\u0005\r!a\u0006\u0002\u000f5,WNY3sA\u0005)1/\u001a;VaR\u0011\u0011q\u0001\u0015\u00041\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003k\t1a\u001c:h\u0013\u0011\tI$a\f\u0003\r\t+gm\u001c:f\u0003i!Xm\u001d;DC:\u0014VMY1mC:\u001cWm\u00165f]N#\u0018M\u00197fQ\rI\u0012q\b\t\u0005\u0003[\t\t%\u0003\u0003\u0002D\u0005=\"\u0001\u0002+fgR\fq\u0005^3ti\u000e\u000bgNU3cC2\fgnY3XQ\u0016t7i\\7qY\u0016$\u0018N\\4SK\n\fG.\u00198dK\"\u001a!$a\u0010\u0002SQ,7\u000f^\"b]:|GOU3cC2\fgnY3XQ\u0016t\u0007K]3qCJLgn\u001a*fE\u0006d\u0017M\\2fQ\rY\u0012qH\u0001\u001ci\u0016\u001cHoQ1o]>$(+\u001a2bY\u0006t7-Z,iK:$U-\u00193)\u0007q\ty$\u0001\u0015uKN$8\u000b^1cY\u0016$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR\u0013\u0018M\\:ji&|g\u000eK\u0002\u001e\u0003\u007f\t!\u0004^3tiN#\u0018M\u00197f)>$U-\u00193Ue\u0006t7/\u001b;j_:D3AHA \u0003M\"Xm\u001d;Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR\u0013\u0018M\\:ji&|g\u000eK\u0002 \u0003\u007f\ta\u0005^3tiB\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a+p\t\u0016\fG\r\u0016:b]NLG/[8oQ\r\u0001\u0013qH\u0001(i\u0016\u001cH\u000f\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR{W)\u001c9usR\u0013\u0018M\\:ji&|g\u000eK\u0002\"\u0003\u007f\t\u0011\u0004^3ti\u0016k\u0007\u000f^=U_\u0012+\u0017\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u001a!%a\u0010\u0002OQ,7\u000f^!xC&$\u0018N\\4SK\n\fG.\u00198dKR{7\u000b^1cY\u0016$&/\u00198tSRLwN\u001c\u0015\u0004G\u0005}\u0012A\t;fgR,U\u000e\u001d;z)>\u001cF/\u00192mK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0004%\u0003\u007f\t\t(a\u001d\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#!!\u001e\u0011\u0007}\u000b9(C\u0002\u0002z\u0001\u0014Q#\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|g.A\u0012uKN$8\u000b^1cY\u0016$vn\u0015;bE2,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u0007\u0015\ny$A\u0017uKN$X)\u001c9usR{\u0017i^1ji&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:DsAJA \u0003c\n\u0019(A\u001euKN$\bK]3qCJLgn\u001a*fE\u0006d\u0017M\\2f)>\u0004&/\u001a9be&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:DsaJA \u0003c\n\u0019(A\u0018uKN$\bK]3qCJLgn\u001a*fE\u0006d\u0017M\\2f)>\u001cF/\u00192mK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0004)\u0003\u007f\t\t(a\u001d\u0002sQ,7\u000f^!xC&$\u0018N\\4SK\n\fG.\u00198dKR{\u0017i^1ji&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:Ds!KA \u0003c\n\u0019(A\u0010uKN$H)Z1e)>$U-\u00193JY2,w-\u00197Ue\u0006t7/\u001b;j_:\f\u0011\u0005^3ti\u0012+\u0017\r\u001a+p'R\f'\r\\3JY2,w-\u00197Ue\u0006t7/\u001b;j_:DsaKA \u0003c\n\u0019(A\u0017uKN$H)Z1e)>\u0004&/\u001a9be&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:Ds\u0001LA \u0003c\n\u0019(\u0001\u0017uKN$H)Z1e)>\fu/Y5uS:<'+\u001a2bY\u0006t7-Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\":Q&a\u0010\u0002r\u0005M\u0014A\u0005;fgR\u001cV\r\\3diB\u0013x\u000e^8d_2D3ALA \u0003\r\"Xm\u001d;TK2,7\r\u001e)s_R|7m\u001c7SC&\u001cXm]%g\u001d>lU-\u001c2feNDsaLA \u0003c\n\u0019(A\u0016uKN$8+\u001a7fGR\u0004&o\u001c;pG>d7\t[8pg\u0016\u001c8i\\7qCRL'\r\\3Qe>$xnY8mQ\r\u0001\u0014qH\u0001\u0016i\u0016\u001cHoU;qa>\u0014Ho\u001d)s_R|7m\u001c7tQ\r\t\u0014qH\u0001\u0015i\u0016\u001cHoU;cg\u000e\u0014\u0018NY3e)>\u0004\u0018nY:)\u0007I\ny$\u0001\u0013uKN$8+\u001e2tGJL'-\u001a3U_BL7m\u001d(p]\u000e{gn];nKJ<%o\\;qQ\r\u0019\u0014qH\u0001\u0017i\u0016\u001cH/\u00138ji:+\u0007\u0010^$f]\u0016\u0014\u0018\r^5p]\"\u001aA'a\u0010\u0002AQ,7\u000f^%oSRtU\r\u001f;HK:,'/\u0019;j_:,U\u000e\u001d;z\u000fJ|W\u000f\u001d\u0015\u0004k\u0005}\u0012\u0001\u0005;fgR|eMZ:fi\u000e{W.\\5uQ\r1\u0014qH\u0001\u0018i\u0016\u001cHo\u00144gg\u0016$8i\\7nSR4\u0015-\u001b7ve\u0016D3aNA \u0003%\"Xm\u001d;PM\u001a\u001cX\r^\"p[6LGOR1jYV\u0014XmV5uQ\u0006sw\u000e\u001e5feB+g\u000eZ5oO\"\u001a\u0001(a\u0010\u0002EQ,7\u000f^(gMN,GoQ8n[&$x+\u001b;i\u0003:|G\u000f[3s!\u0016tG-\u001b8hQ\rI\u0014qH\u0001+i\u0016\u001cHoQ8ogVlWM\u001d\"fCR\u001cHK]1og\u0006\u001cG/[8oC2|eMZ:fi\u000e{W.\\5uQ\rQ\u0014qH\u0001)i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]\n+\u0017\r^:D_:\u001cX/\\3s\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u0015\u0004w\u0005}\u0012!\u000e;fgR$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{W.\\5u\u0013N\f%m\u001c:uK\u0012\fe\u000eZ\"p]N,X.\u001a:D_6l\u0017\u000e^,j]ND3\u0001PA \u00035\"Xm\u001d;GC&dW\r\u001a+y]>3gm]3u\u0007>lW.\u001b;MK\u00064Xm\u001d(p!\u0016tG-\u001b8h'R\fG/\u001a\u0015\u0004{\u0005}\u0012\u0001\r;fgR\u0014V\r\u001d7bG\u0016<%o\\;q\u0013:\u001cH/\u00198dK^KG\u000f[#naRLxI]8va&s7\u000f^1oG\u0016LE\rK\u0004?\u0003\u007f\t\t(!9$\u0005\u0005\r\b\u0003BAs\u0003ktA!a:\u0002r:!\u0011\u0011^Ax\u001b\t\tYOC\u0002\u0002nB\u000ba\u0001\u0010:p_Rt\u0014\"A+\n\u0007\u0005MH+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0018\u0011 \u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t'bAAz)\u0006iC/Z:u%\u0016\u0004H.Y2f\u000fJ|W\u000f]%ogR\fgnY3XSRDgj\u001c8Fq&\u001cH/\u001b8h\u001b\u0016l'-\u001a:)\u000f}\ny$!\u001d\u0002b\u0006AB/Z:u%\u0016\u0004H.Y2f\u000fJ|W\u000f]%ogR\fgnY3)\u0007\u0001\u000by$\u0001\fuKN$\u0018J\u001c<pW\u0016Tu.\u001b8DC2d'-Y2lQ\r\t\u0015qH\u0001\u001ai\u0016\u001cHOT8u\u0013:4xn[3K_&t7)\u00197mE\u0006\u001c7\u000eK\u0002C\u0003\u007f\ta\u0003^3ti&sgo\\6f'ft7mQ1mY\n\f7m\u001b\u0015\u0004\u0007\u0006}\u0012!\u0007;fgRtu\u000e^%om>\\WmU=oG\u000e\u000bG\u000e\u001c2bG.D3\u0001RA \u0003m!Xm\u001d;ICN\u0004VM\u001c3j]\u001etuN\u001c+y]>3gm]3ug\"\u001aQ)a\u0010\u00021Q,7\u000f\u001e%bgB+g\u000eZ5oORChn\u00144gg\u0016$8\u000fK\u0002G\u0003\u007f\t1\"Y:tKJ$8\u000b^1uKR1\u0011q\u0001B\u0010\u0005CAQaS$A\u0002yDqAa\tH\u0001\u0004\u0011)#A\u0006uCJ<W\r^*uCR,\u0007cA.\u0003(%\u0019!\u0011\u0006&\u0003\u0015\u001d\u0013x.\u001e9Ti\u0006$X-A\tpM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006$BAa\f\u0003<A!!\u0011\u0007B\u001c\u001b\t\u0011\u0019DC\u0002\u000369\u000baaY8n[>t\u0017\u0002\u0002B\u001d\u0005g\u0011\u0011c\u00144gg\u0016$\u0018I\u001c3NKR\fG-\u0019;b\u0011\u001d\u0011i\u0004\u0013a\u0001\u0005\u007f\taa\u001c4gg\u0016$\bcA*\u0003B%\u0019!1\t+\u0003\t1{gn\u001a")
public class GroupMetadataTest {
    private final String protocolType;
    private final String groupId;
    private final Some<String> groupInstanceId = new Some((Object)"groupInstanceId");
    private final String memberId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;
    private MemberMetadata member = null;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupId() {
        return this.groupId;
    }

    private Some<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    private String memberId() {
        return this.memberId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    private MemberMetadata member() {
        return this.member;
    }

    private void member_$eq(MemberMetadata x$1) {
        this.member = x$1;
    }

    @Before
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
        this.member_$eq(new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[0]), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)Nil$.MODULE$))));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToStableIllegalTransition() {
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        try {
            this.group().transitionTo((GroupState)Stable$.MODULE$);
            Assert.fail((String)"should have failed due to illegal transition");
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSelectProtocol() {
        void apply_elem;
        void apply_elems;
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[0]), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)Nil$.MODULE$)));
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assert.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[0]), (List)Nil$.MODULE$)));
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        SetOps setOps = (SetOps)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        String string = this.group().selectProtocol();
        if (setOps == null) {
            throw null;
        }
        string = null;
        Assert.assertTrue((boolean)setOps.contains((Object)apply_elem));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[0]), (List)Nil$.MODULE$)));
        GroupMetadata qual$3 = this.group();
        Function1 x$6 = qual$3.add$default$2();
        qual$3.add(lastMember, x$6);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test(expected=IllegalStateException.class)
    public void testSelectProtocolRaisesIfNoMembers() {
        this.group().selectProtocol();
        Assert.fail();
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[0]), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)Nil$.MODULE$)));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)new .colon.colon((Object)new Tuple2((Object)"blah", (Object)new byte[0]), (List)Nil$.MODULE$)));
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSupportsProtocols() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        void apply_elems7;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems7)));
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems6)));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems5)));
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems4)));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)new .colon.colon((Object)new Tuple2((Object)"blah", (Object)new byte[0]), (List)Nil$.MODULE$)));
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems3)));
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"});
        if (set$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        Assert.assertFalse((boolean)this.group().supportsProtocols("invalid_type", (Set)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems2)));
        Set$ set$7 = Predef$.MODULE$.Set();
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"});
        if (set$7 == null) {
            throw null;
        }
        arraySeq7 = null;
        Assert.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)IterableFactory.apply$((IterableFactory)set$7, (scala.collection.immutable.Seq)apply_elems)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSubscribedTopics() {
        void apply_elems;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()), (short)1).array()), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)new Some(IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), (Object)this.group().getSubscribedTopics());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(memberId);
        this.group().initNextGeneration();
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Some((Object)Set.EmptySet$.MODULE$), (Object)this.group().getSubscribedTopics());
        MemberMetadata memberWithFaultyProtocol = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[0]), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(memberWithFaultyProtocol, x$4);
        this.group().initNextGeneration();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testSubscribedTopicsNonConsumerGroup() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), "My Protocol", (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[0]), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInitNextGeneration() {
        void orNull_ev;
        void orNull_ev2;
        this.member().supportedProtocols_$eq((List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(this.member(), (Function1 & Serializable)x$1 -> {
            GroupMetadataTest.$anonfun$testInitNextGeneration$1(x$1);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Option option = this.group().protocolName();
        .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
        if (option == null) {
            throw null;
        }
        Option orNull_this = option;
        Object object = orNull_this.isEmpty() ? orNull_ev2.apply(null) : orNull_this.get();
        Object object2 = object;
        Object var1_2 = null;
        eq2 = null;
        object = null;
        Assert.assertNull((Object)object2);
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Option option2 = this.group().protocolName();
        .eq.colon.eq eq3 = $less$colon$less$.MODULE$.refl();
        if (option2 == null) {
            throw null;
        }
        Option orNull_this2 = option2;
        Object object3 = orNull_this2.isEmpty() ? orNull_ev.apply(null) : orNull_this2.get();
        Object object4 = object3;
        Object var4_5 = null;
        eq3 = null;
        object3 = null;
        Assert.assertEquals((Object)"roundrobin", (Object)object4);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInitNextGenerationEmptyGroup() {
        void orNull_ev;
        void orNull_ev2;
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Option option = this.group().protocolName();
        .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
        if (option == null) {
            throw null;
        }
        Option orNull_this = option;
        Object object = orNull_this.isEmpty() ? orNull_ev2.apply(null) : orNull_this.get();
        Object object2 = object;
        Object var1_2 = null;
        eq2 = null;
        object = null;
        Assert.assertNull((Object)object2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Option option2 = this.group().protocolName();
        .eq.colon.eq eq3 = $less$colon$less$.MODULE$.refl();
        if (option2 == null) {
            throw null;
        }
        Option orNull_this2 = option2;
        Object object3 = orNull_this2.isEmpty() ? orNull_ev.apply(null) : orNull_this2.get();
        Object object4 = object3;
        Object var4_5 = null;
        eq3 = null;
        object3 = null;
        Assert.assertNull((Object)object4);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetCommit() {
        void apply_elems;
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int commitRecordOffset = 3;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)partition, (Object)offset);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.group().prepareOffsetCommit((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)commitRecordOffset), offset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetCommitFailure() {
        void apply_elems;
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)partition, (Object)offset);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.group().prepareOffsetCommit((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        void apply_elems;
        void apply_elems2;
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)partition, (Object)firstOffset);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.group().prepareOffsetCommit((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = new Tuple2((Object)partition, (Object)secondOffset);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.group().prepareOffsetCommit((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)3L), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetCommitWithAnotherPending() {
        void apply_elems;
        void apply_elems2;
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)partition, (Object)firstOffset);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.group().prepareOffsetCommit((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = new Tuple2((Object)partition, (Object)secondOffset);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.group().prepareOffsetCommit((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)4L), firstOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)5L), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        void apply_elems;
        void apply_elems2;
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)partition, (Object)txnOffsetCommit);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.group().prepareTxnOffsetCommit(producerId, (Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = new Tuple2((Object)partition, (Object)consumerOffsetCommit);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.group().prepareOffsetCommit((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)3L), txnOffsetCommit));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)4L), consumerOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        void apply_elems;
        void apply_elems2;
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)partition, (Object)txnOffsetCommit);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.group().prepareTxnOffsetCommit(producerId, (Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = new Tuple2((Object)partition, (Object)consumerOffsetCommit);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.group().prepareOffsetCommit((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)3L), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)4L), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        void apply_elems;
        void apply_elems2;
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)partition, (Object)txnOffsetCommit);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.group().prepareTxnOffsetCommit(producerId, (Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = new Tuple2((Object)partition, (Object)consumerOffsetCommit);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.group().prepareOffsetCommit((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)3L), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)4L), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        void apply_elems;
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)partition, (Object)txnOffsetCommit);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.group().prepareTxnOffsetCommit(producerId, (Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingTxnOffsetCommit(producerId, partition);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceGroupInstanceWithEmptyGroupInstanceId() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assert.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assert.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, (Option)None$.MODULE$);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId());
    }

    @Test
    public void testReplaceGroupInstance() {
        BooleanRef booleanRef;
        BooleanRef booleanRef2;
        boolean create_e = false;
        BooleanRef booleanRef3 = booleanRef2 = new BooleanRef(create_e);
        booleanRef2 = null;
        BooleanRef joinAwaitingMemberFenced = booleanRef3;
        this.group().add(this.member(), (Function1 & Serializable)joinGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$1(joinAwaitingMemberFenced, joinGroupResult);
            return BoxedUnit.UNIT;
        });
        boolean create_e2 = false;
        BooleanRef booleanRef4 = booleanRef = new BooleanRef(create_e2);
        booleanRef = null;
        BooleanRef syncAwaitingMemberFenced = booleanRef4;
        this.member().awaitingSyncCallback_$eq((Function1 & Serializable)syncGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$2(syncAwaitingMemberFenced, syncGroupResult);
            return BoxedUnit.UNIT;
        });
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assert.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assert.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId());
        Assert.assertTrue((boolean)this.group().isLeader(newMemberId));
        Assert.assertEquals((Object)newMemberId, (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        Assert.assertTrue((boolean)joinAwaitingMemberFenced.elem);
        Assert.assertTrue((boolean)syncAwaitingMemberFenced.elem);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testInvokeJoinCallback() {
        BooleanRef booleanRef;
        boolean create_e = false;
        BooleanRef booleanRef2 = booleanRef = new BooleanRef(create_e);
        booleanRef = null;
        BooleanRef invoked = booleanRef2;
        this.group().add(this.member(), (Function1 & Serializable)x$2 -> {
            invoked.elem = true;
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)this.group().hasAllMembersJoined());
        this.group().maybeInvokeJoinCallback(this.member(), JoinGroupResult$.MODULE$.apply(this.member().memberId(), Errors.NONE));
        Assert.assertTrue((boolean)invoked.elem);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testNotInvokeJoinCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
        this.group().maybeInvokeJoinCallback(this.member(), JoinGroupResult$.MODULE$.apply(this.member().memberId(), Errors.NONE));
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testInvokeSyncCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.member().awaitingSyncCallback_$eq((Function1 & Serializable)x$3 -> {
            GroupMetadataTest.$anonfun$testInvokeSyncCallback$1(x$3);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)this.group().maybeInvokeSyncCallback(this.member(), SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testNotInvokeSyncCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        Assert.assertFalse((boolean)this.group().maybeInvokeSyncCallback(this.member(), SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHasPendingNonTxnOffsets() {
        void apply_elems;
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)partition, (Object)offset);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.group().prepareOffsetCommit((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHasPendingTxnOffsets() {
        void apply_elems;
        TopicPartition txnPartition = new TopicPartition("foo", 1);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int producerId = 5;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)txnPartition, (Object)offset);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.group().prepareTxnOffsetCommit((long)producerId, (Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(txnPartition));
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(new TopicPartition("non-exist", 0)));
    }

    /*
     * WARNING - void declaration
     */
    private void assertState(GroupMetadata group, GroupState targetState) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set states = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        if (states == null) {
            throw null;
        }
        ((Set)states.excl((Object)targetState)).foreach((Function1 & Serializable)otherState -> {
            GroupMetadataTest.$anonfun$assertState$1(group, otherState);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", Time.SYSTEM.milliseconds());
    }

    public static final /* synthetic */ void $anonfun$testInitNextGeneration$1(JoinGroupResult x$1) {
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$1(BooleanRef joinAwaitingMemberFenced$1, JoinGroupResult joinGroupResult) {
        Errors errors = joinGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        joinAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$2(BooleanRef syncAwaitingMemberFenced$1, SyncGroupResult syncGroupResult) {
        Errors errors = syncGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        syncAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testInvokeSyncCallback$1(SyncGroupResult x$3) {
    }

    public static final /* synthetic */ void $anonfun$assertState$1(GroupMetadata group$1, GroupState otherState) {
        Assert.assertFalse((boolean)group$1.is(otherState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupId = "groupId";
        this.memberId = "memberId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

