/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.HashMap;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import scala.Function1;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class KafkaBroker$ {
    public static final KafkaBroker$ MODULE$ = new KafkaBroker$();
    private static final String metricsPrefix = "kafka.server";
    private static final String metricsTypeName = "KafkaServer";
    private static final String KAFKA_CLUSTER_ID = "kafka.cluster.id";
    private static final String KAFKA_BROKER_ID = "kafka.broker.id";
    private static final String STARTED_MESSAGE = "Kafka Server started";

    public String metricsPrefix() {
        return metricsPrefix;
    }

    public String metricsTypeName() {
        return metricsTypeName;
    }

    private String KAFKA_CLUSTER_ID() {
        return KAFKA_CLUSTER_ID;
    }

    private String KAFKA_BROKER_ID() {
        return KAFKA_BROKER_ID;
    }

    public KafkaMetricsContext createKafkaMetricsContext(String clusterId, KafkaConfig config) {
        HashMap<String, Object> contextLabels = new HashMap<String, Object>();
        contextLabels.put(this.KAFKA_CLUSTER_ID(), clusterId);
        contextLabels.put(this.KAFKA_BROKER_ID(), Integer.toString(config.brokerId()));
        contextLabels.putAll(config.originalsWithPrefix("metrics.context."));
        return new KafkaMetricsContext(this.metricsPrefix(), contextLabels);
    }

    public void notifyClusterListeners(String clusterId, Seq<Object> clusterListeners) {
        ClusterResourceListeners clusterResourceListeners = new ClusterResourceListeners();
        clusterResourceListeners.maybeAddAll(CollectionConverters$.MODULE$.SeqHasAsJava(clusterListeners).asJava());
        clusterResourceListeners.onUpdate(new ClusterResource(clusterId));
    }

    public void notifyMetricsReporters(String clusterId, KafkaConfig config, Seq<Object> metricsReporters) {
        KafkaMetricsContext metricsContext = this.createKafkaMetricsContext(clusterId, config);
        metricsReporters.foreach((Function1 & Serializable)x0$1 -> {
            KafkaBroker$.$anonfun$notifyMetricsReporters$1(metricsContext, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public String STARTED_MESSAGE() {
        return STARTED_MESSAGE;
    }

    public static final /* synthetic */ void $anonfun$notifyMetricsReporters$1(KafkaMetricsContext metricsContext$1, Object x0$1) {
        if (x0$1 instanceof MetricsReporter) {
            ((MetricsReporter)x0$1).contextChange((MetricsContext)metricsContext$1);
            return;
        }
    }

    private KafkaBroker$() {
    }
}

