/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerContext;
import kafka.controller.Election$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import org.apache.kafka.common.TopicPartition;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001\u0002\u0007\u000e\u0001IA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\u0007\u0005\t7\u0001\u0011\t\u0011)A\u00059!A!\u0005\u0001B\u0001B\u0003%A\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u0004*\u0001\u0001\u0007I\u0011\u0001\u0016\t\u000fe\u0002\u0001\u0019!C\u0001u!1\u0001\t\u0001Q!\n-BQ!\u0011\u0001\u0005\u0002\tCQ!\u0012\u0001\u0005\u0002\u0019CQa\u0012\u0001\u0005B!Caa \u0001\u0005\n\u0005\u0005!!G'pG.\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016T!AD\b\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0011\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q)R\"A\u0007\n\u0005Yi!!\u0006)beRLG/[8o'R\fG/Z'bG\"Lg.Z\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$\bC\u0001\u000b\u001a\u0013\tQRBA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\fA$\u001e8dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g.\u00128bE2,G\r\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcDA\u0004C_>dW-\u00198\u00023%\u001cH*Z1eKJ\u0014VmY8wKJL8+\u001e9q_J$X\rZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u00152s\u0005\u000b\t\u0003)\u0001AQa\u0006\u0003A\u0002aAQa\u0007\u0003A\u0002qAQA\t\u0003A\u0002q\t\u0011d\u001d;bi\u0016\u001c\u0005.\u00198hKN\u0014\u0015\u0010V1sO\u0016$8\u000b^1uKV\t1\u0006\u0005\u0003-cM2T\"A\u0017\u000b\u00059z\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003ay\t!bY8mY\u0016\u001cG/[8o\u0013\t\u0011TFA\u0002NCB\u0004\"\u0001\u0006\u001b\n\u0005Uj!A\u0004)beRLG/[8o'R\fG/\u001a\t\u0003;]J!\u0001\u000f\u0010\u0003\u0007%sG/A\u000fti\u0006$Xm\u00115b]\u001e,7OQ=UCJ<W\r^*uCR,w\fJ3r)\tYd\b\u0005\u0002\u001ey%\u0011QH\b\u0002\u0005+:LG\u000fC\u0004@\r\u0005\u0005\t\u0019A\u0016\u0002\u0007a$\u0013'\u0001\u000eti\u0006$Xm\u00115b]\u001e,7OQ=UCJ<W\r^*uCR,\u0007%A\tti\u0006$Xm\u00115b]\u001e,7oQ1mYN$\"AN\"\t\u000b\u0011C\u0001\u0019A\u001a\u0002\u0017Q\f'oZ3u'R\fG/Z\u0001\u0006G2,\u0017M\u001d\u000b\u0002w\u0005\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)\u0011I\u0005O^<\u0011\t)\u000b6K\u0018\b\u0003\u0017>\u0003\"\u0001\u0014\u0010\u000e\u00035S!AT\t\u0002\rq\u0012xn\u001c;?\u0013\t\u0001f$\u0001\u0004Qe\u0016$WMZ\u0005\u0003eIS!\u0001\u0015\u0010\u0011\u0005QcV\"A+\u000b\u0005Y;\u0016AB2p[6|gN\u0003\u0002\u00111*\u0011\u0011LW\u0001\u0007CB\f7\r[3\u000b\u0003m\u000b1a\u001c:h\u0013\tiVK\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\t}#wM\u001b\b\u0003A\nt!\u0001T1\n\u0003}I!a\u0019\u0010\u0002\u000fA\f7m[1hK&\u0011QM\u001a\u0002\u0007\u000b&$\b.\u001a:\u000b\u0005\rt\u0002CA0i\u0013\tIgMA\u0005UQJ|w/\u00192mKB\u00111N\\\u0007\u0002Y*\u0011QnD\u0001\u0004CBL\u0017BA8m\u00051aU-\u00193fe\u0006sG-S:s\u0011\u0015\t(\u00021\u0001s\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0004gR\u001cV\"A\u0018\n\u0005U|#aA*fc\")AI\u0003a\u0001g!)\u0001P\u0003a\u0001s\u00061B.Z1eKJ,E.Z2uS>t7\u000b\u001e:bi\u0016<\u0017\u0010E\u0002\u001eurL!a\u001f\u0010\u0003\r=\u0003H/[8o!\t!R0\u0003\u0002\u007f\u001b\ty\u0002+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\*ue\u0006$XmZ=\u0002#\u0011|G*Z1eKJ,E.Z2uS>t7\u000fF\u0003J\u0003\u0007\t)\u0001C\u0003r\u0017\u0001\u0007!\u000fC\u0003y\u0017\u0001\u0007A\u0010")
public class MockPartitionStateMachine
extends PartitionStateMachine {
    private final ControllerContext controllerContext;
    private final boolean uncleanLeaderElectionEnabled;
    private final boolean isLeaderRecoverySupported;
    private Map<PartitionState, Object> stateChangesByTargetState;

    public Map<PartitionState, Object> stateChangesByTargetState() {
        return this.stateChangesByTargetState;
    }

    public void stateChangesByTargetState_$eq(Map<PartitionState, Object> x$1) {
        this.stateChangesByTargetState = x$1;
    }

    public int stateChangesCalls(PartitionState targetState) {
        return BoxesRunTime.unboxToInt((Object)this.stateChangesByTargetState().apply((Object)targetState));
    }

    public void clear() {
        this.stateChangesByTargetState().clear();
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<TopicPartition, Either<Throwable, LeaderAndIsr>> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> leaderElectionStrategy) {
        void var5_5;
        void var6_6;
        this.stateChangesByTargetState().update((Object)targetState, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.stateChangesByTargetState().apply((Object)targetState)) + 1)));
        partitions.foreach((Function1 & Serializable)partition -> {
            this.controllerContext.putPartitionStateIfNotExists(partition, (PartitionState)NonExistentPartition$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = this.controllerContext.checkValidPartitionStateChange(partitions, targetState);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq validPartitions = (Seq)tuple2._1();
        Seq invalidPartitions = (Seq)tuple2._2();
        if (var6_6.nonEmpty()) {
            Seq currentStates = (Seq)var6_6.map((Function1 & Serializable)p -> $this.controllerContext.partitionStates().get(p));
            throw new IllegalStateException(new StringBuilder(44).append("Invalid state transition to ").append(targetState).append(" for partitions ").append(currentStates).toString());
        }
        PartitionState partitionState = targetState;
        OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
        if (partitionState != null && partitionState.equals(onlinePartition$)) {
            Seq uninitializedPartitions = (Seq)var5_5.filter((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)MockPartitionStateMachine.$anonfun$handleStateChanges$3(this, partition)));
            Seq partitionsToElectLeader = (Seq)partitions.filter((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)MockPartitionStateMachine.$anonfun$handleStateChanges$4(this, partition)));
            uninitializedPartitions.foreach((Function1 & Serializable)partition -> {
                this.controllerContext.putPartitionState(partition, targetState);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Map<TopicPartition, Either<Throwable, LeaderAndIsr>> electionResults = this.doLeaderElections((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)leaderElectionStrategy.get());
            electionResults.foreach((Function1 & Serializable)x0$1 -> {
                MockPartitionStateMachine.$anonfun$handleStateChanges$6(this, targetState, x0$1);
                return BoxedUnit.UNIT;
            });
            return electionResults;
        }
        var5_5.foreach((Function1 & Serializable)partition -> {
            this.controllerContext.putPartitionState(partition, targetState);
            return BoxedUnit.UNIT;
        });
        return Predef$.MODULE$.Map().empty();
    }

    private scala.collection.immutable.Map<TopicPartition, Either<Throwable, LeaderAndIsr>> doLeaderElections(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy leaderElectionStrategy) {
        Seq seq;
        Map failedElections = (Map)Map$.MODULE$.empty();
        Buffer validLeaderAndIsrs = (Buffer)Buffer$.MODULE$.empty();
        partitions.foreach((Function1 & Serializable)partition -> {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo(partition).get();
            if (leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch()) {
                String failMsg = new StringBuilder(0).append(new StringBuilder(71).append("Aborted leader election for partition ").append(partition).append(" since the LeaderAndIsr path was ").toString()).append("already written by another controller. This probably means that the current controller went through ").append(new StringBuilder(62).append("a soft failure and another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(".").toString()).toString();
                return failedElections.put(partition, (Object)package$.MODULE$.Left().apply((Object)new StateChangeFailedException(failMsg)));
            }
            return validLeaderAndIsrs.append((Object)new Tuple2(partition, (Object)leaderIsrAndControllerEpoch.leaderAndIsr()));
        });
        if (leaderElectionStrategy instanceof OfflinePartitionLeaderElectionStrategy) {
            boolean isUnclean = ((OfflinePartitionLeaderElectionStrategy)leaderElectionStrategy).allowUnclean();
            Buffer partitionsWithUncleanLeaderElectionState = (Buffer)validLeaderAndIsrs.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition partition = (TopicPartition)x0$1._1();
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
                Tuple3 tuple3 = new Tuple3((Object)partition, (Object)new Some((Object)leaderAndIsr), (Object)BoxesRunTime.boxToBoolean((isUnclean || $this.uncleanLeaderElectionEnabled ? 1 : 0) != 0));
                return tuple3;
            });
            seq = Election$.MODULE$.leaderForOffline(this.controllerContext, this.isLeaderRecoverySupported, (Seq)partitionsWithUncleanLeaderElectionState);
        } else if (ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(leaderElectionStrategy)) {
            seq = Election$.MODULE$.leaderForReassign(this.controllerContext, (Seq)validLeaderAndIsrs);
        } else if (PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(leaderElectionStrategy)) {
            seq = Election$.MODULE$.leaderForPreferredReplica(this.controllerContext, (Seq)validLeaderAndIsrs);
        } else if (ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(leaderElectionStrategy)) {
            seq = Election$.MODULE$.leaderForControlledShutdown(this.controllerContext, (Seq)validLeaderAndIsrs);
        } else {
            throw new MatchError((Object)leaderElectionStrategy);
        }
        return (scala.collection.immutable.Map)((IterableOnceOps)seq.map((Function1 & Serializable)electionResult -> {
            Left left;
            TopicPartition partition = electionResult.topicPartition();
            Option option = electionResult.leaderAndIsr();
            if (None$.MODULE$.equals(option)) {
                String failMsg = new StringBuilder(53).append("Failed to elect leader for partition ").append(partition).append(" under strategy ").append(leaderElectionStrategy).toString();
                left = package$.MODULE$.Left().apply((Object)new StateChangeFailedException(failMsg));
            } else if (option instanceof Some) {
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Some)option).value();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
                $this.controllerContext.putPartitionLeadershipInfo(partition, leaderIsrAndControllerEpoch);
                left = package$.MODULE$.Right().apply((Object)leaderAndIsr);
            } else {
                throw new MatchError((Object)option);
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)left);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)failedElections);
    }

    public static final /* synthetic */ boolean $anonfun$handleStateChanges$3(MockPartitionStateMachine $this, TopicPartition partition) {
        PartitionState partitionState = $this.controllerContext.partitionState(partition);
        NewPartition$ newPartition$ = NewPartition$.MODULE$;
        return partitionState != null && partitionState.equals(newPartition$);
    }

    public static final /* synthetic */ boolean $anonfun$handleStateChanges$4(MockPartitionStateMachine $this, TopicPartition partition) {
        block3: {
            block2: {
                PartitionState currentState;
                PartitionState partitionState = currentState = $this.controllerContext.partitionState(partition);
                OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                if (partitionState != null && partitionState.equals(offlinePartition$)) break block2;
                PartitionState partitionState2 = currentState;
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                if (partitionState2 == null || !partitionState2.equals(onlinePartition$)) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$handleStateChanges$6(MockPartitionStateMachine $this, PartitionState targetState$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            if ((Either)x0$1._2() instanceof Right) {
                $this.controllerContext.putPartitionState(partition, targetState$1);
                return;
            }
        }
        if (x0$1 != null && (Either)x0$1._2() instanceof Left) {
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public MockPartitionStateMachine(ControllerContext controllerContext, boolean uncleanLeaderElectionEnabled, boolean isLeaderRecoverySupported) {
        this.controllerContext = controllerContext;
        this.uncleanLeaderElectionEnabled = uncleanLeaderElectionEnabled;
        this.isLeaderRecoverySupported = isLeaderRecoverySupported;
        super(controllerContext);
        this.stateChangesByTargetState = ((Map)Map$.MODULE$.empty()).withDefaultValue((Object)BoxesRunTime.boxToInteger((int)0));
    }
}

