/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.util.stream.IntStream;
import kafka.coordinator.transaction.ProducerIdManagerTest$MockProducerIdManager$;
import kafka.coordinator.transaction.RPCProducerIdManager;
import kafka.coordinator.transaction.ZkProducerIdManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001B\u000f\u001f\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001A\u0002\u0013\u0005\u0011\u0007C\u00049\u0001\u0001\u0007I\u0011A\u001d\t\r}\u0002\u0001\u0015)\u00033\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005Ca\u0001\u0013\u0001!\u0002\u0013\u0011e\u0001B%\u0001\u0001)C\u0001BT\u0004\u0003\u0006\u0004%\ta\u0014\u0005\t'\u001e\u0011\t\u0011)A\u0005!\"AAk\u0002BA\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u000f\t\u0005\r\u0011\"\u0001[\u0011!avA!A!B\u00131\u0006\u0002C/\b\u0005\u000b\u0007I\u0011A(\t\u0011y;!\u0011!Q\u0001\nAC\u0001bX\u0004\u0003\u0002\u0004%\t\u0001\u0019\u0005\t]\u001e\u0011\t\u0019!C\u0001_\"A\u0011o\u0002B\u0001B\u0003&\u0011\rC\u0003-\u000f\u0011\u0005!\u000f\u0003\u0004z\u000f\u0011\u0005cD_\u0004\bw\u0002\t\t\u0011#\u0001}\r\u001dI\u0005!!A\t\u0002uDQ\u0001L\u000b\u0005\u0002yD\u0001b`\u000b\u0012\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u0007\u0003/\u0001A\u0011\u0001>\t\r\u0005=\u0002\u0001\"\u0001{\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!!\u0019\u0001\t\u0003\t\u0019\u0007\u0003\u0004\u0002\u0002\u0002!\tA\u001f\u0002\u0016!J|G-^2fe&#W*\u00198bO\u0016\u0014H+Z:u\u0015\ty\u0002%A\u0006ue\u0006t7/Y2uS>t'BA\u0011#\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003\r\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0018\u0011\u0005=\u0002Q\"\u0001\u0010\u0002%\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM]\u000b\u0002eA\u00111GN\u0007\u0002i)\u0011QGI\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005]\"$\u0001\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\faC\u0019:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe~#S-\u001d\u000b\u0003uu\u0002\"aJ\u001e\n\u0005qB#\u0001B+oSRDqAP\u0002\u0002\u0002\u0003\u0007!'A\u0002yIE\n1C\u0019:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe\u0002\n\u0001B_6DY&,g\u000e^\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011QII\u0001\u0003u.L!a\u0012#\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003%Q8n\u00117jK:$\bEA\u000bN_\u000e\\\u0007K]8ek\u000e,'/\u00133NC:\fw-\u001a:\u0014\u0005\u001dY\u0005CA\u0018M\u0013\tieD\u0001\u000bS!\u000e\u0003&o\u001c3vG\u0016\u0014\u0018\nZ'b]\u0006<WM]\u0001\tEJ|7.\u001a:JIV\t\u0001\u000b\u0005\u0002(#&\u0011!\u000b\u000b\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003\u001dIGm\u0015;beR,\u0012A\u0016\t\u0003O]K!\u0001\u0017\u0015\u0003\t1{gnZ\u0001\fS\u0012\u001cF/\u0019:u?\u0012*\u0017\u000f\u0006\u0002;7\"9ahCA\u0001\u0002\u00041\u0016\u0001C5e'R\f'\u000f\u001e\u0011\u0002\u000b%$G*\u001a8\u0002\r%$G*\u001a8!\u0003\u0015)'O]8s+\u0005\t\u0007C\u00012m\u001b\u0005\u0019'B\u00013f\u0003!\u0001(o\u001c;pG>d'B\u00014h\u0003\u0019\u0019w.\\7p]*\u00111\u0005\u001b\u0006\u0003S*\fa!\u00199bG\",'\"A6\u0002\u0007=\u0014x-\u0003\u0002nG\n1QI\u001d:peN\f\u0011\"\u001a:s_J|F%Z9\u0015\u0005i\u0002\bb\u0002 \u0011\u0003\u0003\u0005\r!Y\u0001\u0007KJ\u0014xN\u001d\u0011\u0015\u000bM,ho\u001e=\u0011\u0005Q<Q\"\u0001\u0001\t\u000b9\u0013\u0002\u0019\u0001)\t\u000bQ\u0013\u0002\u0019\u0001,\t\u000bu\u0013\u0002\u0019\u0001)\t\u000f}\u0013\u0002\u0013!a\u0001C\u0006Y1/\u001a8e%\u0016\fX/Z:u)\u0005Q\u0014!F'pG.\u0004&o\u001c3vG\u0016\u0014\u0018\nZ'b]\u0006<WM\u001d\t\u0003iV\u0019\"!\u0006\u0014\u0015\u0003q\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAA\u0002U\r\t\u0017QA\u0016\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0003\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0016\u0005-!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0019B/Z:u\u000f\u0016$\bK]8ek\u000e,'/\u00133[W\"\u001a\u0001$a\u0007\u0011\t\u0005u\u00111F\u0007\u0003\u0003?QA!!\t\u0002$\u0005\u0019\u0011\r]5\u000b\t\u0005\u0015\u0012qE\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tIC[\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003[\tyB\u0001\u0003UKN$\u0018a\u0007;fgR,\u0005pY3fIB\u0013x\u000eZ;dKJLE\rT5nSRT6\u000eK\u0002\u001a\u00037\t\u0011\u0003^3ti\u000e{g\u000e^5hk>,8/\u00133t)\rQ\u0014q\u0007\u0005\u0007\u0003sQ\u0002\u0019\u0001)\u0002\u0015%$'\t\\8dW2+g\u000eK\u0004\u001b\u0003{\ti%a\u0014\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005A\u0001O]8wS\u0012,'O\u0003\u0003\u0002H\u0005\r\u0012A\u00029be\u0006l7/\u0003\u0003\u0002L\u0005\u0005#a\u0003,bYV,7k\\;sG\u0016\fA!\u001b8ug22\u0011\u0011KA*\u0003+j\u0012!A\u000f\u0002\u0005u\t!\u0002K\u0002\u001b\u00033\u0002B!a\u0017\u0002^5\u0011\u0011QI\u0005\u0005\u0003?\n)EA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fq\u0003^3tiVs'/Z2pm\u0016\u0014\u0018M\u00197f\u000bJ\u0014xN]:\u0015\u0007i\n)\u0007C\u0003`7\u0001\u0007\u0011\rK\u0006\u001c\u0003S\ny'!\u001d\u0002t\u0005U\u0004\u0003BA \u0003WJA!!\u001c\u0002B\tQQI\\;n'>,(oY3\u0002\u000bY\fG.^3$\u0003\u0005\fQA\\1nKNdC!a\u001e\u0002|\u0005\u0012\u0011\u0011P\u0001\u0015+:[ejT,O?N+%KV#S?\u0016\u0013&k\u0014*\"\u0005\u0005u\u0014aD%O-\u0006c\u0015\nR0S\u000bF+Vi\u0015+)\u0007m\tI&A\tuKN$\u0018J\u001c<bY&$'+\u00198hKND3\u0001HA\u000e\u0001")
public class ProducerIdManagerTest {
    private volatile ProducerIdManagerTest$MockProducerIdManager$ MockProducerIdManager$module;
    private BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);

    public ProducerIdManagerTest$MockProducerIdManager$ MockProducerIdManager() {
        if (this.MockProducerIdManager$module == null) {
            this.MockProducerIdManager$lzycompute$1();
        }
        return this.MockProducerIdManager$module;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    @Test
    public void testGetProducerIdZk() {
        ObjectRef zkVersion = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef data = ObjectRef.create(null);
        Mockito.when((Object)this.zkClient().getDataAndVersion(ArgumentMatchers.anyString())).thenAnswer(x$1 -> (Tuple2)((Option)zkVersion$1.elem).map((Function1 & Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)((byte[])data.elem))), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$2)))).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0))));
        ArgumentCaptor capturedVersion = ArgumentCaptor.forClass(Integer.TYPE);
        ArgumentCaptor capturedData = ArgumentCaptor.forClass(byte[].class);
        Mockito.when((Object)this.zkClient().conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])capturedData.capture(), BoxesRunTime.unboxToInt((Object)capturedVersion.capture()), (Option)ArgumentMatchers.any())).thenAnswer(x$3 -> {
            int newZkVersion = BoxesRunTime.unboxToInt((Object)capturedVersion.getValue()) + 1;
            zkVersion$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)newZkVersion));
            data$1.elem = (byte[])capturedData.getValue();
            return new Tuple2.mcZI.sp(true, newZkVersion);
        });
        ZkProducerIdManager manager1 = new ZkProducerIdManager(0, this.zkClient());
        ZkProducerIdManager manager2 = new ZkProducerIdManager(1, this.zkClient());
        long pid1 = manager1.generateProducerId();
        long pid2 = manager2.generateProducerId();
        Assertions.assertEquals((long)0L, (long)pid1);
        Assertions.assertEquals((long)1000L, (long)pid2);
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)1000L)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)i -> Assertions.assertEquals((long)(pid1 + i), (long)manager1.generateProducerId()));
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)1000L)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)i -> Assertions.assertEquals((long)(pid2 + i), (long)manager2.generateProducerId()));
        Assertions.assertEquals((long)(pid2 + 1000L), (long)manager1.generateProducerId());
        Assertions.assertEquals((long)(pid2 + 2000L), (long)manager2.generateProducerId());
    }

    @Test
    public void testExceedProducerIdLimitZk() {
        Mockito.when((Object)this.zkClient().getDataAndVersion(ArgumentMatchers.anyString())).thenAnswer(x$4 -> {
            byte[] json = ProducerIdBlockZNode$.MODULE$.generateProducerIdBlockJson(new ProducerIdsBlock(0, 9223372036854774807L, 1000));
            return new Tuple2((Object)new Some((Object)json), (Object)BoxesRunTime.boxToInteger((int)0));
        });
        Assertions.assertThrows(KafkaException.class, () -> new ZkProducerIdManager(0, this.zkClient()));
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 10})
    public void testContiguousIds(int idBlockLen) {
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, idBlockLen, Errors.NONE);
        IntStream.range(0, idBlockLen * 3).forEach(i -> Assertions.assertEquals((long)i, (long)manager.generateProducerId()));
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"UNKNOWN_SERVER_ERROR", "INVALID_REQUEST"})
    public void testUnrecoverableErrors(Errors error) {
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, 1, Errors.NONE);
        Assertions.assertEquals((long)0L, (long)manager.generateProducerId());
        manager.error_$eq(error);
        Assertions.assertThrows(Throwable.class, () -> manager.generateProducerId());
        manager.error_$eq(Errors.NONE);
        Assertions.assertEquals((long)1L, (long)manager.generateProducerId());
    }

    @Test
    public void testInvalidRanges() {
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        ObjectRef manager = ObjectRef.create((Object)((Object)new MockProducerIdManager(this, 0, -1L, 10, Errors.NONE)));
        Assertions.assertThrows(KafkaException.class, () -> ((MockProducerIdManager)((Object)((Object)manager$3.elem))).generateProducerId());
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        manager.elem = new MockProducerIdManager(this, 0, 0L, -1, Errors.NONE);
        Assertions.assertThrows(KafkaException.class, () -> ((MockProducerIdManager)((Object)((Object)manager$3.elem))).generateProducerId());
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        manager.elem = new MockProducerIdManager(this, 0, 0x7FFFFFFFFFFFFFFEL, 10, Errors.NONE);
        Assertions.assertThrows(KafkaException.class, () -> ((MockProducerIdManager)((Object)((Object)manager$3.elem))).generateProducerId());
    }

    private final void MockProducerIdManager$lzycompute$1() {
        synchronized (this) {
            if (this.MockProducerIdManager$module == null) {
                this.MockProducerIdManager$module = new ProducerIdManagerTest$MockProducerIdManager$(this);
            }
            return;
        }
    }

    public class MockProducerIdManager
    extends RPCProducerIdManager {
        private final int brokerId;
        private long idStart;
        private final int idLen;
        private Errors error;
        public final /* synthetic */ ProducerIdManagerTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public long idStart() {
            return this.idStart;
        }

        public void idStart_$eq(long x$1) {
            this.idStart = x$1;
        }

        public int idLen() {
            return this.idLen;
        }

        public Errors error() {
            return this.error;
        }

        public void error_$eq(Errors x$1) {
            this.error = x$1;
        }

        public void sendRequest() {
            Errors errors = this.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                this.handleAllocateProducerIdsResponse(new AllocateProducerIdsResponse(new AllocateProducerIdsResponseData().setProducerIdStart(this.idStart()).setProducerIdLen(this.idLen())));
                this.idStart_$eq(this.idStart() + (long)this.idLen());
                return;
            }
            this.handleAllocateProducerIdsResponse(new AllocateProducerIdsResponse(new AllocateProducerIdsResponseData().setErrorCode(this.error().code())));
        }

        public /* synthetic */ ProducerIdManagerTest kafka$coordinator$transaction$ProducerIdManagerTest$MockProducerIdManager$$$outer() {
            return this.$outer;
        }

        public MockProducerIdManager(ProducerIdManagerTest $outer, int brokerId, long idStart, int idLen, Errors error) {
            this.brokerId = brokerId;
            this.idStart = idStart;
            this.idLen = idLen;
            this.error = error;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(brokerId, (Function0)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final long apply() {
                    return 1L;
                }

                public long apply$mcJ$sp() {
                    return 1L;
                }
            }, $outer.brokerToController(), 100);
        }
    }
}

