/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.token.delegation;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import kafka.network.RequestChannel;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.security.authorizer.AuthorizerUtils$;
import kafka.server.CreateTokenResult;
import kafka.server.Defaults$;
import kafka.server.DelegationTokenManager;
import kafka.server.DelegationTokenManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t-d\u0001\u0002\u0017.\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004Q\u0001\u0001\u0006Ia\u0011\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0011\u0019Q\u0006\u0001)A\u0005'\"91\f\u0001b\u0001\n\u0003a\u0006BB4\u0001A\u0003%Q\fC\u0004i\u0001\t\u0007I\u0011A5\t\rM\u0004\u0001\u0015!\u0003k\u0011\u001d!\bA1A\u0005\u0002UDaA \u0001!\u0002\u00131\b\u0002C@\u0001\u0005\u0004%\t!!\u0001\t\u0011\u0005-\u0001\u0001)A\u0005\u0003\u0007A\u0011\"!\u0004\u0001\u0005\u0004%\t!!\u0001\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u0007A\u0011\"!\u0005\u0001\u0001\u0004%\t!a\u0005\t\u0013\u0005\u0015\u0002\u00011A\u0005\u0002\u0005\u001d\u0002\u0002CA\u001a\u0001\u0001\u0006K!!\u0006\t\u0013\u0005U\u0002\u00011A\u0005\u0002\u0005]\u0002\"CA#\u0001\u0001\u0007I\u0011AA$\u0011!\tY\u0005\u0001Q!\n\u0005e\u0002bCA'\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u001fB1\"a\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002Z!Y\u0011Q\f\u0001A\u0002\u0003\u0005\u000b\u0015BA)\u0011%\ty\u0006\u0001a\u0001\n\u0003\t\t\u0007C\u0005\u0002p\u0001\u0001\r\u0011\"\u0001\u0002r!A\u0011Q\u000f\u0001!B\u0013\t\u0019\u0007C\u0005\u0002x\u0001\u0001\r\u0011\"\u0001\u0002\u0002!I\u0011\u0011\u0010\u0001A\u0002\u0013\u0005\u00111\u0010\u0005\t\u0003\u007f\u0002\u0001\u0015)\u0003\u0002\u0004!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAS\u0001\u0011\u0005\u0013q\u0015\u0005\b\u0003c\u0003A\u0011AAT\u0011\u001d\tY\f\u0001C\u0001\u0003OCq!a0\u0001\t\u0003\t9\u000bC\u0004\u0002D\u0002!\t!a*\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002(\"9\u00111\u001a\u0001\u0005\u0002\u0005\u001d\u0006bBAh\u0001\u0011%\u0011\u0011\u001b\u0005\b\u0005[\u0001A\u0011AAT\u0011\u001d\u0011\t\u0004\u0001C\u0005\u0005gAqA!\u000f\u0001\t\u0013\u0011Y\u0004C\u0004\u0003D\u0001!IA!\u0012\u00035\u0011+G.Z4bi&|g\u000eV8lK:l\u0015M\\1hKJ$Vm\u001d;\u000b\u00059z\u0013A\u00033fY\u0016<\u0017\r^5p]*\u0011\u0001'M\u0001\u0006i>\\WM\u001c\u0006\u0003eM\n\u0001b]3dkJLG/\u001f\u0006\u0002i\u0005)1.\u00194lC\u000e\u00011C\u0001\u00018!\tA4(D\u0001:\u0015\tQ4'\u0001\u0004tKJ4XM]\u0005\u0003ye\u0012\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tq\b\u0005\u0002A\u00015\tQ&\u0001\u0003uS6,W#A\"\u0011\u0005\u0011sU\"A#\u000b\u0005\u0019;\u0015!B;uS2\u001c(B\u0001%J\u0003\u0019\u0019w.\\7p]*\u0011AG\u0013\u0006\u0003\u00172\u000ba!\u00199bG\",'\"A'\u0002\u0007=\u0014x-\u0003\u0002P\u000b\nAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0003po:,'/F\u0001T!\t!\u0006,D\u0001V\u0015\t1v+\u0001\u0003bkRD'B\u0001\u001aH\u0013\tIVK\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u0002\r=<h.\u001a:!\u0003\u001d\u0011XM\\3xKJ,\u0012!\u0018\t\u0004=\u0016\u001cV\"A0\u000b\u0005\u0001\f\u0017!C5n[V$\u0018M\u00197f\u0015\t\u00117-\u0001\u0006d_2dWm\u0019;j_:T\u0011\u0001Z\u0001\u0006g\u000e\fG.Y\u0005\u0003M~\u0013A\u0001T5ti\u0006A!/\u001a8fo\u0016\u0014\b%A\u0007u_.,g.T1oC\u001e,'o]\u000b\u0002UB\u00191N\u001c9\u000e\u00031T!!\\1\u0002\u000f5,H/\u00192mK&\u0011q\u000e\u001c\u0002\u0007\u0005V4g-\u001a:\u0011\u0005a\n\u0018B\u0001::\u0005Y!U\r\\3hCRLwN\u001c+pW\u0016tW*\u00198bO\u0016\u0014\u0018A\u0004;pW\u0016tW*\u00198bO\u0016\u00148\u000fI\u0001\ng\u0016\u001c'/\u001a;LKf,\u0012A\u001e\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\fA\u0001\\1oO*\t10\u0001\u0003kCZ\f\u0017BA?y\u0005\u0019\u0019FO]5oO\u0006Q1/Z2sKR\\U-\u001f\u0011\u0002)5\f\u0007\u0010T5gKRKW.Z't\t\u00164\u0017-\u001e7u+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005\u001dQ\"A2\n\u0007\u0005%1M\u0001\u0003M_:<\u0017!F7bq2Kg-\u001a+j[\u0016l5\u000fR3gCVdG\u000fI\u0001\u0013e\u0016tWm\u001e+j[\u0016l5\u000fR3gCVdG/A\nsK:,w\u000fV5nK6\u001bH)\u001a4bk2$\b%\u0001\u0006u_.,gnQ1dQ\u0016,\"!!\u0006\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004]\u0005}!B\u0001\u0019X\u0013\u0011\t\u0019#!\u0007\u0003)\u0011+G.Z4bi&|g\u000eV8lK:\u001c\u0015m\u00195f\u00039!xn[3o\u0007\u0006\u001c\u0007.Z0%KF$B!!\u000b\u00020A!\u0011QAA\u0016\u0013\r\tic\u0019\u0002\u0005+:LG\u000fC\u0005\u00022E\t\t\u00111\u0001\u0002\u0016\u0005\u0019\u0001\u0010J\u0019\u0002\u0017Q|7.\u001a8DC\u000eDW\rI\u0001\u0006aJ|\u0007o]\u000b\u0003\u0003s\u0001B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007fQ\u0018\u0001B;uS2LA!a\u0011\u0002>\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u0013A\u0014x\u000e]:`I\u0015\fH\u0003BA\u0015\u0003\u0013B\u0011\"!\r\u0015\u0003\u0003\u0005\r!!\u000f\u0002\rA\u0014x\u000e]:!\u0003E\u0019'/Z1uKR{7.\u001a8SKN,H\u000e^\u000b\u0003\u0003#\u00022\u0001OA*\u0013\r\t)&\u000f\u0002\u0012\u0007J,\u0017\r^3U_.,gNU3tk2$\u0018!F2sK\u0006$X\rV8lK:\u0014Vm];mi~#S-\u001d\u000b\u0005\u0003S\tY\u0006C\u0005\u00022]\t\t\u00111\u0001\u0002R\u0005\u00112M]3bi\u0016$vn[3o%\u0016\u001cX\u000f\u001c;!\u0003\u0015)'O]8s+\t\t\u0019\u0007\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tIgR\u0001\taJ|Go\\2pY&!\u0011QNA4\u0005\u0019)%O]8sg\u0006IQM\u001d:pe~#S-\u001d\u000b\u0005\u0003S\t\u0019\bC\u0005\u00022i\t\t\u00111\u0001\u0002d\u00051QM\u001d:pe\u0002\nq\"\u001a=qSJLH+[7f'R\fW\u000e]\u0001\u0014Kb\u0004\u0018N]=US6,7\u000b^1na~#S-\u001d\u000b\u0005\u0003S\ti\bC\u0005\u00022u\t\t\u00111\u0001\u0002\u0004\u0005\u0001R\r\u001f9jef$\u0016.\\3Ti\u0006l\u0007\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0005\u0003S\t)\tC\u0004\u0002\b~\u0001\r!!#\u0002\u0011Q,7\u000f^%oM>\u0004B!a#\u0002\u001a6\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*A\u0002ba&TA!a%\u0002\u0016\u00069!.\u001e9ji\u0016\u0014(bAAL\u0019\u0006)!.\u001e8ji&!\u00111TAG\u0005!!Vm\u001d;J]\u001a|\u0007fA\u0010\u0002 B!\u00111RAQ\u0013\u0011\t\u0019+!$\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\t\tI\u0003K\u0002!\u0003W\u0003B!a#\u0002.&!\u0011qVAG\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0017uKN$Hk\\6f]J+\u0017/^3tiN<\u0016\u000e\u001e5EK2,w-\u0019;j_:$vn[3o\t&\u001c\u0018M\u00197fI\"\u001a\u0011%!.\u0011\t\u0005-\u0015qW\u0005\u0005\u0003s\u000biI\u0001\u0003UKN$\u0018a\u0004;fgR\u001c%/Z1uKR{7.\u001a8)\u0007\t\n),\u0001\buKN$(+\u001a8foR{7.\u001a8)\u0007\r\n),A\buKN$X\t\u001f9je\u0016$vn[3oQ\r!\u0013QW\u0001\u0014i\u0016\u001cHOU3n_Z,Gk\\6f]\"k\u0017m\u0019\u0015\u0004K\u0005U\u0016!\u0005;fgR$Um]2sS\n,Gk\\6f]\"\u001aa%!.\u0002\u0013\u001d,G\u000fV8lK:\u001cH\u0003DAj\u0003c\f)P!\u0002\u0003$\t\u001d\u0002CBAk\u0003K\fIO\u0004\u0003\u0002X\u0006\u0005h\u0002BAm\u0003?l!!a7\u000b\u0007\u0005uW'\u0001\u0004=e>|GOP\u0005\u0002I&\u0019\u00111]2\u0002\u000fA\f7m[1hK&\u0019a-a:\u000b\u0007\u0005\r8\r\u0005\u0003\u0002l\u00065XBAA\u000f\u0013\u0011\ty/!\b\u0003\u001f\u0011+G.Z4bi&|g\u000eV8lK:Da!a=(\u0001\u0004\u0001\u0018\u0001\u0004;pW\u0016tW*\u00198bO\u0016\u0014\bbBA|O\u0001\u0007\u0011\u0011`\u0001\u000eC\u000ed\u0017)\u001e;i_JL'0\u001a:\u0011\t\u0005m(\u0011A\u0007\u0003\u0003{T1!a@2\u0003)\tW\u000f\u001e5pe&TXM]\u0005\u0005\u0005\u0007\tiPA\u0007BG2\fU\u000f\u001e5pe&TXM\u001d\u0005\b\u0005\u000f9\u0003\u0019\u0001B\u0005\u0003-Awn\u001d;TKN\u001c\u0018n\u001c8\u0011\t\t-!Q\u0004\b\u0005\u0005\u001b\u00119B\u0004\u0003\u0003\u0010\tMa\u0002BAm\u0005#I\u0011\u0001N\u0005\u0004\u0005+\u0019\u0014a\u00028fi^|'o[\u0005\u0005\u00053\u0011Y\"\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u000b\u0007\tU1'\u0003\u0003\u0003 \t\u0005\"aB*fgNLwN\u001c\u0006\u0005\u00053\u0011Y\u0002\u0003\u0004\u0003&\u001d\u0002\raU\u0001\u0011e\u0016\fX/Z:u!JLgnY5qC2DqA!\u000b(\u0001\u0004\u0011Y#A\bsKF,Xm\u001d;fI>;h.\u001a:t!\u0015\t).!:T\u0003]!Xm\u001d;QKJLw\u000eZ5d)>\\WM\\#ya&\u0014\u0018\u0010K\u0002)\u0003k\u000b\u0011d\u0019:fCR,Gk\\6f]J+7/\u001e7u\u0007\u0006dGNQ1dWR!\u0011\u0011\u0006B\u001b\u0011\u001d\u00119$\u000ba\u0001\u0003#\n1A]3u\u0003U\u0011XM\\3x%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.$b!!\u000b\u0003>\t}\u0002b\u0002B\u001cU\u0001\u0007\u00111\r\u0005\b\u0005\u0003R\u0003\u0019AA\u0002\u0003%!\u0018.\\3Ti\u0006l\u0007/\u0001\u000fde\u0016\fG/\u001a#fY\u0016<\u0017\r^5p]R{7.\u001a8NC:\fw-\u001a:\u0015\u0013A\u00149E!\u0015\u0003T\tm\u0003b\u0002B%W\u0001\u0007!1J\u0001\u0007G>tg-[4\u0011\u0007a\u0012i%C\u0002\u0003Pe\u00121bS1gW\u0006\u001cuN\u001c4jO\"9\u0011\u0011C\u0016A\u0002\u0005U\u0001BB!,\u0001\u0004\u0011)\u0006E\u0002E\u0005/J1A!\u0017F\u0005\u0011!\u0016.\\3\t\u000f\tu3\u00061\u0001\u0003`\u0005A!p[\"mS\u0016tG\u000f\u0005\u0003\u0003b\t\u001dTB\u0001B2\u0015\r\u0011)gM\u0001\u0003u.LAA!\u001b\u0003d\ti1*\u00194lCj[7\t\\5f]R\u0004")
public class DelegationTokenManagerTest
extends QuorumTestHarness {
    private final MockTime time = new MockTime();
    private final KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:owner");
    private final List<KafkaPrincipal> renewer = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:renewer1")}));
    private final Buffer<DelegationTokenManager> tokenManagers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final String secretKey;
    private final long maxLifeTimeMsDefault = Defaults$.MODULE$.DelegationTokenMaxLifeTimeMsDefault();
    private final long renewTimeMsDefault = Defaults$.MODULE$.DelegationTokenExpiryTimeMsDefault();
    private DelegationTokenCache tokenCache = null;
    private Properties props = null;
    private CreateTokenResult createTokenResult;
    private Errors error = Errors.NONE;
    private long expiryTimeStamp = 0L;

    public MockTime time() {
        return this.time;
    }

    public KafkaPrincipal owner() {
        return this.owner;
    }

    public List<KafkaPrincipal> renewer() {
        return this.renewer;
    }

    public Buffer<DelegationTokenManager> tokenManagers() {
        return this.tokenManagers;
    }

    public String secretKey() {
        return this.secretKey;
    }

    public long maxLifeTimeMsDefault() {
        return this.maxLifeTimeMsDefault;
    }

    public long renewTimeMsDefault() {
        return this.renewTimeMsDefault;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public Properties props() {
        return this.props;
    }

    public void props_$eq(Properties x$1) {
        this.props = x$1;
    }

    public CreateTokenResult createTokenResult() {
        return this.createTokenResult;
    }

    public void createTokenResult_$eq(CreateTokenResult x$1) {
        this.createTokenResult = x$1;
    }

    public Errors error() {
        return this.error;
    }

    public void error_$eq(Errors x$1) {
        this.error = x$1;
    }

    public long expiryTimeStamp() {
        return this.expiryTimeStamp;
    }

    public void expiryTimeStamp_$eq(long x$1) {
        this.expiryTimeStamp = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        super.setUp(testInfo);
        String x$2 = this.zkConnect();
        boolean bl = true;
        boolean bl2 = true;
        int n = TestUtils$.MODULE$.RandomPort();
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$7 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$9 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n4 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$17 = none$8;
        int n5 = 1;
        int n6 = 1;
        short s = 1;
        this.props_$eq(TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, n, (Option<SecurityProtocol>)x$7, (Option<File>)x$8, (Option<Properties>)x$9, bl3, bl4, n2, bl5, n3, bl6, n4, (Option<String>)x$17, n5, true, n6, s));
        this.props().put(KafkaConfig$.MODULE$.SaslEnabledMechanismsProp(), CollectionConverters$.MODULE$.CollectionHasAsScala(ScramMechanism.mechanismNames()).asScala().mkString(","));
        this.props().put(KafkaConfig$.MODULE$.DelegationTokenSecretKeyProp(), this.secretKey());
        this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.tokenManagers().foreach((Function1 & Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Test
    public void testTokenRequestsWithDelegationTokenDisabled() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.createToken(this.owner(), this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.createTokenResult().error());
        Predef$.MODULE$.assert(Predef$.MODULE$.wrapByteArray((byte[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte())).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(this.createTokenResult().hmac())));
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap("test".getBytes()), 1000000L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.error());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap("test".getBytes()), 1000000L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.error());
    }

    @Test
    public void testCreateToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
        Assertions.assertEquals((Object)new CreateTokenResult(this.owner(), this.owner(), issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        Option token = tokenManager.getToken(tokenId);
        Assertions.assertFalse((boolean)token.isEmpty());
        Assertions.assertTrue((boolean)Predef$.MODULE$.wrapByteArray(password).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(((DelegationToken)token.get()).hmac())));
    }

    @Test
    public void testRenewToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        long maxLifeTime = issueTime + this.maxLifeTimeMsDefault();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
        Assertions.assertEquals((Object)new CreateTokenResult(this.owner(), this.owner(), issueTime, issueTime + this.renewTimeMsDefault(), maxLifeTime, tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap("test".getBytes()), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)this.error());
        KafkaPrincipal unknownOwner = SecurityUtils.parseKafkaPrincipal((String)"User:Unknown");
        tokenManager.renewToken(unknownOwner, ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)this.error());
        this.time().sleep(86400000L);
        long expectedExpiryStamp = this.time().milliseconds() + this.renewTimeMsDefault();
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        Assertions.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(86400000L);
        expectedExpiryStamp = this.time().milliseconds() + 3600000L;
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), 3600000L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        Assertions.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(3600000L);
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), 691200000L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)maxLifeTime, (long)this.expiryTimeStamp());
        Assertions.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(691200000L);
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)this.error());
    }

    @Test
    public void testExpireToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
        Assertions.assertEquals((Object)new CreateTokenResult(this.owner(), this.owner(), issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap("test".getBytes()), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)this.error());
        KafkaPrincipal unknownOwner = SecurityUtils.parseKafkaPrincipal((String)"User:Unknown");
        tokenManager.expireToken(unknownOwner, ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)this.error());
        this.time().sleep(86400000L);
        long expectedExpiryStamp = this.time().milliseconds() + 0x6DDD00L;
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), 0x6DDD00L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        this.time().sleep(3600000L);
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(tokenManager.getToken(tokenId).isEmpty());
        Assertions.assertEquals((Object)Errors.NONE, (Object)this.error());
        Assertions.assertEquals((long)this.time().milliseconds(), (long)this.expiryTimeStamp());
    }

    @Test
    public void testRemoveTokenHmac() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
        Assertions.assertEquals((Object)new CreateTokenResult(this.owner(), this.owner(), issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        String encodedHmac = Base64.getEncoder().encodeToString(password);
        Assertions.assertNull((Object)tokenManager.tokenCache().tokenIdForHmac(encodedHmac));
        Predef$.MODULE$.assert(tokenManager.getToken(tokenId).isEmpty());
    }

    @Test
    public void testDescribeToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        KafkaPrincipal requester1 = SecurityUtils.parseKafkaPrincipal((String)"User:requester1");
        KafkaPrincipal owner1 = SecurityUtils.parseKafkaPrincipal((String)"User:owner1");
        KafkaPrincipal owner2 = SecurityUtils.parseKafkaPrincipal((String)"User:owner2");
        KafkaPrincipal owner3 = SecurityUtils.parseKafkaPrincipal((String)"User:owner3");
        KafkaPrincipal owner4 = SecurityUtils.parseKafkaPrincipal((String)"User:owner4");
        KafkaPrincipal owner5 = SecurityUtils.parseKafkaPrincipal((String)"User:owner5");
        KafkaPrincipal renewer1 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer1");
        KafkaPrincipal renewer2 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer2");
        KafkaPrincipal renewer3 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer3");
        KafkaPrincipal renewer4 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer4");
        AclAuthorizer aclAuthorizer = new AclAuthorizer();
        aclAuthorizer.configure(config.originals());
        RequestChannel.Session hostSession = new RequestChannel.Session(owner1, InetAddress.getByName("192.168.1.1"));
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(owner1, owner1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer1, renewer2})), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(owner2, owner2, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer3})), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        String tokenId2 = this.createTokenResult().tokenId();
        tokenManager.createToken(owner3, owner3, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer4})), 0x6DDD00L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        String tokenId3 = this.createTokenResult().tokenId();
        tokenManager.createToken(owner4, owner4, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1, renewer4})), 0x6DDD00L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(requester1, owner5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer1})), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)5, (int)tokenManager.getAllTokenInformation().size());
        List<DelegationToken> tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:unknown")}))));
        Assertions.assertEquals((int)0, (int)tokens.size());
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)0, (int)tokens.size());
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1}))));
        Assertions.assertEquals((int)2, (int)tokens.size());
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, null);
        Assertions.assertEquals((int)2, (int)tokens.size());
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, SecurityUtils.parseKafkaPrincipal((String)"User:unknown"), null);
        Assertions.assertEquals((int)0, (int)tokens.size());
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1, renewer4}))));
        Assertions.assertEquals((int)2, (int)tokens.size());
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, requester1, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner5}))));
        Assertions.assertEquals((int)1, (int)tokens.size());
        DelegationTokenManagerTest.createAcl$1(new AclBinding(new ResourcePattern(ResourceType.DELEGATION_TOKEN, tokenId3, PatternType.LITERAL), new AccessControlEntry(owner1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW)), aclAuthorizer);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1, renewer4}))));
        Assertions.assertEquals((int)3, (int)tokens.size());
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, renewer4, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer4}))));
        Assertions.assertEquals((int)2, (int)tokens.size());
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, renewer2, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer2, renewer3}))));
        Assertions.assertEquals((int)1, (int)tokens.size());
        hostSession = new RequestChannel.Session(renewer2, InetAddress.getByName("192.168.1.1"));
        DelegationTokenManagerTest.createAcl$1(new AclBinding(new ResourcePattern(ResourceType.DELEGATION_TOKEN, tokenId2, PatternType.LITERAL), new AccessControlEntry(renewer2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW)), aclAuthorizer);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, renewer2, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer2, renewer3}))));
        Assertions.assertEquals((int)2, (int)tokens.size());
        aclAuthorizer.close();
    }

    private List<DelegationToken> getTokens(DelegationTokenManager tokenManager, AclAuthorizer aclAuthorizer, RequestChannel.Session hostSession, KafkaPrincipal requestPrincipal, List<KafkaPrincipal> requestedOwners) {
        if (requestedOwners != null && requestedOwners.isEmpty()) {
            return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        }
        return tokenManager.getTokens((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenManagerTest.eligible$1(token, requestPrincipal, requestedOwners, hostSession, aclAuthorizer)));
    }

    @Test
    public void testPeriodicTokenExpiry() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.owner(), this.renewer(), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(this.owner(), this.owner(), this.renewer(), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(this.owner(), this.owner(), this.renewer(), 0x6DDD00L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(this.owner(), this.owner(), this.renewer(), 0x6DDD00L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(tokenManager.getAllTokenInformation().size() == 4);
        this.time().sleep(0x6DDD00L);
        tokenManager.expireTokens();
        Predef$.MODULE$.assert(tokenManager.getAllTokenInformation().size() == 2);
    }

    private void createTokenResultCallBack(CreateTokenResult ret) {
        this.createTokenResult_$eq(ret);
    }

    private void renewResponseCallback(Errors ret, long timeStamp) {
        this.error_$eq(ret);
        this.expiryTimeStamp_$eq(timeStamp);
    }

    private DelegationTokenManager createDelegationTokenManager(KafkaConfig config, DelegationTokenCache tokenCache, Time time, KafkaZkClient zkClient) {
        DelegationTokenManager tokenManager = new DelegationTokenManager(config, tokenCache, time, zkClient);
        this.tokenManagers().$plus$eq((Object)tokenManager);
        return tokenManager;
    }

    private static final void createAcl$1(AclBinding aclBinding, AclAuthorizer aclAuthorizer$1) {
        ((AclCreateResult)((CompletionStage)aclAuthorizer$1.createAcls(null, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding}))).asJava()).get(0)).toCompletableFuture().get()).exception().ifPresent(e -> {
            throw e;
        });
    }

    private static final boolean authorizeToken$1(String tokenId, RequestChannel.Session hostSession$1, AclAuthorizer aclAuthorizer$2) {
        AuthorizerUtils$.anon.1 var6_3;
        AuthorizerUtils$.anon.1 v0 = var6_3 = new /* Unavailable Anonymous Inner Class!! */;
        var6_3 = null;
        AuthorizerUtils$.anon.1 requestContext = v0;
        Action action = new Action(AclOperation.DESCRIBE, new ResourcePattern(ResourceType.DELEGATION_TOKEN, tokenId, PatternType.LITERAL), 1, true, true);
        Object object = CollectionConverters$.MODULE$.ListHasAsScala(aclAuthorizer$2.authorize((AuthorizableRequestContext)requestContext, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Action[]{action}))).asJava())).asScala().head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private static final boolean authorizeRequester$1(KafkaPrincipal owner, RequestChannel.Session hostSession$1, AclAuthorizer aclAuthorizer$2) {
        AuthorizerUtils$.anon.1 var6_3;
        AuthorizerUtils$.anon.1 v0 = var6_3 = new /* Unavailable Anonymous Inner Class!! */;
        var6_3 = null;
        AuthorizerUtils$.anon.1 requestContext = v0;
        Action action = new Action(AclOperation.DESCRIBE_TOKENS, new ResourcePattern(ResourceType.USER, owner.toString(), PatternType.LITERAL), 1, true, true);
        Object object = CollectionConverters$.MODULE$.ListHasAsScala(aclAuthorizer$2.authorize((AuthorizableRequestContext)requestContext, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Action[]{action}))).asJava())).asScala().head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private static final boolean eligible$1(TokenInformation token, KafkaPrincipal requestPrincipal$1, List requestedOwners$1, RequestChannel.Session hostSession$1, AclAuthorizer aclAuthorizer$2) {
        Option filterToken_owners = Option$.MODULE$.apply((Object)requestedOwners$1);
        boolean bl = filterToken_owners.isDefined() && !((List)filterToken_owners.get()).exists(arg_0 -> DelegationTokenManager$.$anonfun$filterToken$1$adapted((TokenInformation)token, arg_0)) ? false : (token.ownerOrRenewer(requestPrincipal$1) ? true : DelegationTokenManagerTest.authorizeToken$1(token.tokenId(), hostSession$1, aclAuthorizer$2) || DelegationTokenManagerTest.authorizeRequester$1(token.owner(), hostSession$1, aclAuthorizer$2));
        return bl;
    }

    public DelegationTokenManagerTest() {
        this.secretKey = "secretKey";
    }

    public static final /* synthetic */ Object $anonfun$getTokens$1$adapted(RequestChannel.Session hostSession$1, AclAuthorizer aclAuthorizer$2, String tokenId) {
        return BoxesRunTime.boxToBoolean((boolean)DelegationTokenManagerTest.authorizeToken$1(tokenId, hostSession$1, aclAuthorizer$2));
    }

    public static final /* synthetic */ Object $anonfun$getTokens$2$adapted(RequestChannel.Session hostSession$1, AclAuthorizer aclAuthorizer$2, KafkaPrincipal owner) {
        return BoxesRunTime.boxToBoolean((boolean)DelegationTokenManagerTest.authorizeRequester$1(owner, hostSession$1, aclAuthorizer$2));
    }
}

