/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;

public class FieldTermStack {
    private final String fieldName;
    LinkedList<TermInfo> termList = new LinkedList();

    public FieldTermStack(IndexReader reader, int docId, String fieldName, FieldQuery fieldQuery) throws IOException {
        BytesRef text;
        this.fieldName = fieldName;
        Set<String> termSet = fieldQuery.getTermSet(fieldName);
        if (termSet == null) {
            return;
        }
        Fields vectors = reader.getTermVectors(docId);
        if (vectors == null) {
            return;
        }
        Terms vector = vectors.terms(fieldName);
        if (vector == null || !vector.hasPositions()) {
            return;
        }
        CharsRefBuilder spare = new CharsRefBuilder();
        TermsEnum termsEnum = vector.iterator();
        PostingsEnum dpEnum = null;
        int numDocs = reader.maxDoc();
        while ((text = termsEnum.next()) != null) {
            spare.copyUTF8Bytes(text);
            String term = spare.toString();
            if (!termSet.contains(term)) continue;
            dpEnum = termsEnum.postings(dpEnum, 24);
            dpEnum.nextDoc();
            float weight = (float)(Math.log((double)numDocs / (double)(reader.docFreq(new Term(fieldName, text)) + 1)) + 1.0);
            int freq = dpEnum.freq();
            for (int i = 0; i < freq; ++i) {
                int pos = dpEnum.nextPosition();
                if (dpEnum.startOffset() < 0) {
                    return;
                }
                this.termList.add(new TermInfo(term, dpEnum.startOffset(), dpEnum.endOffset(), pos, weight));
            }
        }
        Collections.sort(this.termList);
        int currentPos = -1;
        TermInfo previous = null;
        TermInfo first = null;
        Iterator iterator = this.termList.iterator();
        while (iterator.hasNext()) {
            TermInfo current = (TermInfo)iterator.next();
            if (current.position == currentPos) {
                assert (previous != null);
                previous.setNext(current);
                previous = current;
                iterator.remove();
                continue;
            }
            if (previous != null) {
                previous.setNext(first);
            }
            previous = first = current;
            currentPos = current.position;
        }
        if (previous != null) {
            previous.setNext(first);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public TermInfo pop() {
        return this.termList.poll();
    }

    public void push(TermInfo termInfo) {
        this.termList.push(termInfo);
    }

    public boolean isEmpty() {
        return this.termList == null || this.termList.size() == 0;
    }

    public static class TermInfo
    implements Comparable<TermInfo> {
        private final String text;
        private final int startOffset;
        private final int endOffset;
        private final int position;
        private final float weight;
        private TermInfo next;

        TermInfo(String text, int startOffset, int endOffset, int position, float weight) {
            this.text = text;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.position = position;
            this.weight = weight;
            this.next = this;
        }

        void setNext(TermInfo next) {
            this.next = next;
        }

        public TermInfo getNext() {
            return this.next;
        }

        public String getText() {
            return this.text;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getPosition() {
            return this.position;
        }

        public float getWeight() {
            return this.weight;
        }

        public String toString() {
            return this.text + "(" + this.startOffset + "," + this.endOffset + "," + this.position + ")";
        }

        @Override
        public int compareTo(TermInfo o) {
            return this.position - o.position;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.position;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TermInfo other = (TermInfo)obj;
            return this.position == other.position;
        }
    }
}

