/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.arff;

import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.vectors.arff.ARFFModel;

final class ARFFIterator
extends AbstractIterator<Vector> {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    private final BufferedReader reader;
    private final ARFFModel model;

    ARFFIterator(BufferedReader reader, ARFFModel model) {
        this.reader = reader;
        this.model = model;
    }

    protected Vector computeNext() {
        DenseVector result;
        String line;
        try {
            while ((line = this.reader.readLine()) != null && ((line = line.trim()).isEmpty() || line.startsWith("%"))) {
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        if (line == null) {
            Closeables.closeQuietly((Closeable)this.reader);
            return (Vector)this.endOfData();
        }
        if (line.startsWith("{")) {
            line = line.substring(1, line.length() - 1);
            String[] splits = COMMA_PATTERN.split(line);
            result = new RandomAccessSparseVector(this.model.getLabelSize());
            for (String split : splits) {
                split = split.trim();
                int idIndex = split.indexOf(32);
                int idx = Integer.parseInt(split.substring(0, idIndex).trim());
                String data = split.substring(idIndex).trim();
                result.setQuick(idx, this.model.getValue(data, idx));
            }
        } else {
            result = new DenseVector(this.model.getLabelSize());
            String[] splits = COMMA_PATTERN.split(line);
            for (int i = 0; i < splits.length; ++i) {
                result.setQuick(i, this.model.getValue(splits[i], i));
            }
        }
        return result;
    }
}

